/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.cypher.acceptance;

import org.hamcrest.CoreMatchers;
import org.junit.Assert;
import org.neo4j.cypher.CypherException;
import org.neo4j.cypher.CypherExecutionException;
import org.neo4j.cypher.ExecutionEngineFunSuite;
import org.neo4j.cypher.ExecutionEngineTestSupport;
import org.neo4j.cypher.GraphDatabaseTestSupport;
import org.neo4j.cypher.NewPlannerMonitor;
import org.neo4j.cypher.NewPlannerTestSupport;
import org.neo4j.cypher.NewRuntimeMonitor;
import org.neo4j.cypher.internal.compatibility.v3_3.runtime.executionplan.InternalExecutionResult;
import org.neo4j.cypher.internal.frontend.v3_3.helpers.StringHelper;
import org.neo4j.cypher.internal.frontend.v3_3.helpers.StringHelper$;
import org.neo4j.cypher.internal.frontend.v3_3.test_helpers.CypherFunSuite;
import org.neo4j.cypher.internal.helpers.GraphIcing;
import org.neo4j.cypher.javacompat.internal.GraphDatabaseCypherService;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.cypher.acceptance.CompositeNodeKeyConstraintAcceptanceTest$;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.test.TestEnterpriseGraphDatabaseFactory;
import org.scalatest.Tag;
import org.scalatest.enablers.Emptiness$;
import org.scalatest.matchers.Matcher;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001M4A!\u0001\u0002\u0001\u001b\tA3i\\7q_NLG/\u001a(pI\u0016\\U-_\"p]N$(/Y5oi\u0006\u001b7-\u001a9uC:\u001cW\rV3ti*\u00111\u0001B\u0001\u000bC\u000e\u001cW\r\u001d;b]\u000e,'BA\u0003\u0007\u0003\u0019\u0019\u0017\u0010\u001d5fe*\u0011q\u0001C\u0001\tS:$XM\u001d8bY*\u0011\u0011BC\u0001\u0006]\u0016|GG\u001b\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0019\u0001AD\n\u0011\u0005=\tR\"\u0001\t\u000b\u0005\u0015A\u0011B\u0001\n\u0011\u0005])\u00050Z2vi&|g.\u00128hS:,g)\u001e8Tk&$X\r\u0005\u0002\u0010)%\u0011Q\u0003\u0005\u0002\u0016\u001d\u0016<\b\u000b\\1o]\u0016\u0014H+Z:u'V\u0004\bo\u001c:u\u0011\u00159\u0002\u0001\"\u0001\u0019\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0004\u0005\u0002\u001b\u00015\t!\u0001C\u0003\u001d\u0001\u0011ES$A\nde\u0016\fG/Z$sCBDG)\u0019;bE\u0006\u001cX\r\u0006\u0002\u001fKA\u0011qdI\u0007\u0002A)\u0011q!\t\u0006\u0003EA\t!B[1wC\u000e|W\u000e]1u\u0013\t!\u0003E\u0001\u000eHe\u0006\u0004\b\u000eR1uC\n\f7/Z\"za\",'oU3sm&\u001cW\rC\u0004'7A\u0005\t\u0019A\u0014\u0002\r\r|gNZ5h!\u0011ASfL\"\u000e\u0003%R!AK\u0016\u0002\u0015\r|G\u000e\\3di&|gNC\u0001-\u0003\u0015\u00198-\u00197b\u0013\tq\u0013FA\u0002NCB\u0004$\u0001M\u001d\u0011\u0007E*t'D\u00013\u0015\t13G\u0003\u00025\u0011\u00059qM]1qQ\u0012\u0014\u0017B\u0001\u001c3\u0005\u001d\u0019V\r\u001e;j]\u001e\u0004\"\u0001O\u001d\r\u0001\u0011I!(JA\u0001\u0002\u0003\u0015\ta\u000f\u0002\u0004?\u0012\n\u0014C\u0001\u001fA!\tid(D\u0001,\u0013\ty4FA\u0004O_RD\u0017N\\4\u0011\u0005u\n\u0015B\u0001\",\u0005\r\te.\u001f\t\u0003\t\u001es!!P#\n\u0005\u0019[\u0013A\u0002)sK\u0012,g-\u0003\u0002I\u0013\n11\u000b\u001e:j]\u001eT!AR\u0016\t\u000b-\u0003A\u0011\u0002'\u0002\u0017\u0015D\b/Z2u\u000bJ\u0014xN\u001d\u000b\u0004\u001bB\u0013\u0006CA\u001fO\u0013\ty5F\u0001\u0003V]&$\b\"B)K\u0001\u0004\u0019\u0015!B9vKJL\b\"B*K\u0001\u0004\u0019\u0015!D3ya\u0016\u001cG/\u001a3FeJ|'\u000fC\u0003V\u0001\u0011%a+\u0001\u0003fq\u0016\u001cGCA,a!\rA6L\u0018\b\u0003{eK!AW\u0016\u0002\u000fA\f7m[1hK&\u0011A,\u0018\u0002\u0005\u0019&\u001cHO\u0003\u0002[WA!AiX\"A\u0013\tq\u0013\nC\u0003R)\u0002\u00071\tC\u0004c\u0001E\u0005I\u0011K2\u0002;\r\u0014X-\u0019;f\u000fJ\f\u0007\u000f\u001b#bi\u0006\u0014\u0017m]3%I\u00164\u0017-\u001e7uIE*\u0012\u0001\u001a\u0016\u0003K*\u0004B\u0001K\u0017g\u0007B\u0012q-\u001b\t\u0004cUB\u0007C\u0001\u001dj\t%Q\u0014-!A\u0001\u0002\u000b\u00051hK\u0001l!\ta\u0017/D\u0001n\u0015\tqw.A\u0005v]\u000eDWmY6fI*\u0011\u0001oK\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001:n\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class CompositeNodeKeyConstraintAcceptanceTest
extends ExecutionEngineFunSuite
implements NewPlannerTestSupport {
    private final String org$neo4j$cypher$NewPlannerTestSupport$$otherReadVersion;
    private final String org$neo4j$cypher$NewPlannerTestSupport$$otherWriteVersion;
    private final String org$neo4j$cypher$NewPlannerTestSupport$$currentVersion;
    private final NewRuntimeMonitor newRuntimeMonitor;

    public String org$neo4j$cypher$NewPlannerTestSupport$$otherReadVersion() {
        return this.org$neo4j$cypher$NewPlannerTestSupport$$otherReadVersion;
    }

    public String org$neo4j$cypher$NewPlannerTestSupport$$otherWriteVersion() {
        return this.org$neo4j$cypher$NewPlannerTestSupport$$otherWriteVersion;
    }

    public String org$neo4j$cypher$NewPlannerTestSupport$$currentVersion() {
        return this.org$neo4j$cypher$NewPlannerTestSupport$$currentVersion;
    }

    public NewRuntimeMonitor newRuntimeMonitor() {
        return this.newRuntimeMonitor;
    }

    public /* synthetic */ void org$neo4j$cypher$NewPlannerTestSupport$$super$initTest() {
        ExecutionEngineTestSupport.class.initTest((CypherFunSuite)this);
    }

    public void org$neo4j$cypher$NewPlannerTestSupport$_setter_$org$neo4j$cypher$NewPlannerTestSupport$$otherReadVersion_$eq(String x$1) {
        this.org$neo4j$cypher$NewPlannerTestSupport$$otherReadVersion = x$1;
    }

    public void org$neo4j$cypher$NewPlannerTestSupport$_setter_$org$neo4j$cypher$NewPlannerTestSupport$$otherWriteVersion_$eq(String x$1) {
        this.org$neo4j$cypher$NewPlannerTestSupport$$otherWriteVersion = x$1;
    }

    public void org$neo4j$cypher$NewPlannerTestSupport$_setter_$org$neo4j$cypher$NewPlannerTestSupport$$currentVersion_$eq(String x$1) {
        this.org$neo4j$cypher$NewPlannerTestSupport$$currentVersion = x$1;
    }

    public void org$neo4j$cypher$NewPlannerTestSupport$_setter_$newRuntimeMonitor_$eq(NewRuntimeMonitor x$1) {
        this.newRuntimeMonitor = x$1;
    }

    public scala.collection.immutable.Map<Setting<?>, String> databaseConfig() {
        return NewPlannerTestSupport.class.databaseConfig((ExecutionEngineFunSuite)this);
    }

    public void initTest() {
        NewPlannerTestSupport.class.initTest((ExecutionEngineFunSuite)this);
    }

    public <T> T executeScalarWithAllPlanners(String queryText, Seq<Tuple2<String, Object>> params) {
        return (T)NewPlannerTestSupport.class.executeScalarWithAllPlanners((ExecutionEngineFunSuite)this, (String)queryText, params);
    }

    public <T> T executeScalarWithAllPlannersAndCompatibilityMode(String queryText, Seq<Tuple2<String, Object>> params) {
        return (T)NewPlannerTestSupport.class.executeScalarWithAllPlannersAndCompatibilityMode((ExecutionEngineFunSuite)this, (String)queryText, params);
    }

    public <T> T executeScalarWithAllPlannersAndRuntimes(String queryText, Seq<Tuple2<String, Object>> params) {
        return (T)NewPlannerTestSupport.class.executeScalarWithAllPlannersAndRuntimes((ExecutionEngineFunSuite)this, (String)queryText, params);
    }

    public <T> T executeScalarWithAllPlannersAndRuntimesAndCompatibilityMode(String queryText, Seq<Tuple2<String, Object>> params) {
        return (T)NewPlannerTestSupport.class.executeScalarWithAllPlannersAndRuntimesAndCompatibilityMode((ExecutionEngineFunSuite)this, (String)queryText, params);
    }

    public InternalExecutionResult executeWithAllPlanners(String queryText, Seq<Tuple2<String, Object>> params) {
        return NewPlannerTestSupport.class.executeWithAllPlanners((ExecutionEngineFunSuite)this, (String)queryText, params);
    }

    public InternalExecutionResult executeWithAllPlannersAndCompatibilityMode(String queryText, Seq<Tuple2<String, Object>> params) {
        return NewPlannerTestSupport.class.executeWithAllPlannersAndCompatibilityMode((ExecutionEngineFunSuite)this, (String)queryText, params);
    }

    public InternalExecutionResult updateWithBothPlannersAndCompatibilityMode(String queryText, Seq<Tuple2<String, Object>> params) {
        return NewPlannerTestSupport.class.updateWithBothPlannersAndCompatibilityMode((ExecutionEngineFunSuite)this, (String)queryText, params);
    }

    public InternalExecutionResult updateWithBothPlanners(String queryText, Seq<Tuple2<String, Object>> params) {
        return NewPlannerTestSupport.class.updateWithBothPlanners((ExecutionEngineFunSuite)this, (String)queryText, params);
    }

    public InternalExecutionResult updateWithCostPlannerOnly(String queryText, Seq<Tuple2<String, Object>> params) {
        return NewPlannerTestSupport.class.updateWithCostPlannerOnly((ExecutionEngineFunSuite)this, (String)queryText, params);
    }

    public InternalExecutionResult executeWithAllPlannersAndCompatibilityModeReplaceNaNs(String queryText, Seq<Tuple2<String, Object>> params) {
        return NewPlannerTestSupport.class.executeWithAllPlannersAndCompatibilityModeReplaceNaNs((ExecutionEngineFunSuite)this, (String)queryText, params);
    }

    public InternalExecutionResult executeWithCostPlannerAndInterpretedRuntimeOnly(String queryText, Seq<Tuple2<String, Object>> params) {
        return NewPlannerTestSupport.class.executeWithCostPlannerAndInterpretedRuntimeOnly((ExecutionEngineFunSuite)this, (String)queryText, params);
    }

    public InternalExecutionResult executeWithCostPlannerAndCompiledRuntimeOnly(String queryText, Seq<Tuple2<String, Object>> params) {
        return NewPlannerTestSupport.class.executeWithCostPlannerAndCompiledRuntimeOnly((ExecutionEngineFunSuite)this, (String)queryText, params);
    }

    public InternalExecutionResult executeWithAllPlannersAndRuntimesAndCompatibilityMode(String queryText, Seq<Tuple2<String, Object>> params) {
        return NewPlannerTestSupport.class.executeWithAllPlannersAndRuntimesAndCompatibilityMode((ExecutionEngineFunSuite)this, (String)queryText, params);
    }

    public InternalExecutionResult executeWithAllPlannersAndRuntimes(String queryText, Seq<Tuple2<String, Object>> params) {
        return NewPlannerTestSupport.class.executeWithAllPlannersAndRuntimes((ExecutionEngineFunSuite)this, (String)queryText, params);
    }

    public InternalExecutionResult updateWithCompatibilityAndAssertSimilarPlans(String queryText, Seq<Tuple2<String, Object>> params) {
        return NewPlannerTestSupport.class.updateWithCompatibilityAndAssertSimilarPlans((ExecutionEngineFunSuite)this, (String)queryText, params);
    }

    public InternalExecutionResult executeWithCompatibilityAndAssertSimilarPlans(String queryText, Seq<Tuple2<String, Object>> params) {
        return NewPlannerTestSupport.class.executeWithCompatibilityAndAssertSimilarPlans((ExecutionEngineFunSuite)this, (String)queryText, params);
    }

    public void assertPlansAreSimilar(String otherVersion, InternalExecutionResult other, InternalExecutionResult current, String queryText, String errorMsg, boolean replaceNaNs) {
        NewPlannerTestSupport.class.assertPlansAreSimilar((ExecutionEngineFunSuite)this, (String)otherVersion, (InternalExecutionResult)other, (InternalExecutionResult)current, (String)queryText, (String)errorMsg, (boolean)replaceNaNs);
    }

    public void assertResultsAreSame(InternalExecutionResult result1, InternalExecutionResult result2, String queryText, String errorMsg, boolean replaceNaNs) {
        NewPlannerTestSupport.class.assertResultsAreSame((ExecutionEngineFunSuite)this, (InternalExecutionResult)result1, (InternalExecutionResult)result2, (String)queryText, (String)errorMsg, (boolean)replaceNaNs);
    }

    public InternalExecutionResult innerExecute(String queryText, Seq<Tuple2<String, Object>> params) {
        return NewPlannerTestSupport.class.innerExecute((ExecutionEngineFunSuite)this, (String)queryText, params);
    }

    public Nothing$ execute(String queryText, Seq<Tuple2<String, Object>> params) {
        return NewPlannerTestSupport.class.execute((ExecutionEngineFunSuite)this, (String)queryText, params);
    }

    public <T> T monitoringNewPlanner(Function0<T> action, Function1<List<NewPlannerMonitor.NewPlannerMonitorCall>, BoxedUnit> testPlanner, Function1<List<NewRuntimeMonitor.NewRuntimeMonitorCall>, BoxedUnit> testRuntime) {
        return (T)NewPlannerTestSupport.class.monitoringNewPlanner((ExecutionEngineFunSuite)this, action, testPlanner, testRuntime);
    }

    public NewPlannerTestSupport.RichInternalExecutionResults RichInternalExecutionResults(InternalExecutionResult res) {
        return NewPlannerTestSupport.class.RichInternalExecutionResults((ExecutionEngineFunSuite)this, (InternalExecutionResult)res);
    }

    public NewPlannerTestSupport.RichMapSeq RichMapSeq(Seq<scala.collection.immutable.Map<String, Object>> res) {
        return NewPlannerTestSupport.class.RichMapSeq((ExecutionEngineFunSuite)this, res);
    }

    public Matcher<InternalExecutionResult> evaluateTo(Seq<scala.collection.immutable.Map<String, Object>> expected) {
        return NewPlannerTestSupport.class.evaluateTo((ExecutionEngineFunSuite)this, expected);
    }

    public boolean assertResultsAreSame$default$5() {
        return NewPlannerTestSupport.class.assertResultsAreSame$default$5((ExecutionEngineFunSuite)this);
    }

    public boolean assertPlansAreSimilar$default$6() {
        return NewPlannerTestSupport.class.assertPlansAreSimilar$default$6((ExecutionEngineFunSuite)this);
    }

    public GraphDatabaseCypherService createGraphDatabase(Map<Setting<?>, String> config) {
        return new GraphDatabaseCypherService(new TestEnterpriseGraphDatabaseFactory().newImpermanentDatabase((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(config).asJava()));
    }

    public Map<Setting<?>, String> createGraphDatabase$default$1() {
        return this.databaseConfig();
    }

    public void org$neo4j$internal$cypher$acceptance$CompositeNodeKeyConstraintAcceptanceTest$$expectError(String query, String expectedError) {
        CypherException error = (CypherException)this.intercept((Function0)new Serializable(this, query){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CompositeNodeKeyConstraintAcceptanceTest $outer;
            private final String query$1;

            public final List<scala.collection.immutable.Map<String, Object>> apply() {
                return this.$outer.org$neo4j$internal$cypher$acceptance$CompositeNodeKeyConstraintAcceptanceTest$$exec(this.query$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.query$1 = query$1;
            }
        }, ManifestFactory$.MODULE$.classType(CypherException.class));
        Assert.assertThat((Object)error.getMessage(), (org.hamcrest.Matcher)CoreMatchers.containsString((String)expectedError));
    }

    public List<scala.collection.immutable.Map<String, Object>> org$neo4j$internal$cypher$acceptance$CompositeNodeKeyConstraintAcceptanceTest$$exec(String query) {
        return this.executeWithCostPlannerAndInterpretedRuntimeOnly(StringHelper.RichString$.MODULE$.fixNewLines$extension(StringHelper$.MODULE$.RichString(query)), (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0])).toList();
    }

    public CompositeNodeKeyConstraintAcceptanceTest() {
        NewPlannerTestSupport.class.$init$((ExecutionEngineFunSuite)this);
        this.test("should be able to create and remove single property NODE KEY", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CompositeNodeKeyConstraintAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$internal$cypher$acceptance$CompositeNodeKeyConstraintAcceptanceTest$$exec("CREATE CONSTRAINT ON (n:Person) ASSERT (n.email) IS NODE KEY");
                this.$outer.convertToAnyShouldWrapper(this.$outer.graph()).should((Matcher)new GraphDatabaseTestSupport.haveConstraints((CypherFunSuite)this.$outer, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"NODE_KEY:Person(email)"})));
                this.$outer.org$neo4j$internal$cypher$acceptance$CompositeNodeKeyConstraintAcceptanceTest$$exec("DROP CONSTRAINT ON (n:Person) ASSERT (n.email) IS NODE KEY");
                this.$outer.convertToAnyShouldWrapper(this.$outer.graph()).should(this.$outer.not().apply((Matcher)new GraphDatabaseTestSupport.haveConstraints((CypherFunSuite)this.$outer, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"NODE_KEY:Person(email)"}))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should be able to create and remove multiple property NODE KEY", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CompositeNodeKeyConstraintAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$internal$cypher$acceptance$CompositeNodeKeyConstraintAcceptanceTest$$exec("CREATE CONSTRAINT ON (n:Person) ASSERT (n.email) IS NODE KEY");
                this.$outer.org$neo4j$internal$cypher$acceptance$CompositeNodeKeyConstraintAcceptanceTest$$exec("CREATE CONSTRAINT ON (n:Person) ASSERT (n.firstname,n.lastname) IS NODE KEY");
                this.$outer.convertToAnyShouldWrapper(this.$outer.graph()).should((Matcher)new GraphDatabaseTestSupport.haveConstraints((CypherFunSuite)this.$outer, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"NODE_KEY:Person(email)", "NODE_KEY:Person(firstname,lastname)"})));
                this.$outer.org$neo4j$internal$cypher$acceptance$CompositeNodeKeyConstraintAcceptanceTest$$exec("DROP CONSTRAINT ON (n:Person) ASSERT (n.firstname,n.lastname) IS NODE KEY");
                this.$outer.convertToAnyShouldWrapper(this.$outer.graph()).should((Matcher)new GraphDatabaseTestSupport.haveConstraints((CypherFunSuite)this.$outer, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"NODE_KEY:Person(email)"})));
                this.$outer.convertToAnyShouldWrapper(this.$outer.graph()).should(this.$outer.not().apply((Matcher)new GraphDatabaseTestSupport.haveConstraints((CypherFunSuite)this.$outer, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"NODE_KEY:Person(firstname,lastname)"}))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("composite NODE KEY constraint should not block adding nodes with different properties", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CompositeNodeKeyConstraintAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$internal$cypher$acceptance$CompositeNodeKeyConstraintAcceptanceTest$$exec("CREATE CONSTRAINT ON (n:User) ASSERT (n.firstname,n.lastname) IS NODE KEY");
                this.$outer.createLabeledNode((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"firstname"), (Object)"Joe"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"lastname"), (Object)"Soap")})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"User"}));
                this.$outer.createLabeledNode((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"firstname"), (Object)"Joe"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"lastname"), (Object)"Smoke")})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"User"}));
                this.$outer.createLabeledNode((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"firstname"), (Object)"Jake"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"lastname"), (Object)"Soap")})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"User"}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("composite NODE KEY constraint should block adding nodes with same properties", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CompositeNodeKeyConstraintAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$internal$cypher$acceptance$CompositeNodeKeyConstraintAcceptanceTest$$exec("CREATE CONSTRAINT ON (n:User) ASSERT (n.firstname,n.lastname) IS NODE KEY");
                this.$outer.createLabeledNode((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"firstname"), (Object)"Joe"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"lastname"), (Object)"Soap")})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"User"}));
                this.$outer.createLabeledNode((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"firstname"), (Object)"Joe"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"lastname"), (Object)"Smoke")})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"User"}));
                this.$outer.a(ManifestFactory$.MODULE$.classType(ConstraintViolationException.class)).should(this.$outer.be()).thrownBy((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$4 $outer;

                    public final Node apply() {
                        return this.$outer.org$neo4j$internal$cypher$acceptance$CompositeNodeKeyConstraintAcceptanceTest$$anonfun$$$outer().createLabeledNode((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"firstname"), (Object)"Joe"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"lastname"), (Object)"Soap")})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"User"}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ CompositeNodeKeyConstraintAcceptanceTest org$neo4j$internal$cypher$acceptance$CompositeNodeKeyConstraintAcceptanceTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("single property NODE KEY constraint should block adding nodes with missing property", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CompositeNodeKeyConstraintAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$internal$cypher$acceptance$CompositeNodeKeyConstraintAcceptanceTest$$exec("CREATE CONSTRAINT ON (n:User) ASSERT (n.email) IS NODE KEY");
                this.$outer.createLabeledNode((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"email"), (Object)"joe@soap.tv")})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"User"}));
                this.$outer.createLabeledNode((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"email"), (Object)"jake@soap.tv")})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"User"}));
                this.$outer.a(ManifestFactory$.MODULE$.classType(ConstraintViolationException.class)).should(this.$outer.be()).thrownBy((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$5 $outer;

                    public final Node apply() {
                        return this.$outer.org$neo4j$internal$cypher$acceptance$CompositeNodeKeyConstraintAcceptanceTest$$anonfun$$$outer().createLabeledNode((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"firstname"), (Object)"Joe"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"lastname"), (Object)"Soap")})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"User"}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ CompositeNodeKeyConstraintAcceptanceTest org$neo4j$internal$cypher$acceptance$CompositeNodeKeyConstraintAcceptanceTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("composite NODE KEY constraint should block adding nodes with missing properties", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CompositeNodeKeyConstraintAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$internal$cypher$acceptance$CompositeNodeKeyConstraintAcceptanceTest$$exec("CREATE CONSTRAINT ON (n:User) ASSERT (n.firstname,n.lastname) IS NODE KEY");
                this.$outer.createLabeledNode((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"firstname"), (Object)"Joe"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"lastname"), (Object)"Soap")})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"User"}));
                this.$outer.createLabeledNode((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"firstname"), (Object)"Joe"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"lastname"), (Object)"Smoke")})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"User"}));
                this.$outer.a(ManifestFactory$.MODULE$.classType(ConstraintViolationException.class)).should(this.$outer.be()).thrownBy((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$6 $outer;

                    public final Node apply() {
                        return this.$outer.org$neo4j$internal$cypher$acceptance$CompositeNodeKeyConstraintAcceptanceTest$$anonfun$$$outer().createLabeledNode((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"firstname"), (Object)"Joe"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"lastnamex"), (Object)"Soap")})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"User"}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ CompositeNodeKeyConstraintAcceptanceTest org$neo4j$internal$cypher$acceptance$CompositeNodeKeyConstraintAcceptanceTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("composite NODE KEY constraint should not fail when we have nodes with different properties", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CompositeNodeKeyConstraintAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.createLabeledNode((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"firstname"), (Object)"Joe"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"lastname"), (Object)"Soap")})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"User"}));
                this.$outer.createLabeledNode((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"firstname"), (Object)"Joe"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"lastname"), (Object)"Smoke")})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"User"}));
                this.$outer.createLabeledNode((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"firstname"), (Object)"Jake"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"lastname"), (Object)"Soap")})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"User"}));
                this.$outer.org$neo4j$internal$cypher$acceptance$CompositeNodeKeyConstraintAcceptanceTest$$exec("CREATE CONSTRAINT ON (n:User) ASSERT (n.firstname,n.lastname) IS NODE KEY");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("composite NODE KEY constraint should fail when we have nodes with same properties", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CompositeNodeKeyConstraintAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.createLabeledNode((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"firstname"), (Object)"Joe"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"lastname"), (Object)"Soap")})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"User"}));
                this.$outer.createLabeledNode((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"firstname"), (Object)"Joe"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"lastname"), (Object)"Smoke")})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"User"}));
                this.$outer.createLabeledNode((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"firstname"), (Object)"Joe"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"lastname"), (Object)"Soap")})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"User"}));
                this.$outer.a(ManifestFactory$.MODULE$.classType(CypherExecutionException.class)).should(this.$outer.be()).thrownBy((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$8 $outer;

                    public final List<scala.collection.immutable.Map<String, Object>> apply() {
                        return this.$outer.org$neo4j$internal$cypher$acceptance$CompositeNodeKeyConstraintAcceptanceTest$$anonfun$$$outer().org$neo4j$internal$cypher$acceptance$CompositeNodeKeyConstraintAcceptanceTest$$exec("CREATE CONSTRAINT ON (n:User) ASSERT (n.firstname,n.lastname) IS NODE KEY");
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ CompositeNodeKeyConstraintAcceptanceTest org$neo4j$internal$cypher$acceptance$CompositeNodeKeyConstraintAcceptanceTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("trying to add duplicate node when node key constraint exists", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CompositeNodeKeyConstraintAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.createLabeledNode((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"A")})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Person"}));
                this.$outer.org$neo4j$internal$cypher$acceptance$CompositeNodeKeyConstraintAcceptanceTest$$exec("CREATE CONSTRAINT ON (person:Person) ASSERT (person.name) IS NODE KEY");
                this.$outer.org$neo4j$internal$cypher$acceptance$CompositeNodeKeyConstraintAcceptanceTest$$expectError("CREATE (n:Person) SET n.name = 'A'", String.format("Node(0) already exists with label `Person` and property `name` = 'A'", new Object[0]));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("trying to add duplicate node when composite NODE KEY constraint exists", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CompositeNodeKeyConstraintAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.createLabeledNode((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"A"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"surname"), (Object)"B")})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Person"}));
                this.$outer.org$neo4j$internal$cypher$acceptance$CompositeNodeKeyConstraintAcceptanceTest$$exec("CREATE CONSTRAINT ON (person:Person) ASSERT (person.name, person.surname) IS NODE KEY");
                this.$outer.org$neo4j$internal$cypher$acceptance$CompositeNodeKeyConstraintAcceptanceTest$$expectError("CREATE (n:Person) SET n.name = 'A', n.surname = 'B'", String.format("Node(0) already exists with label `Person` and properties `name` = 'A', `surname` = 'B'", new Object[0]));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("trying to add a composite node key constraint when duplicates exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CompositeNodeKeyConstraintAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.createLabeledNode((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"A"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"surname"), (Object)"B")})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Person"}));
                this.$outer.createLabeledNode((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"A"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"surname"), (Object)"B")})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Person"}));
                this.$outer.org$neo4j$internal$cypher$acceptance$CompositeNodeKeyConstraintAcceptanceTest$$expectError("CREATE CONSTRAINT ON (person:Person) ASSERT (person.name, person.surname) IS NODE KEY", String.format("Unable to create CONSTRAINT ON ( person:Person ) ASSERT (person.name, person.surname) IS NODE KEY:%nBoth Node(0) and Node(1) have the label `Person` and properties `name` = 'A', `surname` = 'B'", new Object[0]));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("trying to add a node key constraint when duplicates exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CompositeNodeKeyConstraintAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.createLabeledNode((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"A")})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Person"}));
                this.$outer.createLabeledNode((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"A")})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Person"}));
                this.$outer.org$neo4j$internal$cypher$acceptance$CompositeNodeKeyConstraintAcceptanceTest$$expectError("CREATE CONSTRAINT ON (person:Person) ASSERT (person.name) IS NODE KEY", String.format("Unable to create CONSTRAINT ON ( person:Person ) ASSERT person.name IS NODE KEY:%nBoth Node(0) and Node(1) have the label `Person` and property `name` = 'A'", new Object[0]));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("drop a non existent node key constraint", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CompositeNodeKeyConstraintAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$internal$cypher$acceptance$CompositeNodeKeyConstraintAcceptanceTest$$expectError("DROP CONSTRAINT ON (person:Person) ASSERT (person.name) IS NODE KEY", "No such constraint");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("trying to add duplicate node when composite node key constraint exists", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CompositeNodeKeyConstraintAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.createLabeledNode((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"A"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"surname"), (Object)"B")})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Person"}));
                this.$outer.org$neo4j$internal$cypher$acceptance$CompositeNodeKeyConstraintAcceptanceTest$$exec("CREATE CONSTRAINT ON (person:Person) ASSERT (person.name, person.surname) IS NODE KEY");
                this.$outer.org$neo4j$internal$cypher$acceptance$CompositeNodeKeyConstraintAcceptanceTest$$expectError("CREATE (n:Person) SET n.name = 'A', n.surname = 'B'", String.format("Node(0) already exists with label `Person` and properties `name` = 'A', `surname` = 'B'", new Object[0]));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("trying to add node withoutwhen composite node key constraint exists", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CompositeNodeKeyConstraintAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.createLabeledNode((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"A"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"surname"), (Object)"B")})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Person"}));
                this.$outer.org$neo4j$internal$cypher$acceptance$CompositeNodeKeyConstraintAcceptanceTest$$exec("CREATE CONSTRAINT ON (person:Person) ASSERT (person.name, person.surname) IS NODE KEY");
                this.$outer.org$neo4j$internal$cypher$acceptance$CompositeNodeKeyConstraintAcceptanceTest$$expectError("CREATE (n:Person) SET n.name = 'A', n.surname = 'B'", String.format("Node(0) already exists with label `Person` and properties `name` = 'A', `surname` = 'B'", new Object[0]));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should give appropriate error message when there is already an index", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CompositeNodeKeyConstraintAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$internal$cypher$acceptance$CompositeNodeKeyConstraintAcceptanceTest$$exec("CREATE INDEX ON :Person(firstname, lastname)");
                this.$outer.org$neo4j$internal$cypher$acceptance$CompositeNodeKeyConstraintAcceptanceTest$$expectError("CREATE CONSTRAINT ON (n:Person) ASSERT (n.firstname,n.lastname) IS NODE KEY", "There already exists an index for label 'Person' on properties 'firstname' and 'lastname'. A constraint cannot be created until the index has been dropped.");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should give appropriate error message when there is already a NODE KEY constraint", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CompositeNodeKeyConstraintAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$internal$cypher$acceptance$CompositeNodeKeyConstraintAcceptanceTest$$exec("CREATE CONSTRAINT ON (n:Person) ASSERT (n.firstname,n.lastname) IS NODE KEY");
                this.$outer.org$neo4j$internal$cypher$acceptance$CompositeNodeKeyConstraintAcceptanceTest$$expectError("CREATE INDEX ON :Person(firstname, lastname)", "Label 'Person' and properties 'firstname' and 'lastname' have a unique constraint defined on them, so an index is already created that matches this.");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Should give a nice error message when trying to remove property with node key constraint", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CompositeNodeKeyConstraintAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$internal$cypher$acceptance$CompositeNodeKeyConstraintAcceptanceTest$$exec("CREATE CONSTRAINT ON (n:Person) ASSERT (n.firstname, n.surname) IS NODE KEY");
                long id = this.$outer.createLabeledNode((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"firstname"), (Object)"John"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"surname"), (Object)"Wood")})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Person"})).getId();
                this.$outer.org$neo4j$internal$cypher$acceptance$CompositeNodeKeyConstraintAcceptanceTest$$expectError("MATCH (p:Person {firstname: 'John', surname: 'Wood'}) REMOVE p.surname", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Node(", ") with label `Person` must have the properties `firstname, surname`"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)id)})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Should be able to remove non constrained property", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CompositeNodeKeyConstraintAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$internal$cypher$acceptance$CompositeNodeKeyConstraintAcceptanceTest$$exec("CREATE CONSTRAINT ON (n:Person) ASSERT (n.firstname, n.surname) IS NODE KEY");
                Node node = this.$outer.createLabeledNode((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"firstname"), (Object)"John"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"surname"), (Object)"Wood"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo"), (Object)"bar")})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Person"}));
                this.$outer.org$neo4j$internal$cypher$acceptance$CompositeNodeKeyConstraintAcceptanceTest$$exec("MATCH (p:Person {firstname: 'John', surname: 'Wood'}) REMOVE p.foo");
                GraphIcing.RichGraphDatabaseQueryService qual$1 = this.$outer.RichGraphDatabaseQueryService((GraphDatabaseQueryService)this.$outer.graph());
                Serializable x$1 = new Serializable(this, node){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$19 $outer;
                    private final Node node$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.org$neo4j$internal$cypher$acceptance$CompositeNodeKeyConstraintAcceptanceTest$$anonfun$$$outer().convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)this.node$1.hasProperty("foo"))).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)false));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.node$1 = node$1;
                    }
                };
                KernelTransaction.Type x$2 = qual$1.inTx$default$2();
                qual$1.inTx((Function0)x$1, x$2);
            }

            public /* synthetic */ CompositeNodeKeyConstraintAcceptanceTest org$neo4j$internal$cypher$acceptance$CompositeNodeKeyConstraintAcceptanceTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Should be able to delete node constrained with node key constraint", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CompositeNodeKeyConstraintAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$internal$cypher$acceptance$CompositeNodeKeyConstraintAcceptanceTest$$exec("CREATE CONSTRAINT ON (n:Person) ASSERT (n.firstname, n.surname) IS NODE KEY");
                this.$outer.createLabeledNode((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"firstname"), (Object)"John"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"surname"), (Object)"Wood"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo"), (Object)"bar")})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Person"}));
                this.$outer.org$neo4j$internal$cypher$acceptance$CompositeNodeKeyConstraintAcceptanceTest$$exec("MATCH (p:Person {firstname: 'John', surname: 'Wood'}) DELETE p");
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$internal$cypher$acceptance$CompositeNodeKeyConstraintAcceptanceTest$$exec("MATCH (p:Person {firstname: 'John', surname: 'Wood'}) RETURN p")).shouldBe(this.$outer.empty(), Emptiness$.MODULE$.emptinessOfGenTraversable());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Should be able to remove label when node key constraint", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CompositeNodeKeyConstraintAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$internal$cypher$acceptance$CompositeNodeKeyConstraintAcceptanceTest$$exec("CREATE CONSTRAINT ON (n:Person) ASSERT (n.firstname, n.surname) IS NODE KEY");
                this.$outer.createLabeledNode((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"firstname"), (Object)"John"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"surname"), (Object)"Wood"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo"), (Object)"bar")})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Person"}));
                this.$outer.org$neo4j$internal$cypher$acceptance$CompositeNodeKeyConstraintAcceptanceTest$$exec("MATCH (p:Person {firstname: 'John', surname: 'Wood'}) REMOVE p:Person");
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$internal$cypher$acceptance$CompositeNodeKeyConstraintAcceptanceTest$$exec("MATCH (p:Person {firstname: 'John', surname: 'Wood'}) RETURN p")).shouldBe(this.$outer.empty(), Emptiness$.MODULE$.emptinessOfGenTraversable());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

