/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.cypher.acceptance;

import org.neo4j.cypher.SyntaxException;
import org.neo4j.cypher.internal.compatibility.v3_3.runtime.executionplan.InternalExecutionResult;
import org.neo4j.internal.cypher.acceptance.BuiltInProcedureAcceptanceTest$;
import org.neo4j.internal.cypher.acceptance.ProcedureCallAcceptanceTest;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import org.scalatest.enablers.Emptiness$;
import scala.Function0;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001Y1A!\u0001\u0002\u0001\u001b\tq\")^5mi&s\u0007K]8dK\u0012,(/Z!dG\u0016\u0004H/\u00198dKR+7\u000f\u001e\u0006\u0003\u0007\u0011\t!\"Y2dKB$\u0018M\\2f\u0015\t)a!\u0001\u0004dsBDWM\u001d\u0006\u0003\u000f!\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u0013)\tQA\\3pi)T\u0011aC\u0001\u0004_J<7\u0001A\n\u0003\u00019\u0001\"a\u0004\t\u000e\u0003\tI!!\u0005\u0002\u00037A\u0013xnY3ekJ,7)\u00197m\u0003\u000e\u001cW\r\u001d;b]\u000e,G+Z:u\u0011\u0015\u0019\u0002\u0001\"\u0001\u0015\u0003\u0019a\u0014N\\5u}Q\tQ\u0003\u0005\u0002\u0010\u0001\u0001")
public class BuiltInProcedureAcceptanceTest
extends ProcedureCallAcceptanceTest {
    public BuiltInProcedureAcceptanceTest() {
        this.test("should be able to filter as part of call", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BuiltInProcedureAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.createLabeledNode((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A"}));
                this.$outer.createLabeledNode((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"B"}));
                this.$outer.createLabeledNode((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"C"}));
                InternalExecutionResult result = this.$outer.execute("CALL db.labels() YIELD label WHERE label <> 'A' RETURN *", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                this.$outer.convertToAnyShouldWrapper(result.toList()).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Map[]{(scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"label"), (Object)"B")})), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"label"), (Object)"C")}))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should not be able to filter as part of standalone call", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BuiltInProcedureAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.a(ManifestFactory$.MODULE$.classType(SyntaxException.class)).should(this.$outer.be()).thrownBy((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$2 $outer;

                    public final InternalExecutionResult apply() {
                        return this.$outer.org$neo4j$internal$cypher$acceptance$BuiltInProcedureAcceptanceTest$$anonfun$$$outer().execute("CALL db.labels() YIELD label WHERE label <> 'A'", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ BuiltInProcedureAcceptanceTest org$neo4j$internal$cypher$acceptance$BuiltInProcedureAcceptanceTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should be able to find labels from built-in-procedure", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BuiltInProcedureAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.createLabeledNode((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A"}));
                this.$outer.createLabeledNode((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"B"}));
                this.$outer.createLabeledNode((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"C"}));
                InternalExecutionResult result = this.$outer.execute("CALL db.labels() YIELD label RETURN *", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                this.$outer.convertToAnyShouldWrapper(result.toList()).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Map[]{(scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"label"), (Object)"A")})), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"label"), (Object)"B")})), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"label"), (Object)"C")}))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should be able to find labels from built-in-procedure from within a query", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BuiltInProcedureAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.createLabeledNode((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"Tic")})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A"}));
                this.$outer.createLabeledNode((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"Tac")})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"B"}));
                this.$outer.createLabeledNode((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"Toc")})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"C"}));
                InternalExecutionResult result = this.$outer.execute("MATCH (n {name: 'Toc'}) WITH n.name AS name CALL db.labels() YIELD label RETURN *", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                this.$outer.convertToAnyShouldWrapper(result.toList()).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Map[]{(scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"Toc"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"label"), (Object)"A")})), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"Toc"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"label"), (Object)"B")})), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"Toc"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"label"), (Object)"C")}))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("db.labels works on an empty database", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BuiltInProcedureAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                InternalExecutionResult result = this.$outer.execute("CALL db.labels() YIELD label RETURN *", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                this.$outer.convertToAnyShouldWrapper(result.toList()).shouldBe(this.$outer.empty(), Emptiness$.MODULE$.emptinessOfGenTraversable());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("db.labels work on an empty database", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BuiltInProcedureAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                InternalExecutionResult result = this.$outer.execute("CALL db.labels", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                this.$outer.convertToAnyShouldWrapper(result.toList()).shouldBe(this.$outer.empty(), Emptiness$.MODULE$.emptinessOfGenTraversable());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("db.labels should be empty when all labels are removed", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BuiltInProcedureAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.createLabeledNode((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A"}));
                this.$outer.execute("MATCH (a:A) REMOVE a:A", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                InternalExecutionResult result = this.$outer.execute("CALL db.labels", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                this.$outer.convertToAnyShouldWrapper(result).shouldBe(this.$outer.empty(), Emptiness$.MODULE$.emptinessOfAnyRefWithParameterlessIsEmptyMethod());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("db.labels should be empty when all nodes are removed", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BuiltInProcedureAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.createLabeledNode((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A"}));
                this.$outer.execute("MATCH (a) DETACH DELETE a", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                InternalExecutionResult result = this.$outer.execute("CALL db.labels", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                this.$outer.convertToAnyShouldWrapper(result).shouldBe(this.$outer.empty(), Emptiness$.MODULE$.emptinessOfAnyRefWithParameterlessIsEmptyMethod());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should be able to find types from built-in-procedure", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BuiltInProcedureAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.relate(this.$outer.createNode(), this.$outer.createNode(), "A", this.$outer.relate$default$4());
                this.$outer.relate(this.$outer.createNode(), this.$outer.createNode(), "B", this.$outer.relate$default$4());
                this.$outer.relate(this.$outer.createNode(), this.$outer.createNode(), "C", this.$outer.relate$default$4());
                InternalExecutionResult result = this.$outer.execute("CALL db.relationshipTypes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                this.$outer.convertToAnyShouldWrapper(result.toList()).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Map[]{(scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"relationshipType"), (Object)"A")})), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"relationshipType"), (Object)"B")})), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"relationshipType"), (Object)"C")}))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("db.relationshipType work on an empty database", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BuiltInProcedureAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                InternalExecutionResult result = this.$outer.execute("CALL db.relationshipTypes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                this.$outer.convertToAnyShouldWrapper(result).shouldBe(this.$outer.empty(), Emptiness$.MODULE$.emptinessOfAnyRefWithParameterlessIsEmptyMethod());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("db.relationshipTypes should be empty when all relationships are removed", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BuiltInProcedureAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.relate(this.$outer.createNode(), this.$outer.createNode(), "A", this.$outer.relate$default$4());
                this.$outer.relate(this.$outer.createNode(), this.$outer.createNode(), "B", this.$outer.relate$default$4());
                this.$outer.relate(this.$outer.createNode(), this.$outer.createNode(), "C", this.$outer.relate$default$4());
                this.$outer.execute("MATCH (a) DETACH DELETE a", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                InternalExecutionResult result = this.$outer.execute("CALL db.relationshipTypes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                this.$outer.convertToAnyShouldWrapper(result).shouldBe(this.$outer.empty(), Emptiness$.MODULE$.emptinessOfAnyRefWithParameterlessIsEmptyMethod());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should be able to find propertyKeys from built-in-procedure", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BuiltInProcedureAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.createNode((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"A"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"B"), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C"), (Object)BoxesRunTime.boxToInteger((int)3))}));
                InternalExecutionResult result = this.$outer.execute("CALL db.propertyKeys", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                this.$outer.convertToAnyShouldWrapper(result.toList()).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Map[]{(scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"propertyKey"), (Object)"A")})), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"propertyKey"), (Object)"B")})), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"propertyKey"), (Object)"C")}))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("db.propertyKeys works on an empty database", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BuiltInProcedureAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                InternalExecutionResult result = this.$outer.execute("CALL db.propertyKeys", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                this.$outer.convertToAnyShouldWrapper(result).shouldBe(this.$outer.empty(), Emptiness$.MODULE$.emptinessOfAnyRefWithParameterlessIsEmptyMethod());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("removing properties from nodes and relationships does not remove them from the store", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BuiltInProcedureAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.relate(this.$outer.createNode((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"A"), (Object)BoxesRunTime.boxToInteger((int)1))})), this.$outer.createNode((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"B"), (Object)BoxesRunTime.boxToInteger((int)1))})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"R"), (Object)BoxesRunTime.boxToInteger((int)1))}));
                this.$outer.execute("MATCH (a)-[r]-(b) REMOVE a.A, r.R, b.B", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                InternalExecutionResult result = this.$outer.execute("CALL db.propertyKeys", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                this.$outer.convertToAnyShouldWrapper(result.toList()).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Map[]{(scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"propertyKey"), (Object)"A")})), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"propertyKey"), (Object)"B")})), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"propertyKey"), (Object)"R")}))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("removing all nodes and relationship does not remove properties from the store", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BuiltInProcedureAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.relate(this.$outer.createNode((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"A"), (Object)BoxesRunTime.boxToInteger((int)1))})), this.$outer.createNode((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"B"), (Object)BoxesRunTime.boxToInteger((int)1))})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"R"), (Object)BoxesRunTime.boxToInteger((int)1))}));
                this.$outer.execute("MATCH (a) DETACH DELETE a", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                InternalExecutionResult result = this.$outer.execute("CALL db.propertyKeys", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                this.$outer.convertToAnyShouldWrapper(result.toList()).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Map[]{(scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"propertyKey"), (Object)"A")})), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"propertyKey"), (Object)"B")})), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"propertyKey"), (Object)"R")}))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should be able to find indexes from built-in-procedure", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BuiltInProcedureAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.RichGraphDatabaseQueryService((GraphDatabaseQueryService)this.$outer.graph()).createIndex("A", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"prop"}));
                InternalExecutionResult result = this.$outer.execute("CALL db.indexes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                this.$outer.convertToAnyShouldWrapper(result.toList()).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Map[]{(scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"description"), (Object)"INDEX ON :A(prop)"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"state"), (Object)"ONLINE"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)"node_label_property")}))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

