/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.cypher.acceptance;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.internal.cypher.acceptance.ProcedureCallAcceptanceTest;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.proc.Neo4jTypes;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import org.scalatest.matchers.TypeMatcherHelper$;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001Y1A!\u0001\u0002\u0001\u001b\ta\u0013iZ4sK\u001e\fG/[8o\rVt7\r^5p]\u000e\u000bG\u000e\\*vaB|'\u000f^!dG\u0016\u0004H/\u00198dKR+7\u000f\u001e\u0006\u0003\u0007\u0011\t!\"Y2dKB$\u0018M\\2f\u0015\t)a!\u0001\u0004dsBDWM\u001d\u0006\u0003\u000f!\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u0013)\tQA\\3pi)T\u0011aC\u0001\u0004_J<7\u0001A\n\u0003\u00019\u0001\"a\u0004\t\u000e\u0003\tI!!\u0005\u0002\u00037A\u0013xnY3ekJ,7)\u00197m\u0003\u000e\u001cW\r\u001d;b]\u000e,G+Z:u\u0011\u0015\u0019\u0002\u0001\"\u0001\u0015\u0003\u0019a\u0014N\\5u}Q\tQ\u0003\u0005\u0002\u0010\u0001\u0001")
public class AggregationFunctionCallSupportAcceptanceTest
extends ProcedureCallAcceptanceTest {
    public AggregationFunctionCallSupportAcceptanceTest() {
        this.test("should return correctly typed map result (even if converting to and from scala representation internally)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AggregationFunctionCallSupportAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                HashMap<String, Object> value = new HashMap<String, Object>();
                value.put("name", "Cypher");
                value.put("level", BoxesRunTime.boxToInteger((int)9001));
                this.$outer.registerUserAggregationFunction(value, this.$outer.registerUserAggregationFunction$default$2());
                this.$outer.convertToAnyShouldWrapper(Predef$.MODULE$.refArrayOps(this.$outer.RichGraphDatabaseQueryService((GraphDatabaseQueryService)this.$outer.graph()).execute("RETURN my.first.value()").stream().toArray()).toList()).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{Collections.singletonMap("my.first.value()", value)}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should return correctly typed list result (even if converting to and from scala representation internally)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AggregationFunctionCallSupportAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ArrayList<String> value = new ArrayList<String>();
                value.add("Norris");
                value.add("Strange");
                this.$outer.registerUserAggregationFunction(value, this.$outer.registerUserAggregationFunction$default$2());
                this.$outer.convertToAnyShouldWrapper(Predef$.MODULE$.refArrayOps(this.$outer.RichGraphDatabaseQueryService((GraphDatabaseQueryService)this.$outer.graph()).execute("RETURN my.first.value() AS out").stream().toArray()).toList()).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{Collections.singletonMap("out", value)}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should return correctly typed stream result (even if converting to and from scala representation internally)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AggregationFunctionCallSupportAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ArrayList<String> value = new ArrayList<String>();
                value.add("Norris");
                value.add("Strange");
                Stream<E> stream = value.stream();
                this.$outer.registerUserAggregationFunction(stream, this.$outer.registerUserAggregationFunction$default$2());
                this.$outer.convertToAnyShouldWrapper(Predef$.MODULE$.refArrayOps(this.$outer.RichGraphDatabaseQueryService((GraphDatabaseQueryService)this.$outer.graph()).execute("RETURN my.first.value() AS out").stream().toArray()).toList()).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{Collections.singletonMap("out", stream)}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should not copy lists unnecessarily", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AggregationFunctionCallSupportAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ArrayList<String> value = new ArrayList<String>();
                value.add("Norris");
                value.add("Strange");
                this.$outer.registerUserAggregationFunction(value, this.$outer.registerUserAggregationFunction$default$2());
                V returned = this.$outer.RichGraphDatabaseQueryService((GraphDatabaseQueryService)this.$outer.graph()).execute("RETURN my.first.value() AS out").next().get("out");
                TypeMatcherHelper$.MODULE$.checkAnType(this.$outer.convertToAnyShouldWrapper(returned).leftSideValue(), this.$outer.an(ManifestFactory$.MODULE$.classType(ArrayList.class, ManifestFactory$.MODULE$.wildcardType(ManifestFactory$.MODULE$.Nothing(), ManifestFactory$.MODULE$.Any()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0]))));
                this.$outer.convertToAnyShouldWrapper(returned).shouldBe(value);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should not copy unnecessarily with nested types", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AggregationFunctionCallSupportAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ArrayList<Object> value = new ArrayList<Object>();
                ArrayList<E> inner = new ArrayList<E>();
                value.add("Norris");
                value.add(inner);
                this.$outer.registerUserAggregationFunction(value, this.$outer.registerUserAggregationFunction$default$2());
                V returned = this.$outer.RichGraphDatabaseQueryService((GraphDatabaseQueryService)this.$outer.graph()).execute("RETURN my.first.value() AS out").next().get("out");
                TypeMatcherHelper$.MODULE$.checkAnType(this.$outer.convertToAnyShouldWrapper(returned).leftSideValue(), this.$outer.an(ManifestFactory$.MODULE$.classType(ArrayList.class, ManifestFactory$.MODULE$.wildcardType(ManifestFactory$.MODULE$.Nothing(), ManifestFactory$.MODULE$.Any()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0]))));
                this.$outer.convertToAnyShouldWrapper(returned).shouldBe(value);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should handle interacting with list", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AggregationFunctionCallSupportAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ArrayList<Integer> value = new ArrayList<Integer>();
                value.add(Predef$.MODULE$.int2Integer(1));
                value.add(Predef$.MODULE$.int2Integer(3));
                this.$outer.registerUserAggregationFunction(value, (Neo4jTypes.AnyType)Neo4jTypes.NTList((Neo4jTypes.AnyType)Neo4jTypes.NTInteger));
                V returned = this.$outer.RichGraphDatabaseQueryService((GraphDatabaseQueryService)this.$outer.graph()).execute("WITH my.first.value() AS list RETURN list[0] + list[1] AS out").next().get("out");
                this.$outer.convertToAnyShouldWrapper(returned).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)4)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

