/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.csv.reader;

import java.io.Reader;
import java.io.StringReader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.csv.reader.SectionedCharBuffer;

class SectionedCharBufferTest {
    SectionedCharBufferTest() {
    }

    @Test
    void shouldCompactIntoItself() throws Exception {
        StringReader data = new StringReader("01234567");
        SectionedCharBuffer buffer = new SectionedCharBuffer(4);
        buffer.readFrom((Reader)data);
        buffer.compact(buffer, buffer.front() - 2);
        Assertions.assertEquals((char)'2', (char)buffer.array()[2]);
        Assertions.assertEquals((char)'3', (char)buffer.array()[3]);
    }

    @Test
    void shouldCompactIntoAnotherBuffer() throws Exception {
        StringReader data = new StringReader("01234567");
        SectionedCharBuffer buffer1 = new SectionedCharBuffer(8);
        SectionedCharBuffer buffer2 = new SectionedCharBuffer(8);
        buffer1.readFrom((Reader)data);
        buffer2.readFrom((Reader)data);
        buffer1.compact(buffer2, buffer1.pivot() + 2);
        Assertions.assertEquals((char)'2', (char)buffer2.array()[2]);
        Assertions.assertEquals((char)'3', (char)buffer2.array()[3]);
        Assertions.assertEquals((char)'4', (char)buffer2.array()[4]);
        Assertions.assertEquals((char)'5', (char)buffer2.array()[5]);
        Assertions.assertEquals((char)'6', (char)buffer2.array()[6]);
        Assertions.assertEquals((char)'7', (char)buffer2.array()[7]);
    }
}

