/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.csv.reader;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.csv.reader.Extractor;
import org.neo4j.csv.reader.Extractors;
import org.neo4j.values.storable.CSVHeaderInformation;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.Values;

class ExtractorsTest {
    ExtractorsTest() {
    }

    @Test
    void shouldExtractStringArray() {
        Extractors extractors = new Extractors(',');
        String data = "abcde,fghijkl,mnopq";
        Extractor extractor = extractors.valueOf("STRING[]");
        extractor.extract(data.toCharArray(), 0, data.length(), false);
        Assertions.assertArrayEquals((Object[])new String[]{"abcde", "fghijkl", "mnopq"}, (Object[])((Object[])extractor.value()));
    }

    @Test
    void shouldExtractLongArray() {
        Extractors extractors = new Extractors(',');
        long[] longData = new long[]{123L, 4567L, 987654321L};
        String data = ExtractorsTest.toString(longData, ',');
        Extractor extractor = extractors.valueOf("long[]");
        extractor.extract(data.toCharArray(), 0, data.length(), false);
        Assertions.assertArrayEquals((long[])longData, (long[])((long[])extractor.value()));
    }

    @Test
    void shouldExtractBooleanArray() {
        Extractors extractors = new Extractors(',');
        boolean[] booleanData = new boolean[]{true, false, true};
        String data = ExtractorsTest.toString(booleanData, ',');
        Extractor extractor = extractors.booleanArray();
        extractor.extract(data.toCharArray(), 0, data.length(), false);
        ExtractorsTest.assertBooleanArrayEquals(booleanData, (boolean[])extractor.value());
    }

    @Test
    void shouldExtractDoubleArray() {
        Extractors extractors = new Extractors(',');
        double[] doubleData = new double[]{123.123, 4567.4567, 9.876543210987E8};
        String data = ExtractorsTest.toString(doubleData, ',');
        Extractor extractor = extractors.doubleArray();
        extractor.extract(data.toCharArray(), 0, data.length(), false);
        Assertions.assertArrayEquals((double[])doubleData, (double[])((double[])extractor.value()), (double)0.001);
    }

    @Test
    void shouldFailExtractingLongArrayWhereAnyValueIsEmpty() {
        Extractors extractors = new Extractors(';');
        long[] longData = new long[]{112233L, 4455L, 66778899L};
        String data = ExtractorsTest.toString(longData, ';') + ";";
        Assertions.assertThrows(NumberFormatException.class, () -> extractors.longArray().extract(data.toCharArray(), 0, data.length(), false));
    }

    @Test
    void shouldFailExtractingLongArrayWhereAnyValueIsntReallyANumber() {
        Extractors extractors = new Extractors(';');
        String data = "123;456;abc;789";
        Assertions.assertThrows(NumberFormatException.class, () -> extractors.valueOf("long[]").extract(data.toCharArray(), 0, data.length(), false));
    }

    @Test
    void shouldExtractPoint() {
        Extractors extractors = new Extractors(',');
        PointValue value = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{13.2, 56.7});
        char[] asChars = "Point{latitude: 56.7, longitude: 13.2}".toCharArray();
        Extractors.PointExtractor extractor = extractors.point();
        String headerInfo = "{crs:WGS-84}";
        extractor.extract(asChars, 0, asChars.length, false, (CSVHeaderInformation)PointValue.parseHeaderInformation((CharSequence)headerInfo));
        Assertions.assertEquals((Object)value, (Object)extractor.value);
    }

    @Test
    void shouldExtractNegativeInt() {
        Extractors extractors = new Extractors(',');
        int value = -1234567;
        char[] asChars = String.valueOf(value).toCharArray();
        Extractors.IntExtractor extractor = extractors.int_();
        extractor.extract(asChars, 0, asChars.length, false);
        Assertions.assertEquals((int)value, (int)extractor.intValue());
    }

    @Test
    void shouldExtractEmptyStringForEmptyArrayString() {
        Extractors extractors = new Extractors(',');
        String value = "";
        Extractor extractor = extractors.stringArray();
        extractor.extract(value.toCharArray(), 0, value.length(), false);
        Assertions.assertEquals((int)0, (int)((String[])extractor.value()).length);
    }

    @Test
    void shouldExtractEmptyLongArrayForEmptyArrayString() {
        Extractors extractors = new Extractors(',');
        String value = "";
        Extractor extractor = extractors.longArray();
        extractor.extract(value.toCharArray(), 0, value.length(), false);
        Assertions.assertEquals((int)0, (int)((long[])extractor.value()).length);
    }

    @Test
    void shouldExtractTwoEmptyStringsForSingleDelimiterInArrayString() {
        Extractors extractors = new Extractors(',');
        String value = ",";
        Extractor extractor = extractors.stringArray();
        extractor.extract(value.toCharArray(), 0, value.length(), false);
        Assertions.assertArrayEquals((Object[])new String[]{"", ""}, (Object[])((Object[])extractor.value()));
    }

    @Test
    void shouldExtractEmptyStringForEmptyQuotedString() {
        Extractors extractors = new Extractors(',');
        String value = "";
        Extractor extractor = extractors.string();
        extractor.extract(value.toCharArray(), 0, value.length(), true);
        Assertions.assertEquals((Object)"", (Object)extractor.value());
    }

    @Test
    void shouldExtractNullForEmptyQuotedStringIfConfiguredTo() {
        Extractors extractors = new Extractors(';', true);
        Extractor extractor = extractors.string();
        extractor.extract(new char[0], 0, 0, true);
        String extracted = (String)extractor.value();
        Assertions.assertNull((Object)extracted);
    }

    @Test
    void shouldTrimStringArrayIfConfiguredTo() {
        Extractors extractors = new Extractors(';', true, true);
        String value = "ab;cd ; ef; gh ";
        char[] asChars = value.toCharArray();
        Extractor extractor = extractors.stringArray();
        extractor.extract(asChars, 0, asChars.length, true);
        Assertions.assertArrayEquals((Object[])new String[]{"ab", "cd", "ef", "gh"}, (Object[])((Object[])extractor.value()));
    }

    @Test
    void shouldNotTrimStringIfNotConfiguredTo() {
        Extractors extractors = new Extractors(';', true, false);
        String value = "ab;cd ; ef; gh ";
        char[] asChars = value.toCharArray();
        Extractor extractor = extractors.stringArray();
        extractor.extract(asChars, 0, asChars.length, true);
        Assertions.assertArrayEquals((Object[])new String[]{"ab", "cd ", " ef", " gh "}, (Object[])((Object[])extractor.value()));
    }

    @Test
    void shouldCloneExtractor() {
        Extractors extractors = new Extractors(';');
        Extractor e1 = extractors.string();
        Extractor e2 = e1.clone();
        String v1 = "abc";
        e1.extract(v1.toCharArray(), 0, v1.length(), false);
        Assertions.assertEquals((Object)v1, (Object)e1.value());
        Assertions.assertNull((Object)e2.value());
        String v2 = "def";
        e2.extract(v2.toCharArray(), 0, v2.length(), false);
        Assertions.assertEquals((Object)v2, (Object)e2.value());
        Assertions.assertEquals((Object)v1, (Object)e1.value());
    }

    private static String toString(long[] values, char delimiter) {
        StringBuilder builder = new StringBuilder();
        for (long value : values) {
            builder.append(builder.length() > 0 ? Character.valueOf(delimiter) : "").append(value);
        }
        return builder.toString();
    }

    private static String toString(double[] values, char delimiter) {
        StringBuilder builder = new StringBuilder();
        for (double value : values) {
            builder.append(builder.length() > 0 ? Character.valueOf(delimiter) : "").append(value);
        }
        return builder.toString();
    }

    private static String toString(boolean[] values, char delimiter) {
        StringBuilder builder = new StringBuilder();
        for (boolean value : values) {
            builder.append(builder.length() > 0 ? Character.valueOf(delimiter) : "").append(value);
        }
        return builder.toString();
    }

    private static void assertBooleanArrayEquals(boolean[] expected, boolean[] values) {
        Assertions.assertEquals((int)expected.length, (int)values.length, (String)"Array lengths differ");
        for (int i = 0; i < expected.length; ++i) {
            Assertions.assertEquals((Object)expected[i], (Object)values[i], (String)("Item " + i + " differs"));
        }
    }
}

