/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.csv.reader;

import java.util.Arrays;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.csv.reader.CharReadable;
import org.neo4j.csv.reader.CharReadableChunker;
import org.neo4j.csv.reader.ClosestNewLineChunker;
import org.neo4j.csv.reader.Readables;
import org.neo4j.csv.reader.Source;

class ClosestNewLineChunkerTest {
    ClosestNewLineChunkerTest() {
    }

    @Test
    void shouldBackUpChunkToClosestNewline() throws Exception {
        CharReadable reader = Readables.wrap((String)"1234567\n8901234\n5678901234");
        try (ClosestNewLineChunker source = new ClosestNewLineChunker(reader, 12);){
            CharReadableChunker.ChunkImpl chunk = source.newChunk();
            Assertions.assertTrue((boolean)source.nextChunk((Source.Chunk)chunk));
            Assertions.assertArrayEquals((char[])"1234567\n".toCharArray(), (char[])ClosestNewLineChunkerTest.charactersOf((Source.Chunk)chunk));
            Assertions.assertTrue((boolean)source.nextChunk((Source.Chunk)chunk));
            Assertions.assertArrayEquals((char[])"8901234\n".toCharArray(), (char[])ClosestNewLineChunkerTest.charactersOf((Source.Chunk)chunk));
            Assertions.assertTrue((boolean)source.nextChunk((Source.Chunk)chunk));
            Assertions.assertArrayEquals((char[])"5678901234".toCharArray(), (char[])ClosestNewLineChunkerTest.charactersOf((Source.Chunk)chunk));
            Assertions.assertFalse((boolean)source.nextChunk((Source.Chunk)chunk));
        }
    }

    @Test
    void shouldFailIfNoNewlineInChunk() throws Exception {
        CharReadable reader = Readables.wrap((String)"1234567\n89012345678901234");
        try (ClosestNewLineChunker source = new ClosestNewLineChunker(reader, 12);){
            CharReadableChunker.ChunkImpl chunk = source.newChunk();
            Assertions.assertTrue((boolean)source.nextChunk((Source.Chunk)chunk));
            Assertions.assertArrayEquals((char[])"1234567\n".toCharArray(), (char[])ClosestNewLineChunkerTest.charactersOf((Source.Chunk)chunk));
            Assertions.assertThrows(IllegalStateException.class, () -> ClosestNewLineChunkerTest.lambda$shouldFailIfNoNewlineInChunk$0(source, (Source.Chunk)chunk));
        }
    }

    private static char[] charactersOf(Source.Chunk chunk) {
        return Arrays.copyOfRange(chunk.data(), chunk.startPosition(), chunk.startPosition() + chunk.length());
    }

    private static /* synthetic */ void lambda$shouldFailIfNoNewlineInChunk$0(ClosestNewLineChunker source, Source.Chunk chunk) throws Throwable {
        Assertions.assertFalse((boolean)source.nextChunk(chunk));
    }
}

