/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.csv.reader;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.csv.reader.CharReadable;
import org.neo4j.csv.reader.CharSeeker;
import org.neo4j.csv.reader.CharSeekers;
import org.neo4j.csv.reader.Configuration;
import org.neo4j.csv.reader.DataAfterQuoteException;
import org.neo4j.csv.reader.Extractor;
import org.neo4j.csv.reader.Extractors;
import org.neo4j.csv.reader.Mark;
import org.neo4j.csv.reader.Readables;
import org.neo4j.csv.reader.SectionedCharBuffer;
import org.neo4j.helpers.collection.Iterators;

@RunWith(value=Parameterized.class)
public class BufferedCharSeekerTest {
    private static final char[] WHITESPACE_CHARS = new char[]{'\f', '\u000e', '\u00a0', '\u2007', '\u202f', '\t', '\f', '\u001c', '\u001d', '\u001e', '\u001f'};
    private static final char[] DELIMITER_CHARS = new char[]{',', '\t'};
    private static final String TEST_SOURCE = "TestSource";
    private final boolean useThreadAhead;
    private static final int TAB = 9;
    private static final int COMMA = 44;
    private static final Random random = new Random();
    private final Extractors extractors = new Extractors(',');
    private final Mark mark = new Mark();
    private CharSeeker seeker;

    @Parameterized.Parameters(name="{1}")
    public static Collection<Object[]> data() {
        return Arrays.asList({Boolean.FALSE, "without thread-ahead"}, {Boolean.TRUE, "with thread-ahead"});
    }

    @After
    public void closeSeeker() throws IOException {
        if (this.seeker != null) {
            this.seeker.close();
        }
    }

    public BufferedCharSeekerTest(boolean useThreadAhead, String description) {
        this.useThreadAhead = useThreadAhead;
    }

    @Test
    public void shouldFindCertainCharacter() throws Exception {
        this.seeker = this.seeker("abcdefg\thijklmnop\tqrstuvxyz");
        Assert.assertTrue((boolean)this.seeker.seek(this.mark, 9));
        Assert.assertEquals((long)9L, (long)this.mark.character());
        Assert.assertFalse((boolean)this.mark.isEndOfLine());
        Assert.assertEquals((Object)"abcdefg", (Object)this.seeker.extract(this.mark, this.extractors.string()).value());
        Assert.assertTrue((boolean)this.seeker.seek(this.mark, 9));
        Assert.assertEquals((long)9L, (long)this.mark.character());
        Assert.assertFalse((boolean)this.mark.isEndOfLine());
        Assert.assertEquals((Object)"hijklmnop", (Object)this.seeker.extract(this.mark, this.extractors.string()).value());
        Assert.assertTrue((boolean)this.seeker.seek(this.mark, 9));
        Assert.assertTrue((boolean)this.mark.isEndOfLine());
        Assert.assertEquals((Object)"qrstuvxyz", (Object)this.seeker.extract(this.mark, this.extractors.string()).value());
        Assert.assertFalse((boolean)this.seeker.seek(this.mark, 9));
        Assert.assertFalse((boolean)this.seeker.seek(this.mark, 9));
    }

    @Test
    public void shouldReadMultipleLines() throws Exception {
        this.seeker = this.seeker("1\t2\t3\n4\t5\t6\n");
        Assert.assertTrue((boolean)this.seeker.seek(this.mark, 9));
        Assert.assertEquals((long)1L, (long)((Extractors.LongExtractor)this.seeker.extract(this.mark, (Extractor)this.extractors.long_())).longValue());
        Assert.assertTrue((boolean)this.seeker.seek(this.mark, 9));
        Assert.assertEquals((long)2L, (long)((Extractors.LongExtractor)this.seeker.extract(this.mark, (Extractor)this.extractors.long_())).longValue());
        Assert.assertTrue((boolean)this.seeker.seek(this.mark, 9));
        Assert.assertEquals((long)3L, (long)((Extractors.LongExtractor)this.seeker.extract(this.mark, (Extractor)this.extractors.long_())).longValue());
        Assert.assertTrue((boolean)this.mark.isEndOfLine());
        Assert.assertTrue((boolean)this.seeker.seek(this.mark, 9));
        Assert.assertEquals((long)4L, (long)((Extractors.LongExtractor)this.seeker.extract(this.mark, (Extractor)this.extractors.long_())).longValue());
        Assert.assertTrue((boolean)this.seeker.seek(this.mark, 9));
        Assert.assertEquals((long)5L, (long)((Extractors.LongExtractor)this.seeker.extract(this.mark, (Extractor)this.extractors.long_())).longValue());
        Assert.assertTrue((boolean)this.seeker.seek(this.mark, 9));
        Assert.assertEquals((long)6L, (long)((Extractors.LongExtractor)this.seeker.extract(this.mark, (Extractor)this.extractors.long_())).longValue());
        Assert.assertTrue((boolean)this.mark.isEndOfLine());
        Assert.assertFalse((boolean)this.seeker.seek(this.mark, 9));
    }

    @Test
    public void shouldSeekThroughAdditionalBufferRead() throws Exception {
        this.seeker = this.seeker("1234,5678,9012,3456", BufferedCharSeekerTest.config(12));
        this.seeker.seek(this.mark, 44);
        Assert.assertEquals((long)1234L, (long)((Extractors.LongExtractor)this.seeker.extract(this.mark, (Extractor)this.extractors.long_())).longValue());
        this.seeker.seek(this.mark, 44);
        Assert.assertEquals((long)5678L, (long)((Extractors.LongExtractor)this.seeker.extract(this.mark, (Extractor)this.extractors.long_())).longValue());
        this.seeker.seek(this.mark, 44);
        Assert.assertEquals((long)9012L, (long)((Extractors.LongExtractor)this.seeker.extract(this.mark, (Extractor)this.extractors.long_())).longValue());
        this.seeker.seek(this.mark, 44);
        Assert.assertEquals((long)3456L, (long)((Extractors.LongExtractor)this.seeker.extract(this.mark, (Extractor)this.extractors.long_())).longValue());
        Assert.assertFalse((boolean)this.seeker.seek(this.mark, 44));
    }

    @Test
    public void shouldHandleWindowsEndOfLineCharacters() throws Exception {
        this.seeker = this.seeker("here,comes,Windows\r\nand,it,has\rother,line,endings");
        Assert.assertEquals((Object)"here", (Object)(this.seeker.seek(this.mark, 44) ? this.seeker.extract(this.mark, this.extractors.string()).value() : ""));
        Assert.assertEquals((Object)"comes", (Object)(this.seeker.seek(this.mark, 44) ? this.seeker.extract(this.mark, this.extractors.string()).value() : ""));
        Assert.assertEquals((Object)"Windows", (Object)(this.seeker.seek(this.mark, 44) ? this.seeker.extract(this.mark, this.extractors.string()).value() : ""));
        Assert.assertTrue((boolean)this.mark.isEndOfLine());
        Assert.assertEquals((Object)"and", (Object)(this.seeker.seek(this.mark, 44) ? this.seeker.extract(this.mark, this.extractors.string()).value() : ""));
        Assert.assertEquals((Object)"it", (Object)(this.seeker.seek(this.mark, 44) ? this.seeker.extract(this.mark, this.extractors.string()).value() : ""));
        Assert.assertEquals((Object)"has", (Object)(this.seeker.seek(this.mark, 44) ? this.seeker.extract(this.mark, this.extractors.string()).value() : ""));
        Assert.assertTrue((boolean)this.mark.isEndOfLine());
        Assert.assertEquals((Object)"other", (Object)(this.seeker.seek(this.mark, 44) ? this.seeker.extract(this.mark, this.extractors.string()).value() : ""));
        Assert.assertEquals((Object)"line", (Object)(this.seeker.seek(this.mark, 44) ? this.seeker.extract(this.mark, this.extractors.string()).value() : ""));
        Assert.assertEquals((Object)"endings", (Object)(this.seeker.seek(this.mark, 44) ? this.seeker.extract(this.mark, this.extractors.string()).value() : ""));
        Assert.assertTrue((boolean)this.mark.isEndOfLine());
    }

    @Test
    public void shouldHandleReallyWeirdChars() throws Exception {
        int cols = 3;
        int rows = 3;
        char delimiter = '\t';
        String[][] data = this.randomWeirdValues(cols, rows, delimiter, '\n', '\r');
        this.seeker = this.seeker(this.join(data, delimiter));
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < cols; ++col) {
                Assert.assertTrue((boolean)this.seeker.seek(this.mark, 9));
                Assert.assertEquals((Object)data[row][col], (Object)this.seeker.extract(this.mark, this.extractors.string()).value());
            }
            Assert.assertTrue((boolean)this.mark.isEndOfLine());
        }
        Assert.assertFalse((boolean)this.seeker.seek(this.mark, 9));
    }

    @Test
    public void shouldHandleEmptyValues() throws Exception {
        this.seeker = this.seeker("1,,3,4");
        Assert.assertTrue((boolean)this.seeker.seek(this.mark, 44));
        Assert.assertEquals((long)1L, (long)((Extractors.IntExtractor)this.seeker.extract(this.mark, (Extractor)this.extractors.int_())).intValue());
        Assert.assertTrue((boolean)this.seeker.seek(this.mark, 44));
        Assert.assertTrue((boolean)this.seeker.seek(this.mark, 44));
        Assert.assertEquals((long)3L, (long)((Extractors.IntExtractor)this.seeker.extract(this.mark, (Extractor)this.extractors.int_())).intValue());
        Assert.assertTrue((boolean)this.seeker.seek(this.mark, 44));
        Assert.assertEquals((long)4L, (long)((Extractors.IntExtractor)this.seeker.extract(this.mark, (Extractor)this.extractors.int_())).intValue());
    }

    @Test
    public void shouldNotLetEolCharSkippingMessUpPositionsInMark() throws Exception {
        this.seeker = this.seeker("12,34,56\n789,901,23", BufferedCharSeekerTest.config(9));
        Assert.assertTrue((boolean)this.seeker.seek(this.mark, 44));
        Assert.assertEquals((long)12L, (long)((Extractors.IntExtractor)this.seeker.extract(this.mark, (Extractor)this.extractors.int_())).intValue());
        Assert.assertTrue((boolean)this.seeker.seek(this.mark, 44));
        Assert.assertEquals((long)34L, (long)((Extractors.IntExtractor)this.seeker.extract(this.mark, (Extractor)this.extractors.int_())).intValue());
        Assert.assertTrue((boolean)this.seeker.seek(this.mark, 44));
        Assert.assertEquals((long)56L, (long)((Extractors.IntExtractor)this.seeker.extract(this.mark, (Extractor)this.extractors.int_())).intValue());
        Assert.assertTrue((boolean)this.seeker.seek(this.mark, 44));
        Assert.assertEquals((long)789L, (long)((Extractors.IntExtractor)this.seeker.extract(this.mark, (Extractor)this.extractors.int_())).intValue());
        Assert.assertTrue((boolean)this.seeker.seek(this.mark, 44));
        Assert.assertEquals((long)901L, (long)((Extractors.IntExtractor)this.seeker.extract(this.mark, (Extractor)this.extractors.int_())).intValue());
        Assert.assertTrue((boolean)this.seeker.seek(this.mark, 44));
        Assert.assertEquals((long)23L, (long)((Extractors.IntExtractor)this.seeker.extract(this.mark, (Extractor)this.extractors.int_())).intValue());
        Assert.assertFalse((boolean)this.seeker.seek(this.mark, 44));
    }

    @Test
    public void shouldSeeEofEvenIfBufferAlignsWithEnd() throws Exception {
        this.seeker = this.seeker("123,56", BufferedCharSeekerTest.config(6));
        Assert.assertTrue((boolean)this.seeker.seek(this.mark, 44));
        Assert.assertEquals((long)123L, (long)((Extractors.IntExtractor)this.seeker.extract(this.mark, (Extractor)this.extractors.int_())).intValue());
        Assert.assertTrue((boolean)this.seeker.seek(this.mark, 44));
        Assert.assertEquals((long)56L, (long)((Extractors.IntExtractor)this.seeker.extract(this.mark, (Extractor)this.extractors.int_())).intValue());
        Assert.assertFalse((boolean)this.seeker.seek(this.mark, 44));
        Assert.assertFalse((boolean)this.seeker.seek(this.mark, 44));
    }

    @Test
    public void shouldSkipEmptyLastValue() throws Exception {
        this.seeker = this.seeker("one,two,three,\nuno,dos,tres,");
        this.assertNextValue(this.seeker, this.mark, 44, "one");
        this.assertNextValue(this.seeker, this.mark, 44, "two");
        this.assertNextValue(this.seeker, this.mark, 44, "three");
        this.assertNextValueNotExtracted(this.seeker, this.mark, 44);
        Assert.assertTrue((boolean)this.mark.isEndOfLine());
        this.assertNextValue(this.seeker, this.mark, 44, "uno");
        this.assertNextValue(this.seeker, this.mark, 44, "dos");
        this.assertNextValue(this.seeker, this.mark, 44, "tres");
        this.assertNextValueNotExtracted(this.seeker, this.mark, 44);
        this.assertEnd(this.seeker, this.mark, 44);
    }

    @Test
    public void shouldExtractEmptyStringForEmptyQuotedString() throws Exception {
        this.seeker = this.seeker("\"\",,\"\"");
        this.assertNextValue(this.seeker, this.mark, 44, "");
        this.assertNextValueNotExtracted(this.seeker, this.mark, 44);
        this.assertNextValue(this.seeker, this.mark, 44, "");
        Assert.assertFalse((boolean)this.seeker.seek(this.mark, 44));
    }

    @Test
    public void shouldExtractNullForEmptyFieldWhenWeSkipEOLChars() throws Exception {
        this.seeker = this.seeker("\"\",\r\n");
        this.assertNextValue(this.seeker, this.mark, 44, "");
        this.assertNextValueNotExtracted(this.seeker, this.mark, 44);
        Assert.assertFalse((boolean)this.seeker.seek(this.mark, 44));
    }

    @Test
    public void shouldContinueThroughCompletelyEmptyLines() throws Exception {
        this.seeker = this.seeker("one,two,three\n\n\nfour,five,six");
        Assert.assertArrayEquals((Object[])new String[]{"one", "two", "three"}, (Object[])this.nextLineOfAllStrings(this.seeker, this.mark));
        Assert.assertArrayEquals((Object[])new String[]{"four", "five", "six"}, (Object[])this.nextLineOfAllStrings(this.seeker, this.mark));
    }

    @Test
    public void shouldHandleDoubleCharValues() throws IOException {
        this.seeker = this.seeker("v\ud800\udc00lue one\t\"v\ud801\udc01lue two\"\tv\ud804\udc03lue three");
        Assert.assertTrue((boolean)this.seeker.seek(this.mark, 9));
        Assert.assertEquals((Object)"v\ud800\udc00lue one", (Object)this.seeker.extract(this.mark, this.extractors.string()).value());
        Assert.assertTrue((boolean)this.seeker.seek(this.mark, 9));
        Assert.assertEquals((Object)"v\ud801\udc01lue two", (Object)this.seeker.extract(this.mark, this.extractors.string()).value());
        Assert.assertTrue((boolean)this.seeker.seek(this.mark, 9));
        Assert.assertEquals((Object)"v\ud804\udc03lue three", (Object)this.seeker.extract(this.mark, this.extractors.string()).value());
    }

    @Test
    public void shouldReadQuotes() throws Exception {
        this.seeker = this.seeker("value one\t\"value two\"\tvalue three");
        Assert.assertTrue((boolean)this.seeker.seek(this.mark, 9));
        Assert.assertEquals((Object)"value one", (Object)this.seeker.extract(this.mark, this.extractors.string()).value());
        Assert.assertTrue((boolean)this.seeker.seek(this.mark, 9));
        Assert.assertEquals((Object)"value two", (Object)this.seeker.extract(this.mark, this.extractors.string()).value());
        Assert.assertTrue((boolean)this.seeker.seek(this.mark, 9));
        Assert.assertEquals((Object)"value three", (Object)this.seeker.extract(this.mark, this.extractors.string()).value());
    }

    @Test
    public void shouldReadQuotedValuesWithDelimiterInside() throws Exception {
        this.seeker = this.seeker("value one\t\"value\ttwo\"\tvalue three");
        Assert.assertTrue((boolean)this.seeker.seek(this.mark, 9));
        Assert.assertEquals((Object)"value one", (Object)this.seeker.extract(this.mark, this.extractors.string()).value());
        Assert.assertTrue((boolean)this.seeker.seek(this.mark, 9));
        Assert.assertEquals((Object)"value\ttwo", (Object)this.seeker.extract(this.mark, this.extractors.string()).value());
        Assert.assertTrue((boolean)this.seeker.seek(this.mark, 9));
        Assert.assertEquals((Object)"value three", (Object)this.seeker.extract(this.mark, this.extractors.string()).value());
    }

    @Test
    public void shouldReadQuotedValuesWithNewLinesInside() throws Exception {
        this.seeker = this.seeker("value one\t\"value\ntwo\"\tvalue three", BufferedCharSeekerTest.withMultilineFields(BufferedCharSeekerTest.config(), true));
        Assert.assertTrue((boolean)this.seeker.seek(this.mark, 9));
        Assert.assertEquals((Object)"value one", (Object)this.seeker.extract(this.mark, this.extractors.string()).value());
        Assert.assertTrue((boolean)this.seeker.seek(this.mark, 9));
        Assert.assertEquals((Object)"value\ntwo", (Object)this.seeker.extract(this.mark, this.extractors.string()).value());
        Assert.assertTrue((boolean)this.seeker.seek(this.mark, 9));
        Assert.assertEquals((Object)"value three", (Object)this.seeker.extract(this.mark, this.extractors.string()).value());
    }

    @Test
    public void shouldHandleDoubleQuotes() throws Exception {
        this.seeker = this.seeker("\"value \"\"one\"\"\"\t\"\"\"value\"\" two\"\t\"va\"\"lue\"\" three\"");
        Assert.assertTrue((boolean)this.seeker.seek(this.mark, 9));
        Assert.assertEquals((Object)"value \"one\"", (Object)this.seeker.extract(this.mark, this.extractors.string()).value());
        Assert.assertTrue((boolean)this.seeker.seek(this.mark, 9));
        Assert.assertEquals((Object)"\"value\" two", (Object)this.seeker.extract(this.mark, this.extractors.string()).value());
        Assert.assertTrue((boolean)this.seeker.seek(this.mark, 9));
        Assert.assertEquals((Object)"va\"lue\" three", (Object)this.seeker.extract(this.mark, this.extractors.string()).value());
    }

    @Test
    public void shouldHandleSlashEncodedQuotesIfConfiguredWithLegacyStyleQuoting() throws Exception {
        this.seeker = this.seeker("\"value \\\"one\\\"\"\t\"\\\"value\\\" two\"\t\"va\\\"lue\\\" three\"", BufferedCharSeekerTest.withLegacyStyleQuoting(BufferedCharSeekerTest.config(), true));
        Assert.assertTrue((boolean)this.seeker.seek(this.mark, 9));
        Assert.assertEquals((Object)"value \"one\"", (Object)this.seeker.extract(this.mark, this.extractors.string()).value());
        Assert.assertTrue((boolean)this.seeker.seek(this.mark, 9));
        Assert.assertEquals((Object)"\"value\" two", (Object)this.seeker.extract(this.mark, this.extractors.string()).value());
        Assert.assertTrue((boolean)this.seeker.seek(this.mark, 9));
        Assert.assertEquals((Object)"va\"lue\" three", (Object)this.seeker.extract(this.mark, this.extractors.string()).value());
    }

    @Test
    public void shouldRecognizeStrayQuoteCharacters() throws Exception {
        this.seeker = this.seeker("one,two\",th\"ree\nfour,five,s\"ix");
        this.assertNextValue(this.seeker, this.mark, 44, "one");
        this.assertNextValue(this.seeker, this.mark, 44, "two\"");
        this.assertNextValue(this.seeker, this.mark, 44, "th\"ree");
        Assert.assertTrue((boolean)this.mark.isEndOfLine());
        this.assertNextValue(this.seeker, this.mark, 44, "four");
        this.assertNextValue(this.seeker, this.mark, 44, "five");
        this.assertNextValue(this.seeker, this.mark, 44, "s\"ix");
        this.assertEnd(this.seeker, this.mark, 44);
    }

    @Test
    public void shouldNotMisinterpretUnfilledRead() throws Exception {
        ControlledCharReadable readable = new ControlledCharReadable("123,456,789\nabc,def,ghi", 5);
        this.seeker = this.seeker((CharReadable)readable);
        this.assertNextValue(this.seeker, this.mark, 44, "123");
        this.assertNextValue(this.seeker, this.mark, 44, "456");
        this.assertNextValue(this.seeker, this.mark, 44, "789");
        Assert.assertTrue((boolean)this.mark.isEndOfLine());
        this.assertNextValue(this.seeker, this.mark, 44, "abc");
        this.assertNextValue(this.seeker, this.mark, 44, "def");
        this.assertNextValue(this.seeker, this.mark, 44, "ghi");
        this.assertEnd(this.seeker, this.mark, 44);
    }

    @Test
    public void shouldNotFindAnyValuesForEmptySource() throws Exception {
        this.seeker = this.seeker("");
        Assert.assertFalse((boolean)this.seeker.seek(this.mark, 44));
    }

    @Test
    public void shouldSeeQuotesInQuotes() throws Exception {
        this.seeker = this.seeker("4,\"\"\"\",\"f\\oo\"");
        this.assertNextValue(this.seeker, this.mark, 44, "4");
        this.assertNextValue(this.seeker, this.mark, 44, "\"");
        this.assertNextValue(this.seeker, this.mark, 44, "f\\oo");
        Assert.assertFalse((boolean)this.seeker.seek(this.mark, 44));
    }

    @Test
    public void shouldEscapeBackslashesInQuotesIfConfiguredWithLegacyStyleQuoting() throws Exception {
        this.seeker = this.seeker("4,\"\\\\\\\"\",\"f\\oo\"", BufferedCharSeekerTest.withLegacyStyleQuoting(BufferedCharSeekerTest.config(), true));
        this.assertNextValue(this.seeker, this.mark, 44, "4");
        this.assertNextValue(this.seeker, this.mark, 44, "\\\"");
        this.assertNextValue(this.seeker, this.mark, 44, "f\\oo");
        Assert.assertFalse((boolean)this.seeker.seek(this.mark, 44));
    }

    @Test
    public void shouldListenToMusic() throws Exception {
        String data = "\"1\",\"ABBA\",\"1992\"\n\"2\",\"Roxette\",\"1986\"\n\"3\",\"Europe\",\"1979\"\n\"4\",\"The Cardigans\",\"1992\"";
        this.seeker = this.seeker(data);
        this.assertNextValue(this.seeker, this.mark, 44, "1");
        this.assertNextValue(this.seeker, this.mark, 44, "ABBA");
        this.assertNextValue(this.seeker, this.mark, 44, "1992");
        Assert.assertTrue((boolean)this.mark.isEndOfLine());
        this.assertNextValue(this.seeker, this.mark, 44, "2");
        this.assertNextValue(this.seeker, this.mark, 44, "Roxette");
        this.assertNextValue(this.seeker, this.mark, 44, "1986");
        Assert.assertTrue((boolean)this.mark.isEndOfLine());
        this.assertNextValue(this.seeker, this.mark, 44, "3");
        this.assertNextValue(this.seeker, this.mark, 44, "Europe");
        this.assertNextValue(this.seeker, this.mark, 44, "1979");
        Assert.assertTrue((boolean)this.mark.isEndOfLine());
        this.assertNextValue(this.seeker, this.mark, 44, "4");
        this.assertNextValue(this.seeker, this.mark, 44, "The Cardigans");
        this.assertNextValue(this.seeker, this.mark, 44, "1992");
        this.assertEnd(this.seeker, this.mark, 44);
    }

    @Test
    public void shouldFailOnCharactersAfterEndQuote() throws Exception {
        String data = "abc,\"def\"ghi,jkl";
        this.seeker = this.seeker(data);
        this.assertNextValue(this.seeker, this.mark, 44, "abc");
        try {
            this.seeker.seek(this.mark, 44);
            Assert.fail((String)"Should've failed");
        }
        catch (DataAfterQuoteException e) {
            Assert.assertEquals((Object)TEST_SOURCE, (Object)e.source().sourceDescription());
        }
    }

    @Test
    public void shouldParseMultilineFieldWhereEndQuoteIsOnItsOwnLineSingleCharNewline() throws Exception {
        this.shouldParseMultilineFieldWhereEndQuoteIsOnItsOwnLine("\n");
    }

    @Test
    public void shouldParseMultilineFieldWhereEndQuoteIsOnItsOwnLinePlatformNewline() throws Exception {
        this.shouldParseMultilineFieldWhereEndQuoteIsOnItsOwnLine("%n");
    }

    @Test
    public void shouldFailOnReadingFieldLargerThanBufferSize() throws Exception {
        String data = this.lines("\n", "a,b,c", "d,e,f", "\"g,h,i", "abcdefghijlkmopqrstuvwxyz,l,m");
        this.seeker = this.seeker(data, BufferedCharSeekerTest.withMultilineFields(BufferedCharSeekerTest.config(20), true));
        this.assertNextValue(this.seeker, this.mark, 44, "a");
        this.assertNextValue(this.seeker, this.mark, 44, "b");
        this.assertNextValue(this.seeker, this.mark, 44, "c");
        Assert.assertTrue((boolean)this.mark.isEndOfLine());
        this.assertNextValue(this.seeker, this.mark, 44, "d");
        this.assertNextValue(this.seeker, this.mark, 44, "e");
        this.assertNextValue(this.seeker, this.mark, 44, "f");
        Assert.assertTrue((boolean)this.mark.isEndOfLine());
        try {
            this.seeker.seek(this.mark, 44);
            Assert.fail((String)"Should have failed");
        }
        catch (IllegalStateException e) {
            String source = this.seeker.sourceDescription();
            Assert.assertTrue((boolean)e.getMessage().contains("Tried to read"));
            Assert.assertTrue((boolean)e.getMessage().contains(source + ":3"));
        }
    }

    @Test
    public void shouldNotInterpretBackslashQuoteDifferentlyIfDisabledLegacyStyleQuoting() throws Exception {
        char slash = '\\';
        String data = this.lines("\n", "'abc''def" + slash + "''ghi'");
        this.seeker = this.seeker(data, BufferedCharSeekerTest.withLegacyStyleQuoting(BufferedCharSeekerTest.withQuoteCharacter(BufferedCharSeekerTest.config(), '\''), false));
        this.assertNextValue(this.seeker, this.mark, 44, "abc'def" + slash + "'ghi");
        Assert.assertFalse((boolean)this.seeker.seek(this.mark, 44));
    }

    private void shouldParseMultilineFieldWhereEndQuoteIsOnItsOwnLine(String newline) throws Exception {
        String data = this.lines(newline, "1,\"Bar\"", "2,\"Bar", "", "Quux", "\"", "3,\"Bar", "", "Quux\"", "");
        this.seeker = this.seeker(data, BufferedCharSeekerTest.withMultilineFields(BufferedCharSeekerTest.config(), true));
        this.assertNextValue(this.seeker, this.mark, 44, "1");
        this.assertNextValue(this.seeker, this.mark, 44, "Bar");
        this.assertNextValue(this.seeker, this.mark, 44, "2");
        this.assertNextValue(this.seeker, this.mark, 44, this.lines(newline, "Bar", "", "Quux", ""));
        this.assertNextValue(this.seeker, this.mark, 44, "3");
        this.assertNextValue(this.seeker, this.mark, 44, this.lines(newline, "Bar", "", "Quux"));
    }

    @Test
    public void shouldTrimWhitespace() throws Exception {
        String data = this.lines("\n", "Foo, Bar,  Twobar , \"Baz\" , \" Quux \",\"Wiii \" , Waaaa  ");
        this.seeker = this.seeker(data, BufferedCharSeekerTest.withTrimStrings(BufferedCharSeekerTest.config(), true));
        this.assertNextValue(this.seeker, this.mark, 44, "Foo");
        this.assertNextValue(this.seeker, this.mark, 44, "Bar");
        this.assertNextValue(this.seeker, this.mark, 44, "Twobar");
        this.assertNextValue(this.seeker, this.mark, 44, "Baz");
        this.assertNextValue(this.seeker, this.mark, 44, " Quux ");
        this.assertNextValue(this.seeker, this.mark, 44, "Wiii ");
        this.assertNextValue(this.seeker, this.mark, 44, "Waaaa");
    }

    @Test
    public void shouldTrimStringsWithFirstLineCharacterSpace() throws IOException {
        String line = " ,a, ,b, ";
        this.seeker = this.seeker(line, BufferedCharSeekerTest.withTrimStrings(BufferedCharSeekerTest.config(), true));
        this.assertNextValueNotExtracted(this.seeker, this.mark, 44);
        this.assertNextValue(this.seeker, this.mark, 44, "a");
        this.assertNextValueNotExtracted(this.seeker, this.mark, 44);
        this.assertNextValue(this.seeker, this.mark, 44, "b");
        this.assertNextValueNotExtracted(this.seeker, this.mark, 44);
        this.assertEnd(this.seeker, this.mark, 44);
    }

    @Test
    public void shouldParseAndTrimRandomStrings() throws IOException {
        StringBuilder builder = new StringBuilder();
        int columns = random.nextInt(10) + 5;
        int lines = 100;
        ArrayList<String> expected = new ArrayList<String>();
        char delimiter = this.randomDelimiter();
        for (int i = 0; i < lines; ++i) {
            for (int j = 0; j < columns; ++j) {
                if (j > 0) {
                    if (random.nextBoolean()) {
                        builder.append(this.randomWhitespace(delimiter));
                    }
                    builder.append(delimiter);
                    if (random.nextBoolean()) {
                        builder.append(this.randomWhitespace(delimiter));
                    }
                }
                boolean quote = random.nextBoolean();
                if (random.nextBoolean()) {
                    String value = "";
                    if (quote && random.nextBoolean()) {
                        value = value + this.randomWhitespace(delimiter);
                    }
                    value = value + String.valueOf(random.nextInt());
                    if (quote && random.nextBoolean()) {
                        value = value + this.randomWhitespace(delimiter);
                    }
                    expected.add(value);
                    builder.append(quote ? "\"" + value + "\"" : value);
                    continue;
                }
                expected.add(null);
            }
            builder.append(String.format("%n", new Object[0]));
        }
        String data = builder.toString();
        this.seeker = this.seeker(data, BufferedCharSeekerTest.withTrimStrings(BufferedCharSeekerTest.config(), true));
        Iterator next = expected.iterator();
        for (int i = 0; i < lines; ++i) {
            for (int j = 0; j < columns; ++j) {
                String nextExpected = (String)next.next();
                if (nextExpected == null) {
                    this.assertNextValueNotExtracted(this.seeker, this.mark, delimiter);
                    continue;
                }
                this.assertNextValue(this.seeker, this.mark, delimiter, nextExpected);
            }
        }
        this.assertEnd(this.seeker, this.mark, delimiter);
    }

    private char randomDelimiter() {
        return DELIMITER_CHARS[random.nextInt(DELIMITER_CHARS.length)];
    }

    private char randomWhitespace(char except) {
        char ch;
        while ((ch = WHITESPACE_CHARS[random.nextInt(WHITESPACE_CHARS.length)]) == except) {
        }
        return ch;
    }

    @Test
    public void shouldParseNonLatinCharacters() throws IOException {
        List<String[]> expected = Arrays.asList((String[])Iterators.array((Object[])new String[]{"\u666e\u901a\ufffd?/\u666e\u901a\u8a71", "\ud83d\ude21"}), (String[])Iterators.array((Object[])new String[]{"\ud83d\ude21\ud83d\udca9\ud83d\udc7b", "\u2cb9\u6961\ufffd?\uf382\ud19c\u0d37\u06e2\u2f08\ufffd?\ufffd\ub289\ufffd?\ufffd\u20ad\uc0fa\ue652\u131a\u7827\u6521\u8dff\u5bb6\u4bf6\ufffd?\u2b16\ufffd?\ufffd\u72bd\u06fc"}), (String[])Iterators.array((Object[])new String[]{"\u2009\u3e82\ufffd?\u92e6\u6be0\uefe0", "\u037e\uba35\ufffd?\u88ec\u5cb0\u9df2\u8dab\ua8c5\uc5b1\u34d9\u9aff\u16b3\u1b3c\u2269\ufffd?\ufffd\u2004"}));
        String data = this.lines(String.format("%n", new Object[0]), expected);
        this.seeker = this.seeker(data);
        for (String[] line : expected) {
            for (String cell : line) {
                this.assertNextValue(this.seeker, this.mark, 44, cell);
            }
        }
        this.assertEnd(this.seeker, this.mark, 44);
    }

    private String lines(String newline, List<String[]> cells) {
        String[] lines = new String[cells.size()];
        int i = 0;
        for (Object[] objectArray : cells) {
            lines[i++] = StringUtils.join((Object[])objectArray, (String)",");
        }
        return this.lines(newline, lines);
    }

    private String lines(String newline, String ... lines) {
        StringBuilder builder = new StringBuilder();
        for (String line : lines) {
            if (builder.length() > 0) {
                builder.append(String.format(newline, new Object[0]));
            }
            builder.append(line);
        }
        return builder.toString();
    }

    private String[][] randomWeirdValues(int cols, int rows, char ... except) {
        String[][] data = new String[rows][cols];
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < cols; ++col) {
                data[row][col] = this.randomWeirdValue(except);
            }
        }
        return data;
    }

    private String randomWeirdValue(char ... except) {
        int length = random.nextInt(10) + 5;
        char[] chars = new char[length];
        for (int i = 0; i < length; ++i) {
            chars[i] = this.randomWeirdChar(except);
        }
        return new String(chars);
    }

    private char randomWeirdChar(char ... except) {
        char candidate;
        while (this.in(candidate = (char)random.nextInt(65535), except)) {
        }
        return candidate;
    }

    private boolean in(char candidate, char[] set) {
        for (char ch : set) {
            if (ch != candidate) continue;
            return true;
        }
        return false;
    }

    private String join(String[][] data, char delimiter) {
        String delimiterString = String.valueOf(delimiter);
        StringBuilder builder = new StringBuilder();
        for (String[] line : data) {
            for (int i = 0; i < line.length; ++i) {
                builder.append(i > 0 ? delimiterString : "").append(line[i]);
            }
            builder.append("\n");
        }
        return builder.toString();
    }

    private void assertNextValue(CharSeeker seeker, Mark mark, int delimiter, String expectedValue) throws IOException {
        Assert.assertTrue((boolean)seeker.seek(mark, delimiter));
        Assert.assertEquals((Object)expectedValue, (Object)seeker.extract(mark, this.extractors.string()).value());
    }

    private void assertNextValueNotExtracted(CharSeeker seeker, Mark mark, int delimiter) throws IOException {
        Assert.assertTrue((boolean)seeker.seek(mark, delimiter));
        Assert.assertFalse((boolean)seeker.tryExtract(mark, this.extractors.string()));
    }

    private void assertEnd(CharSeeker seeker, Mark mark, int delimiter) throws IOException {
        Assert.assertTrue((boolean)mark.isEndOfLine());
        Assert.assertFalse((boolean)seeker.seek(mark, delimiter));
    }

    private String[] nextLineOfAllStrings(CharSeeker seeker, Mark mark) throws IOException {
        ArrayList<Object> line = new ArrayList<Object>();
        while (seeker.seek(mark, 44)) {
            line.add(seeker.extract(mark, this.extractors.string()).value());
            if (!mark.isEndOfLine()) continue;
            break;
        }
        return line.toArray(new String[line.size()]);
    }

    private CharSeeker seeker(CharReadable readable) {
        return this.seeker(readable, BufferedCharSeekerTest.config());
    }

    private CharSeeker seeker(CharReadable readable, Configuration config) {
        return CharSeekers.charSeeker((CharReadable)readable, (Configuration)config, (boolean)this.useThreadAhead);
    }

    private CharSeeker seeker(String data) {
        return this.seeker(data, BufferedCharSeekerTest.config());
    }

    private CharSeeker seeker(String data, Configuration config) {
        return this.seeker(Readables.wrap((Reader)this.stringReaderWithName(data, TEST_SOURCE), (long)(data.length() * 2)), config);
    }

    private Reader stringReaderWithName(String data, final String name) {
        return new StringReader(data){

            public String toString() {
                return name;
            }
        };
    }

    private static Configuration config() {
        return BufferedCharSeekerTest.config(1000);
    }

    private static Configuration config(final int bufferSize) {
        return new Configuration.Overridden(Configuration.DEFAULT){

            public int bufferSize() {
                return bufferSize;
            }
        };
    }

    private static Configuration withMultilineFields(Configuration config, final boolean multiline) {
        return new Configuration.Overridden(config){

            public boolean multilineFields() {
                return multiline;
            }
        };
    }

    private static Configuration withLegacyStyleQuoting(Configuration config, final boolean legacyStyleQuoting) {
        return new Configuration.Overridden(config){

            public boolean legacyStyleQuoting() {
                return legacyStyleQuoting;
            }
        };
    }

    private static Configuration withQuoteCharacter(Configuration config, final char quoteCharacter) {
        return new Configuration.Overridden(config){

            public char quotationCharacter() {
                return quoteCharacter;
            }
        };
    }

    private static Configuration withTrimStrings(Configuration config, final boolean trimStrings) {
        return new Configuration.Overridden(config){

            public boolean trimStrings() {
                return trimStrings;
            }
        };
    }

    private static class ControlledCharReadable
    extends CharReadable.Adapter {
        private final StringReader reader;
        private final int maxBytesPerRead;
        private final String data;

        ControlledCharReadable(String data, int maxBytesPerRead) {
            this.data = data;
            this.reader = new StringReader(data);
            this.maxBytesPerRead = maxBytesPerRead;
        }

        public SectionedCharBuffer read(SectionedCharBuffer buffer, int from) throws IOException {
            buffer.compact(buffer, from);
            buffer.readFrom((Reader)this.reader, this.maxBytesPerRead);
            return buffer;
        }

        public int read(char[] into, int offset, int length) {
            throw new UnsupportedOperationException();
        }

        public long position() {
            return 0L;
        }

        public String sourceDescription() {
            return ((Object)((Object)this)).getClass().getSimpleName();
        }

        public long length() {
            return this.data.length() * 2;
        }
    }
}

