/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.csv.reader;

import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.csv.reader.CharReadable;
import org.neo4j.csv.reader.CharReadableChunker;
import org.neo4j.csv.reader.ClosestNewLineChunker;
import org.neo4j.csv.reader.Readables;
import org.neo4j.csv.reader.SectionedCharBuffer;
import org.neo4j.csv.reader.Source;

public class ClosestNewLineChunkerTest {
    @Test
    public void shouldBackUpChunkToClosestNewline() throws Exception {
        CharReadable reader = Readables.wrap((String)"1234567\n8901234\n5678901234");
        try (ClosestNewLineChunker source = new ClosestNewLineChunker(reader, 12);){
            CharReadableChunker.ChunkImpl chunk = source.newChunk();
            Assert.assertTrue((boolean)source.nextChunk((Source.Chunk)chunk));
            Assert.assertArrayEquals((char[])"1234567\n".toCharArray(), (char[])ClosestNewLineChunkerTest.charactersOf((Source.Chunk)chunk));
            Assert.assertTrue((boolean)source.nextChunk((Source.Chunk)chunk));
            Assert.assertArrayEquals((char[])"8901234\n".toCharArray(), (char[])ClosestNewLineChunkerTest.charactersOf((Source.Chunk)chunk));
            Assert.assertTrue((boolean)source.nextChunk((Source.Chunk)chunk));
            Assert.assertArrayEquals((char[])"5678901234".toCharArray(), (char[])ClosestNewLineChunkerTest.charactersOf((Source.Chunk)chunk));
            Assert.assertFalse((boolean)source.nextChunk((Source.Chunk)chunk));
        }
    }

    @Test
    public void shouldFailIfNoNewlineInChunk() throws Exception {
        CharReadable reader = Readables.wrap((String)"1234567\n89012345678901234");
        try (ClosestNewLineChunker source = new ClosestNewLineChunker(reader, 12);){
            CharReadableChunker.ChunkImpl chunk = source.newChunk();
            Assert.assertTrue((boolean)source.nextChunk((Source.Chunk)chunk));
            Assert.assertArrayEquals((char[])"1234567\n".toCharArray(), (char[])ClosestNewLineChunkerTest.charactersOf((Source.Chunk)chunk));
            try {
                Assert.assertFalse((boolean)source.nextChunk((Source.Chunk)chunk));
                Assert.fail((String)"Should have failed here");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    private CharReadable dataWithLines(final int lineCount) {
        return new CharReadable.Adapter(){
            private int line;

            public String sourceDescription() {
                return "test";
            }

            public int read(char[] into, int offset, int length) {
                assert (offset == 0) : "This test assumes offset is 0, which it always was for this use case at the time of writing";
                if (this.line++ == lineCount) {
                    return -1;
                }
                into[length - 1] = 10;
                return length;
            }

            public SectionedCharBuffer read(SectionedCharBuffer buffer, int from) {
                throw new UnsupportedOperationException();
            }

            public long length() {
                return 0L;
            }
        };
    }

    static char[] charactersOf(Source.Chunk chunk) {
        return Arrays.copyOfRange(chunk.data(), chunk.startPosition(), chunk.startPosition() + chunk.length());
    }
}

