/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.csv.reader;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.collection.RawIterator;
import org.neo4j.csv.reader.CharReadable;
import org.neo4j.csv.reader.CharSeeker;
import org.neo4j.csv.reader.CharSeekers;
import org.neo4j.csv.reader.Configuration;
import org.neo4j.csv.reader.Extractors;
import org.neo4j.csv.reader.Mark;
import org.neo4j.csv.reader.MultiReadable;
import org.neo4j.csv.reader.Readables;
import org.neo4j.csv.reader.SectionedCharBuffer;

public class MultiReadableTest {
    private static final Configuration CONFIG = new Configuration.Overridden(Configuration.DEFAULT){

        public int bufferSize() {
            return 200;
        }
    };
    private final Mark mark = new Mark();
    private final Extractors extractors = new Extractors(';');
    private final int delimiter = 44;

    @Test
    public void shouldReadFromMultipleReaders() throws Exception {
        String[][] data = new String[][]{{"this is", "the first line"}, {"where this", "is the second line"}, {"and here comes", "the third line"}};
        RawIterator<CharReadable, IOException> readers = this.readerIteratorFromStrings(data, null);
        CharSeeker seeker = CharSeekers.charSeeker((CharReadable)new MultiReadable(readers), (Configuration)CONFIG, (boolean)true);
        for (String[] line : data) {
            this.assertNextLine(line, seeker, this.mark, this.extractors);
        }
        Assert.assertFalse((boolean)seeker.seek(this.mark, 44));
        seeker.close();
    }

    @Test
    public void shouldHandleSourcesEndingWithNewLine() throws Exception {
        String[][] data = new String[][]{{"this is", "the first line"}, {"where this", "is the second line"}};
        RawIterator<CharReadable, IOException> readers = this.readerIteratorFromStrings(data, Character.valueOf('\n'));
        CharSeeker seeker = CharSeekers.charSeeker((CharReadable)new MultiReadable(readers), (Configuration)CONFIG, (boolean)true);
        for (String[] line : data) {
            this.assertNextLine(line, seeker, this.mark, this.extractors);
        }
        Assert.assertFalse((boolean)seeker.seek(this.mark, 44));
        seeker.close();
    }

    @Test
    public void shouldTrackAbsolutePosition() throws Exception {
        String[][] data = new String[][]{{"this is", "the first line"}, {"where this", "is the second line"}};
        RawIterator<CharReadable, IOException> readers = this.readerIteratorFromStrings(data, Character.valueOf('\n'));
        MultiReadable reader = new MultiReadable(readers);
        Assert.assertEquals((long)0L, (long)reader.position());
        SectionedCharBuffer buffer = new SectionedCharBuffer(15);
        reader.read(buffer, buffer.front());
        Assert.assertEquals((long)15L, (long)reader.position());
        reader.read(buffer, buffer.front());
        Assert.assertEquals((String)"Should not transition to a new reader in the middle of a read", (long)23L, (long)reader.position());
        Assert.assertEquals((Object)"Reader1", (Object)reader.sourceDescription());
        reader.read(buffer, buffer.front());
        Assert.assertEquals((long)38L, (long)reader.position());
        reader.read(buffer, buffer.front());
        Assert.assertEquals((long)53L, (long)reader.position());
        reader.read(buffer, buffer.front());
        Assert.assertFalse((boolean)buffer.hasAvailable());
    }

    @Test
    public void shouldNotCrossSourcesInOneRead() throws Exception {
        String source1 = "abcdefghijklm";
        String source2 = "nopqrstuvwxyz";
        String[][] data = new String[][]{{source1}, {source2}};
        MultiReadable readable = new MultiReadable(this.readerIteratorFromStrings(data, Character.valueOf('\n')));
        char[] target = new char[source1.length() + source2.length() / 2];
        int read = readable.read(target, 0, target.length);
        Assert.assertEquals((long)(source1.length() + 1), (long)read);
        target = new char[source2.length()];
        read = readable.read(target, 0, target.length);
        Assert.assertEquals((long)source2.length(), (long)read);
        read = readable.read(target, 0, target.length);
        Assert.assertEquals((long)1L, (long)read);
    }

    private void assertNextLine(String[] line, CharSeeker seeker, Mark mark, Extractors extractors) throws IOException {
        for (String value : line) {
            Assert.assertTrue((boolean)seeker.seek(mark, 44));
            Assert.assertEquals((Object)value, (Object)seeker.extract(mark, extractors.string()).value());
        }
        Assert.assertTrue((boolean)mark.isEndOfLine());
    }

    private RawIterator<CharReadable, IOException> readerIteratorFromStrings(final String[][] data, final Character lineEnding) {
        return new RawIterator<CharReadable, IOException>(){
            private int cursor;

            public boolean hasNext() {
                return this.cursor < data.length;
            }

            public CharReadable next() {
                String string = this.join(data[this.cursor++]);
                return Readables.wrap((Reader)new StringReader(string){

                    public String toString() {
                        return "Reader" + cursor;
                    }
                }, (long)(string.length() * 2));
            }

            private String join(String[] strings) {
                StringBuilder builder = new StringBuilder();
                for (String string : strings) {
                    builder.append(builder.length() > 0 ? "," : "").append(string);
                }
                if (lineEnding != null) {
                    builder.append(lineEnding);
                }
                return builder.toString();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

