/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.csv.reader;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.collection.RawIterator;
import org.neo4j.csv.reader.CharReadable;
import org.neo4j.csv.reader.CharSeeker;
import org.neo4j.csv.reader.CharSeekers;
import org.neo4j.csv.reader.Configuration;
import org.neo4j.csv.reader.Extractors;
import org.neo4j.csv.reader.Mark;
import org.neo4j.csv.reader.MultiReadable;
import org.neo4j.csv.reader.Readables;
import org.neo4j.csv.reader.SectionedCharBuffer;

public class MultiReadableTest {
    private static final Configuration CONFIG = new Configuration.Overridden(Configuration.DEFAULT){

        public int bufferSize() {
            return 200;
        }
    };
    private final Mark mark = new Mark();
    private final Extractors extractors = new Extractors(';');
    private final int delimiter = 44;

    @Test
    public void shouldReadFromMultipleReaders() throws Exception {
        String[][] data = new String[][]{{"this is", "the first line"}, {"where this", "is the second line"}, {"and here comes", "the third line"}};
        RawIterator<Reader, IOException> readers = this.readerIteratorFromStrings(data, null);
        CharSeeker seeker = CharSeekers.charSeeker((CharReadable)new MultiReadable(readers), (Configuration)CONFIG, (boolean)true);
        for (String[] line : data) {
            this.assertNextLine(line, seeker, this.mark, this.extractors);
        }
        Assert.assertFalse((boolean)seeker.seek(this.mark, 44));
        seeker.close();
    }

    @Test
    public void shouldHandleSourcesEndingWithNewLine() throws Exception {
        String[][] data = new String[][]{{"this is", "the first line"}, {"where this", "is the second line"}};
        RawIterator<Reader, IOException> readers = this.readerIteratorFromStrings(data, Character.valueOf('\n'));
        CharSeeker seeker = CharSeekers.charSeeker((CharReadable)Readables.sources(readers), (Configuration)CONFIG, (boolean)true);
        for (String[] line : data) {
            this.assertNextLine(line, seeker, this.mark, this.extractors);
        }
        Assert.assertFalse((boolean)seeker.seek(this.mark, 44));
        seeker.close();
    }

    @Test
    public void shouldTrackAbsolutePosition() throws Exception {
        String[][] data = new String[][]{{"this is", "the first line"}, {"where this", "is the second line"}};
        RawIterator<Reader, IOException> readers = this.readerIteratorFromStrings(data, Character.valueOf('\n'));
        CharReadable reader = Readables.sources(readers);
        Assert.assertEquals((long)0L, (long)reader.position());
        SectionedCharBuffer buffer = new SectionedCharBuffer(15);
        reader.read(buffer, buffer.front());
        Assert.assertEquals((long)15L, (long)reader.position());
        reader.read(buffer, buffer.front());
        Assert.assertEquals((String)"Should not transition to a new reader in the middle of a read", (long)23L, (long)reader.position());
        Assert.assertEquals((Object)"Reader1", (Object)reader.sourceDescription());
        reader.read(buffer, buffer.front());
        Assert.assertEquals((long)38L, (long)reader.position());
        reader.read(buffer, buffer.front());
        Assert.assertEquals((long)53L, (long)reader.position());
        reader.read(buffer, buffer.front());
        Assert.assertFalse((boolean)buffer.hasAvailable());
    }

    private void assertNextLine(String[] line, CharSeeker seeker, Mark mark, Extractors extractors) throws IOException {
        for (String value : line) {
            Assert.assertTrue((boolean)seeker.seek(mark, 44));
            Assert.assertEquals((Object)value, (Object)seeker.extract(mark, extractors.string()).value());
        }
        Assert.assertTrue((boolean)mark.isEndOfLine());
    }

    private RawIterator<Reader, IOException> readerIteratorFromStrings(final String[][] data, final Character lineEnding) {
        return new RawIterator<Reader, IOException>(){
            private int cursor;

            public boolean hasNext() {
                return this.cursor < data.length;
            }

            public Reader next() {
                return new StringReader(this.join(data[this.cursor++])){

                    public String toString() {
                        return "Reader" + cursor;
                    }
                };
            }

            private String join(String[] strings) {
                StringBuilder builder = new StringBuilder();
                for (String string : strings) {
                    builder.append(builder.length() > 0 ? "," : "").append(string);
                }
                if (lineEnding != null) {
                    builder.append(lineEnding);
                }
                return builder.toString();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

