/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.csv.reader;

import java.io.Reader;
import java.io.StringReader;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.csv.reader.SectionedCharBuffer;

public class SectionedCharBufferTest {
    @Test
    public void shouldCompactIntoItself() throws Exception {
        StringReader data = new StringReader("01234567");
        SectionedCharBuffer buffer = new SectionedCharBuffer(4);
        buffer.readFrom((Reader)data);
        buffer.compact(buffer, buffer.front() - 2);
        Assert.assertEquals((long)50L, (long)buffer.array()[2]);
        Assert.assertEquals((long)51L, (long)buffer.array()[3]);
    }

    @Test
    public void shouldCompactIntoAnotherBuffer() throws Exception {
        StringReader data = new StringReader("01234567");
        SectionedCharBuffer buffer1 = new SectionedCharBuffer(8);
        SectionedCharBuffer buffer2 = new SectionedCharBuffer(8);
        buffer1.readFrom((Reader)data);
        buffer2.readFrom((Reader)data);
        buffer1.compact(buffer2, buffer1.pivot() + 2);
        Assert.assertEquals((long)50L, (long)buffer2.array()[2]);
        Assert.assertEquals((long)51L, (long)buffer2.array()[3]);
        Assert.assertEquals((long)52L, (long)buffer2.array()[4]);
        Assert.assertEquals((long)53L, (long)buffer2.array()[5]);
        Assert.assertEquals((long)54L, (long)buffer2.array()[6]);
        Assert.assertEquals((long)55L, (long)buffer2.array()[7]);
    }
}

