/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.csv.reader;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.csv.reader.CharReadable;
import org.neo4j.csv.reader.ProcessingSource;
import org.neo4j.csv.reader.Readables;
import org.neo4j.csv.reader.SectionedCharBuffer;
import org.neo4j.csv.reader.Source;

public class ProcessingSourceTest {
    @Test
    public void shouldBackUpChunkToClosestNewline() throws Exception {
        CharReadable reader = Readables.wrap((Reader)new StringReader("1234567\n8901234\n5678901234"));
        try (ProcessingSource source = new ProcessingSource(reader, 12, 1);){
            Source.Chunk first = source.nextChunk();
            Assert.assertArrayEquals((char[])"1234567\n".toCharArray(), (char[])this.charactersOf(first));
            Source.Chunk second = source.nextChunk();
            Assert.assertArrayEquals((char[])"8901234\n".toCharArray(), (char[])this.charactersOf(second));
            Source.Chunk third = source.nextChunk();
            Assert.assertArrayEquals((char[])"5678901234".toCharArray(), (char[])this.charactersOf(third));
            Assert.assertEquals((long)0L, (long)source.nextChunk().length());
        }
    }

    @Test
    public void shouldFailIfNoNewlineInChunk() throws Exception {
        CharReadable reader = Readables.wrap((Reader)new StringReader("1234567\n89012345678901234"));
        try (ProcessingSource source = new ProcessingSource(reader, 12, 1);){
            Source.Chunk first = source.nextChunk();
            Assert.assertArrayEquals((char[])"1234567\n".toCharArray(), (char[])this.charactersOf(first));
            try {
                source.nextChunk();
                Assert.fail((String)"Should have failed here");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    @Test
    public void shouldReuseBuffers() throws Exception {
        ProcessingSource source = new ProcessingSource(this.dataWithLines(2), 100, 1);
        Source.Chunk firstChunk = source.nextChunk();
        char[] firstBuffer = firstChunk.data();
        firstChunk.close();
        Source.Chunk secondChunk = source.nextChunk();
        char[] secondBuffer = secondChunk.data();
        secondChunk.close();
        Assert.assertSame((Object)firstBuffer, (Object)secondBuffer);
        source.close();
    }

    @Test
    public void shouldReuseBuffersEventually() throws Exception {
        ProcessingSource source = new ProcessingSource(this.dataWithLines(5), 100, 2);
        Source.Chunk firstChunk = source.nextChunk();
        char[] firstBuffer = firstChunk.data();
        Source.Chunk secondChunk = source.nextChunk();
        char[] secondBuffer = secondChunk.data();
        Assert.assertNotSame((Object)secondBuffer, (Object)firstBuffer);
        firstChunk.close();
        Source.Chunk thirdChunk = source.nextChunk();
        char[] thirdBuffer = thirdChunk.data();
        Assert.assertSame((Object)firstBuffer, (Object)thirdBuffer);
        secondChunk.close();
        thirdChunk.close();
        source.close();
    }

    @Test
    public void shouldStressReuse() throws Exception {
        int nThreads = 10;
        ProcessingSource source = new ProcessingSource(this.dataWithLines(3000), 100, nThreads);
        ExecutorService executor = Executors.newFixedThreadPool(nThreads);
        AtomicInteger activeProcessors = new AtomicInteger();
        Source.Chunk chunk = Source.EMPTY_CHUNK;
        HashSet<char[]> observedDataArrays = new HashSet<char[]>();
        while (true) {
            if (activeProcessors.get() == nThreads) {
                continue;
            }
            chunk = source.nextChunk();
            observedDataArrays.add(chunk.data());
            activeProcessors.incrementAndGet();
            Source.Chunk currentChunk = chunk;
            executor.submit(() -> {
                currentChunk.close();
                activeProcessors.decrementAndGet();
            });
            if (chunk.length() <= 0) break;
        }
        executor.shutdown();
        executor.awaitTermination(100L, TimeUnit.SECONDS);
        source.close();
        Assert.assertTrue((String)("" + observedDataArrays.size()), (observedDataArrays.size() >= 1 && observedDataArrays.size() <= nThreads ? 1 : 0) != 0);
    }

    private CharReadable dataWithLines(final int lineCount) {
        return new CharReadable.Adapter(){
            private int line;

            public String sourceDescription() {
                return "test";
            }

            public int read(char[] into, int offset, int length) throws IOException {
                assert (offset == 0) : "This test assumes offset is 0, which it always was for this use case at the time of writing";
                if (this.line++ == lineCount) {
                    return -1;
                }
                into[length - 1] = 10;
                return length;
            }

            public SectionedCharBuffer read(SectionedCharBuffer buffer, int from) throws IOException {
                throw new UnsupportedOperationException();
            }
        };
    }

    private char[] charactersOf(Source.Chunk chunk) {
        return Arrays.copyOfRange(chunk.data(), chunk.startPosition(), chunk.startPosition() + chunk.length());
    }
}

