/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.csv.reader;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.csv.reader.Extractor;
import org.neo4j.csv.reader.Extractors;

public class ExtractorsTest {
    @Test
    public void shouldExtractStringArray() throws Exception {
        Extractors extractors = new Extractors(',');
        String data = "abcde,fghijkl,mnopq";
        Extractor extractor = extractors.valueOf("STRING[]");
        extractor.extract(data.toCharArray(), 0, data.length(), false);
        Assert.assertArrayEquals((Object[])new String[]{"abcde", "fghijkl", "mnopq"}, (Object[])((Object[])extractor.value()));
    }

    @Test
    public void shouldExtractLongArray() throws Exception {
        Extractors extractors = new Extractors(',');
        long[] longData = new long[]{123L, 4567L, 987654321L};
        String data = this.toString(longData, ',');
        Extractor extractor = extractors.valueOf("long[]");
        extractor.extract(data.toCharArray(), 0, data.length(), false);
        Assert.assertArrayEquals((long[])longData, (long[])((long[])extractor.value()));
    }

    @Test
    public void shouldExtractBooleanArray() throws Exception {
        Extractors extractors = new Extractors(',');
        boolean[] booleanData = new boolean[]{true, false, true};
        String data = this.toString(booleanData, ',');
        Extractor extractor = extractors.booleanArray();
        extractor.extract(data.toCharArray(), 0, data.length(), false);
        this.assertBooleanArrayEquals(booleanData, (boolean[])extractor.value());
    }

    @Test
    public void shouldExtractDoubleArray() throws Exception {
        Extractors extractors = new Extractors(',');
        double[] doubleData = new double[]{123.123, 4567.4567, 9.876543210987E8};
        String data = this.toString(doubleData, ',');
        Extractor extractor = extractors.doubleArray();
        extractor.extract(data.toCharArray(), 0, data.length(), false);
        Assert.assertArrayEquals((double[])doubleData, (double[])((double[])extractor.value()), (double)0.001);
    }

    @Test
    public void shouldFailExtractingLongArrayWhereAnyValueIsEmpty() throws Exception {
        Extractors extractors = new Extractors(';');
        long[] longData = new long[]{112233L, 4455L, 66778899L};
        String data = this.toString(longData, ';') + ";";
        try {
            extractors.longArray().extract(data.toCharArray(), 0, data.length(), false);
            Assert.fail((String)"Should have failed");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Test
    public void shouldFailExtractingLongArrayWhereAnyValueIsntReallyANumber() throws Exception {
        Extractors extractors = new Extractors(';');
        String data = "123;456;abc;789";
        try {
            extractors.valueOf("long[]").extract(data.toCharArray(), 0, data.length(), false);
            Assert.fail((String)"Should have failed");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Test
    public void shouldExtractNegativeInt() throws Exception {
        Extractors extractors = new Extractors(',');
        int value = -1234567;
        char[] asChars = String.valueOf(value).toCharArray();
        Extractors.IntExtractor extractor = extractors.int_();
        extractor.extract(asChars, 0, asChars.length, false);
        Assert.assertEquals((long)value, (long)extractor.intValue());
    }

    @Test
    public void shouldExtractEmptyStringForEmptyArrayString() throws Exception {
        Extractors extractors = new Extractors(',');
        String value = "";
        Extractor extractor = extractors.stringArray();
        extractor.extract(value.toCharArray(), 0, value.length(), false);
        Assert.assertEquals((long)0L, (long)((String[])extractor.value()).length);
    }

    @Test
    public void shouldExtractEmptyLongArrayForEmptyArrayString() throws Exception {
        Extractors extractors = new Extractors(',');
        String value = "";
        Extractor extractor = extractors.longArray();
        extractor.extract(value.toCharArray(), 0, value.length(), false);
        Assert.assertEquals((long)0L, (long)((long[])extractor.value()).length);
    }

    @Test
    public void shouldExtractTwoEmptyStringsForSingleDelimiterInArrayString() throws Exception {
        Extractors extractors = new Extractors(',');
        String value = ",";
        Extractor extractor = extractors.stringArray();
        extractor.extract(value.toCharArray(), 0, value.length(), false);
        Assert.assertArrayEquals((Object[])new String[]{"", ""}, (Object[])((Object[])extractor.value()));
    }

    @Test
    public void shouldExtractEmptyStringForEmptyQuotedString() throws Exception {
        Extractors extractors = new Extractors(',');
        String value = "";
        Extractor extractor = extractors.string();
        extractor.extract(value.toCharArray(), 0, value.length(), true);
        Assert.assertEquals((Object)"", (Object)extractor.value());
    }

    @Test
    public void shouldExtractNullForEmptyQuotedStringIfConfiguredTo() throws Exception {
        Extractors extractors = new Extractors(';', true);
        Extractor extractor = extractors.string();
        extractor.extract(new char[0], 0, 0, true);
        String extracted = (String)extractor.value();
        Assert.assertNull((Object)extracted);
    }

    @Test
    public void shouldTrimStringIfConfiguredTo() throws Exception {
        Extractors extractors = new Extractors(',', true, true);
        String value = " abcde fgh  ";
        char[] asChars = value.toCharArray();
        Extractor extractor = extractors.string();
        extractor.extract(asChars, 0, asChars.length, true);
        Assert.assertEquals((Object)value.trim(), (Object)extractor.value());
    }

    @Test
    public void shouldNotTrimStringIfNotConfiguredTo() throws Exception {
        Extractors extractors = new Extractors(',', true, false);
        String value = " abcde fgh  ";
        char[] asChars = value.toCharArray();
        Extractor extractor = extractors.string();
        extractor.extract(asChars, 0, asChars.length, true);
        Assert.assertEquals((Object)value, (Object)extractor.value());
    }

    @Test
    public void shouldCloneExtractor() throws Exception {
        Extractors extractors = new Extractors(';');
        Extractor e1 = extractors.string();
        Extractor e2 = e1.clone();
        String v1 = "abc";
        e1.extract(v1.toCharArray(), 0, v1.length(), false);
        Assert.assertEquals((Object)v1, (Object)e1.value());
        Assert.assertNull((Object)e2.value());
        String v2 = "def";
        e2.extract(v2.toCharArray(), 0, v2.length(), false);
        Assert.assertEquals((Object)v2, (Object)e2.value());
        Assert.assertEquals((Object)v1, (Object)e1.value());
    }

    private String toString(long[] values, char delimiter) {
        StringBuilder builder = new StringBuilder();
        for (long value : values) {
            builder.append(builder.length() > 0 ? Character.valueOf(delimiter) : "").append(value);
        }
        return builder.toString();
    }

    private String toString(double[] values, char delimiter) {
        StringBuilder builder = new StringBuilder();
        for (double value : values) {
            builder.append(builder.length() > 0 ? Character.valueOf(delimiter) : "").append(value);
        }
        return builder.toString();
    }

    private String toString(boolean[] values, char delimiter) {
        StringBuilder builder = new StringBuilder();
        for (boolean value : values) {
            builder.append(builder.length() > 0 ? Character.valueOf(delimiter) : "").append(value);
        }
        return builder.toString();
    }

    private void assertBooleanArrayEquals(boolean[] expected, boolean[] values) {
        Assert.assertEquals((String)"Array lengths differ", (long)expected.length, (long)values.length);
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((String)("Item " + i + " differs"), (Object)expected[i], (Object)values[i]);
        }
    }
}

