/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.csv.reader;

import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.concurrent.locks.LockSupport;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.csv.reader.CharReadable;
import org.neo4j.csv.reader.Readables;
import org.neo4j.csv.reader.SectionedCharBuffer;
import org.neo4j.csv.reader.ThreadAheadReadable;

public class ThreadAheadReadableTest {
    @Test
    public void shouldReadAhead() throws Exception {
        TrackingReader actual = new TrackingReader(23);
        int bufferSize = 5;
        CharReadable aheadReader = ThreadAheadReadable.threadAhead((CharReadable)actual, (int)bufferSize);
        SectionedCharBuffer buffer = new SectionedCharBuffer(bufferSize);
        Assert.assertEquals((long)bufferSize, (long)actual.awaitCompletedReadAttempts(1));
        int read = 0;
        buffer = aheadReader.read(buffer, buffer.front());
        this.assertBuffer(ThreadAheadReadableTest.chars(read, bufferSize), buffer, 0, bufferSize);
        read += buffer.available();
        buffer = aheadReader.read(buffer, buffer.front());
        this.assertBuffer(ThreadAheadReadableTest.chars(read, bufferSize), buffer, 0, bufferSize);
        read += buffer.available();
        int keep = 2;
        buffer = aheadReader.read(buffer, buffer.front() - keep);
        this.assertBuffer(ThreadAheadReadableTest.chars(read - keep, bufferSize + keep), buffer, keep, bufferSize);
        read += buffer.available();
        keep = 3;
        buffer = aheadReader.read(buffer, buffer.front() - keep);
        this.assertBuffer(ThreadAheadReadableTest.chars(read - keep, bufferSize + keep), buffer, keep, bufferSize);
        read += buffer.available();
        keep = 1;
        buffer = aheadReader.read(buffer, buffer.front() - keep);
        Assert.assertEquals((long)3L, (long)buffer.available());
        this.assertBuffer(ThreadAheadReadableTest.chars(read - keep, buffer.available() + keep), buffer, keep, 3);
        Assert.assertEquals((long)23L, (long)(read += buffer.available()));
    }

    @Test
    public void shouldHandleReadAheadEmptyData() throws Exception {
        TrackingReader actual = new TrackingReader(0);
        int bufferSize = 10;
        CharReadable aheadReadable = ThreadAheadReadable.threadAhead((CharReadable)actual, (int)bufferSize);
        actual.awaitCompletedReadAttempts(1);
        SectionedCharBuffer buffer = new SectionedCharBuffer(bufferSize);
        buffer = aheadReadable.read(buffer, buffer.front());
        Assert.assertEquals((long)buffer.pivot(), (long)buffer.back());
        Assert.assertEquals((long)buffer.pivot(), (long)buffer.front());
    }

    private void assertBuffer(char[] expectedChars, SectionedCharBuffer buffer, int charsInBack, int charsInFront) {
        Assert.assertEquals((long)(buffer.pivot() - charsInBack), (long)buffer.back());
        Assert.assertEquals((long)(buffer.pivot() + charsInFront), (long)buffer.front());
        Assert.assertArrayEquals((char[])expectedChars, (char[])Arrays.copyOfRange(buffer.array(), buffer.back(), buffer.front()));
    }

    private static char[] chars(int start, int length) {
        char[] result = new char[length];
        for (int i = 0; i < length; ++i) {
            result[i] = (char)(start + i);
        }
        return result;
    }

    private static class TrackingReader
    extends CharReadable.Adapter {
        private int bytesRead;
        private volatile int readsCompleted;
        private final CharReadable actual;

        TrackingReader(int length) {
            this.actual = Readables.wrap((Reader)new CharArrayReader(ThreadAheadReadableTest.chars(0, length)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SectionedCharBuffer read(SectionedCharBuffer buffer, int from) throws IOException {
            try {
                SectionedCharBuffer sectionedCharBuffer = this.registerBytesRead(this.actual.read(buffer, from));
                return sectionedCharBuffer;
            }
            finally {
                ++this.readsCompleted;
            }
        }

        public int read(char[] into, int offset, int length) throws IOException {
            throw new UnsupportedOperationException();
        }

        private SectionedCharBuffer registerBytesRead(SectionedCharBuffer buffer) {
            this.bytesRead += buffer.available();
            return buffer;
        }

        public void close() throws IOException {
        }

        private int awaitCompletedReadAttempts(int ticket) {
            while (this.readsCompleted < ticket) {
                LockSupport.parkNanos(10000000L);
            }
            return this.bytesRead;
        }

        public long position() {
            return this.actual.position();
        }

        public String sourceDescription() {
            return ((Object)((Object)this)).getClass().getSimpleName();
        }
    }
}

