/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.io.File;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class TestDirectory
implements TestRule {
    private File directory;

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                TestDirectory.this.directory = new File(new File(new File(new File("target"), "test-data"), description.getClassName()), description.getMethodName());
                TestDirectory.this.delete(TestDirectory.this.directory);
                TestDirectory.this.directory.mkdirs();
                boolean success = false;
                try {
                    base.evaluate();
                    success = true;
                }
                finally {
                    if (success) {
                        TestDirectory.this.delete(TestDirectory.this.directory);
                        TestDirectory.this.delete(TestDirectory.this.directory.getParentFile());
                    }
                }
            }
        };
    }

    private void clear(File file) {
        if (file.exists()) {
            for (File child : file.listFiles()) {
                this.delete(child);
            }
        }
    }

    private void delete(File child) {
        if (child.isDirectory()) {
            this.clear(child);
        }
        child.delete();
    }

    public File directory() {
        return this.directory;
    }

    public String getAbsolutePath() {
        return this.directory.getAbsolutePath();
    }

    public File directory(String name) {
        File result = new File(this.directory, name);
        result.mkdirs();
        return result;
    }

    public File file(String name) {
        return new File(this.directory, name);
    }
}

