/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

public interface Stage {
    public static final Stage SEQUENTIAL_FORWARD = new Adapter(false, true, "General purpose", new int[0]);
    public static final Stage PARALLEL_FORWARD = new Adapter(true, true, "General purpose", new int[0]);

    public boolean isParallel();

    public boolean isForward();

    public String getPurpose();

    public int ordinal();

    public int[] getCacheSlotSizes();

    public static class Adapter
    implements Stage {
        private final boolean parallel;
        private final boolean forward;
        private final String purpose;
        private final int[] cacheSlotSizes;

        public Adapter(boolean parallel, boolean forward, String purpose, int ... cacheSlotSizes) {
            this.parallel = parallel;
            this.forward = forward;
            this.purpose = purpose;
            this.cacheSlotSizes = cacheSlotSizes;
        }

        @Override
        public boolean isParallel() {
            return this.parallel;
        }

        @Override
        public boolean isForward() {
            return this.forward;
        }

        @Override
        public String getPurpose() {
            return this.purpose;
        }

        @Override
        public int ordinal() {
            return -1;
        }

        @Override
        public int[] getCacheSlotSizes() {
            return this.cacheSlotSizes;
        }
    }
}

