/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.consistency.checking.CheckerEngine;
import org.neo4j.consistency.checking.ComparativeRecordChecker;
import org.neo4j.consistency.checking.LabelChainWalker;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.consistency.store.RecordReference;
import org.neo4j.kernel.impl.store.DynamicNodeLabels;
import org.neo4j.kernel.impl.store.NodeLabels;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;

public class NodeInUseWithCorrectLabelsCheck<RECORD extends AbstractBaseRecord, REPORT extends ConsistencyReport.NodeInUseWithCorrectLabelsReport>
implements ComparativeRecordChecker<RECORD, NodeRecord, REPORT> {
    private final long[] indexLabels;
    private final boolean checkStoreToIndex;

    public NodeInUseWithCorrectLabelsCheck(long[] expectedLabels, boolean checkStoreToIndex) {
        this.checkStoreToIndex = checkStoreToIndex;
        this.indexLabels = NodeInUseWithCorrectLabelsCheck.sortAndDeduplicate(expectedLabels);
    }

    private static long[] sortAndDeduplicate(long[] labels) {
        if (ArrayUtils.isNotEmpty((long[])labels)) {
            Arrays.sort(labels);
            return PrimitiveLongCollections.deduplicate((long[])labels);
        }
        return labels;
    }

    @Override
    public void checkReference(RECORD record, NodeRecord nodeRecord, CheckerEngine<RECORD, REPORT> engine, RecordAccess records) {
        if (nodeRecord.inUse()) {
            NodeLabels nodeLabels = NodeLabelsField.parseLabelsField((NodeRecord)nodeRecord);
            if (nodeLabels instanceof DynamicNodeLabels) {
                DynamicNodeLabels dynamicNodeLabels = (DynamicNodeLabels)nodeLabels;
                long firstRecordId = dynamicNodeLabels.getFirstDynamicRecordId();
                RecordReference<DynamicRecord> firstRecordReference = records.nodeLabels(firstRecordId);
                ExpectedNodeLabelsChecker expectedNodeLabelsChecker = new ExpectedNodeLabelsChecker(nodeRecord);
                LabelChainWalker checker = new LabelChainWalker(expectedNodeLabelsChecker);
                engine.comparativeCheck(firstRecordReference, checker);
                nodeRecord.getDynamicLabelRecords();
            } else {
                long[] storeLabels = nodeLabels.get(null);
                ConsistencyReport.NodeInUseWithCorrectLabelsReport report = (ConsistencyReport.NodeInUseWithCorrectLabelsReport)engine.report();
                this.validateLabelIds(nodeRecord, storeLabels, report);
            }
        } else if (this.indexLabels.length != 0) {
            ((ConsistencyReport.NodeInUseWithCorrectLabelsReport)engine.report()).nodeNotInUse(nodeRecord);
        }
    }

    private void validateLabelIds(NodeRecord nodeRecord, long[] storeLabels, REPORT report) {
        storeLabels = NodeInUseWithCorrectLabelsCheck.sortAndDeduplicate(storeLabels);
        int indexLabelsCursor = 0;
        int storeLabelsCursor = 0;
        while (indexLabelsCursor < this.indexLabels.length && storeLabelsCursor < storeLabels.length) {
            long indexLabel = this.indexLabels[indexLabelsCursor];
            long storeLabel = storeLabels[storeLabelsCursor];
            if (indexLabel < storeLabel) {
                report.nodeDoesNotHaveExpectedLabel(nodeRecord, indexLabel);
                ++indexLabelsCursor;
                continue;
            }
            if (indexLabel > storeLabel) {
                this.reportNodeLabelNotInIndex(report, nodeRecord, storeLabel);
                ++storeLabelsCursor;
                continue;
            }
            ++indexLabelsCursor;
            ++storeLabelsCursor;
        }
        while (indexLabelsCursor < this.indexLabels.length) {
            report.nodeDoesNotHaveExpectedLabel(nodeRecord, this.indexLabels[indexLabelsCursor++]);
        }
        while (storeLabelsCursor < storeLabels.length) {
            this.reportNodeLabelNotInIndex(report, nodeRecord, storeLabels[storeLabelsCursor]);
            ++storeLabelsCursor;
        }
    }

    private void reportNodeLabelNotInIndex(REPORT report, NodeRecord nodeRecord, long storeLabel) {
        if (this.checkStoreToIndex) {
            report.nodeLabelNotInIndex(nodeRecord, storeLabel);
        }
    }

    private class ExpectedNodeLabelsChecker
    implements LabelChainWalker.Validator<RECORD, REPORT> {
        private final NodeRecord nodeRecord;

        ExpectedNodeLabelsChecker(NodeRecord nodeRecord) {
            this.nodeRecord = nodeRecord;
        }

        @Override
        public void onRecordNotInUse(DynamicRecord dynamicRecord, CheckerEngine<RECORD, REPORT> engine) {
        }

        @Override
        public void onRecordChainCycle(DynamicRecord record, CheckerEngine<RECORD, REPORT> engine) {
        }

        @Override
        public void onWellFormedChain(long[] labelIds, CheckerEngine<RECORD, REPORT> engine, RecordAccess records) {
            NodeInUseWithCorrectLabelsCheck.this.validateLabelIds(this.nodeRecord, labelIds, (ConsistencyReport.NodeInUseWithCorrectLabelsReport)engine.report());
        }
    }
}

