/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.store;

import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.TypeSafeMatcher;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.consistency.store.CacheSmallStoresRecordAccess;
import org.neo4j.consistency.store.DirectRecordReference;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.consistency.store.RecordReference;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;

class CacheSmallStoresRecordAccessTest {
    CacheSmallStoresRecordAccessTest() {
    }

    @Test
    void shouldDelegateLookupForMostStores() {
        RecordAccess delegate = (RecordAccess)Mockito.mock(RecordAccess.class);
        CacheSmallStoresRecordAccess recordAccess = new CacheSmallStoresRecordAccess(delegate, null, null, null);
        recordAccess.node(42L);
        recordAccess.relationship(2001L);
        recordAccess.property(2468L);
        recordAccess.string(666L);
        recordAccess.array(11L);
        ((RecordAccess)Mockito.verify((Object)delegate)).node(42L);
        ((RecordAccess)Mockito.verify((Object)delegate)).relationship(2001L);
        ((RecordAccess)Mockito.verify((Object)delegate)).property(2468L);
        ((RecordAccess)Mockito.verify((Object)delegate)).string(666L);
        ((RecordAccess)Mockito.verify((Object)delegate)).array(11L);
    }

    @Test
    void shouldServePropertyKeysAndRelationshipLabelsFromSuppliedArrayCaches() {
        RecordAccess delegate = (RecordAccess)Mockito.mock(RecordAccess.class);
        PropertyKeyTokenRecord propertyKey0 = new PropertyKeyTokenRecord(0);
        PropertyKeyTokenRecord propertyKey2 = new PropertyKeyTokenRecord(2);
        PropertyKeyTokenRecord propertyKey1 = new PropertyKeyTokenRecord(1);
        RelationshipTypeTokenRecord relationshipType0 = new RelationshipTypeTokenRecord(0);
        RelationshipTypeTokenRecord relationshipType1 = new RelationshipTypeTokenRecord(1);
        RelationshipTypeTokenRecord relationshipType2 = new RelationshipTypeTokenRecord(2);
        LabelTokenRecord label0 = new LabelTokenRecord(0L);
        LabelTokenRecord label1 = new LabelTokenRecord(1L);
        LabelTokenRecord label2 = new LabelTokenRecord(2L);
        CacheSmallStoresRecordAccess recordAccess = new CacheSmallStoresRecordAccess(delegate, new PropertyKeyTokenRecord[]{propertyKey0, propertyKey1, propertyKey2}, new RelationshipTypeTokenRecord[]{relationshipType0, relationshipType1, relationshipType2}, new LabelTokenRecord[]{label0, label1, label2});
        MatcherAssert.assertThat((Object)recordAccess.propertyKey(0), CacheSmallStoresRecordAccessTest.isDirectReferenceTo(propertyKey0));
        MatcherAssert.assertThat((Object)recordAccess.propertyKey(1), CacheSmallStoresRecordAccessTest.isDirectReferenceTo(propertyKey1));
        MatcherAssert.assertThat((Object)recordAccess.propertyKey(2), CacheSmallStoresRecordAccessTest.isDirectReferenceTo(propertyKey2));
        MatcherAssert.assertThat((Object)recordAccess.relationshipType(0), CacheSmallStoresRecordAccessTest.isDirectReferenceTo(relationshipType0));
        MatcherAssert.assertThat((Object)recordAccess.relationshipType(1), CacheSmallStoresRecordAccessTest.isDirectReferenceTo(relationshipType1));
        MatcherAssert.assertThat((Object)recordAccess.relationshipType(2), CacheSmallStoresRecordAccessTest.isDirectReferenceTo(relationshipType2));
        MatcherAssert.assertThat((Object)recordAccess.label(0), CacheSmallStoresRecordAccessTest.isDirectReferenceTo(label0));
        MatcherAssert.assertThat((Object)recordAccess.label(1), CacheSmallStoresRecordAccessTest.isDirectReferenceTo(label1));
        MatcherAssert.assertThat((Object)recordAccess.label(2), CacheSmallStoresRecordAccessTest.isDirectReferenceTo(label2));
        Mockito.verifyZeroInteractions((Object[])new Object[]{delegate});
    }

    private static <T extends AbstractBaseRecord> Matcher<RecordReference<T>> isDirectReferenceTo(T record) {
        return new DirectReferenceMatcher<T>(record);
    }

    private static class DirectReferenceMatcher<T extends AbstractBaseRecord>
    extends TypeSafeMatcher<DirectRecordReference<T>> {
        private final T record;

        DirectReferenceMatcher(T record) {
            super(DirectRecordReference.class);
            this.record = record;
        }

        public boolean matchesSafely(DirectRecordReference<T> reference) {
            return this.record == reference.record();
        }

        public void describeTo(Description description) {
            description.appendText(DirectRecordReference.class.getName()).appendText("( ").appendValue(this.record).appendText(" )");
        }
    }
}

