/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.statistics;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.consistency.statistics.Counts;
import org.neo4j.consistency.statistics.DefaultCounts;

class DefaultCountsTest {
    DefaultCountsTest() {
    }

    @Test
    void shouldCountPerThread() {
        DefaultCounts counts = new DefaultCounts(3);
        counts.incAndGet(Counts.Type.activeCache, 0);
        counts.incAndGet(Counts.Type.activeCache, 1);
        counts.incAndGet(Counts.Type.backLinks, 2);
        Assertions.assertEquals((long)2L, (long)counts.sum(Counts.Type.activeCache));
        Assertions.assertEquals((long)1L, (long)counts.sum(Counts.Type.backLinks));
        Assertions.assertEquals((long)0L, (long)counts.sum(Counts.Type.clearCache));
    }

    @Test
    void shouldResetCounts() {
        DefaultCounts counts = new DefaultCounts(2);
        counts.incAndGet(Counts.Type.activeCache, 0);
        Assertions.assertEquals((long)1L, (long)counts.sum(Counts.Type.activeCache));
        counts.reset();
        Assertions.assertEquals((long)0L, (long)counts.sum(Counts.Type.activeCache));
    }
}

