/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.io.File;
import java.util.function.Predicate;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.consistency.checking.cache.CacheAccess;
import org.neo4j.consistency.checking.full.QueueDistribution;
import org.neo4j.consistency.checking.full.Stage;
import org.neo4j.consistency.checking.full.StoreProcessor;
import org.neo4j.consistency.checking.full.StoreProcessorTask;
import org.neo4j.consistency.statistics.Statistics;
import org.neo4j.helpers.progress.ProgressListener;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.RecordStore;

class StoreProcessorTaskTest {
    StoreProcessorTaskTest() {
    }

    @Test
    void singlePassShouldOnlyProcessTheStoreOnce() {
        StoreProcessor singlePassProcessor = (StoreProcessor)Mockito.mock(StoreProcessor.class);
        Mockito.when((Object)singlePassProcessor.getStage()).thenReturn((Object)Stage.SEQUENTIAL_FORWARD);
        NodeStore store = (NodeStore)Mockito.mock(NodeStore.class);
        Mockito.when((Object)store.getStorageFileName()).thenReturn((Object)new File("node-store"));
        StoreProcessorTask task = new StoreProcessorTask("nodes", Statistics.NONE, 1, (RecordStore)store, null, "nodes", ProgressMonitorFactory.NONE.multipleParts("check"), CacheAccess.EMPTY, singlePassProcessor, QueueDistribution.ROUND_ROBIN);
        task.run();
        ((StoreProcessor)Mockito.verify((Object)singlePassProcessor)).applyFiltered((RecordStore)ArgumentMatchers.same((Object)store), (ProgressListener)ArgumentMatchers.any(ProgressListener.class), new Predicate[0]);
    }
}

