/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.consistency.RecordType;
import org.neo4j.consistency.checking.DynamicRecordCheckTest;
import org.neo4j.consistency.checking.DynamicStore;
import org.neo4j.consistency.checking.OwningRecordCheck;
import org.neo4j.consistency.checking.PrimitiveRecordCheck;
import org.neo4j.consistency.checking.RecordCheck;
import org.neo4j.consistency.checking.RecordCheckTestBase;
import org.neo4j.consistency.checking.full.OwnerCheck;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.store.RecordAccessStub;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NeoStoreRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;

class OwnerCheckTest {
    OwnerCheckTest() {
    }

    @Test
    void shouldNotDecorateCheckerWhenInactive() {
        OwnerCheck decorator = new OwnerCheck(false, new DynamicStore[0]);
        PrimitiveRecordCheck<NodeRecord, ConsistencyReport.NodeConsistencyReport> checker = RecordCheckTestBase.dummyNodeCheck();
        OwningRecordCheck decorated = decorator.decorateNodeChecker(checker);
        Assertions.assertSame(checker, (Object)decorated);
    }

    @Test
    void shouldNotReportAnythingForNodesWithDifferentPropertyChains() {
        OwnerCheck decorator = new OwnerCheck(true, new DynamicStore[0]);
        OwningRecordCheck nodeChecker = decorator.decorateNodeChecker(RecordCheckTestBase.dummyNodeCheck());
        RecordAccessStub records = new RecordAccessStub();
        NodeRecord node1 = records.add(RecordCheckTestBase.inUse(new NodeRecord(1L, false, -1L, 7L)));
        NodeRecord node2 = records.add(RecordCheckTestBase.inUse(new NodeRecord(2L, false, -1L, 8L)));
        ConsistencyReport.NodeConsistencyReport report1 = RecordCheckTestBase.check(ConsistencyReport.NodeConsistencyReport.class, nodeChecker, node1, records);
        ConsistencyReport.NodeConsistencyReport report2 = RecordCheckTestBase.check(ConsistencyReport.NodeConsistencyReport.class, nodeChecker, node2, records);
        Mockito.verifyZeroInteractions((Object[])new Object[]{report1});
        Mockito.verifyZeroInteractions((Object[])new Object[]{report2});
    }

    @Test
    void shouldNotReportAnythingForNodesNotInUse() {
        OwnerCheck decorator = new OwnerCheck(true, new DynamicStore[0]);
        OwningRecordCheck nodeChecker = decorator.decorateNodeChecker(RecordCheckTestBase.dummyNodeCheck());
        RecordAccessStub records = new RecordAccessStub();
        NodeRecord node1 = records.add(RecordCheckTestBase.notInUse(new NodeRecord(1L, false, -1L, 6L)));
        NodeRecord node2 = records.add(RecordCheckTestBase.notInUse(new NodeRecord(2L, false, -1L, 6L)));
        ConsistencyReport.NodeConsistencyReport report1 = RecordCheckTestBase.check(ConsistencyReport.NodeConsistencyReport.class, nodeChecker, node1, records);
        ConsistencyReport.NodeConsistencyReport report2 = RecordCheckTestBase.check(ConsistencyReport.NodeConsistencyReport.class, nodeChecker, node2, records);
        Mockito.verifyZeroInteractions((Object[])new Object[]{report1});
        Mockito.verifyZeroInteractions((Object[])new Object[]{report2});
    }

    @Test
    void shouldNotReportAnythingForRelationshipsWithDifferentPropertyChains() {
        OwnerCheck decorator = new OwnerCheck(true, new DynamicStore[0]);
        OwningRecordCheck relationshipChecker = decorator.decorateRelationshipChecker(RecordCheckTestBase.dummyRelationshipChecker());
        RecordAccessStub records = new RecordAccessStub();
        RelationshipRecord relationship1 = records.add(RecordCheckTestBase.inUse(new RelationshipRecord(1L, 0L, 1L, 0)));
        relationship1.setNextProp(7L);
        RelationshipRecord relationship2 = records.add(RecordCheckTestBase.inUse(new RelationshipRecord(2L, 0L, 1L, 0)));
        relationship2.setNextProp(8L);
        ConsistencyReport.RelationshipConsistencyReport report1 = RecordCheckTestBase.check(ConsistencyReport.RelationshipConsistencyReport.class, relationshipChecker, relationship1, records);
        ConsistencyReport.RelationshipConsistencyReport report2 = RecordCheckTestBase.check(ConsistencyReport.RelationshipConsistencyReport.class, relationshipChecker, relationship2, records);
        Mockito.verifyZeroInteractions((Object[])new Object[]{report1});
        Mockito.verifyZeroInteractions((Object[])new Object[]{report2});
    }

    @Test
    void shouldReportTwoNodesWithSamePropertyChain() {
        OwnerCheck decorator = new OwnerCheck(true, new DynamicStore[0]);
        OwningRecordCheck nodeChecker = decorator.decorateNodeChecker(RecordCheckTestBase.dummyNodeCheck());
        RecordAccessStub records = new RecordAccessStub();
        NodeRecord node1 = records.add(RecordCheckTestBase.inUse(new NodeRecord(1L, false, -1L, 7L)));
        NodeRecord node2 = records.add(RecordCheckTestBase.inUse(new NodeRecord(2L, false, -1L, 7L)));
        ConsistencyReport.NodeConsistencyReport report1 = RecordCheckTestBase.check(ConsistencyReport.NodeConsistencyReport.class, nodeChecker, node1, records);
        ConsistencyReport.NodeConsistencyReport report2 = RecordCheckTestBase.check(ConsistencyReport.NodeConsistencyReport.class, nodeChecker, node2, records);
        Mockito.verifyZeroInteractions((Object[])new Object[]{report1});
        ((ConsistencyReport.NodeConsistencyReport)Mockito.verify((Object)report2)).multipleOwners(node1);
    }

    @Test
    void shouldReportTwoRelationshipsWithSamePropertyChain() {
        OwnerCheck decorator = new OwnerCheck(true, new DynamicStore[0]);
        OwningRecordCheck relationshipChecker = decorator.decorateRelationshipChecker(RecordCheckTestBase.dummyRelationshipChecker());
        RecordAccessStub records = new RecordAccessStub();
        RelationshipRecord relationship1 = records.add(RecordCheckTestBase.inUse(new RelationshipRecord(1L, 0L, 1L, 0)));
        relationship1.setNextProp(7L);
        RelationshipRecord relationship2 = records.add(RecordCheckTestBase.inUse(new RelationshipRecord(2L, 0L, 1L, 0)));
        relationship2.setNextProp(relationship1.getNextProp());
        ConsistencyReport.RelationshipConsistencyReport report1 = RecordCheckTestBase.check(ConsistencyReport.RelationshipConsistencyReport.class, relationshipChecker, relationship1, records);
        ConsistencyReport.RelationshipConsistencyReport report2 = RecordCheckTestBase.check(ConsistencyReport.RelationshipConsistencyReport.class, relationshipChecker, relationship2, records);
        Mockito.verifyZeroInteractions((Object[])new Object[]{report1});
        ((ConsistencyReport.RelationshipConsistencyReport)Mockito.verify((Object)report2)).multipleOwners(relationship1);
    }

    @Test
    void shouldReportRelationshipWithSamePropertyChainAsNode() {
        OwnerCheck decorator = new OwnerCheck(true, new DynamicStore[0]);
        OwningRecordCheck nodeChecker = decorator.decorateNodeChecker(RecordCheckTestBase.dummyNodeCheck());
        OwningRecordCheck relationshipChecker = decorator.decorateRelationshipChecker(RecordCheckTestBase.dummyRelationshipChecker());
        RecordAccessStub records = new RecordAccessStub();
        NodeRecord node = records.add(RecordCheckTestBase.inUse(new NodeRecord(1L, false, -1L, 7L)));
        RelationshipRecord relationship = records.add(RecordCheckTestBase.inUse(new RelationshipRecord(1L, 0L, 1L, 0)));
        relationship.setNextProp(node.getNextProp());
        ConsistencyReport.NodeConsistencyReport nodeReport = RecordCheckTestBase.check(ConsistencyReport.NodeConsistencyReport.class, nodeChecker, node, records);
        ConsistencyReport.RelationshipConsistencyReport relationshipReport = RecordCheckTestBase.check(ConsistencyReport.RelationshipConsistencyReport.class, relationshipChecker, relationship, records);
        Mockito.verifyZeroInteractions((Object[])new Object[]{nodeReport});
        ((ConsistencyReport.RelationshipConsistencyReport)Mockito.verify((Object)relationshipReport)).multipleOwners(node);
    }

    @Test
    void shouldReportRelationshipWithReferenceToTheGraphGlobalChain() {
        OwnerCheck decorator = new OwnerCheck(true, new DynamicStore[0]);
        OwningRecordCheck relationshipChecker = decorator.decorateRelationshipChecker(RecordCheckTestBase.dummyRelationshipChecker());
        OwningRecordCheck neoStoreCheck = decorator.decorateNeoStoreChecker(RecordCheckTestBase.dummyNeoStoreCheck());
        RecordAccessStub records = new RecordAccessStub();
        NeoStoreRecord master = records.add(new NeoStoreRecord());
        master.setNextProp(7L);
        RelationshipRecord relationship = records.add(RecordCheckTestBase.inUse(new RelationshipRecord(1L, 0L, 1L, 0)));
        relationship.setNextProp(7L);
        ConsistencyReport.NeoStoreConsistencyReport masterReport = RecordCheckTestBase.check(ConsistencyReport.NeoStoreConsistencyReport.class, neoStoreCheck, master, records);
        ConsistencyReport.RelationshipConsistencyReport relationshipReport = RecordCheckTestBase.check(ConsistencyReport.RelationshipConsistencyReport.class, relationshipChecker, relationship, records);
        Mockito.verifyZeroInteractions((Object[])new Object[]{masterReport});
        ((ConsistencyReport.RelationshipConsistencyReport)Mockito.verify((Object)relationshipReport)).multipleOwners(master);
    }

    @Test
    void shouldReportNodeWithSamePropertyChainAsRelationship() {
        OwnerCheck decorator = new OwnerCheck(true, new DynamicStore[0]);
        OwningRecordCheck nodeChecker = decorator.decorateNodeChecker(RecordCheckTestBase.dummyNodeCheck());
        OwningRecordCheck relationshipChecker = decorator.decorateRelationshipChecker(RecordCheckTestBase.dummyRelationshipChecker());
        RecordAccessStub records = new RecordAccessStub();
        NodeRecord node = records.add(RecordCheckTestBase.inUse(new NodeRecord(1L, false, -1L, 7L)));
        RelationshipRecord relationship = records.add(RecordCheckTestBase.inUse(new RelationshipRecord(1L, 0L, 1L, 0)));
        relationship.setNextProp(node.getNextProp());
        ConsistencyReport.RelationshipConsistencyReport relationshipReport = RecordCheckTestBase.check(ConsistencyReport.RelationshipConsistencyReport.class, relationshipChecker, relationship, records);
        ConsistencyReport.NodeConsistencyReport nodeReport = RecordCheckTestBase.check(ConsistencyReport.NodeConsistencyReport.class, nodeChecker, node, records);
        Mockito.verifyZeroInteractions((Object[])new Object[]{relationshipReport});
        ((ConsistencyReport.NodeConsistencyReport)Mockito.verify((Object)nodeReport)).multipleOwners(relationship);
    }

    @Test
    void shouldReportNodeWithReferenceToTheGraphGlobalChain() {
        OwnerCheck decorator = new OwnerCheck(true, new DynamicStore[0]);
        OwningRecordCheck nodeChecker = decorator.decorateNodeChecker(RecordCheckTestBase.dummyNodeCheck());
        OwningRecordCheck neoStoreCheck = decorator.decorateNeoStoreChecker(RecordCheckTestBase.dummyNeoStoreCheck());
        RecordAccessStub records = new RecordAccessStub();
        NodeRecord node = records.add(RecordCheckTestBase.inUse(new NodeRecord(1L, false, -1L, 7L)));
        NeoStoreRecord master = records.add(new NeoStoreRecord());
        master.setNextProp(node.getNextProp());
        ConsistencyReport.NeoStoreConsistencyReport masterReport = RecordCheckTestBase.check(ConsistencyReport.NeoStoreConsistencyReport.class, neoStoreCheck, master, records);
        ConsistencyReport.NodeConsistencyReport nodeReport = RecordCheckTestBase.check(ConsistencyReport.NodeConsistencyReport.class, nodeChecker, node, records);
        Mockito.verifyZeroInteractions((Object[])new Object[]{masterReport});
        ((ConsistencyReport.NodeConsistencyReport)Mockito.verify((Object)nodeReport)).multipleOwners(master);
    }

    @Test
    void shouldReportNodeStoreReferencingSameChainAsNode() {
        OwnerCheck decorator = new OwnerCheck(true, new DynamicStore[0]);
        OwningRecordCheck nodeChecker = decorator.decorateNodeChecker(RecordCheckTestBase.dummyNodeCheck());
        OwningRecordCheck neoStoreCheck = decorator.decorateNeoStoreChecker(RecordCheckTestBase.dummyNeoStoreCheck());
        RecordAccessStub records = new RecordAccessStub();
        NodeRecord node = records.add(RecordCheckTestBase.inUse(new NodeRecord(1L, false, -1L, 7L)));
        NeoStoreRecord master = records.add(new NeoStoreRecord());
        master.setNextProp(node.getNextProp());
        ConsistencyReport.NodeConsistencyReport nodeReport = RecordCheckTestBase.check(ConsistencyReport.NodeConsistencyReport.class, nodeChecker, node, records);
        ConsistencyReport.NeoStoreConsistencyReport masterReport = RecordCheckTestBase.check(ConsistencyReport.NeoStoreConsistencyReport.class, neoStoreCheck, master, records);
        Mockito.verifyZeroInteractions((Object[])new Object[]{nodeReport});
        ((ConsistencyReport.NeoStoreConsistencyReport)Mockito.verify((Object)masterReport)).multipleOwners(node);
    }

    @Test
    void shouldReportNodeStoreReferencingSameChainAsRelationship() {
        OwnerCheck decorator = new OwnerCheck(true, new DynamicStore[0]);
        OwningRecordCheck relationshipChecker = decorator.decorateRelationshipChecker(RecordCheckTestBase.dummyRelationshipChecker());
        OwningRecordCheck neoStoreCheck = decorator.decorateNeoStoreChecker(RecordCheckTestBase.dummyNeoStoreCheck());
        RecordAccessStub records = new RecordAccessStub();
        NeoStoreRecord master = records.add(new NeoStoreRecord());
        master.setNextProp(7L);
        RelationshipRecord relationship = records.add(RecordCheckTestBase.inUse(new RelationshipRecord(1L, 0L, 1L, 0)));
        relationship.setNextProp(7L);
        ConsistencyReport.RelationshipConsistencyReport relationshipReport = RecordCheckTestBase.check(ConsistencyReport.RelationshipConsistencyReport.class, relationshipChecker, relationship, records);
        ConsistencyReport.NeoStoreConsistencyReport masterReport = RecordCheckTestBase.check(ConsistencyReport.NeoStoreConsistencyReport.class, neoStoreCheck, master, records);
        Mockito.verifyZeroInteractions((Object[])new Object[]{relationshipReport});
        ((ConsistencyReport.NeoStoreConsistencyReport)Mockito.verify((Object)masterReport)).multipleOwners(relationship);
    }

    @Test
    void shouldReportOrphanPropertyChain() {
        RecordAccessStub records = new RecordAccessStub();
        OwnerCheck decorator = new OwnerCheck(true, new DynamicStore[0]);
        RecordCheck checker = decorator.decoratePropertyChecker(RecordCheckTestBase.dummyPropertyChecker());
        PropertyRecord record = RecordCheckTestBase.inUse(new PropertyRecord(42L));
        ConsistencyReport.PropertyConsistencyReport report = RecordCheckTestBase.check(ConsistencyReport.PropertyConsistencyReport.class, checker, record, records);
        decorator.scanForOrphanChains(ProgressMonitorFactory.NONE);
        records.checkDeferred();
        ((ConsistencyReport.PropertyConsistencyReport)Mockito.verify((Object)report)).orphanPropertyChain();
    }

    @Test
    void shouldNotReportOrphanIfOwnedByNode() {
        RecordAccessStub records = new RecordAccessStub();
        OwnerCheck decorator = new OwnerCheck(true, new DynamicStore[0]);
        PropertyRecord record = RecordCheckTestBase.inUse(new PropertyRecord(42L));
        ConsistencyReport.PropertyConsistencyReport report = RecordCheckTestBase.check(ConsistencyReport.PropertyConsistencyReport.class, decorator.decoratePropertyChecker(RecordCheckTestBase.dummyPropertyChecker()), record, records);
        ConsistencyReport.NodeConsistencyReport nodeReport = RecordCheckTestBase.check(ConsistencyReport.NodeConsistencyReport.class, decorator.decorateNodeChecker(RecordCheckTestBase.dummyNodeCheck()), RecordCheckTestBase.inUse(new NodeRecord(10L, false, -1L, 42L)), records);
        decorator.scanForOrphanChains(ProgressMonitorFactory.NONE);
        records.checkDeferred();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{nodeReport});
    }

    @Test
    void shouldNotReportOrphanIfOwnedByRelationship() {
        RecordAccessStub records = new RecordAccessStub();
        OwnerCheck decorator = new OwnerCheck(true, new DynamicStore[0]);
        PropertyRecord record = RecordCheckTestBase.inUse(new PropertyRecord(42L));
        ConsistencyReport.PropertyConsistencyReport report = RecordCheckTestBase.check(ConsistencyReport.PropertyConsistencyReport.class, decorator.decoratePropertyChecker(RecordCheckTestBase.dummyPropertyChecker()), record, records);
        RelationshipRecord relationship = RecordCheckTestBase.inUse(new RelationshipRecord(10L, 1L, 1L, 0));
        relationship.setNextProp(42L);
        ConsistencyReport.RelationshipConsistencyReport relationshipReport = RecordCheckTestBase.check(ConsistencyReport.RelationshipConsistencyReport.class, decorator.decorateRelationshipChecker(RecordCheckTestBase.dummyRelationshipChecker()), relationship, records);
        decorator.scanForOrphanChains(ProgressMonitorFactory.NONE);
        records.checkDeferred();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{relationshipReport});
    }

    @Test
    void shouldNotReportOrphanIfOwnedByNeoStore() {
        RecordAccessStub records = new RecordAccessStub();
        OwnerCheck decorator = new OwnerCheck(true, new DynamicStore[0]);
        PropertyRecord record = RecordCheckTestBase.inUse(new PropertyRecord(42L));
        ConsistencyReport.PropertyConsistencyReport report = RecordCheckTestBase.check(ConsistencyReport.PropertyConsistencyReport.class, decorator.decoratePropertyChecker(RecordCheckTestBase.dummyPropertyChecker()), record, records);
        NeoStoreRecord master = RecordCheckTestBase.inUse(new NeoStoreRecord());
        master.setNextProp(42L);
        ConsistencyReport.NeoStoreConsistencyReport masterReport = RecordCheckTestBase.check(ConsistencyReport.NeoStoreConsistencyReport.class, decorator.decorateNeoStoreChecker(RecordCheckTestBase.dummyNeoStoreCheck()), master, records);
        decorator.scanForOrphanChains(ProgressMonitorFactory.NONE);
        records.checkDeferred();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{masterReport});
    }

    @Test
    void shouldReportDynamicRecordOwnedByTwoOtherDynamicRecords() {
        RecordAccessStub records = new RecordAccessStub();
        OwnerCheck decorator = new OwnerCheck(true, new DynamicStore[]{DynamicStore.STRING});
        RecordCheck checker = decorator.decorateDynamicChecker(RecordType.STRING_PROPERTY, RecordCheckTestBase.dummyDynamicCheck(DynamicRecordCheckTest.configureDynamicStore(50), DynamicStore.STRING));
        DynamicRecord record1 = records.add(RecordCheckTestBase.inUse(RecordCheckTestBase.string(new DynamicRecord(1L))));
        DynamicRecord record2 = records.add(RecordCheckTestBase.inUse(RecordCheckTestBase.string(new DynamicRecord(2L))));
        DynamicRecord record3 = records.add(RecordCheckTestBase.inUse(RecordCheckTestBase.string(new DynamicRecord(3L))));
        record1.setNextBlock(record3.getId());
        record2.setNextBlock(record3.getId());
        ConsistencyReport.DynamicConsistencyReport report1 = RecordCheckTestBase.check(ConsistencyReport.DynamicConsistencyReport.class, checker, record1, records);
        ConsistencyReport.DynamicConsistencyReport report2 = RecordCheckTestBase.check(ConsistencyReport.DynamicConsistencyReport.class, checker, record2, records);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report1});
        ((ConsistencyReport.DynamicConsistencyReport)Mockito.verify((Object)report2)).nextMultipleOwners(record1);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report2});
    }

    @Test
    void shouldReportDynamicStringRecordOwnedByTwoPropertyRecords() {
        RecordAccessStub records = new RecordAccessStub();
        OwnerCheck decorator = new OwnerCheck(true, new DynamicStore[]{DynamicStore.STRING});
        RecordCheck propChecker = decorator.decoratePropertyChecker(RecordCheckTestBase.dummyPropertyChecker());
        DynamicRecord dynamic = records.add(RecordCheckTestBase.inUse(RecordCheckTestBase.string(new DynamicRecord(42L))));
        PropertyRecord property1 = records.add(RecordCheckTestBase.inUse(new PropertyRecord(1L)));
        PropertyRecord property2 = records.add(RecordCheckTestBase.inUse(new PropertyRecord(2L)));
        PropertyKeyTokenRecord key = records.add(RecordCheckTestBase.inUse(new PropertyKeyTokenRecord(10)));
        property1.addPropertyBlock(RecordCheckTestBase.propertyBlock(key, PropertyType.STRING, dynamic.getId()));
        property2.addPropertyBlock(RecordCheckTestBase.propertyBlock(key, PropertyType.STRING, dynamic.getId()));
        ConsistencyReport.PropertyConsistencyReport report1 = RecordCheckTestBase.check(ConsistencyReport.PropertyConsistencyReport.class, propChecker, property1, records);
        ConsistencyReport.PropertyConsistencyReport report2 = RecordCheckTestBase.check(ConsistencyReport.PropertyConsistencyReport.class, propChecker, property2, records);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report1});
        ((ConsistencyReport.PropertyConsistencyReport)Mockito.verify((Object)report2)).stringMultipleOwners(property1);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report2});
    }

    @Test
    void shouldReportDynamicArrayRecordOwnedByTwoPropertyRecords() {
        RecordAccessStub records = new RecordAccessStub();
        OwnerCheck decorator = new OwnerCheck(true, new DynamicStore[]{DynamicStore.ARRAY});
        RecordCheck propChecker = decorator.decoratePropertyChecker(RecordCheckTestBase.dummyPropertyChecker());
        DynamicRecord dynamic = records.add(RecordCheckTestBase.inUse(RecordCheckTestBase.array(new DynamicRecord(42L))));
        PropertyRecord property1 = records.add(RecordCheckTestBase.inUse(new PropertyRecord(1L)));
        PropertyRecord property2 = records.add(RecordCheckTestBase.inUse(new PropertyRecord(2L)));
        PropertyKeyTokenRecord key = records.add(RecordCheckTestBase.inUse(new PropertyKeyTokenRecord(10)));
        property1.addPropertyBlock(RecordCheckTestBase.propertyBlock(key, PropertyType.ARRAY, dynamic.getId()));
        property2.addPropertyBlock(RecordCheckTestBase.propertyBlock(key, PropertyType.ARRAY, dynamic.getId()));
        ConsistencyReport.PropertyConsistencyReport report1 = RecordCheckTestBase.check(ConsistencyReport.PropertyConsistencyReport.class, propChecker, property1, records);
        ConsistencyReport.PropertyConsistencyReport report2 = RecordCheckTestBase.check(ConsistencyReport.PropertyConsistencyReport.class, propChecker, property2, records);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report1});
        ((ConsistencyReport.PropertyConsistencyReport)Mockito.verify((Object)report2)).arrayMultipleOwners(property1);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report2});
    }

    @Test
    void shouldReportDynamicRecordOwnedByPropertyAndOtherDynamic() {
        RecordAccessStub records = new RecordAccessStub();
        OwnerCheck decorator = new OwnerCheck(true, new DynamicStore[]{DynamicStore.STRING});
        RecordCheck dynChecker = decorator.decorateDynamicChecker(RecordType.STRING_PROPERTY, RecordCheckTestBase.dummyDynamicCheck(DynamicRecordCheckTest.configureDynamicStore(50), DynamicStore.STRING));
        RecordCheck propChecker = decorator.decoratePropertyChecker(RecordCheckTestBase.dummyPropertyChecker());
        DynamicRecord owned = records.add(RecordCheckTestBase.inUse(RecordCheckTestBase.string(new DynamicRecord(42L))));
        DynamicRecord dynamic = records.add(RecordCheckTestBase.inUse(RecordCheckTestBase.string(new DynamicRecord(100L))));
        dynamic.setNextBlock(owned.getId());
        PropertyRecord property = records.add(RecordCheckTestBase.inUse(new PropertyRecord(1L)));
        PropertyKeyTokenRecord key = records.add(RecordCheckTestBase.inUse(new PropertyKeyTokenRecord(10)));
        property.addPropertyBlock(RecordCheckTestBase.propertyBlock(key, PropertyType.STRING, owned.getId()));
        ConsistencyReport.PropertyConsistencyReport propReport = RecordCheckTestBase.check(ConsistencyReport.PropertyConsistencyReport.class, propChecker, property, records);
        ConsistencyReport.DynamicConsistencyReport dynReport = RecordCheckTestBase.check(ConsistencyReport.DynamicConsistencyReport.class, dynChecker, dynamic, records);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{propReport});
        ((ConsistencyReport.DynamicConsistencyReport)Mockito.verify((Object)dynReport)).nextMultipleOwners(property);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{dynReport});
    }

    @Test
    void shouldReportDynamicStringRecordOwnedByOtherDynamicAndProperty() {
        RecordAccessStub records = new RecordAccessStub();
        OwnerCheck decorator = new OwnerCheck(true, new DynamicStore[]{DynamicStore.STRING});
        RecordCheck dynChecker = decorator.decorateDynamicChecker(RecordType.STRING_PROPERTY, RecordCheckTestBase.dummyDynamicCheck(DynamicRecordCheckTest.configureDynamicStore(50), DynamicStore.STRING));
        RecordCheck propChecker = decorator.decoratePropertyChecker(RecordCheckTestBase.dummyPropertyChecker());
        DynamicRecord owned = records.add(RecordCheckTestBase.inUse(RecordCheckTestBase.string(new DynamicRecord(42L))));
        DynamicRecord dynamic = records.add(RecordCheckTestBase.inUse(RecordCheckTestBase.string(new DynamicRecord(100L))));
        dynamic.setNextBlock(owned.getId());
        PropertyRecord property = records.add(RecordCheckTestBase.inUse(new PropertyRecord(1L)));
        PropertyKeyTokenRecord key = records.add(RecordCheckTestBase.inUse(new PropertyKeyTokenRecord(10)));
        property.addPropertyBlock(RecordCheckTestBase.propertyBlock(key, PropertyType.STRING, owned.getId()));
        ConsistencyReport.DynamicConsistencyReport dynReport = RecordCheckTestBase.check(ConsistencyReport.DynamicConsistencyReport.class, dynChecker, dynamic, records);
        ConsistencyReport.PropertyConsistencyReport propReport = RecordCheckTestBase.check(ConsistencyReport.PropertyConsistencyReport.class, propChecker, property, records);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{dynReport});
        ((ConsistencyReport.PropertyConsistencyReport)Mockito.verify((Object)propReport)).stringMultipleOwners(dynamic);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{dynReport});
    }

    @Test
    void shouldReportDynamicArrayRecordOwnedByOtherDynamicAndProperty() {
        RecordAccessStub records = new RecordAccessStub();
        OwnerCheck decorator = new OwnerCheck(true, new DynamicStore[]{DynamicStore.ARRAY});
        RecordCheck dynChecker = decorator.decorateDynamicChecker(RecordType.ARRAY_PROPERTY, RecordCheckTestBase.dummyDynamicCheck(DynamicRecordCheckTest.configureDynamicStore(50), DynamicStore.ARRAY));
        RecordCheck propChecker = decorator.decoratePropertyChecker(RecordCheckTestBase.dummyPropertyChecker());
        DynamicRecord owned = records.add(RecordCheckTestBase.inUse(RecordCheckTestBase.array(new DynamicRecord(42L))));
        DynamicRecord dynamic = records.add(RecordCheckTestBase.inUse(RecordCheckTestBase.array(new DynamicRecord(100L))));
        dynamic.setNextBlock(owned.getId());
        PropertyRecord property = records.add(RecordCheckTestBase.inUse(new PropertyRecord(1L)));
        PropertyKeyTokenRecord key = records.add(RecordCheckTestBase.inUse(new PropertyKeyTokenRecord(10)));
        property.addPropertyBlock(RecordCheckTestBase.propertyBlock(key, PropertyType.ARRAY, owned.getId()));
        ConsistencyReport.DynamicConsistencyReport dynReport = RecordCheckTestBase.check(ConsistencyReport.DynamicConsistencyReport.class, dynChecker, dynamic, records);
        ConsistencyReport.PropertyConsistencyReport propReport = RecordCheckTestBase.check(ConsistencyReport.PropertyConsistencyReport.class, propChecker, property, records);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{dynReport});
        ((ConsistencyReport.PropertyConsistencyReport)Mockito.verify((Object)propReport)).arrayMultipleOwners(dynamic);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{dynReport});
    }

    @Test
    void shouldReportDynamicRecordOwnedByTwoRelationshipLabels() {
        RecordAccessStub records = new RecordAccessStub();
        OwnerCheck decorator = new OwnerCheck(true, new DynamicStore[]{DynamicStore.RELATIONSHIP_TYPE});
        RecordCheck checker = decorator.decorateRelationshipTypeTokenChecker(RecordCheckTestBase.dummyRelationshipLabelCheck());
        DynamicRecord dynamic = records.addRelationshipTypeName(RecordCheckTestBase.inUse(RecordCheckTestBase.string(new DynamicRecord(42L))));
        RelationshipTypeTokenRecord record1 = records.add(RecordCheckTestBase.inUse(new RelationshipTypeTokenRecord(1)));
        RelationshipTypeTokenRecord record2 = records.add(RecordCheckTestBase.inUse(new RelationshipTypeTokenRecord(2)));
        record1.setNameId((int)dynamic.getId());
        record2.setNameId((int)dynamic.getId());
        ConsistencyReport.RelationshipTypeConsistencyReport report1 = RecordCheckTestBase.check(ConsistencyReport.RelationshipTypeConsistencyReport.class, checker, record1, records);
        ConsistencyReport.RelationshipTypeConsistencyReport report2 = RecordCheckTestBase.check(ConsistencyReport.RelationshipTypeConsistencyReport.class, checker, record2, records);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report1});
        ((ConsistencyReport.RelationshipTypeConsistencyReport)Mockito.verify((Object)report2)).nameMultipleOwners(record1);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report2});
    }

    @Test
    void shouldReportDynamicRecordOwnedByRelationshipLabelAndOtherDynamicRecord() {
        RecordAccessStub records = new RecordAccessStub();
        OwnerCheck decorator = new OwnerCheck(true, new DynamicStore[]{DynamicStore.RELATIONSHIP_TYPE});
        RecordCheck dynChecker = decorator.decorateDynamicChecker(RecordType.RELATIONSHIP_TYPE_NAME, RecordCheckTestBase.dummyDynamicCheck(DynamicRecordCheckTest.configureDynamicStore(50), DynamicStore.RELATIONSHIP_TYPE));
        RecordCheck labelCheck = decorator.decorateRelationshipTypeTokenChecker(RecordCheckTestBase.dummyRelationshipLabelCheck());
        DynamicRecord owned = records.addRelationshipTypeName(RecordCheckTestBase.inUse(RecordCheckTestBase.string(new DynamicRecord(42L))));
        DynamicRecord dynamic = records.addRelationshipTypeName(RecordCheckTestBase.inUse(RecordCheckTestBase.string(new DynamicRecord(1L))));
        RelationshipTypeTokenRecord label = records.add(RecordCheckTestBase.inUse(new RelationshipTypeTokenRecord(1)));
        dynamic.setNextBlock(owned.getId());
        label.setNameId((int)owned.getId());
        ConsistencyReport.RelationshipTypeConsistencyReport labelReport = RecordCheckTestBase.check(ConsistencyReport.RelationshipTypeConsistencyReport.class, labelCheck, label, records);
        ConsistencyReport.DynamicConsistencyReport dynReport = RecordCheckTestBase.check(ConsistencyReport.DynamicConsistencyReport.class, dynChecker, dynamic, records);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{labelReport});
        ((ConsistencyReport.DynamicConsistencyReport)Mockito.verify((Object)dynReport)).nextMultipleOwners(label);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{dynReport});
    }

    @Test
    void shouldReportDynamicRecordOwnedByOtherDynamicRecordAndRelationshipLabel() {
        RecordAccessStub records = new RecordAccessStub();
        OwnerCheck decorator = new OwnerCheck(true, new DynamicStore[]{DynamicStore.RELATIONSHIP_TYPE});
        RecordCheck dynChecker = decorator.decorateDynamicChecker(RecordType.RELATIONSHIP_TYPE_NAME, RecordCheckTestBase.dummyDynamicCheck(DynamicRecordCheckTest.configureDynamicStore(50), DynamicStore.RELATIONSHIP_TYPE));
        RecordCheck labelCheck = decorator.decorateRelationshipTypeTokenChecker(RecordCheckTestBase.dummyRelationshipLabelCheck());
        DynamicRecord owned = records.addRelationshipTypeName(RecordCheckTestBase.inUse(RecordCheckTestBase.string(new DynamicRecord(42L))));
        DynamicRecord dynamic = records.addRelationshipTypeName(RecordCheckTestBase.inUse(RecordCheckTestBase.string(new DynamicRecord(1L))));
        RelationshipTypeTokenRecord label = records.add(RecordCheckTestBase.inUse(new RelationshipTypeTokenRecord(1)));
        dynamic.setNextBlock(owned.getId());
        label.setNameId((int)owned.getId());
        ConsistencyReport.DynamicConsistencyReport dynReport = RecordCheckTestBase.check(ConsistencyReport.DynamicConsistencyReport.class, dynChecker, dynamic, records);
        ConsistencyReport.RelationshipTypeConsistencyReport labelReport = RecordCheckTestBase.check(ConsistencyReport.RelationshipTypeConsistencyReport.class, labelCheck, label, records);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{dynReport});
        ((ConsistencyReport.RelationshipTypeConsistencyReport)Mockito.verify((Object)labelReport)).nameMultipleOwners(dynamic);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{labelReport});
    }

    @Test
    void shouldReportDynamicRecordOwnedByTwoPropertyKeys() {
        RecordAccessStub records = new RecordAccessStub();
        OwnerCheck decorator = new OwnerCheck(true, new DynamicStore[]{DynamicStore.PROPERTY_KEY});
        RecordCheck checker = decorator.decoratePropertyKeyTokenChecker(RecordCheckTestBase.dummyPropertyKeyCheck());
        DynamicRecord dynamic = records.addPropertyKeyName(RecordCheckTestBase.inUse(RecordCheckTestBase.string(new DynamicRecord(42L))));
        PropertyKeyTokenRecord record1 = records.add(RecordCheckTestBase.inUse(new PropertyKeyTokenRecord(1)));
        PropertyKeyTokenRecord record2 = records.add(RecordCheckTestBase.inUse(new PropertyKeyTokenRecord(2)));
        record1.setNameId((int)dynamic.getId());
        record2.setNameId((int)dynamic.getId());
        ConsistencyReport.PropertyKeyTokenConsistencyReport report1 = RecordCheckTestBase.check(ConsistencyReport.PropertyKeyTokenConsistencyReport.class, checker, record1, records);
        ConsistencyReport.PropertyKeyTokenConsistencyReport report2 = RecordCheckTestBase.check(ConsistencyReport.PropertyKeyTokenConsistencyReport.class, checker, record2, records);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report1});
        ((ConsistencyReport.PropertyKeyTokenConsistencyReport)Mockito.verify((Object)report2)).nameMultipleOwners(record1);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report2});
    }

    @Test
    void shouldReportDynamicRecordOwnedByPropertyKeyAndOtherDynamicRecord() {
        RecordAccessStub records = new RecordAccessStub();
        OwnerCheck decorator = new OwnerCheck(true, new DynamicStore[]{DynamicStore.PROPERTY_KEY});
        RecordCheck dynChecker = decorator.decorateDynamicChecker(RecordType.PROPERTY_KEY_NAME, RecordCheckTestBase.dummyDynamicCheck(DynamicRecordCheckTest.configureDynamicStore(50), DynamicStore.PROPERTY_KEY));
        RecordCheck keyCheck = decorator.decoratePropertyKeyTokenChecker(RecordCheckTestBase.dummyPropertyKeyCheck());
        DynamicRecord owned = records.addPropertyKeyName(RecordCheckTestBase.inUse(RecordCheckTestBase.string(new DynamicRecord(42L))));
        DynamicRecord dynamic = records.addPropertyKeyName(RecordCheckTestBase.inUse(RecordCheckTestBase.string(new DynamicRecord(1L))));
        PropertyKeyTokenRecord key = records.add(RecordCheckTestBase.inUse(new PropertyKeyTokenRecord(1)));
        dynamic.setNextBlock(owned.getId());
        key.setNameId((int)owned.getId());
        ConsistencyReport.PropertyKeyTokenConsistencyReport keyReport = RecordCheckTestBase.check(ConsistencyReport.PropertyKeyTokenConsistencyReport.class, keyCheck, key, records);
        ConsistencyReport.DynamicConsistencyReport dynReport = RecordCheckTestBase.check(ConsistencyReport.DynamicConsistencyReport.class, dynChecker, dynamic, records);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{keyReport});
        ((ConsistencyReport.DynamicConsistencyReport)Mockito.verify((Object)dynReport)).nextMultipleOwners(key);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{dynReport});
    }

    @Test
    void shouldReportDynamicRecordOwnedByOtherDynamicRecordAndPropertyKey() {
        RecordAccessStub records = new RecordAccessStub();
        OwnerCheck decorator = new OwnerCheck(true, new DynamicStore[]{DynamicStore.PROPERTY_KEY});
        RecordCheck dynChecker = decorator.decorateDynamicChecker(RecordType.PROPERTY_KEY_NAME, RecordCheckTestBase.dummyDynamicCheck(DynamicRecordCheckTest.configureDynamicStore(50), DynamicStore.PROPERTY_KEY));
        RecordCheck keyCheck = decorator.decoratePropertyKeyTokenChecker(RecordCheckTestBase.dummyPropertyKeyCheck());
        DynamicRecord owned = records.addPropertyKeyName(RecordCheckTestBase.inUse(RecordCheckTestBase.string(new DynamicRecord(42L))));
        DynamicRecord dynamic = records.addPropertyKeyName(RecordCheckTestBase.inUse(RecordCheckTestBase.string(new DynamicRecord(1L))));
        PropertyKeyTokenRecord key = records.add(RecordCheckTestBase.inUse(new PropertyKeyTokenRecord(1)));
        dynamic.setNextBlock(owned.getId());
        key.setNameId((int)owned.getId());
        ConsistencyReport.DynamicConsistencyReport dynReport = RecordCheckTestBase.check(ConsistencyReport.DynamicConsistencyReport.class, dynChecker, dynamic, records);
        ConsistencyReport.PropertyKeyTokenConsistencyReport keyReport = RecordCheckTestBase.check(ConsistencyReport.PropertyKeyTokenConsistencyReport.class, keyCheck, key, records);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{dynReport});
        ((ConsistencyReport.PropertyKeyTokenConsistencyReport)Mockito.verify((Object)keyReport)).nameMultipleOwners(dynamic);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{keyReport});
    }

    @Test
    void shouldReportOrphanedDynamicStringRecord() {
        RecordAccessStub records = new RecordAccessStub();
        OwnerCheck owners = new OwnerCheck(true, new DynamicStore[]{DynamicStore.STRING});
        RecordCheck stringCheck = owners.decorateDynamicChecker(RecordType.STRING_PROPERTY, RecordCheckTestBase.dummyDynamicCheck(DynamicRecordCheckTest.configureDynamicStore(60), DynamicStore.STRING));
        DynamicRecord record = RecordCheckTestBase.string(RecordCheckTestBase.inUse(new DynamicRecord(42L)));
        ConsistencyReport.DynamicConsistencyReport report = RecordCheckTestBase.check(ConsistencyReport.DynamicConsistencyReport.class, stringCheck, record, records);
        owners.scanForOrphanChains(ProgressMonitorFactory.NONE);
        records.checkDeferred();
        ((ConsistencyReport.DynamicConsistencyReport)Mockito.verify((Object)report)).orphanDynamicRecord();
    }

    @Test
    void shouldReportOrphanedDynamicArrayRecord() {
        RecordAccessStub records = new RecordAccessStub();
        OwnerCheck owners = new OwnerCheck(true, new DynamicStore[]{DynamicStore.ARRAY});
        RecordCheck stringCheck = owners.decorateDynamicChecker(RecordType.ARRAY_PROPERTY, RecordCheckTestBase.dummyDynamicCheck(DynamicRecordCheckTest.configureDynamicStore(60), DynamicStore.ARRAY));
        DynamicRecord record = RecordCheckTestBase.string(RecordCheckTestBase.inUse(new DynamicRecord(42L)));
        ConsistencyReport.DynamicConsistencyReport report = RecordCheckTestBase.check(ConsistencyReport.DynamicConsistencyReport.class, stringCheck, record, records);
        owners.scanForOrphanChains(ProgressMonitorFactory.NONE);
        records.checkDeferred();
        ((ConsistencyReport.DynamicConsistencyReport)Mockito.verify((Object)report)).orphanDynamicRecord();
    }

    @Test
    void shouldReportOrphanedDynamicRelationshipLabelRecord() {
        RecordAccessStub records = new RecordAccessStub();
        OwnerCheck owners = new OwnerCheck(true, new DynamicStore[]{DynamicStore.RELATIONSHIP_TYPE});
        RecordCheck stringCheck = owners.decorateDynamicChecker(RecordType.RELATIONSHIP_TYPE_NAME, RecordCheckTestBase.dummyDynamicCheck(DynamicRecordCheckTest.configureDynamicStore(60), DynamicStore.RELATIONSHIP_TYPE));
        DynamicRecord record = RecordCheckTestBase.string(RecordCheckTestBase.inUse(new DynamicRecord(42L)));
        ConsistencyReport.DynamicConsistencyReport report = RecordCheckTestBase.check(ConsistencyReport.DynamicConsistencyReport.class, stringCheck, record, records);
        owners.scanForOrphanChains(ProgressMonitorFactory.NONE);
        records.checkDeferred();
        ((ConsistencyReport.DynamicConsistencyReport)Mockito.verify((Object)report)).orphanDynamicRecord();
    }

    @Test
    void shouldReportOrphanedDynamicPropertyKeyRecord() {
        RecordAccessStub records = new RecordAccessStub();
        OwnerCheck owners = new OwnerCheck(true, new DynamicStore[]{DynamicStore.PROPERTY_KEY});
        RecordCheck stringCheck = owners.decorateDynamicChecker(RecordType.PROPERTY_KEY_NAME, RecordCheckTestBase.dummyDynamicCheck(DynamicRecordCheckTest.configureDynamicStore(60), DynamicStore.PROPERTY_KEY));
        DynamicRecord record = RecordCheckTestBase.string(RecordCheckTestBase.inUse(new DynamicRecord(42L)));
        ConsistencyReport.DynamicConsistencyReport report = RecordCheckTestBase.check(ConsistencyReport.DynamicConsistencyReport.class, stringCheck, record, records);
        owners.scanForOrphanChains(ProgressMonitorFactory.NONE);
        records.checkDeferred();
        ((ConsistencyReport.DynamicConsistencyReport)Mockito.verify((Object)report)).orphanDynamicRecord();
    }
}

