/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.consistency.checking.ChainCheck;
import org.neo4j.consistency.checking.CheckerEngine;
import org.neo4j.consistency.checking.RecordCheckTestBase;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.consistency.store.RecordAccessStub;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;

class DuplicatePropertyTest {
    DuplicatePropertyTest() {
    }

    @Test
    void shouldReportDuplicatePropertyIndexesInPropertyRecordForNode() {
        ChainCheck check = new ChainCheck();
        RecordAccessStub records = new RecordAccessStub();
        NodeRecord master = records.add(RecordCheckTestBase.inUse(new NodeRecord(1L, false, -1L, 1L)));
        PropertyRecord propertyRecord = RecordCheckTestBase.inUse(new PropertyRecord(1L));
        PropertyBlock firstBlock = new PropertyBlock();
        firstBlock.setSingleBlock(1L);
        firstBlock.setKeyIndexId(1);
        PropertyBlock secondBlock = new PropertyBlock();
        secondBlock.setSingleBlock(1L);
        secondBlock.setKeyIndexId(2);
        PropertyBlock thirdBlock = new PropertyBlock();
        thirdBlock.setSingleBlock(1L);
        thirdBlock.setKeyIndexId(1);
        propertyRecord.addPropertyBlock(firstBlock);
        propertyRecord.addPropertyBlock(secondBlock);
        propertyRecord.addPropertyBlock(thirdBlock);
        records.add(propertyRecord);
        ConsistencyReport.NodeConsistencyReport report = (ConsistencyReport.NodeConsistencyReport)Mockito.mock(ConsistencyReport.NodeConsistencyReport.class);
        CheckerEngine<NodeRecord, ConsistencyReport.NodeConsistencyReport> checkEngine = records.engine(master, report);
        check.checkReference((PrimitiveRecord)master, propertyRecord, checkEngine, (RecordAccess)records);
        ((ConsistencyReport.NodeConsistencyReport)Mockito.verify((Object)report)).propertyKeyNotUniqueInChain();
    }

    @Test
    void shouldReportDuplicatePropertyIndexesAcrossRecordsInPropertyChainForNode() {
        ChainCheck check = new ChainCheck();
        RecordAccessStub records = new RecordAccessStub();
        RelationshipRecord master = records.add(RecordCheckTestBase.inUse(new RelationshipRecord(1L, 2L, 3L, 4)));
        master.setNextProp(1L);
        PropertyRecord firstRecord = RecordCheckTestBase.inUse(new PropertyRecord(1L));
        firstRecord.setNextProp(12L);
        PropertyBlock firstBlock = new PropertyBlock();
        firstBlock.setSingleBlock(1L);
        firstBlock.setKeyIndexId(1);
        PropertyBlock secondBlock = new PropertyBlock();
        secondBlock.setSingleBlock(1L);
        secondBlock.setKeyIndexId(2);
        PropertyRecord secondRecord = RecordCheckTestBase.inUse(new PropertyRecord(12L));
        secondRecord.setPrevProp(1L);
        PropertyBlock thirdBlock = new PropertyBlock();
        thirdBlock.setSingleBlock(1L);
        thirdBlock.setKeyIndexId(4);
        PropertyBlock fourthBlock = new PropertyBlock();
        fourthBlock.setSingleBlock(1L);
        fourthBlock.setKeyIndexId(1);
        firstRecord.addPropertyBlock(firstBlock);
        firstRecord.addPropertyBlock(secondBlock);
        secondRecord.addPropertyBlock(thirdBlock);
        secondRecord.addPropertyBlock(fourthBlock);
        records.add(firstRecord);
        records.add(secondRecord);
        ConsistencyReport.RelationshipConsistencyReport report = (ConsistencyReport.RelationshipConsistencyReport)Mockito.mock(ConsistencyReport.RelationshipConsistencyReport.class);
        CheckerEngine<RelationshipRecord, ConsistencyReport.RelationshipConsistencyReport> checkEngine = records.engine(master, report);
        check.checkReference((PrimitiveRecord)master, firstRecord, checkEngine, (RecordAccess)records);
        records.checkDeferred();
        ((ConsistencyReport.RelationshipConsistencyReport)Mockito.verify((Object)report)).propertyKeyNotUniqueInChain();
    }

    @Test
    void shouldNotReportAnythingForConsistentChains() {
        ChainCheck check = new ChainCheck();
        RecordAccessStub records = new RecordAccessStub();
        RelationshipRecord master = records.add(RecordCheckTestBase.inUse(new RelationshipRecord(1L, 2L, 3L, 4)));
        master.setNextProp(1L);
        PropertyRecord firstRecord = RecordCheckTestBase.inUse(new PropertyRecord(1L));
        firstRecord.setNextProp(12L);
        PropertyBlock firstBlock = new PropertyBlock();
        firstBlock.setSingleBlock(1L);
        firstBlock.setKeyIndexId(1);
        PropertyBlock secondBlock = new PropertyBlock();
        secondBlock.setSingleBlock(1L);
        secondBlock.setKeyIndexId(2);
        PropertyRecord secondRecord = RecordCheckTestBase.inUse(new PropertyRecord(12L));
        secondRecord.setPrevProp(1L);
        PropertyBlock thirdBlock = new PropertyBlock();
        thirdBlock.setSingleBlock(1L);
        thirdBlock.setKeyIndexId(4);
        PropertyBlock fourthBlock = new PropertyBlock();
        fourthBlock.setSingleBlock(11L);
        fourthBlock.setKeyIndexId(11);
        firstRecord.addPropertyBlock(firstBlock);
        firstRecord.addPropertyBlock(secondBlock);
        secondRecord.addPropertyBlock(thirdBlock);
        secondRecord.addPropertyBlock(fourthBlock);
        records.add(firstRecord);
        records.add(secondRecord);
        ConsistencyReport.RelationshipConsistencyReport report = (ConsistencyReport.RelationshipConsistencyReport)Mockito.mock(ConsistencyReport.RelationshipConsistencyReport.class);
        CheckerEngine<RelationshipRecord, ConsistencyReport.RelationshipConsistencyReport> checkEngine = records.engine(master, report);
        check.checkReference((PrimitiveRecord)master, firstRecord, checkEngine, (RecordAccess)records);
        records.checkDeferred();
        Mockito.verifyZeroInteractions((Object[])new Object[]{report});
    }
}

