/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.cache;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.consistency.checking.cache.PackedMultiFieldCache;

class PackedMultiFieldCacheTest {
    PackedMultiFieldCacheTest() {
    }

    @Test
    void shouldPutValuesIntoSlots() {
        PackedMultiFieldCache cache = new PackedMultiFieldCache(new int[]{5, 10, 25, 24});
        int index = 10;
        long[] values = new long[]{3L, 100L, 12345L, 67890L};
        cache.put((long)index, values);
        for (int i = 0; i < values.length; ++i) {
            Assertions.assertEquals((long)values[i], (long)cache.get((long)index, i));
        }
    }

    @Test
    void shouldHaveCorrectDefaultValues() {
        PackedMultiFieldCache cache = new PackedMultiFieldCache(new int[]{1, 34, 35});
        int index = 0;
        cache.clear((long)index);
        Assertions.assertEquals((long)0L, (long)cache.get((long)index, 0));
        Assertions.assertEquals((long)0L, (long)cache.get((long)index, 1));
        Assertions.assertEquals((long)-1L, (long)cache.get((long)index, 2));
    }

    @Test
    void shouldBeAbleToChangeSlotSize() {
        PackedMultiFieldCache cache = new PackedMultiFieldCache(new int[]{1, 5});
        int index = 10;
        Assertions.assertThrows(IllegalStateException.class, () -> cache.put((long)index, 0, 10L));
        cache.setSlotSizes(new int[]{5, 20});
        cache.put((long)index, 0, 10L);
        Assertions.assertEquals((long)10L, (long)cache.get((long)index, 0));
    }
}

