/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking;

import org.junit.jupiter.api.Assertions;
import org.mockito.Mockito;
import org.neo4j.consistency.checking.CheckerEngine;
import org.neo4j.consistency.checking.DynamicRecordCheck;
import org.neo4j.consistency.checking.DynamicStore;
import org.neo4j.consistency.checking.NeoStoreCheck;
import org.neo4j.consistency.checking.NodeRecordCheck;
import org.neo4j.consistency.checking.PrimitiveRecordCheck;
import org.neo4j.consistency.checking.PropertyChain;
import org.neo4j.consistency.checking.PropertyKeyTokenRecordCheck;
import org.neo4j.consistency.checking.RecordCheck;
import org.neo4j.consistency.checking.RecordField;
import org.neo4j.consistency.checking.RelationshipRecordCheck;
import org.neo4j.consistency.checking.RelationshipTypeTokenRecordCheck;
import org.neo4j.consistency.checking.full.MultiPassStore;
import org.neo4j.consistency.checking.full.Stage;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.consistency.store.RecordAccessStub;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NeoStoreRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;

public abstract class RecordCheckTestBase<RECORD extends AbstractBaseRecord, REPORT extends ConsistencyReport, CHECKER extends RecordCheck<RECORD, REPORT>> {
    public static final int NONE = -1;
    protected final CHECKER checker;
    private final Class<REPORT> reportClass;
    protected RecordAccessStub records;
    private Stage stage;

    RecordCheckTestBase(CHECKER checker, Class<REPORT> reportClass, int[] cacheFields, MultiPassStore ... storesToCheck) {
        this(checker, reportClass, (Stage)new Stage.Adapter(false, true, "Test stage", cacheFields), storesToCheck);
    }

    RecordCheckTestBase(CHECKER checker, Class<REPORT> reportClass, Stage stage, MultiPassStore ... storesToCheck) {
        this.checker = checker;
        this.reportClass = reportClass;
        this.stage = stage;
        this.initialize(storesToCheck);
    }

    protected void initialize(MultiPassStore ... storesToCheck) {
        this.records = new RecordAccessStub(this.stage, storesToCheck);
        if (this.stage.getCacheSlotSizes().length > 0) {
            this.records.cacheAccess().setCacheSlotSizes(this.stage.getCacheSlotSizes());
        }
    }

    public static PrimitiveRecordCheck<NodeRecord, ConsistencyReport.NodeConsistencyReport> dummyNodeCheck() {
        return new NodeRecordCheck(){

            public void check(NodeRecord record, CheckerEngine<NodeRecord, ConsistencyReport.NodeConsistencyReport> engine, RecordAccess records) {
            }
        };
    }

    public static PrimitiveRecordCheck<RelationshipRecord, ConsistencyReport.RelationshipConsistencyReport> dummyRelationshipChecker() {
        return new RelationshipRecordCheck(){

            public void check(RelationshipRecord record, CheckerEngine<RelationshipRecord, ConsistencyReport.RelationshipConsistencyReport> engine, RecordAccess records) {
            }
        };
    }

    public static RecordCheck<PropertyRecord, ConsistencyReport.PropertyConsistencyReport> dummyPropertyChecker() {
        return (record, engine, records) -> {};
    }

    public static PrimitiveRecordCheck<NeoStoreRecord, ConsistencyReport.NeoStoreConsistencyReport> dummyNeoStoreCheck() {
        return new NeoStoreCheck(new RecordField[]{new PropertyChain(from -> null)}){

            public void check(NeoStoreRecord record, CheckerEngine<NeoStoreRecord, ConsistencyReport.NeoStoreConsistencyReport> engine, RecordAccess records) {
            }
        };
    }

    public static RecordCheck<DynamicRecord, ConsistencyReport.DynamicConsistencyReport> dummyDynamicCheck(RecordStore<DynamicRecord> store, DynamicStore dereference) {
        return new DynamicRecordCheck(store, dereference){

            public void check(DynamicRecord record, CheckerEngine<DynamicRecord, ConsistencyReport.DynamicConsistencyReport> engine, RecordAccess records) {
            }
        };
    }

    public static RecordCheck<PropertyKeyTokenRecord, ConsistencyReport.PropertyKeyTokenConsistencyReport> dummyPropertyKeyCheck() {
        return new PropertyKeyTokenRecordCheck(){

            public void check(PropertyKeyTokenRecord record, CheckerEngine<PropertyKeyTokenRecord, ConsistencyReport.PropertyKeyTokenConsistencyReport> engine, RecordAccess records) {
            }
        };
    }

    public static RecordCheck<RelationshipTypeTokenRecord, ConsistencyReport.RelationshipTypeConsistencyReport> dummyRelationshipLabelCheck() {
        return new RelationshipTypeTokenRecordCheck(){

            public void check(RelationshipTypeTokenRecord record, CheckerEngine<RelationshipTypeTokenRecord, ConsistencyReport.RelationshipTypeConsistencyReport> engine, RecordAccess records) {
            }
        };
    }

    REPORT check(RECORD record) {
        return RecordCheckTestBase.check(this.reportClass, this.checker, record, this.records);
    }

    void check(REPORT report, RECORD record) {
        RecordCheckTestBase.check(report, this.checker, record, this.records);
    }

    final REPORT check(CHECKER externalChecker, RECORD record) {
        return RecordCheckTestBase.check(this.reportClass, externalChecker, record, this.records);
    }

    public static <RECORD extends AbstractBaseRecord, REPORT extends ConsistencyReport> REPORT check(Class<REPORT> reportClass, RecordCheck<RECORD, REPORT> checker, RECORD record, RecordAccessStub records) {
        ConsistencyReport report = (ConsistencyReport)Mockito.mock(reportClass);
        RecordCheckTestBase.check(report, checker, record, records);
        return (REPORT)report;
    }

    public static <RECORD extends AbstractBaseRecord, REPORT extends ConsistencyReport> void check(REPORT report, RecordCheck<RECORD, REPORT> checker, RECORD record, RecordAccessStub records) {
        checker.check(record, records.engine(record, report), (RecordAccess)records);
        records.checkDeferred();
    }

    <R extends AbstractBaseRecord> R addChange(R oldRecord, R newRecord) {
        return this.records.addChange(oldRecord, newRecord);
    }

    <R extends AbstractBaseRecord> R add(R record) {
        return this.records.add(record);
    }

    DynamicRecord addNodeDynamicLabels(DynamicRecord labels) {
        return this.records.addNodeDynamicLabels(labels);
    }

    DynamicRecord addKeyName(DynamicRecord name) {
        return this.records.addPropertyKeyName(name);
    }

    DynamicRecord addRelationshipTypeName(DynamicRecord name) {
        return this.records.addRelationshipTypeName(name);
    }

    DynamicRecord addLabelName(DynamicRecord name) {
        return this.records.addLabelName(name);
    }

    public static DynamicRecord string(DynamicRecord record) {
        record.setType(PropertyType.STRING.intValue());
        return record;
    }

    public static DynamicRecord array(DynamicRecord record) {
        record.setType(PropertyType.ARRAY.intValue());
        return record;
    }

    static PropertyBlock propertyBlock(PropertyKeyTokenRecord key, DynamicRecord value) {
        PropertyType type = value.getType();
        if (value.getType() != PropertyType.STRING && value.getType() != PropertyType.ARRAY) {
            Assertions.fail((String)"Dynamic record must be either STRING or ARRAY");
            return null;
        }
        return RecordCheckTestBase.propertyBlock(key, type, value.getId());
    }

    public static PropertyBlock propertyBlock(PropertyKeyTokenRecord key, PropertyType type, long value) {
        PropertyBlock block = new PropertyBlock();
        block.setSingleBlock(key.getId() | (long)type.intValue() << 24 | value << 28);
        return block;
    }

    public static <R extends AbstractBaseRecord> R inUse(R record) {
        record.setInUse(true);
        return record;
    }

    public static <R extends AbstractBaseRecord> R notInUse(R record) {
        record.setInUse(false);
        return record;
    }

    protected CHECKER checker() {
        return this.checker;
    }
}

