/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.report;

import org.junit.Test;
import org.neo4j.consistency.RecordType;
import org.neo4j.consistency.report.InconsistencyMessageLogger;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.NeoStoreRecord;
import org.neo4j.logging.AssertableLogProvider;

public class MessageConsistencyLoggerTest {
    private static final AssertableLogProvider.LogMatcherBuilder INLOG = AssertableLogProvider.inLog(MessageConsistencyLoggerTest.class);
    private final InconsistencyMessageLogger logger;
    private final AssertableLogProvider logProvider = new AssertableLogProvider();

    public MessageConsistencyLoggerTest() {
        this.logger = new InconsistencyMessageLogger(this.logProvider.getLog(this.getClass()));
    }

    @Test
    public void shouldFormatErrorForRecord() {
        this.logger.error(RecordType.NEO_STORE, (AbstractBaseRecord)new NeoStoreRecord(), "sample message", new Object[]{1, 2});
        this.logProvider.assertExactly(new AssertableLogProvider.LogMatcher[]{INLOG.error(this.join("sample message", this.neoStoreRecord(true, -1L), "Inconsistent with: 1 2"))});
    }

    private String neoStoreRecord(boolean used, long nextProp) {
        NeoStoreRecord record = new NeoStoreRecord();
        record.setInUse(used);
        record.setNextProp(nextProp);
        return record.toString();
    }

    @Test
    public void shouldFlattenAMultiLineMessageToASingleLine() {
        this.logger.error(RecordType.NEO_STORE, (AbstractBaseRecord)new NeoStoreRecord(), "multiple\n line\r\n message", new Object[]{1, 2});
        this.logProvider.assertExactly(new AssertableLogProvider.LogMatcher[]{INLOG.error(this.join("multiple line message", this.neoStoreRecord(true, -1L), "Inconsistent with: 1 2"))});
    }

    @Test
    public void shouldFormatWarningForRecord() {
        this.logger.warning(RecordType.NEO_STORE, (AbstractBaseRecord)new NeoStoreRecord(), "sample message", new Object[]{1, 2});
        this.logProvider.assertExactly(new AssertableLogProvider.LogMatcher[]{INLOG.warn(this.join("sample message", this.neoStoreRecord(true, -1L), "Inconsistent with: 1 2"))});
    }

    @Test
    public void shouldFormatLogForChangedRecord() {
        this.logger.error(RecordType.NEO_STORE, (AbstractBaseRecord)new NeoStoreRecord(), (AbstractBaseRecord)new NeoStoreRecord(), "sample message", new Object[]{1, 2});
        this.logProvider.assertExactly(new AssertableLogProvider.LogMatcher[]{INLOG.error(this.join("sample message", "- " + this.neoStoreRecord(true, -1L), "+ " + this.neoStoreRecord(true, -1L), "Inconsistent with: 1 2"))});
    }

    private String join(String firstLine, String ... lines) {
        StringBuilder expected = new StringBuilder(firstLine);
        for (String line : lines) {
            expected.append(System.lineSeparator()).append("\t").append(line);
        }
        return expected.toString();
    }
}

