/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.mutable.MutableInt;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.consistency.ConsistencyCheckSettings;
import org.neo4j.consistency.RecordType;
import org.neo4j.consistency.checking.GraphStoreFixture;
import org.neo4j.consistency.checking.RecordCheckTestBase;
import org.neo4j.consistency.checking.SchemaRuleUtil;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.consistency.checking.full.FullCheck;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.report.ConsistencySummaryStatistics;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptorSupplier;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.direct.DirectStoreAccess;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.api.labelscan.LabelScanWriter;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.api.schema.constaints.ConstraintDescriptorFactory;
import org.neo4j.kernel.api.schema.constaints.IndexBackedConstraintDescriptor;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.NodeUpdates;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.store.AbstractDynamicStore;
import org.neo4j.kernel.impl.store.DynamicArrayStore;
import org.neo4j.kernel.impl.store.DynamicNodeLabels;
import org.neo4j.kernel.impl.store.DynamicRecordAllocator;
import org.neo4j.kernel.impl.store.LabelIdArray;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.SchemaStorage;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.StoreAccess;
import org.neo4j.kernel.impl.store.allocator.ReusableRecordsAllocator;
import org.neo4j.kernel.impl.store.allocator.ReusableRecordsCompositeAllocator;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.ConstraintRule;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.transaction.state.storeview.NeoStoreIndexStoreView;
import org.neo4j.kernel.impl.util.Bits;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.FormattedLog;
import org.neo4j.logging.Log;
import org.neo4j.storageengine.api.schema.SchemaRule;
import org.neo4j.string.UTF8;
import org.neo4j.test.Property;
import org.neo4j.test.rule.SuppressOutput;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class FullCheckIntegrationTest {
    private static final IndexProvider.Descriptor DESCRIPTOR = new IndexProvider.Descriptor("lucene", "1.0");
    private static final String PROP1 = "key1";
    private static final String PROP2 = "key2";
    private static final Object VALUE1 = "value1";
    private static final Object VALUE2 = "value2";
    private int label1;
    private int label2;
    private int label3;
    private int label4;
    private int draconian;
    private int key1;
    private int key2;
    private int mandatory;
    private int C;
    private int T;
    private int M;
    private final List<Long> indexedNodes = new ArrayList<Long>();
    private static final Map<Class<?>, Set<String>> allReports = new HashMap();
    private final GraphStoreFixture fixture = new GraphStoreFixture(this.getRecordFormatName()){

        @Override
        protected void generateInitialData(GraphDatabaseService db) {
            Throwable throwable;
            Transaction tx;
            try {
                tx = db.beginTx();
                throwable = null;
                try {
                    db.schema().indexFor(Label.label((String)"label3")).on(FullCheckIntegrationTest.PROP1).create();
                    KernelTransaction ktx = FullCheckIntegrationTest.transactionOn(db);
                    try (Statement ignore = ktx.acquireStatement();){
                        TokenWrite tokenWrite = ktx.tokenWrite();
                        FullCheckIntegrationTest.this.key1 = tokenWrite.propertyKeyGetOrCreateForName(FullCheckIntegrationTest.PROP1);
                        FullCheckIntegrationTest.this.key2 = tokenWrite.propertyKeyGetOrCreateForName(FullCheckIntegrationTest.PROP2);
                        FullCheckIntegrationTest.this.label3 = ktx.tokenRead().nodeLabel("label3");
                        ktx.schemaWrite().indexCreate((SchemaDescriptor)SchemaDescriptorFactory.forLabel((int)FullCheckIntegrationTest.this.label3, (int[])new int[]{FullCheckIntegrationTest.this.key1, FullCheckIntegrationTest.this.key2}));
                    }
                    db.schema().constraintFor(Label.label((String)"label4")).assertPropertyIsUnique(FullCheckIntegrationTest.PROP1).create();
                    tx.success();
                }
                catch (Throwable ktx) {
                    throwable = ktx;
                    throw ktx;
                }
                finally {
                    if (tx != null) {
                        if (throwable != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable ktx) {
                                throwable.addSuppressed(ktx);
                            }
                        } else {
                            tx.close();
                        }
                    }
                }
            }
            catch (KernelException e) {
                throw new RuntimeException(e);
            }
            throwable = null;
            try (Transaction ignored = db.beginTx();){
                db.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            }
            catch (Throwable ktx) {
                throwable = ktx;
                throw ktx;
            }
            try {
                tx = db.beginTx();
                throwable = null;
                try {
                    Node node1 = (Node)Property.set((PropertyContainer)db.createNode(new Label[]{Label.label((String)"label1")}), (Property[])new Property[0]);
                    Node node2 = (Node)Property.set((PropertyContainer)db.createNode(new Label[]{Label.label((String)"label2")}), (Property[])new Property[]{Property.property((String)FullCheckIntegrationTest.PROP1, (Object)VALUE1)});
                    node1.createRelationshipTo(node2, RelationshipType.withName((String)"C"));
                    db.createNode().createRelationshipTo(db.createNode(), RelationshipType.withName((String)"T"));
                    FullCheckIntegrationTest.this.indexedNodes.add(((Node)Property.set((PropertyContainer)db.createNode(new Label[]{Label.label((String)"label3")}), (Property[])new Property[]{Property.property((String)FullCheckIntegrationTest.PROP1, (Object)VALUE1)})).getId());
                    FullCheckIntegrationTest.this.indexedNodes.add(((Node)Property.set((PropertyContainer)db.createNode(new Label[]{Label.label((String)"label3")}), (Property[])new Property[]{Property.property((String)FullCheckIntegrationTest.PROP1, (Object)VALUE1), Property.property((String)FullCheckIntegrationTest.PROP2, (Object)VALUE2)})).getId());
                    Property.set((PropertyContainer)db.createNode(new Label[]{Label.label((String)"label4")}), (Property[])new Property[]{Property.property((String)FullCheckIntegrationTest.PROP1, (Object)VALUE1)});
                    tx.success();
                    KernelTransaction ktx = FullCheckIntegrationTest.transactionOn(db);
                    try (Statement ignore = ktx.acquireStatement();){
                        TokenRead tokenRead = ktx.tokenRead();
                        TokenWrite tokenWrite = ktx.tokenWrite();
                        FullCheckIntegrationTest.this.label1 = tokenRead.nodeLabel("label1");
                        FullCheckIntegrationTest.this.label2 = tokenRead.nodeLabel("label2");
                        FullCheckIntegrationTest.this.label3 = tokenRead.nodeLabel("label3");
                        FullCheckIntegrationTest.this.label4 = tokenRead.nodeLabel("label4");
                        FullCheckIntegrationTest.this.draconian = tokenWrite.labelGetOrCreateForName("draconian");
                        FullCheckIntegrationTest.this.key1 = tokenRead.propertyKey(FullCheckIntegrationTest.PROP1);
                        FullCheckIntegrationTest.this.mandatory = tokenWrite.propertyKeyGetOrCreateForName("mandatory");
                        FullCheckIntegrationTest.this.C = tokenRead.relationshipType("C");
                        FullCheckIntegrationTest.this.T = tokenRead.relationshipType("T");
                        FullCheckIntegrationTest.this.M = tokenWrite.relationshipTypeGetOrCreateForName("M");
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (tx != null) {
                        if (throwable != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            tx.close();
                        }
                    }
                }
            }
            catch (KernelException e) {
                throw new RuntimeException(e);
            }
        }
    };
    private final SuppressOutput suppressOutput = SuppressOutput.suppress((SuppressOutput.Suppressible[])new SuppressOutput.Suppressible[]{SuppressOutput.System.out});
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.suppressOutput).around((TestRule)this.fixture);
    private static DynamicRecordAllocator schemaAllocator = new DynamicRecordAllocator(){
        private int next = 10000;

        public int getRecordDataSize() {
            return 56;
        }

        public DynamicRecord nextRecord() {
            return new DynamicRecord((long)this.next++);
        }
    };

    @BeforeClass
    public static void collectAllDifferentInconsistencyTypes() {
        Class<ConsistencyReport> reportClass = ConsistencyReport.class;
        for (Class<?> cls : reportClass.getDeclaredClasses()) {
            for (Method method : cls.getDeclaredMethods()) {
                if (method.getAnnotation(Documented.class) == null) continue;
                Set types = allReports.computeIfAbsent(cls, k -> new HashSet());
                types.add(method.getName());
            }
        }
    }

    @AfterClass
    public static void verifyThatWeHaveExercisedAllTypesOfInconsistenciesThatWeHave() {
        if (!allReports.isEmpty()) {
            StringBuilder builder = new StringBuilder("There are types of inconsistencies not covered by this integration test, please add tests that tests for:");
            for (Map.Entry<Class<?>, Set<String>> reporter : allReports.entrySet()) {
                builder.append(String.format("%n%s:", reporter.getKey().getSimpleName()));
                for (String type : reporter.getValue()) {
                    builder.append(String.format("%n  %s", type));
                }
            }
            System.err.println(builder.toString());
        }
    }

    @Test
    public void shouldCheckConsistencyOfAConsistentStore() throws Exception {
        ConsistencySummaryStatistics result = this.check();
        Assert.assertEquals((String)result.toString(), (long)0L, (long)result.getTotalInconsistencyCount());
    }

    @Test
    public void shouldReportNodeInconsistencies() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                tx.create(new NodeRecord(next.node(), false, next.relationship(), -1L));
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        ConsistencySummaryVerifier.on(stats).verify(RecordType.NODE, 1).andThatsAllFolks();
    }

    @Test
    public void shouldReportInlineNodeLabelInconsistencies() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                NodeRecord nodeRecord = new NodeRecord(next.node(), false, -1L, -1L);
                NodeLabelsField.parseLabelsField((NodeRecord)nodeRecord).add(10L, null, null);
                tx.create(nodeRecord);
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        ConsistencySummaryVerifier.on(stats).verify(RecordType.NODE, 1).andThatsAllFolks();
    }

    @Test
    public void shouldReportNodeDynamicLabelContainingUnknownLabelAsNodeInconsistency() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                NodeRecord nodeRecord = new NodeRecord(next.node(), false, -1L, -1L);
                DynamicRecord record = RecordCheckTestBase.inUse(new DynamicRecord(next.nodeLabel()));
                ArrayList newRecords = new ArrayList();
                DynamicArrayStore.allocateFromNumbers(newRecords, (Object)LabelIdArray.prependNodeId((long)nodeRecord.getId(), (long[])new long[]{42L}), (DynamicRecordAllocator)new ReusableRecordsAllocator(60, new DynamicRecord[]{record}));
                nodeRecord.setLabelField(DynamicNodeLabels.dynamicPointer(newRecords), newRecords);
                tx.create(nodeRecord);
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        ConsistencySummaryVerifier.on(stats).verify(RecordType.NODE, 1).andThatsAllFolks();
    }

    @Test
    public void shouldNotReportAnythingForNodeWithConsistentChainOfDynamicRecordsWithLabels() throws Exception {
        Assert.assertEquals((long)3L, (long)((List)this.chainOfDynamicRecordsWithLabelsForANode(130).first()).size());
        ConsistencySummaryStatistics stats = this.check();
        Assert.assertTrue((String)"should be consistent", (boolean)stats.isConsistent());
    }

    @Test
    public void shouldReportLabelScanStoreInconsistencies() throws Exception {
        GraphStoreFixture.IdGenerator idGenerator = this.fixture.idGenerator();
        long nodeId1 = idGenerator.node();
        long labelId = idGenerator.label() - 1;
        LabelScanStore labelScanStore = this.fixture.directStoreAccess().labelScanStore();
        Iterable nodeLabelUpdates = Iterables.asIterable((Object[])new NodeLabelUpdate[]{NodeLabelUpdate.labelChanges((long)nodeId1, (long[])new long[0], (long[])new long[]{labelId})});
        this.write(labelScanStore, nodeLabelUpdates);
        ConsistencySummaryStatistics stats = this.check();
        ConsistencySummaryVerifier.on(stats).verify(RecordType.LABEL_SCAN_DOCUMENT, 1).andThatsAllFolks();
    }

    private void write(LabelScanStore labelScanStore, Iterable<NodeLabelUpdate> nodeLabelUpdates) throws IOException {
        try (LabelScanWriter writer = labelScanStore.newWriter();){
            for (NodeLabelUpdate update : nodeLabelUpdates) {
                writer.write(update);
            }
        }
    }

    @Test
    public void shouldReportIndexInconsistencies() throws Exception {
        for (Long indexedNodeId : this.indexedNodes) {
            this.fixture.directStoreAccess().nativeStores().getNodeStore().updateRecord((AbstractBaseRecord)RecordCheckTestBase.notInUse(new NodeRecord(indexedNodeId.longValue(), false, -1L, -1L)));
        }
        ConsistencySummaryStatistics stats = this.check();
        ConsistencySummaryVerifier.on(stats).verify(RecordType.INDEX, 3).verify(RecordType.LABEL_SCAN_DOCUMENT, 2).verify(RecordType.COUNTS, 3).andThatsAllFolks();
    }

    @Test
    public void shouldNotReportIndexInconsistenciesIfIndexIsFailed() throws Exception {
        DirectStoreAccess storeAccess = this.fixture.directStoreAccess();
        Iterator rules = new SchemaStorage(storeAccess.nativeStores().getSchemaStore()).indexesGetAll();
        while (rules.hasNext()) {
            IndexRule rule = (IndexRule)rules.next();
            IndexSamplingConfig samplingConfig = new IndexSamplingConfig(Config.defaults());
            IndexPopulator populator = storeAccess.indexes().apply(rule.getProviderDescriptor()).getPopulator(rule.getId(), rule.getIndexDescriptor(), samplingConfig);
            populator.markAsFailed("Oh noes! I was a shiny index and then I was failed");
            populator.close(false);
        }
        for (Long indexedNodeId : this.indexedNodes) {
            storeAccess.nativeStores().getNodeStore().updateRecord((AbstractBaseRecord)RecordCheckTestBase.notInUse(new NodeRecord(indexedNodeId.longValue(), false, -1L, -1L)));
        }
        ConsistencySummaryStatistics stats = this.check();
        ConsistencySummaryVerifier.on(stats).verify(RecordType.LABEL_SCAN_DOCUMENT, 2).verify(RecordType.COUNTS, 3).andThatsAllFolks();
    }

    @Test
    public void shouldReportMismatchedLabels() throws Exception {
        final ArrayList labels = new ArrayList();
        final Pair<List<DynamicRecord>, List<Integer>> pair = this.chainOfDynamicRecordsWithLabelsForANode(3);
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                NodeRecord node = new NodeRecord(42L, false, -1L, -1L);
                node.setInUse(true);
                List dynamicRecords = (List)pair.first();
                labels.addAll((Collection)pair.other());
                node.setLabelField(DynamicNodeLabels.dynamicPointer((Collection)dynamicRecords), (Collection)dynamicRecords);
                tx.create(node);
            }
        });
        long[] before = this.asArray(labels);
        labels.remove(1);
        long[] after = this.asArray(labels);
        this.write(this.fixture.directStoreAccess().labelScanStore(), Arrays.asList(NodeLabelUpdate.labelChanges((long)42L, (long[])before, (long[])after)));
        ConsistencySummaryStatistics stats = this.check();
        ConsistencySummaryVerifier.on(stats).verify(RecordType.LABEL_SCAN_DOCUMENT, 1).andThatsAllFolks();
    }

    private long[] asArray(List<? extends Number> in) {
        long[] longs = new long[in.size()];
        for (int i = 0; i < in.size(); ++i) {
            longs[i] = in.get(i).longValue();
        }
        return longs;
    }

    private PrimitiveLongSet asPrimitiveLongSet(List<? extends Number> in) {
        return PrimitiveLongCollections.setOf((long[])this.asArray(in));
    }

    @Test
    public void shouldReportMismatchedInlinedLabels() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                NodeRecord node = new NodeRecord(42L, false, -1L, -1L);
                node.setInUse(true);
                node.setLabelField(FullCheckIntegrationTest.this.inlinedLabelsLongRepresentation(new long[]{FullCheckIntegrationTest.this.label1, FullCheckIntegrationTest.this.label2}), Collections.emptySet());
                tx.create(node);
            }
        });
        this.write(this.fixture.directStoreAccess().labelScanStore(), Arrays.asList(NodeLabelUpdate.labelChanges((long)42L, (long[])new long[]{this.label1, this.label2}, (long[])new long[]{this.label1})));
        ConsistencySummaryStatistics stats = this.check();
        ConsistencySummaryVerifier.on(stats).verify(RecordType.LABEL_SCAN_DOCUMENT, 1).andThatsAllFolks();
    }

    @Test
    public void shouldReportNodesThatAreNotIndexed() throws Exception {
        IndexSamplingConfig samplingConfig = new IndexSamplingConfig(Config.defaults());
        Iterator indexRuleIterator = new SchemaStorage(this.fixture.directStoreAccess().nativeStores().getSchemaStore()).indexesGetAll();
        NeoStoreIndexStoreView storeView = new NeoStoreIndexStoreView(LockService.NO_LOCK_SERVICE, this.fixture.directStoreAccess().nativeStores().getRawNeoStores());
        while (indexRuleIterator.hasNext()) {
            IndexRule indexRule = (IndexRule)indexRuleIterator.next();
            SchemaIndexDescriptor descriptor = indexRule.getIndexDescriptor();
            IndexAccessor accessor = this.fixture.directStoreAccess().indexes().apply(indexRule.getProviderDescriptor()).getOnlineAccessor(indexRule.getId(), descriptor, samplingConfig);
            try (IndexUpdater updater = accessor.newUpdater(IndexUpdateMode.ONLINE);){
                for (long nodeId : this.indexedNodes) {
                    NodeUpdates updates = storeView.nodeAsUpdates(nodeId);
                    for (IndexEntryUpdate update : updates.forIndexKeys(Arrays.asList(descriptor))) {
                        updater.process(IndexEntryUpdate.remove((long)nodeId, (SchemaDescriptorSupplier)descriptor, (Value[])update.values()));
                    }
                }
            }
            accessor.force(IOLimiter.unlimited());
            accessor.close();
        }
        ConsistencySummaryStatistics stats = this.check();
        ConsistencySummaryVerifier.on(stats).verify(RecordType.NODE, 3).andThatsAllFolks();
    }

    @Test
    public void shouldReportNodesWithDuplicatePropertyValueInUniqueIndex() throws Exception {
        IndexSamplingConfig samplingConfig = new IndexSamplingConfig(Config.defaults());
        Iterator indexRuleIterator = new SchemaStorage(this.fixture.directStoreAccess().nativeStores().getSchemaStore()).indexesGetAll();
        while (indexRuleIterator.hasNext()) {
            IndexRule indexRule = (IndexRule)indexRuleIterator.next();
            IndexAccessor accessor = this.fixture.directStoreAccess().indexes().apply(indexRule.getProviderDescriptor()).getOnlineAccessor(indexRule.getId(), indexRule.getIndexDescriptor(), samplingConfig);
            IndexUpdater updater = accessor.newUpdater(IndexUpdateMode.ONLINE);
            updater.process(IndexEntryUpdate.add((long)42L, (SchemaDescriptorSupplier)indexRule.getIndexDescriptor().schema(), (Value[])this.values(indexRule)));
            updater.close();
            accessor.force(IOLimiter.unlimited());
            accessor.close();
        }
        ConsistencySummaryStatistics stats = this.check();
        ConsistencySummaryVerifier.on(stats).verify(RecordType.NODE, 1).verify(RecordType.INDEX, 3).andThatsAllFolks();
    }

    private Value[] values(IndexRule indexRule) {
        switch (indexRule.schema().getPropertyIds().length) {
            case 1: {
                return (Value[])Iterators.array((Object[])new Value[]{Values.of((Object)VALUE1)});
            }
            case 2: {
                return (Value[])Iterators.array((Object[])new Value[]{Values.of((Object)VALUE1), Values.of((Object)VALUE2)});
            }
        }
        throw new UnsupportedOperationException();
    }

    @Test
    public void shouldReportMissingMandatoryNodeProperty() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                NodeRecord node = new NodeRecord(next.node(), false, -1L, next.property());
                node.setInUse(true);
                node.setLabelField(FullCheckIntegrationTest.this.inlinedLabelsLongRepresentation(new long[]{FullCheckIntegrationTest.this.draconian}), Collections.emptySet());
                PropertyRecord property = new PropertyRecord(node.getNextProp(), (PrimitiveRecord)node);
                property.setInUse(true);
                PropertyBlock block = new PropertyBlock();
                block.setSingleBlock((long)FullCheckIntegrationTest.this.key1 | (long)PropertyType.INT.intValue() << 24 | 0x5390000000L);
                property.addPropertyBlock(block);
                tx.create(node);
                tx.create(property);
            }
        });
        this.createNodePropertyExistenceConstraint(this.draconian, this.mandatory);
        ConsistencySummaryStatistics stats = this.check();
        ConsistencySummaryVerifier.on(stats).verify(RecordType.NODE, 1).andThatsAllFolks();
    }

    @Test
    public void shouldReportMissingMandatoryRelationshipProperty() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                long nodeId1 = next.node();
                long nodeId2 = next.node();
                long relId = next.relationship();
                long propId = next.property();
                NodeRecord node1 = new NodeRecord(nodeId1, true, false, relId, (long)Record.NO_NEXT_PROPERTY.intValue(), (long)Record.NO_LABELS_FIELD.intValue());
                NodeRecord node2 = new NodeRecord(nodeId2, true, false, relId, (long)Record.NO_NEXT_PROPERTY.intValue(), (long)Record.NO_LABELS_FIELD.intValue());
                RelationshipRecord relationship = new RelationshipRecord(relId, true, nodeId1, nodeId2, FullCheckIntegrationTest.this.M, (long)Record.NO_PREV_RELATIONSHIP.intValue(), (long)Record.NO_NEXT_RELATIONSHIP.intValue(), (long)Record.NO_PREV_RELATIONSHIP.intValue(), (long)Record.NO_NEXT_RELATIONSHIP.intValue(), true, true);
                relationship.setNextProp(propId);
                PropertyRecord property = new PropertyRecord(propId, (PrimitiveRecord)relationship);
                property.setInUse(true);
                PropertyBlock block = new PropertyBlock();
                block.setSingleBlock((long)FullCheckIntegrationTest.this.key1 | (long)PropertyType.INT.intValue() << 24 | 0x5390000000L);
                property.addPropertyBlock(block);
                tx.create(node1);
                tx.create(node2);
                tx.create(relationship);
                tx.create(property);
                tx.incrementRelationshipCount(-1, -1, -1, 1L);
                tx.incrementRelationshipCount(-1, FullCheckIntegrationTest.this.M, -1, 1L);
            }
        });
        this.createRelationshipPropertyExistenceConstraint(this.M, this.mandatory);
        ConsistencySummaryStatistics stats = this.check();
        ConsistencySummaryVerifier.on(stats).verify(RecordType.RELATIONSHIP, 1).andThatsAllFolks();
    }

    private long inlinedLabelsLongRepresentation(long ... labelIds) {
        long header = (long)labelIds.length << 36;
        byte bitsPerLabel = (byte)(36 / labelIds.length);
        Bits bits = Bits.bits((int)5);
        for (long labelId : labelIds) {
            bits.put(labelId, (int)bitsPerLabel);
        }
        return header | bits.getLongs()[0];
    }

    @Test
    public void shouldReportCyclesInDynamicRecordsWithLabels() throws Exception {
        final List chain = (List)this.chainOfDynamicRecordsWithLabelsForANode(176).first();
        Assert.assertEquals((String)"number of records in chain", (long)3L, (long)chain.size());
        Assert.assertEquals((String)"all records full", (long)((DynamicRecord)chain.get(0)).getLength(), (long)((DynamicRecord)chain.get(2)).getLength());
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                long nodeId = ((long[])DynamicArrayStore.getRightArray((Pair)AbstractDynamicStore.readFullByteArrayFromHeavyRecords((Iterable)chain, (PropertyType)PropertyType.ARRAY)).asObject())[0];
                NodeRecord before = RecordCheckTestBase.inUse(new NodeRecord(nodeId, false, -1L, -1L));
                NodeRecord after = RecordCheckTestBase.inUse(new NodeRecord(nodeId, false, -1L, -1L));
                DynamicRecord record1 = ((DynamicRecord)chain.get(0)).clone();
                DynamicRecord record2 = ((DynamicRecord)chain.get(1)).clone();
                DynamicRecord record3 = ((DynamicRecord)chain.get(2)).clone();
                record3.setNextBlock(record2.getId());
                before.setLabelField(DynamicNodeLabels.dynamicPointer((Collection)chain), (Collection)chain);
                after.setLabelField(DynamicNodeLabels.dynamicPointer((Collection)chain), Arrays.asList(record1, record2, record3));
                tx.update(before, after);
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        ConsistencySummaryVerifier.on(stats).verify(RecordType.NODE, 1).verify(RecordType.COUNTS, 177).andThatsAllFolks();
    }

    private Pair<List<DynamicRecord>, List<Integer>> chainOfDynamicRecordsWithLabelsForANode(int labelCount) throws TransactionFailureException {
        final long[] labels = new long[labelCount + 1];
        final ArrayList createdLabels = new ArrayList();
        try (GraphStoreFixture.Applier applier = this.fixture.createApplier();){
            int i = 1;
            while (i < labels.length) {
                final int offset = i++;
                applier.apply(new GraphStoreFixture.Transaction(){

                    @Override
                    protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                        Integer label = next.label();
                        labels[offset] = label.intValue();
                        tx.nodeLabel((int)labels[offset], "label:" + offset);
                        createdLabels.add(label);
                    }
                });
            }
        }
        final ArrayList chain = new ArrayList();
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                NodeRecord nodeRecord = new NodeRecord(next.node(), false, -1L, -1L);
                DynamicRecord record1 = RecordCheckTestBase.inUse(new DynamicRecord(next.nodeLabel()));
                DynamicRecord record2 = RecordCheckTestBase.inUse(new DynamicRecord(next.nodeLabel()));
                DynamicRecord record3 = RecordCheckTestBase.inUse(new DynamicRecord(next.nodeLabel()));
                labels[0] = nodeRecord.getId();
                ReusableRecordsAllocator allocator = new ReusableRecordsAllocator(60, new DynamicRecord[]{record1, record2, record3});
                DynamicArrayStore.allocateFromNumbers((Collection)chain, (Object)labels, (DynamicRecordAllocator)allocator);
                nodeRecord.setLabelField(DynamicNodeLabels.dynamicPointer((Collection)chain), (Collection)chain);
                tx.create(nodeRecord);
            }
        });
        return Pair.of(chain, createdLabels);
    }

    @Test
    public void shouldReportNodeDynamicLabelContainingDuplicateLabelAsNodeInconsistency() throws Exception {
        final int nodeId = 1000;
        final ArrayList duplicatedLabel = new ArrayList();
        final Pair<List<DynamicRecord>, List<Integer>> labels = this.chainOfDynamicRecordsWithLabelsForANode(1);
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                NodeRecord node = new NodeRecord((long)nodeId, false, -1L, -1L);
                node.setInUse(true);
                List labelRecords = (List)labels.first();
                node.setLabelField(DynamicNodeLabels.dynamicPointer((Collection)labelRecords), (Collection)labelRecords);
                tx.create(node);
                Integer labelId = (Integer)((List)labels.other()).get(0);
                DynamicRecord record = RecordCheckTestBase.inUse(new DynamicRecord((long)labelId.intValue()));
                DynamicArrayStore.allocateFromNumbers((Collection)duplicatedLabel, (Object)new long[]{nodeId, labelId.intValue(), labelId.intValue()}, (DynamicRecordAllocator)new ReusableRecordsAllocator(60, new DynamicRecord[]{record}));
            }
        });
        StoreAccess storeAccess = this.fixture.directStoreAccess().nativeStores();
        NodeRecord nodeRecord = new NodeRecord((long)nodeId);
        storeAccess.getNodeStore().getRecord((long)nodeId, (AbstractBaseRecord)nodeRecord, RecordLoad.FORCE);
        nodeRecord.setLabelField(DynamicNodeLabels.dynamicPointer(duplicatedLabel), duplicatedLabel);
        nodeRecord.setInUse(true);
        storeAccess.getNodeStore().updateRecord((AbstractBaseRecord)nodeRecord);
        ConsistencySummaryStatistics stats = this.check();
        ConsistencySummaryVerifier.on(stats).verify(RecordType.NODE, 1).verify(RecordType.COUNTS, 0).andThatsAllFolks();
    }

    @Test
    public void shouldReportOrphanedNodeDynamicLabelAsNodeInconsistency() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                tx.nodeLabel(42, "Label");
                NodeRecord nodeRecord = new NodeRecord(next.node(), false, -1L, -1L);
                DynamicRecord record = RecordCheckTestBase.inUse(new DynamicRecord(next.nodeLabel()));
                ArrayList newRecords = new ArrayList();
                DynamicArrayStore.allocateFromNumbers(newRecords, (Object)LabelIdArray.prependNodeId((long)next.node(), (long[])new long[]{42L}), (DynamicRecordAllocator)new ReusableRecordsAllocator(60, new DynamicRecord[]{record}));
                nodeRecord.setLabelField(DynamicNodeLabels.dynamicPointer(newRecords), newRecords);
                tx.create(nodeRecord);
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        ConsistencySummaryVerifier.on(stats).verify(RecordType.NODE_DYNAMIC_LABEL, 1).andThatsAllFolks();
    }

    @Test
    public void shouldReportRelationshipInconsistencies() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                tx.create(new RelationshipRecord(next.relationship(), 1L, 2L, FullCheckIntegrationTest.this.C));
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        ConsistencySummaryVerifier.on(stats).verify(RecordType.RELATIONSHIP, 2).verify(RecordType.COUNTS, 3).andThatsAllFolks();
    }

    @Test
    public void shouldReportRelationshipOtherNodeInconsistencies() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                long node1 = next.node();
                long node2 = next.node();
                long rel = next.relationship();
                tx.create(RecordCheckTestBase.inUse(new RelationshipRecord(rel, node1, node2, 0)));
                tx.create(RecordCheckTestBase.inUse(new NodeRecord(node1, false, rel + 1L, -1L)));
                tx.create(RecordCheckTestBase.inUse(new NodeRecord(node2, false, rel + 2L, -1L)));
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        ConsistencySummaryVerifier.on(stats).verify(RecordType.RELATIONSHIP, 2).verify(RecordType.NODE, 2).verify(RecordType.COUNTS, 2).andThatsAllFolks();
    }

    @Test
    public void shouldReportPropertyInconsistencies() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                NodeRecord node = new NodeRecord(next.node());
                PropertyRecord property = new PropertyRecord(next.property());
                node.setNextProp(property.getId());
                property.setNextProp(1000L);
                PropertyBlock block = new PropertyBlock();
                block.setSingleBlock((long)next.propertyKey() | (long)PropertyType.INT.intValue() << 24 | 0x29A0000000L);
                property.addPropertyBlock(block);
                tx.create(node);
                tx.create(property);
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        ConsistencySummaryVerifier.on(stats).verify(RecordType.PROPERTY, 2).verify(RecordType.NODE, 1).andThatsAllFolks();
    }

    @Test
    public void shouldReportStringPropertyInconsistencies() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                DynamicRecord string = new DynamicRecord(next.stringProperty());
                string.setInUse(true);
                string.setCreated();
                string.setType(PropertyType.STRING.intValue());
                string.setNextBlock(next.stringProperty());
                string.setData(UTF8.encode((String)"hello world"));
                PropertyBlock block = new PropertyBlock();
                block.setSingleBlock((long)PropertyType.STRING.intValue() << 24 | string.getId() << 28);
                block.addValueRecord(string);
                PropertyRecord property = new PropertyRecord(next.property());
                property.addPropertyBlock(block);
                tx.create(property);
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        ConsistencySummaryVerifier.on(stats).verify(RecordType.STRING_PROPERTY, 1).andThatsAllFolks();
    }

    @Test
    public void shouldReportBrokenSchemaRecordChain() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                DynamicRecord schema = new DynamicRecord(next.schema());
                DynamicRecord schemaBefore = schema.clone();
                schema.setNextBlock(next.schema());
                IndexRule rule = SchemaRuleUtil.indexRule(schema.getId(), FullCheckIntegrationTest.this.label1, FullCheckIntegrationTest.this.key1, DESCRIPTOR);
                schema.setData(rule.serialize());
                tx.createSchema(Arrays.asList(schemaBefore), Arrays.asList(schema), (SchemaRule)rule);
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        ConsistencySummaryVerifier.on(stats).verify(RecordType.SCHEMA, 3).andThatsAllFolks();
    }

    @Test
    public void shouldReportDuplicateConstraintReferences() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                int ruleId1 = (int)next.schema();
                int ruleId2 = (int)next.schema();
                int labelId = next.label();
                int propertyKeyId = next.propertyKey();
                DynamicRecord record1 = new DynamicRecord((long)ruleId1);
                DynamicRecord record2 = new DynamicRecord((long)ruleId2);
                DynamicRecord record1Before = record1.clone();
                DynamicRecord record2Before = record2.clone();
                IndexRule rule1 = SchemaRuleUtil.constraintIndexRule(ruleId1, labelId, propertyKeyId, DESCRIPTOR, ruleId1);
                IndexRule rule2 = SchemaRuleUtil.constraintIndexRule(ruleId2, labelId, propertyKeyId, DESCRIPTOR, ruleId1);
                Collection records1 = FullCheckIntegrationTest.serializeRule((SchemaRule)rule1, new DynamicRecord[]{record1});
                Collection records2 = FullCheckIntegrationTest.serializeRule((SchemaRule)rule2, new DynamicRecord[]{record2});
                Assert.assertEquals(Arrays.asList(record1), (Object)records1);
                Assert.assertEquals(Arrays.asList(record2), (Object)records2);
                tx.nodeLabel(labelId, "label");
                tx.propertyKey(propertyKeyId, "property");
                tx.createSchema(Arrays.asList(record1Before), records1, (SchemaRule)rule1);
                tx.createSchema(Arrays.asList(record2Before), records2, (SchemaRule)rule2);
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        ConsistencySummaryVerifier.on(stats).verify(RecordType.SCHEMA, 4).andThatsAllFolks();
    }

    @Test
    public void shouldReportInvalidConstraintBackReferences() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                int ruleId1 = (int)next.schema();
                int ruleId2 = (int)next.schema();
                int labelId = next.label();
                int propertyKeyId = next.propertyKey();
                DynamicRecord record1 = new DynamicRecord((long)ruleId1);
                DynamicRecord record2 = new DynamicRecord((long)ruleId2);
                DynamicRecord record1Before = record1.clone();
                DynamicRecord record2Before = record2.clone();
                IndexRule rule1 = SchemaRuleUtil.constraintIndexRule(ruleId1, labelId, propertyKeyId, DESCRIPTOR, ruleId2);
                ConstraintRule rule2 = SchemaRuleUtil.uniquenessConstraintRule(ruleId2, labelId, propertyKeyId, ruleId2);
                Collection records1 = FullCheckIntegrationTest.serializeRule((SchemaRule)rule1, new DynamicRecord[]{record1});
                Collection records2 = FullCheckIntegrationTest.serializeRule((SchemaRule)rule2, new DynamicRecord[]{record2});
                Assert.assertEquals(Arrays.asList(record1), (Object)records1);
                Assert.assertEquals(Arrays.asList(record2), (Object)records2);
                tx.nodeLabel(labelId, "label");
                tx.propertyKey(propertyKeyId, "property");
                tx.createSchema(Arrays.asList(record1Before), records1, (SchemaRule)rule1);
                tx.createSchema(Arrays.asList(record2Before), records2, (SchemaRule)rule2);
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        ConsistencySummaryVerifier.on(stats).verify(RecordType.SCHEMA, 2).andThatsAllFolks();
    }

    @Test
    public void shouldReportArrayPropertyInconsistencies() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                DynamicRecord array = new DynamicRecord(next.arrayProperty());
                array.setInUse(true);
                array.setCreated();
                array.setType(PropertyType.ARRAY.intValue());
                array.setNextBlock(next.arrayProperty());
                array.setData(UTF8.encode((String)"hello world"));
                PropertyBlock block = new PropertyBlock();
                block.setSingleBlock((long)PropertyType.ARRAY.intValue() << 24 | array.getId() << 28);
                block.addValueRecord(array);
                PropertyRecord property = new PropertyRecord(next.property());
                property.addPropertyBlock(block);
                tx.create(property);
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        ConsistencySummaryVerifier.on(stats).verify(RecordType.ARRAY_PROPERTY, 1).andThatsAllFolks();
    }

    @Test
    public void shouldReportRelationshipLabelNameInconsistencies() throws Exception {
        final Reference inconsistentName = new Reference();
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                inconsistentName.set(next.relationshipType());
                tx.relationshipType((Integer)inconsistentName.get(), "FOO");
            }
        });
        StoreAccess access = this.fixture.directStoreAccess().nativeStores();
        DynamicRecord record = (DynamicRecord)access.getRelationshipTypeNameStore().getRecord((long)((Integer)inconsistentName.get()).intValue(), access.getRelationshipTypeNameStore().newRecord(), RecordLoad.FORCE);
        record.setNextBlock(record.getId());
        access.getRelationshipTypeNameStore().updateRecord((AbstractBaseRecord)record);
        ConsistencySummaryStatistics stats = this.check();
        ConsistencySummaryVerifier.on(stats).verify(RecordType.RELATIONSHIP_TYPE_NAME, 1).andThatsAllFolks();
    }

    @Test
    public void shouldReportPropertyKeyNameInconsistencies() throws Exception {
        final Reference inconsistentName = new Reference();
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                inconsistentName.set(next.propertyKey());
                tx.propertyKey((Integer)inconsistentName.get(), "FOO");
            }
        });
        StoreAccess access = this.fixture.directStoreAccess().nativeStores();
        DynamicRecord record = (DynamicRecord)access.getPropertyKeyNameStore().getRecord((long)((Integer)inconsistentName.get() + 1), access.getPropertyKeyNameStore().newRecord(), RecordLoad.FORCE);
        record.setNextBlock(record.getId());
        access.getPropertyKeyNameStore().updateRecord((AbstractBaseRecord)record);
        ConsistencySummaryStatistics stats = this.check();
        ConsistencySummaryVerifier.on(stats).verify(RecordType.PROPERTY_KEY_NAME, 1).andThatsAllFolks();
    }

    @Test
    public void shouldReportRelationshipTypeInconsistencies() throws Exception {
        StoreAccess access = this.fixture.directStoreAccess().nativeStores();
        RecordStore relTypeStore = access.getRelationshipTypeTokenStore();
        RelationshipTypeTokenRecord record = (RelationshipTypeTokenRecord)relTypeStore.getRecord((long)((int)relTypeStore.nextId()), relTypeStore.newRecord(), RecordLoad.FORCE);
        record.setNameId(20);
        record.setInUse(true);
        relTypeStore.updateRecord((AbstractBaseRecord)record);
        ConsistencySummaryStatistics stats = this.check();
        access.close();
        ConsistencySummaryVerifier.on(stats).verify(RecordType.RELATIONSHIP_TYPE, 1).andThatsAllFolks();
    }

    @Test
    public void shouldReportLabelInconsistencies() throws Exception {
        StoreAccess access = this.fixture.directStoreAccess().nativeStores();
        LabelTokenRecord record = (LabelTokenRecord)access.getLabelTokenStore().getRecord(1L, access.getLabelTokenStore().newRecord(), RecordLoad.FORCE);
        record.setNameId(20);
        record.setInUse(true);
        access.getLabelTokenStore().updateRecord((AbstractBaseRecord)record);
        ConsistencySummaryStatistics stats = this.check();
        ConsistencySummaryVerifier.on(stats).verify(RecordType.LABEL, 1).andThatsAllFolks();
    }

    @Test
    public void shouldReportPropertyKeyInconsistencies() throws Exception {
        final Reference inconsistentKey = new Reference();
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                inconsistentKey.set(next.propertyKey());
                tx.propertyKey((Integer)inconsistentKey.get(), "FOO");
            }
        });
        StoreAccess access = this.fixture.directStoreAccess().nativeStores();
        DynamicRecord record = (DynamicRecord)access.getPropertyKeyNameStore().getRecord((long)((Integer)inconsistentKey.get() + 1), access.getPropertyKeyNameStore().newRecord(), RecordLoad.FORCE);
        record.setInUse(false);
        access.getPropertyKeyNameStore().updateRecord((AbstractBaseRecord)record);
        ConsistencySummaryStatistics stats = this.check();
        ConsistencySummaryVerifier.on(stats).verify(RecordType.PROPERTY_KEY, 1).andThatsAllFolks();
    }

    @Test
    public void shouldReportRelationshipGroupTypeInconsistencies() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                long node = next.node();
                long group = next.relationshipGroup();
                int nonExistentType = next.relationshipType() + 1;
                tx.create(RecordCheckTestBase.inUse(new NodeRecord(node, true, group, (long)Record.NO_NEXT_PROPERTY.intValue())));
                tx.create(FullCheckIntegrationTest.withOwner(RecordCheckTestBase.inUse(new RelationshipGroupRecord(group, nonExistentType)), node));
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        ConsistencySummaryVerifier.on(stats).verify(RecordType.RELATIONSHIP_GROUP, 1).andThatsAllFolks();
    }

    @Test
    public void shouldReportRelationshipGroupChainInconsistencies() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                long node = next.node();
                long group = next.relationshipGroup();
                tx.create(RecordCheckTestBase.inUse(new NodeRecord(node, true, group, (long)Record.NO_NEXT_PROPERTY.intValue())));
                tx.create(FullCheckIntegrationTest.withOwner(FullCheckIntegrationTest.withNext(RecordCheckTestBase.inUse(new RelationshipGroupRecord(group, FullCheckIntegrationTest.this.C)), group + 1L), node));
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        ConsistencySummaryVerifier.on(stats).verify(RecordType.RELATIONSHIP_GROUP, 1).andThatsAllFolks();
    }

    @Test
    public void shouldReportRelationshipGroupUnsortedChainInconsistencies() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                long node = next.node();
                long firstGroupId = next.relationshipGroup();
                long otherGroupId = next.relationshipGroup();
                tx.create(RecordCheckTestBase.inUse(new NodeRecord(node, true, firstGroupId, (long)Record.NO_NEXT_PROPERTY.intValue())));
                tx.create(FullCheckIntegrationTest.withOwner(FullCheckIntegrationTest.withNext(RecordCheckTestBase.inUse(new RelationshipGroupRecord(firstGroupId, FullCheckIntegrationTest.this.T)), otherGroupId), node));
                tx.create(FullCheckIntegrationTest.withOwner(RecordCheckTestBase.inUse(new RelationshipGroupRecord(otherGroupId, FullCheckIntegrationTest.this.C)), node));
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        ConsistencySummaryVerifier.on(stats).verify(RecordType.RELATIONSHIP_GROUP, 1).andThatsAllFolks();
    }

    @Test
    public void shouldReportRelationshipGroupRelationshipNotInUseInconsistencies() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                long node = next.node();
                long groupId = next.relationshipGroup();
                long rel = next.relationship();
                tx.create(RecordCheckTestBase.inUse(new NodeRecord(node, true, groupId, (long)Record.NO_NEXT_PROPERTY.intValue())));
                tx.create(FullCheckIntegrationTest.withOwner(FullCheckIntegrationTest.withRelationships(RecordCheckTestBase.inUse(new RelationshipGroupRecord(groupId, FullCheckIntegrationTest.this.C)), rel, rel, rel), node));
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        ConsistencySummaryVerifier.on(stats).verify(RecordType.RELATIONSHIP_GROUP, 3).andThatsAllFolks();
    }

    @Test
    public void shouldReportRelationshipGroupRelationshipNotFirstInconsistencies() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                long node = next.node();
                long otherNode = next.node();
                long group = next.relationshipGroup();
                long relA = next.relationship();
                long relB = next.relationship();
                tx.create(RecordCheckTestBase.inUse(new NodeRecord(node, true, group, (long)Record.NO_NEXT_PROPERTY.intValue())));
                tx.create(RecordCheckTestBase.inUse(new NodeRecord(otherNode, false, relA, (long)Record.NO_NEXT_PROPERTY.intValue())));
                tx.create(FullCheckIntegrationTest.this.withNext(RecordCheckTestBase.inUse(new RelationshipRecord(relA, otherNode, otherNode, FullCheckIntegrationTest.this.C)), relB));
                tx.create(FullCheckIntegrationTest.this.withPrev(RecordCheckTestBase.inUse(new RelationshipRecord(relB, otherNode, otherNode, FullCheckIntegrationTest.this.C)), relA));
                tx.create(FullCheckIntegrationTest.withOwner(FullCheckIntegrationTest.withRelationships(RecordCheckTestBase.inUse(new RelationshipGroupRecord(group, FullCheckIntegrationTest.this.C)), relB, relB, relB), node));
                tx.incrementRelationshipCount(-1, -1, -1, 2L);
                tx.incrementRelationshipCount(-1, FullCheckIntegrationTest.this.C, -1, 2L);
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        ConsistencySummaryVerifier.on(stats).verify(RecordType.RELATIONSHIP_GROUP, 3).andThatsAllFolks();
    }

    @Test
    public void shouldReportFirstRelationshipGroupOwnerInconsistency() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                long node = next.node();
                long otherNode = next.node();
                long group = next.relationshipGroup();
                tx.create(RecordCheckTestBase.inUse(new NodeRecord(node, true, group, (long)Record.NO_NEXT_PROPERTY.intValue())));
                tx.create(RecordCheckTestBase.inUse(new NodeRecord(otherNode, false, (long)Record.NO_NEXT_RELATIONSHIP.intValue(), (long)Record.NO_NEXT_PROPERTY.intValue())));
                tx.create(FullCheckIntegrationTest.withOwner(RecordCheckTestBase.inUse(new RelationshipGroupRecord(group, FullCheckIntegrationTest.this.C)), otherNode));
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        ConsistencySummaryVerifier.on(stats).verify(RecordType.NODE, 1).andThatsAllFolks();
    }

    @Test
    public void shouldReportChainedRelationshipGroupOwnerInconsistency() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                long node = next.node();
                long otherNode = next.node();
                long groupA = next.relationshipGroup();
                long groupB = next.relationshipGroup();
                tx.create(RecordCheckTestBase.inUse(new NodeRecord(node, true, groupA, (long)Record.NO_NEXT_PROPERTY.intValue())));
                tx.create(RecordCheckTestBase.inUse(new NodeRecord(otherNode, false, (long)Record.NO_NEXT_RELATIONSHIP.intValue(), (long)Record.NO_NEXT_PROPERTY.intValue())));
                tx.create(FullCheckIntegrationTest.withNext(FullCheckIntegrationTest.withOwner(RecordCheckTestBase.inUse(new RelationshipGroupRecord(groupA, FullCheckIntegrationTest.this.C)), node), groupB));
                tx.create(FullCheckIntegrationTest.withOwner(RecordCheckTestBase.inUse(new RelationshipGroupRecord(groupB, FullCheckIntegrationTest.this.T)), otherNode));
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        ConsistencySummaryVerifier.on(stats).verify(RecordType.RELATIONSHIP_GROUP, 1).andThatsAllFolks();
    }

    @Test
    public void shouldReportRelationshipGroupOwnerNotInUse() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                long node = next.node();
                long group = next.relationshipGroup();
                tx.create(FullCheckIntegrationTest.withOwner(RecordCheckTestBase.inUse(new RelationshipGroupRecord(group, FullCheckIntegrationTest.this.C)), node));
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        ConsistencySummaryVerifier.on(stats).verify(RecordType.RELATIONSHIP_GROUP, 1).andThatsAllFolks();
    }

    @Test
    public void shouldReportRelationshipGroupOwnerInvalidValue() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                long group = next.relationshipGroup();
                tx.create(FullCheckIntegrationTest.withOwner(RecordCheckTestBase.inUse(new RelationshipGroupRecord(group, FullCheckIntegrationTest.this.C)), -1L));
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        ConsistencySummaryVerifier.on(stats).verify(RecordType.RELATIONSHIP_GROUP, 1).andThatsAllFolks();
    }

    private RelationshipRecord withNext(RelationshipRecord relationship, long next) {
        relationship.setFirstNextRel(next);
        relationship.setSecondNextRel(next);
        return relationship;
    }

    private RelationshipRecord withPrev(RelationshipRecord relationship, long prev) {
        relationship.setFirstInFirstChain(false);
        relationship.setFirstInSecondChain(false);
        relationship.setFirstPrevRel(prev);
        relationship.setSecondPrevRel(prev);
        return relationship;
    }

    @Test
    public void shouldReportRelationshipGroupRelationshipOfOtherTypeInconsistencies() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                long node = next.node();
                long otherNode = next.node();
                long group = next.relationshipGroup();
                long rel = next.relationship();
                tx.create(new NodeRecord(node, true, group, (long)Record.NO_NEXT_PROPERTY.intValue()));
                tx.create(new NodeRecord(otherNode, false, rel, (long)Record.NO_NEXT_PROPERTY.intValue()));
                tx.create(new RelationshipRecord(rel, otherNode, otherNode, FullCheckIntegrationTest.this.T));
                tx.create(FullCheckIntegrationTest.withOwner(FullCheckIntegrationTest.withRelationships(new RelationshipGroupRecord(group, FullCheckIntegrationTest.this.C), rel, rel, rel), node));
                tx.incrementRelationshipCount(-1, -1, -1, 1L);
                tx.incrementRelationshipCount(-1, FullCheckIntegrationTest.this.T, -1, 1L);
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        ConsistencySummaryVerifier.on(stats).verify(RecordType.RELATIONSHIP_GROUP, 3).andThatsAllFolks();
    }

    @Test
    public void shouldNotReportRelationshipGroupInconsistenciesForConsistentRecords() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                long nodeA = next.node();
                long nodeB = next.node();
                long rel = next.relationship();
                long groupA = next.relationshipGroup();
                long groupB = next.relationshipGroup();
                tx.create(new NodeRecord(nodeA, true, groupA, (long)Record.NO_NEXT_PROPERTY.intValue()));
                tx.create(new NodeRecord(nodeB, false, rel, (long)Record.NO_NEXT_PROPERTY.intValue()));
                tx.create(FullCheckIntegrationTest.firstInChains(new RelationshipRecord(rel, nodeA, nodeB, FullCheckIntegrationTest.this.C), 1));
                tx.incrementRelationshipCount(-1, -1, -1, 1L);
                tx.incrementRelationshipCount(-1, FullCheckIntegrationTest.this.C, -1, 1L);
                tx.create(FullCheckIntegrationTest.withOwner(FullCheckIntegrationTest.withRelationship(FullCheckIntegrationTest.withNext(new RelationshipGroupRecord(groupA, FullCheckIntegrationTest.this.C), groupB), Direction.OUTGOING, rel), nodeA));
                tx.create(FullCheckIntegrationTest.withOwner(new RelationshipGroupRecord(groupB, FullCheckIntegrationTest.this.T), nodeA));
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        Assert.assertTrue((String)"should be consistent", (boolean)stats.isConsistent());
    }

    @Test
    public void shouldReportWrongNodeCountsEntries() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                tx.incrementNodeCount(FullCheckIntegrationTest.this.label3, 1L);
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        ConsistencySummaryVerifier.on(stats).verify(RecordType.COUNTS, 1).andThatsAllFolks();
    }

    @Test
    public void shouldReportWrongRelationshipCountsEntries() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                tx.incrementRelationshipCount(FullCheckIntegrationTest.this.label1, FullCheckIntegrationTest.this.C, -1, 1L);
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        ConsistencySummaryVerifier.on(stats).verify(RecordType.COUNTS, 1).andThatsAllFolks();
    }

    @Test
    public void shouldReportIfSomeKeysAreMissing() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                tx.incrementNodeCount(FullCheckIntegrationTest.this.label3, -1L);
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        ConsistencySummaryVerifier.on(stats).verify(RecordType.COUNTS, 1).andThatsAllFolks();
    }

    @Test
    public void shouldReportIfThereAreExtraKeys() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                tx.incrementNodeCount(1024, 1L);
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        ConsistencySummaryVerifier.on(stats).verify(RecordType.COUNTS, 2).andThatsAllFolks();
    }

    @Test
    public void shouldReportDuplicatedIndexRules() throws Exception {
        int labelId = this.createLabel();
        int propertyKeyId = this.createPropertyKey();
        this.createIndexRule(labelId, propertyKeyId);
        this.createIndexRule(labelId, propertyKeyId);
        ConsistencySummaryStatistics stats = this.check();
        ConsistencySummaryVerifier.on(stats).verify(RecordType.SCHEMA, 1).andThatsAllFolks();
    }

    @Test
    public void shouldReportDuplicatedCompositeIndexRules() throws Exception {
        int labelId = this.createLabel();
        int propertyKeyId1 = this.createPropertyKey("p1");
        int propertyKeyId2 = this.createPropertyKey("p2");
        int propertyKeyId3 = this.createPropertyKey("p3");
        this.createIndexRule(labelId, propertyKeyId1, propertyKeyId2, propertyKeyId3);
        this.createIndexRule(labelId, propertyKeyId1, propertyKeyId2, propertyKeyId3);
        ConsistencySummaryStatistics stats = this.check();
        ConsistencySummaryVerifier.on(stats).verify(RecordType.SCHEMA, 1).andThatsAllFolks();
    }

    @Test
    public void shouldReportDuplicatedUniquenessConstraintRules() throws Exception {
        int labelId = this.createLabel();
        int propertyKeyId = this.createPropertyKey();
        this.createUniquenessConstraintRule(labelId, propertyKeyId);
        this.createUniquenessConstraintRule(labelId, propertyKeyId);
        ConsistencySummaryStatistics stats = this.check();
        ConsistencySummaryVerifier.on(stats).verify(RecordType.SCHEMA, 2).andThatsAllFolks();
    }

    @Test
    public void shouldReportDuplicatedCompositeUniquenessConstraintRules() throws Exception {
        int labelId = this.createLabel();
        int propertyKeyId1 = this.createPropertyKey("p1");
        int propertyKeyId2 = this.createPropertyKey("p2");
        this.createUniquenessConstraintRule(labelId, propertyKeyId1, propertyKeyId2);
        this.createUniquenessConstraintRule(labelId, propertyKeyId1, propertyKeyId2);
        ConsistencySummaryStatistics stats = this.check();
        ConsistencySummaryVerifier.on(stats).verify(RecordType.SCHEMA, 2).andThatsAllFolks();
    }

    @Test
    public void shouldReportDuplicatedNodeKeyConstraintRules() throws Exception {
        int labelId = this.createLabel();
        int propertyKeyId1 = this.createPropertyKey("p1");
        int propertyKeyId2 = this.createPropertyKey("p2");
        this.createNodeKeyConstraintRule(labelId, propertyKeyId1, propertyKeyId2);
        this.createNodeKeyConstraintRule(labelId, propertyKeyId1, propertyKeyId2);
        ConsistencySummaryStatistics stats = this.check();
        ConsistencySummaryVerifier.on(stats).verify(RecordType.SCHEMA, 2).andThatsAllFolks();
    }

    @Test
    public void shouldReportDuplicatedNodePropertyExistenceConstraintRules() throws Exception {
        int labelId = this.createLabel();
        int propertyKeyId = this.createPropertyKey();
        this.createNodePropertyExistenceConstraint(labelId, propertyKeyId);
        this.createNodePropertyExistenceConstraint(labelId, propertyKeyId);
        ConsistencySummaryStatistics stats = this.check();
        ConsistencySummaryVerifier.on(stats).verify(RecordType.SCHEMA, 1).andThatsAllFolks();
    }

    @Test
    public void shouldReportDuplicatedRelationshipPropertyExistenceConstraintRules() throws Exception {
        int relTypeId = this.createRelType();
        int propertyKeyId = this.createPropertyKey();
        this.createRelationshipPropertyExistenceConstraint(relTypeId, propertyKeyId);
        this.createRelationshipPropertyExistenceConstraint(relTypeId, propertyKeyId);
        ConsistencySummaryStatistics stats = this.check();
        ConsistencySummaryVerifier.on(stats).verify(RecordType.SCHEMA, 1).andThatsAllFolks();
    }

    @Test
    public void shouldReportInvalidLabelIdInIndexRule() throws Exception {
        int labelId = this.fixture.idGenerator().label();
        int propertyKeyId = this.createPropertyKey();
        this.createIndexRule(labelId, propertyKeyId);
        ConsistencySummaryStatistics stats = this.check();
        ConsistencySummaryVerifier.on(stats).verify(RecordType.SCHEMA, 1).andThatsAllFolks();
    }

    @Test
    public void shouldReportInvalidLabelIdInUniquenessConstraintRule() throws Exception {
        int badLabelId = this.fixture.idGenerator().label();
        int propertyKeyId = this.createPropertyKey();
        this.createUniquenessConstraintRule(badLabelId, propertyKeyId);
        ConsistencySummaryStatistics stats = this.check();
        ConsistencySummaryVerifier.on(stats).verify(RecordType.SCHEMA, 2).andThatsAllFolks();
    }

    @Test
    public void shouldReportInvalidLabelIdInNodeKeyConstraintRule() throws Exception {
        int badLabelId = this.fixture.idGenerator().label();
        int propertyKeyId = this.createPropertyKey();
        this.createNodeKeyConstraintRule(badLabelId, propertyKeyId);
        ConsistencySummaryStatistics stats = this.check();
        ConsistencySummaryVerifier.on(stats).verify(RecordType.SCHEMA, 2).andThatsAllFolks();
    }

    @Test
    public void shouldReportInvalidLabelIdInNodePropertyExistenceConstraintRule() throws Exception {
        int badLabelId = this.fixture.idGenerator().label();
        int propertyKeyId = this.createPropertyKey();
        this.createNodePropertyExistenceConstraint(badLabelId, propertyKeyId);
        ConsistencySummaryStatistics stats = this.check();
        ConsistencySummaryVerifier.on(stats).verify(RecordType.SCHEMA, 1).andThatsAllFolks();
    }

    @Test
    public void shouldReportInvalidPropertyKeyIdInIndexRule() throws Exception {
        int labelId = this.createLabel();
        int badPropertyKeyId = this.fixture.idGenerator().propertyKey();
        this.createIndexRule(labelId, badPropertyKeyId);
        ConsistencySummaryStatistics stats = this.check();
        ConsistencySummaryVerifier.on(stats).verify(RecordType.SCHEMA, 1).andThatsAllFolks();
    }

    @Test
    public void shouldReportInvalidSecondPropertyKeyIdInIndexRule() throws Exception {
        int labelId = this.createLabel();
        int propertyKeyId = this.createPropertyKey();
        int badPropertyKeyId = this.fixture.idGenerator().propertyKey();
        this.createIndexRule(labelId, propertyKeyId, badPropertyKeyId);
        ConsistencySummaryStatistics stats = this.check();
        ConsistencySummaryVerifier.on(stats).verify(RecordType.SCHEMA, 1).andThatsAllFolks();
    }

    @Test
    public void shouldReportInvalidPropertyKeyIdInUniquenessConstraintRule() throws Exception {
        int labelId = this.createLabel();
        int badPropertyKeyId = this.fixture.idGenerator().propertyKey();
        this.createUniquenessConstraintRule(labelId, badPropertyKeyId);
        ConsistencySummaryStatistics stats = this.check();
        ConsistencySummaryVerifier.on(stats).verify(RecordType.SCHEMA, 2).andThatsAllFolks();
    }

    @Test
    public void shouldReportInvalidSecondPropertyKeyIdInUniquenessConstraintRule() throws Exception {
        int labelId = this.createLabel();
        int propertyKeyId = this.createPropertyKey();
        int badPropertyKeyId = this.fixture.idGenerator().propertyKey();
        this.createUniquenessConstraintRule(labelId, propertyKeyId, badPropertyKeyId);
        ConsistencySummaryStatistics stats = this.check();
        ConsistencySummaryVerifier.on(stats).verify(RecordType.SCHEMA, 2).andThatsAllFolks();
    }

    @Test
    public void shouldReportInvalidSecondPropertyKeyIdInNodeKeyConstraintRule() throws Exception {
        int labelId = this.createLabel();
        int propertyKeyId = this.createPropertyKey();
        int badPropertyKeyId = this.fixture.idGenerator().propertyKey();
        this.createNodeKeyConstraintRule(labelId, propertyKeyId, badPropertyKeyId);
        ConsistencySummaryStatistics stats = this.check();
        ConsistencySummaryVerifier.on(stats).verify(RecordType.SCHEMA, 2).andThatsAllFolks();
    }

    @Test
    public void shouldReportInvalidPropertyKeyIdInNodePropertyExistenceConstraintRule() throws Exception {
        int labelId = this.createLabel();
        int badPropertyKeyId = this.fixture.idGenerator().propertyKey();
        this.createNodePropertyExistenceConstraint(labelId, badPropertyKeyId);
        ConsistencySummaryStatistics stats = this.check();
        ConsistencySummaryVerifier.on(stats).verify(RecordType.SCHEMA, 1).andThatsAllFolks();
    }

    @Test
    public void shouldReportInvalidRelTypeIdInRelationshipPropertyExistenceConstraintRule() throws Exception {
        int badRelTypeId = this.fixture.idGenerator().relationshipType();
        int propertyKeyId = this.createPropertyKey();
        this.createRelationshipPropertyExistenceConstraint(badRelTypeId, propertyKeyId);
        ConsistencySummaryStatistics stats = this.check();
        ConsistencySummaryVerifier.on(stats).verify(RecordType.SCHEMA, 1).andThatsAllFolks();
    }

    @Test
    public void shouldReportNothingForUniquenessAndPropertyExistenceConstraintOnSameLabelAndProperty() throws Exception {
        int labelId = this.createLabel();
        int propertyKeyId = this.createPropertyKey();
        this.createUniquenessConstraintRule(labelId, propertyKeyId);
        this.createNodePropertyExistenceConstraint(labelId, propertyKeyId);
        ConsistencySummaryStatistics stats = this.check();
        Assert.assertTrue((boolean)stats.isConsistent());
    }

    @Test
    public void shouldReportNothingForNodeKeyAndPropertyExistenceConstraintOnSameLabelAndProperty() throws Exception {
        int labelId = this.createLabel();
        int propertyKeyId = this.createPropertyKey();
        this.createNodeKeyConstraintRule(labelId, propertyKeyId);
        this.createNodePropertyExistenceConstraint(labelId, propertyKeyId);
        ConsistencySummaryStatistics stats = this.check();
        Assert.assertTrue((boolean)stats.isConsistent());
    }

    @Test
    public void shouldManageUnusedRecordsWithWeirdDataIn() throws Exception {
        final AtomicLong id = new AtomicLong();
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                id.set(next.relationship());
                RelationshipRecord relationship = new RelationshipRecord(id.get());
                relationship.setFirstNode(-1L);
                relationship.setSecondNode(-1L);
                relationship.setInUse(true);
                tx.create(relationship);
            }
        });
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                RelationshipRecord relationship = new RelationshipRecord(id.get());
                tx.delete(relationship);
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        Assert.assertTrue((boolean)stats.isConsistent());
    }

    private ConsistencySummaryStatistics check() throws ConsistencyCheckIncompleteException {
        return this.check(this.fixture.directStoreAccess());
    }

    private ConsistencySummaryStatistics check(DirectStoreAccess stores) throws ConsistencyCheckIncompleteException {
        Config config = this.config();
        FullCheck checker = new FullCheck(config, ProgressMonitorFactory.NONE, this.fixture.getAccessStatistics(), ConsistencyCheckService.defaultConsistencyCheckThreadsNumber());
        return checker.execute(stores, (Log)FormattedLog.toOutputStream((OutputStream)System.out), (report, method, message) -> {
            Set<String> types = allReports.get(report);
            assert (types != null);
            types.remove(method);
        });
    }

    private Config config() {
        Map params = MapUtil.stringMap((String[])new String[]{ConsistencyCheckSettings.consistency_check_property_owners.name(), "true", GraphDatabaseSettings.record_format.name(), this.getRecordFormatName()});
        return Config.defaults((Map)params);
    }

    protected static RelationshipGroupRecord withRelationships(RelationshipGroupRecord group, long out, long in, long loop) {
        group.setFirstOut(out);
        group.setFirstIn(in);
        group.setFirstLoop(loop);
        return group;
    }

    protected static RelationshipGroupRecord withRelationship(RelationshipGroupRecord group, Direction direction, long rel) {
        switch (direction) {
            case OUTGOING: {
                group.setFirstOut(rel);
                break;
            }
            case INCOMING: {
                group.setFirstIn(rel);
                break;
            }
            case BOTH: {
                group.setFirstLoop(rel);
                break;
            }
            default: {
                throw new IllegalArgumentException(direction.name());
            }
        }
        return group;
    }

    protected static RelationshipRecord firstInChains(RelationshipRecord relationship, int count) {
        relationship.setFirstInFirstChain(true);
        relationship.setFirstPrevRel((long)count);
        relationship.setFirstInSecondChain(true);
        relationship.setSecondPrevRel((long)count);
        return relationship;
    }

    protected static RelationshipGroupRecord withNext(RelationshipGroupRecord group, long next) {
        group.setNext(next);
        return group;
    }

    protected static RelationshipGroupRecord withOwner(RelationshipGroupRecord record, long owner) {
        record.setOwningNode(owner);
        return record;
    }

    protected String getRecordFormatName() {
        return "";
    }

    private int createLabel() throws Exception {
        final MutableInt id = new MutableInt(-1);
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                int labelId = next.label();
                tx.nodeLabel(labelId, "label");
                id.setValue(labelId);
            }
        });
        return id.intValue();
    }

    private int createPropertyKey() throws Exception {
        return this.createPropertyKey("property");
    }

    private int createPropertyKey(final String propertyKey) throws Exception {
        final MutableInt id = new MutableInt(-1);
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                int propertyKeyId = next.propertyKey();
                tx.propertyKey(propertyKeyId, propertyKey);
                id.setValue(propertyKeyId);
            }
        });
        return id.intValue();
    }

    private int createRelType() throws Exception {
        final MutableInt id = new MutableInt(-1);
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                int relTypeId = next.relationshipType();
                tx.relationshipType(relTypeId, "relType");
                id.setValue(relTypeId);
            }
        });
        return id.intValue();
    }

    private void createIndexRule(final int labelId, final int ... propertyKeyIds) throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                int id = (int)next.schema();
                DynamicRecord recordBefore = new DynamicRecord((long)id);
                DynamicRecord recordAfter = recordBefore.clone();
                IndexRule rule = IndexRule.indexRule((long)id, (SchemaIndexDescriptor)SchemaIndexDescriptorFactory.forLabel((int)labelId, (int[])propertyKeyIds), (IndexProvider.Descriptor)DESCRIPTOR);
                Collection records = FullCheckIntegrationTest.serializeRule((SchemaRule)rule, new DynamicRecord[]{recordAfter});
                tx.createSchema(Collections.singleton(recordBefore), records, (SchemaRule)rule);
            }
        });
    }

    private void createUniquenessConstraintRule(int labelId, int ... propertyKeyIds) {
        SchemaStore schemaStore = (SchemaStore)this.fixture.directStoreAccess().nativeStores().getSchemaStore();
        long ruleId1 = schemaStore.nextId();
        long ruleId2 = schemaStore.nextId();
        IndexRule indexRule = IndexRule.constraintIndexRule((long)ruleId1, (SchemaIndexDescriptor)SchemaIndexDescriptorFactory.uniqueForLabel((int)labelId, (int[])propertyKeyIds), (IndexProvider.Descriptor)DESCRIPTOR, (Long)ruleId2);
        ConstraintRule uniqueRule = ConstraintRule.constraintRule((long)ruleId2, (IndexBackedConstraintDescriptor)ConstraintDescriptorFactory.uniqueForLabel((int)labelId, (int[])propertyKeyIds), (long)ruleId1);
        this.writeToSchemaStore(schemaStore, (SchemaRule)indexRule);
        this.writeToSchemaStore(schemaStore, (SchemaRule)uniqueRule);
    }

    private void createNodeKeyConstraintRule(int labelId, int ... propertyKeyIds) {
        SchemaStore schemaStore = (SchemaStore)this.fixture.directStoreAccess().nativeStores().getSchemaStore();
        long ruleId1 = schemaStore.nextId();
        long ruleId2 = schemaStore.nextId();
        IndexRule indexRule = IndexRule.constraintIndexRule((long)ruleId1, (SchemaIndexDescriptor)SchemaIndexDescriptorFactory.uniqueForLabel((int)labelId, (int[])propertyKeyIds), (IndexProvider.Descriptor)DESCRIPTOR, (Long)ruleId2);
        ConstraintRule nodeKeyRule = ConstraintRule.constraintRule((long)ruleId2, (IndexBackedConstraintDescriptor)ConstraintDescriptorFactory.nodeKeyForLabel((int)labelId, (int[])propertyKeyIds), (long)ruleId1);
        this.writeToSchemaStore(schemaStore, (SchemaRule)indexRule);
        this.writeToSchemaStore(schemaStore, (SchemaRule)nodeKeyRule);
    }

    private void createNodePropertyExistenceConstraint(int labelId, int propertyKeyId) {
        SchemaStore schemaStore = (SchemaStore)this.fixture.directStoreAccess().nativeStores().getSchemaStore();
        ConstraintRule rule = SchemaRuleUtil.nodePropertyExistenceConstraintRule(schemaStore.nextId(), labelId, propertyKeyId);
        this.writeToSchemaStore(schemaStore, (SchemaRule)rule);
    }

    private void createRelationshipPropertyExistenceConstraint(int relTypeId, int propertyKeyId) {
        SchemaStore schemaStore = (SchemaStore)this.fixture.directStoreAccess().nativeStores().getSchemaStore();
        ConstraintRule rule = SchemaRuleUtil.relPropertyExistenceConstraintRule(schemaStore.nextId(), relTypeId, propertyKeyId);
        this.writeToSchemaStore(schemaStore, (SchemaRule)rule);
    }

    private void writeToSchemaStore(SchemaStore schemaStore, SchemaRule rule) {
        List records = schemaStore.allocateFrom(rule);
        for (DynamicRecord record : records) {
            schemaStore.updateRecord((AbstractBaseRecord)record);
        }
    }

    private static KernelTransaction transactionOn(GraphDatabaseService db) {
        DependencyResolver resolver = ((GraphDatabaseAPI)db).getDependencyResolver();
        ThreadToStatementContextBridge bridge = (ThreadToStatementContextBridge)resolver.resolveDependency(ThreadToStatementContextBridge.class);
        return bridge.getKernelTransactionBoundToThisThread(true);
    }

    private static Collection<DynamicRecord> serializeRule(SchemaRule rule, DynamicRecord ... records) {
        byte[] data = rule.serialize();
        ReusableRecordsCompositeAllocator dynamicRecordAllocator = new ReusableRecordsCompositeAllocator(Arrays.asList(records), schemaAllocator);
        ArrayList<DynamicRecord> result = new ArrayList<DynamicRecord>();
        AbstractDynamicStore.allocateRecordsFromBytes(result, (byte[])data, (DynamicRecordAllocator)dynamicRecordAllocator);
        return result;
    }

    public static final class ConsistencySummaryVerifier {
        private final ConsistencySummaryStatistics stats;
        private final Set<RecordType> types = new HashSet<RecordType>();
        private long total;

        public static ConsistencySummaryVerifier on(ConsistencySummaryStatistics stats) {
            return new ConsistencySummaryVerifier(stats);
        }

        private ConsistencySummaryVerifier(ConsistencySummaryStatistics stats) {
            this.stats = stats;
        }

        public ConsistencySummaryVerifier verify(RecordType type, int inconsistencies) {
            if (!this.types.add(type)) {
                throw new IllegalStateException("Tried to verify the same type twice: " + type);
            }
            Assert.assertEquals((String)("Inconsistencies of type: " + type), (long)inconsistencies, (long)this.stats.getInconsistencyCountForRecordType(type));
            this.total += (long)inconsistencies;
            return this;
        }

        public void andThatsAllFolks() {
            Assert.assertEquals((String)("Total number of inconsistencies: " + this.stats), (long)this.total, (long)this.stats.getTotalInconsistencyCount());
        }
    }

    private static class Reference<T> {
        private T value;

        private Reference() {
        }

        void set(T value) {
            this.value = value;
        }

        T get() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

