/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.util.Map;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.consistency.RecordType;
import org.neo4j.consistency.checking.full.FullCheck;
import org.neo4j.consistency.report.ConsistencySummaryStatistics;
import org.neo4j.consistency.statistics.Statistics;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.api.direct.DirectStoreAccess;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.StoreAccess;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.id.DefaultIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class DetectAllRelationshipInconsistenciesIT {
    private final TestDirectory directory = TestDirectory.testDirectory();
    private final RandomRule random = new RandomRule();
    private final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    @Rule
    public final RuleChain rules = RuleChain.outerRule((TestRule)this.random).around((TestRule)this.directory).around((TestRule)this.fileSystemRule);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldDetectSabotagedRelationshipWhereEverItIs() throws Exception {
        Sabotage sabotage;
        GraphDatabaseAPI db = this.getGraphDatabaseAPI();
        try {
            Object[] nodes = new Node[1000];
            Object[] relationships = new Relationship[10000];
            try (Transaction tx = db.beginTx();){
                int i;
                for (i = 0; i < nodes.length; ++i) {
                    nodes[i] = db.createNode(new Label[]{Label.label((String)"Foo")});
                }
                for (i = 0; i < 10000; ++i) {
                    relationships[i] = ((Node)this.random.among(nodes)).createRelationshipTo((Node)this.random.among(nodes), (RelationshipType)MyRelTypes.TEST);
                }
                tx.success();
            }
            DependencyResolver resolver = db.getDependencyResolver();
            PageCache pageCache = (PageCache)resolver.resolveDependency(PageCache.class);
            StoreFactory storeFactory = this.newStoreFactory(pageCache);
            try (NeoStores neoStores = storeFactory.openNeoStores(false, new StoreType[]{StoreType.RELATIONSHIP});){
                RelationshipStore relationshipStore = neoStores.getRelationshipStore();
                Relationship sabotagedRelationships = (Relationship)this.random.among(relationships);
                sabotage = this.sabotage(relationshipStore, sabotagedRelationships.getId());
            }
        }
        finally {
            db.shutdown();
        }
        db = this.getGraphDatabaseAPI();
        try {
            DependencyResolver resolver = db.getDependencyResolver();
            PageCache pageCache = (PageCache)resolver.resolveDependency(PageCache.class);
            StoreFactory storeFactory = this.newStoreFactory(pageCache);
            try (NeoStores neoStores = storeFactory.openAllNeoStores();){
                StoreAccess storeAccess = new StoreAccess(neoStores).initialize();
                DirectStoreAccess directStoreAccess = new DirectStoreAccess(storeAccess, (LabelScanStore)db.getDependencyResolver().resolveDependency(LabelScanStore.class), (IndexProviderMap)db.getDependencyResolver().resolveDependency(IndexProviderMap.class));
                int threads = this.random.intBetween(2, 10);
                FullCheck checker = new FullCheck(this.getTuningConfiguration(), ProgressMonitorFactory.NONE, Statistics.NONE, threads);
                AssertableLogProvider logProvider = new AssertableLogProvider(true);
                ConsistencySummaryStatistics summary = checker.execute(directStoreAccess, logProvider.getLog(FullCheck.class));
                int relationshipInconsistencies = summary.getInconsistencyCountForRecordType(RecordType.RELATIONSHIP);
                Assert.assertTrue((String)("Couldn't detect sabotaged relationship " + sabotage), (relationshipInconsistencies > 0 ? 1 : 0) != 0);
                logProvider.assertContainsLogCallContaining(sabotage.after.toString());
            }
        }
        finally {
            db.shutdown();
        }
    }

    private StoreFactory newStoreFactory(PageCache pageCache) {
        FileSystemAbstraction fileSystem = this.fileSystemRule.get();
        return new StoreFactory(this.directory.directory(), this.getTuningConfiguration(), (IdGeneratorFactory)new DefaultIdGeneratorFactory(fileSystem), pageCache, fileSystem, (LogProvider)NullLogProvider.getInstance(), EmptyVersionContextSupplier.EMPTY);
    }

    private Config getTuningConfiguration() {
        return Config.defaults((Map)MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.pagecache_memory.name(), "8m", GraphDatabaseSettings.record_format.name(), this.getRecordFormatName()}));
    }

    private GraphDatabaseAPI getGraphDatabaseAPI() {
        TestGraphDatabaseFactory factory = new TestGraphDatabaseFactory();
        GraphDatabaseService database = factory.newEmbeddedDatabaseBuilder(this.directory.absolutePath()).setConfig(GraphDatabaseSettings.record_format, this.getRecordFormatName()).setConfig("dbms.backup.enabled", "false").newGraphDatabase();
        return (GraphDatabaseAPI)database;
    }

    protected String getRecordFormatName() {
        return "";
    }

    private Sabotage sabotage(RelationshipStore store, long id) {
        long otherReference;
        RelationshipRecord before = (RelationshipRecord)store.getRecord(id, store.newRecord(), RecordLoad.NORMAL);
        RelationshipRecord after = before.clone();
        if (!after.isFirstInFirstChain()) {
            otherReference = after.getFirstPrevRel() + 1L;
            after.setFirstPrevRel(otherReference);
        } else {
            otherReference = after.getFirstNextRel() + 1L;
            after.setFirstNextRel(otherReference);
        }
        store.prepareForCommit((AbstractBaseRecord)after);
        store.updateRecord((AbstractBaseRecord)after);
        RelationshipRecord other = (RelationshipRecord)store.getRecord(otherReference, store.newRecord(), RecordLoad.FORCE);
        return new Sabotage(before, after, other);
    }

    private static class Sabotage {
        private final RelationshipRecord before;
        private final RelationshipRecord after;
        private final RelationshipRecord other;

        Sabotage(RelationshipRecord before, RelationshipRecord after, RelationshipRecord other) {
            this.before = before;
            this.after = after;
            this.other = other;
        }

        public String toString() {
            return "Sabotabed " + this.before + " --> " + this.after + ", other relationship " + this.other;
        }
    }
}

