/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.cache;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.consistency.checking.cache.CacheAccess;
import org.neo4j.consistency.checking.cache.DefaultCacheAccess;
import org.neo4j.consistency.statistics.Counts;
import org.neo4j.consistency.statistics.DefaultCounts;

public class DefaultClientTest {
    private static ExecutorService executor;

    @BeforeClass
    public static void setUp() {
        executor = Executors.newSingleThreadExecutor();
    }

    @AfterClass
    public static void tearDown() {
        executor.shutdown();
    }

    @Test
    public void checkClientsIdBounds() throws ExecutionException, InterruptedException {
        int threads = 2;
        DefaultCounts counts = new DefaultCounts(threads);
        DefaultCacheAccess cacheAccess = new DefaultCacheAccess((Counts)counts, threads);
        cacheAccess.prepareForProcessingOfSingleStore(34L);
        CacheAccess.Client client1 = cacheAccess.client();
        Assert.assertTrue((boolean)client1.withinBounds(0L));
        Assert.assertTrue((boolean)client1.withinBounds(10L));
        Assert.assertTrue((boolean)client1.withinBounds(33L));
        Assert.assertFalse((boolean)client1.withinBounds(34L));
        Future<?> secondClientIdChecks = executor.submit(() -> {
            CacheAccess.Client client = cacheAccess.client();
            Assert.assertFalse((boolean)client.withinBounds(5L));
            Assert.assertFalse((boolean)client.withinBounds(33L));
            Assert.assertTrue((boolean)client.withinBounds(34L));
            Assert.assertTrue((boolean)client.withinBounds(67L));
            Assert.assertFalse((boolean)client.withinBounds(68L));
        });
        secondClientIdChecks.get();
    }
}

