/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.cache;

import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.neo4j.consistency.checking.cache.CacheAccess;
import org.neo4j.consistency.checking.cache.CacheTask;
import org.neo4j.consistency.checking.cache.DefaultCacheAccess;
import org.neo4j.consistency.checking.full.Stage;
import org.neo4j.consistency.checking.full.StoreProcessor;
import org.neo4j.consistency.statistics.Counts;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.StoreAccess;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;

public class CheckNextRelTaskTest {
    @Test
    public void scanForHighIdOnlyOnceWhenProcessCache() {
        NeoStores neoStores = (NeoStores)Mockito.mock(NeoStores.class, (Answer)Mockito.RETURNS_MOCKS);
        NodeStore nodeStore = (NodeStore)Mockito.mock(NodeStore.class);
        NodeRecord nodeRecord = (NodeRecord)Mockito.mock(NodeRecord.class);
        StoreProcessor storeProcessor = (StoreProcessor)Mockito.mock(StoreProcessor.class);
        Mockito.when((Object)neoStores.getNodeStore()).thenReturn((Object)nodeStore);
        Mockito.when((Object)nodeStore.getHighId()).thenReturn((Object)10L);
        Mockito.when((Object)nodeStore.getRecord(ArgumentMatchers.anyLong(), (AbstractBaseRecord)ArgumentMatchers.any(NodeRecord.class), (RecordLoad)ArgumentMatchers.any(RecordLoad.class))).thenReturn((Object)nodeRecord);
        Mockito.when((Object)nodeStore.newRecord()).thenReturn((Object)nodeRecord);
        StoreAccess storeAccess = new StoreAccess(neoStores);
        storeAccess.initialize();
        CacheTask.CheckNextRel cacheTask = new CacheTask.CheckNextRel(Stage.SEQUENTIAL_FORWARD, (CacheAccess)new DefaultCacheAccess(Counts.NONE, 1), storeAccess, storeProcessor);
        cacheTask.processCache();
        ((NodeStore)Mockito.verify((Object)nodeStore, (VerificationMode)Mockito.times((int)1))).getHighId();
    }
}

