/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking;

import org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.schema.constaints.ConstraintDescriptorFactory;
import org.neo4j.kernel.api.schema.constaints.IndexBackedConstraintDescriptor;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptorFactory;
import org.neo4j.kernel.impl.store.record.ConstraintRule;
import org.neo4j.kernel.impl.store.record.IndexRule;

public class SchemaRuleUtil {
    private SchemaRuleUtil() {
    }

    public static ConstraintRule uniquenessConstraintRule(long ruleId, int labelId, int propertyId, long indexId) {
        return ConstraintRule.constraintRule((long)ruleId, (IndexBackedConstraintDescriptor)ConstraintDescriptorFactory.uniqueForLabel((int)labelId, (int[])new int[]{propertyId}), (long)indexId);
    }

    public static ConstraintRule nodePropertyExistenceConstraintRule(long ruleId, int labelId, int propertyId) {
        return ConstraintRule.constraintRule((long)ruleId, (ConstraintDescriptor)ConstraintDescriptorFactory.existsForLabel((int)labelId, (int[])new int[]{propertyId}));
    }

    public static ConstraintRule relPropertyExistenceConstraintRule(long ruleId, int labelId, int propertyId) {
        return ConstraintRule.constraintRule((long)ruleId, (ConstraintDescriptor)ConstraintDescriptorFactory.existsForRelType((int)labelId, (int[])new int[]{propertyId}));
    }

    public static IndexRule indexRule(long ruleId, int labelId, int propertyId, IndexProvider.Descriptor descriptor) {
        return IndexRule.indexRule((long)ruleId, (SchemaIndexDescriptor)SchemaIndexDescriptorFactory.forLabel((int)labelId, (int[])new int[]{propertyId}), (IndexProvider.Descriptor)descriptor);
    }

    public static IndexRule constraintIndexRule(long ruleId, int labelId, int propertyId, IndexProvider.Descriptor descriptor, long constraintId) {
        return IndexRule.constraintIndexRule((long)ruleId, (SchemaIndexDescriptor)SchemaIndexDescriptorFactory.uniqueForLabel((int)labelId, (int[])new int[]{propertyId}), (IndexProvider.Descriptor)descriptor, (Long)constraintId);
    }

    public static IndexRule constraintIndexRule(long ruleId, int labelId, int propertyId, IndexProvider.Descriptor descriptor) {
        return IndexRule.indexRule((long)ruleId, (SchemaIndexDescriptor)SchemaIndexDescriptorFactory.uniqueForLabel((int)labelId, (int[])new int[]{propertyId}), (IndexProvider.Descriptor)descriptor);
    }
}

