/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking;

import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.consistency.checking.LabelTokenRecordCheck;
import org.neo4j.consistency.checking.RecordCheckTestBase;
import org.neo4j.consistency.checking.full.MultiPassStore;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;

public class LabelTokenRecordCheckTest
extends RecordCheckTestBase<LabelTokenRecord, ConsistencyReport.LabelTokenConsistencyReport, LabelTokenRecordCheck> {
    public LabelTokenRecordCheckTest() {
        super(new LabelTokenRecordCheck(), ConsistencyReport.LabelTokenConsistencyReport.class, new int[0], new MultiPassStore[0]);
    }

    @Test
    public void shouldNotReportAnythingForRecordNotInUse() {
        LabelTokenRecord key = LabelTokenRecordCheckTest.notInUse(new LabelTokenRecord(42));
        ConsistencyReport.LabelTokenConsistencyReport report = (ConsistencyReport.LabelTokenConsistencyReport)this.check(key);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    public void shouldNotReportAnythingForRecordThatDoesNotReferenceADynamicBlock() {
        LabelTokenRecord key = LabelTokenRecordCheckTest.inUse(new LabelTokenRecord(42));
        ConsistencyReport.LabelTokenConsistencyReport report = (ConsistencyReport.LabelTokenConsistencyReport)this.check(key);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    public void shouldReportDynamicBlockNotInUse() {
        LabelTokenRecord key = LabelTokenRecordCheckTest.inUse(new LabelTokenRecord(42));
        DynamicRecord name = this.addLabelName(LabelTokenRecordCheckTest.notInUse(new DynamicRecord(6L)));
        key.setNameId((int)name.getId());
        ConsistencyReport.LabelTokenConsistencyReport report = (ConsistencyReport.LabelTokenConsistencyReport)this.check(key);
        ((ConsistencyReport.LabelTokenConsistencyReport)Mockito.verify((Object)report)).nameBlockNotInUse(name);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    public void shouldReportEmptyName() {
        LabelTokenRecord key = LabelTokenRecordCheckTest.inUse(new LabelTokenRecord(42));
        DynamicRecord name = this.addLabelName(LabelTokenRecordCheckTest.inUse(new DynamicRecord(6L)));
        key.setNameId((int)name.getId());
        ConsistencyReport.LabelTokenConsistencyReport report = (ConsistencyReport.LabelTokenConsistencyReport)this.check(key);
        ((ConsistencyReport.LabelTokenConsistencyReport)Mockito.verify((Object)report)).emptyName(name);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }
}

