/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.impl.transaction.state.DefaultIndexProviderMap;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.test.TestLabels;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.EmbeddedDatabaseRule;
import org.neo4j.test.rule.RandomRule;

public class IndexConsistencyIT {
    @Rule
    public final DatabaseRule db = new EmbeddedDatabaseRule();
    @Rule
    public final RandomRule random = new RandomRule();
    private final AssertableLogProvider log = new AssertableLogProvider();
    private static final Label[] LABELS = new Label[]{TestLabels.LABEL_ONE, TestLabels.LABEL_TWO, TestLabels.LABEL_THREE};
    private static final String PROPERTY_KEY = "numericProperty";
    private static final double DELETE_RATIO = 0.2;
    private static final double UPDATE_RATIO = 0.2;
    private static final int NODE_COUNT_BASELINE = 10;
    private final FileFilter SOURCE_COPY_FILE_FILTER = file -> file.isDirectory() || file.getName().startsWith("index");

    @Test
    public void reportNotCleanNativeIndex() throws IOException, ConsistencyCheckIncompleteException {
        File storeDir = this.db.getStoreDir();
        this.someData();
        this.resolveComponent(CheckPointer.class).forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("forcedCheckpoint"));
        File indexesCopy = new File(storeDir, "indexesCopy");
        File indexSources = this.resolveComponent(DefaultIndexProviderMap.class).getDefaultProvider().directoryStructure().rootDirectory();
        FileUtils.copyRecursively((File)indexSources, (File)indexesCopy, (FileFilter)this.SOURCE_COPY_FILE_FILTER);
        try (Transaction tx = this.db.beginTx();){
            this.createNewNode(new Label[]{TestLabels.LABEL_ONE});
            tx.success();
        }
        this.db.shutdownAndKeepStore();
        FileUtils.copyRecursively((File)indexesCopy, (File)indexSources);
        ConsistencyCheckService.Result result = this.fullConsistencyCheck();
        Assert.assertFalse((String)"Expected consistency check to fail", (boolean)result.isSuccessful());
        Assert.assertThat(this.readReport(result), (Matcher)Matchers.hasItem((Matcher)Matchers.containsString((String)"WARN : Index was not properly shutdown and rebuild is required.")));
    }

    @Test
    public void reportNotCleanNativeIndexWithCorrectData() throws IOException, ConsistencyCheckIncompleteException {
        File storeDir = this.db.getStoreDir();
        this.someData();
        this.resolveComponent(CheckPointer.class).forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("forcedCheckpoint"));
        File indexesCopy = new File(storeDir, "indexesCopy");
        File indexSources = this.resolveComponent(DefaultIndexProviderMap.class).getDefaultProvider().directoryStructure().rootDirectory();
        FileUtils.copyRecursively((File)indexSources, (File)indexesCopy, (FileFilter)this.SOURCE_COPY_FILE_FILTER);
        this.db.shutdownAndKeepStore();
        FileUtils.copyRecursively((File)indexesCopy, (File)indexSources);
        ConsistencyCheckService.Result result = this.fullConsistencyCheck();
        Assert.assertTrue((String)"Expected consistency check to fail", (boolean)result.isSuccessful());
        Assert.assertThat(this.readReport(result), (Matcher)Matchers.hasItem((Matcher)Matchers.containsString((String)"WARN : Index was not properly shutdown and rebuild is required.")));
    }

    private <T> T resolveComponent(Class<T> clazz) {
        return (T)this.db.resolveDependency(clazz);
    }

    private List<String> readReport(ConsistencyCheckService.Result result) throws IOException {
        return Files.readAllLines(result.reportFile().toPath());
    }

    List<Pair<Long, Label[]>> someData() {
        return this.someData(50);
    }

    List<Pair<Long, Label[]>> someData(int numberOfModifications) {
        ArrayList<Pair<Long, Label[]>> existingNodes = new ArrayList<Pair<Long, Label[]>>();
        try (Transaction tx = this.db.beginTx();){
            this.randomModifications(existingNodes, numberOfModifications);
            tx.success();
        }
        tx = this.db.beginTx();
        var4_4 = null;
        try {
            this.db.schema().indexFor((Label)TestLabels.LABEL_ONE).on(PROPERTY_KEY).create();
            tx.success();
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_4 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = this.db.beginTx();
        var4_4 = null;
        try {
            this.db.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            tx.success();
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_4 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        return existingNodes;
    }

    private List<Pair<Long, Label[]>> randomModifications(List<Pair<Long, Label[]>> existingNodes, int numberOfModifications) {
        for (int i = 0; i < numberOfModifications; ++i) {
            double selectModification = this.random.nextDouble();
            if (existingNodes.size() < 10 || selectModification >= 0.4) {
                this.createNewNode(existingNodes);
                continue;
            }
            if (selectModification < 0.2) {
                this.deleteExistingNode(existingNodes);
                continue;
            }
            this.modifyLabelsOnExistingNode(existingNodes);
        }
        return existingNodes;
    }

    private void createNewNode(List<Pair<Long, Label[]>> existingNodes) {
        Label[] labels = this.randomLabels();
        Node node = this.createNewNode(labels);
        existingNodes.add((Pair<Long, Label[]>)Pair.of((Object)node.getId(), (Object)labels));
    }

    private Node createNewNode(Label[] labels) {
        Node node = this.db.createNode(labels);
        node.setProperty(PROPERTY_KEY, (Object)this.random.nextInt());
        return node;
    }

    private void modifyLabelsOnExistingNode(List<Pair<Long, Label[]>> existingNodes) {
        Label[] newLabels;
        int targetIndex = this.random.nextInt(existingNodes.size());
        Pair<Long, Label[]> existingPair = existingNodes.get(targetIndex);
        long nodeId = (Long)existingPair.first();
        Node node = this.db.getNodeById(nodeId);
        node.getLabels().forEach(arg_0 -> ((Node)node).removeLabel(arg_0));
        for (Label label : newLabels = this.randomLabels()) {
            node.addLabel(label);
        }
        existingNodes.remove(targetIndex);
        existingNodes.add((Pair<Long, Label[]>)Pair.of((Object)nodeId, (Object)newLabels));
    }

    private void deleteExistingNode(List<Pair<Long, Label[]>> existingNodes) {
        int targetIndex = this.random.nextInt(existingNodes.size());
        Pair<Long, Label[]> existingPair = existingNodes.get(targetIndex);
        Node node = this.db.getNodeById(((Long)existingPair.first()).longValue());
        node.delete();
        existingNodes.remove(targetIndex);
    }

    private Label[] randomLabels() {
        ArrayList<Label> labels = new ArrayList<Label>(LABELS.length);
        for (Label label : LABELS) {
            if (!this.random.nextBoolean()) continue;
            labels.add(label);
        }
        return labels.toArray(new Label[labels.size()]);
    }

    ConsistencyCheckService.Result fullConsistencyCheck() throws ConsistencyCheckIncompleteException, IOException {
        try (DefaultFileSystemAbstraction fsa = new DefaultFileSystemAbstraction();){
            ConsistencyCheckService service = new ConsistencyCheckService();
            Config config = Config.defaults();
            ConsistencyCheckService.Result result = service.runFullConsistencyCheck(this.db.getStoreDir(), config, ProgressMonitorFactory.NONE, (LogProvider)this.log, (FileSystemAbstraction)fsa, true);
            return result;
        }
    }
}

