/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.commandline.admin.CommandFailed;
import org.neo4j.commandline.admin.CommandLocator;
import org.neo4j.commandline.admin.IncorrectUsage;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.commandline.admin.Usage;
import org.neo4j.consistency.CheckConsistencyCommand;
import org.neo4j.consistency.CheckConsistencyCommandProvider;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.consistency.checking.full.ConsistencyFlags;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.LogProvider;
import org.neo4j.test.rule.TestDirectory;

public class CheckConsistencyCommandTest {
    @Rule
    public TestDirectory testDir = TestDirectory.testDirectory(this.getClass());
    @Rule
    public ExpectedException expect = ExpectedException.none();

    @Test
    public void runsConsistencyChecker() throws Exception {
        ConsistencyCheckService consistencyCheckService = (ConsistencyCheckService)Mockito.mock(ConsistencyCheckService.class);
        Path homeDir = this.testDir.directory("home").toPath();
        OutsideWorld outsideWorld = (OutsideWorld)Mockito.mock(OutsideWorld.class);
        CheckConsistencyCommand checkConsistencyCommand = new CheckConsistencyCommand(homeDir, this.testDir.directory("conf").toPath(), outsideWorld, consistencyCheckService);
        File databasePath = new File(homeDir.toFile(), "data/databases/mydb");
        Mockito.when((Object)consistencyCheckService.runFullConsistencyCheck((File)ArgumentMatchers.eq((Object)databasePath), (Config)ArgumentMatchers.any(Config.class), (ProgressMonitorFactory)ArgumentMatchers.any(ProgressMonitorFactory.class), (LogProvider)ArgumentMatchers.any(LogProvider.class), (FileSystemAbstraction)ArgumentMatchers.any(FileSystemAbstraction.class), ArgumentMatchers.eq((boolean)false), (File)ArgumentMatchers.any(), (ConsistencyFlags)ArgumentMatchers.any(ConsistencyFlags.class))).thenReturn((Object)ConsistencyCheckService.Result.success(null));
        checkConsistencyCommand.execute(new String[]{"--database=mydb"});
        ((ConsistencyCheckService)Mockito.verify((Object)consistencyCheckService)).runFullConsistencyCheck((File)ArgumentMatchers.eq((Object)databasePath), (Config)ArgumentMatchers.any(Config.class), (ProgressMonitorFactory)ArgumentMatchers.any(ProgressMonitorFactory.class), (LogProvider)ArgumentMatchers.any(LogProvider.class), (FileSystemAbstraction)ArgumentMatchers.any(FileSystemAbstraction.class), ArgumentMatchers.eq((boolean)false), (File)ArgumentMatchers.any(), (ConsistencyFlags)ArgumentMatchers.any(ConsistencyFlags.class));
    }

    @Test
    public void enablesVerbosity() throws Exception {
        ConsistencyCheckService consistencyCheckService = (ConsistencyCheckService)Mockito.mock(ConsistencyCheckService.class);
        Path homeDir = this.testDir.directory("home").toPath();
        OutsideWorld outsideWorld = (OutsideWorld)Mockito.mock(OutsideWorld.class);
        CheckConsistencyCommand checkConsistencyCommand = new CheckConsistencyCommand(homeDir, this.testDir.directory("conf").toPath(), outsideWorld, consistencyCheckService);
        File databasePath = new File(homeDir.toFile(), "data/databases/mydb");
        Mockito.when((Object)consistencyCheckService.runFullConsistencyCheck((File)ArgumentMatchers.eq((Object)databasePath), (Config)ArgumentMatchers.any(Config.class), (ProgressMonitorFactory)ArgumentMatchers.any(ProgressMonitorFactory.class), (LogProvider)ArgumentMatchers.any(LogProvider.class), (FileSystemAbstraction)ArgumentMatchers.any(FileSystemAbstraction.class), ArgumentMatchers.eq((boolean)true), (File)ArgumentMatchers.any(), (ConsistencyFlags)ArgumentMatchers.any(ConsistencyFlags.class))).thenReturn((Object)ConsistencyCheckService.Result.success(null));
        checkConsistencyCommand.execute(new String[]{"--database=mydb", "--verbose"});
        ((ConsistencyCheckService)Mockito.verify((Object)consistencyCheckService)).runFullConsistencyCheck((File)ArgumentMatchers.eq((Object)databasePath), (Config)ArgumentMatchers.any(Config.class), (ProgressMonitorFactory)ArgumentMatchers.any(ProgressMonitorFactory.class), (LogProvider)ArgumentMatchers.any(LogProvider.class), (FileSystemAbstraction)ArgumentMatchers.any(FileSystemAbstraction.class), ArgumentMatchers.eq((boolean)true), (File)ArgumentMatchers.any(), (ConsistencyFlags)ArgumentMatchers.any(ConsistencyFlags.class));
    }

    @Test
    public void failsWhenInconsistenciesAreFound() throws Exception {
        ConsistencyCheckService consistencyCheckService = (ConsistencyCheckService)Mockito.mock(ConsistencyCheckService.class);
        Path homeDir = this.testDir.directory("home").toPath();
        OutsideWorld outsideWorld = (OutsideWorld)Mockito.mock(OutsideWorld.class);
        CheckConsistencyCommand checkConsistencyCommand = new CheckConsistencyCommand(homeDir, this.testDir.directory("conf").toPath(), outsideWorld, consistencyCheckService);
        File databasePath = new File(homeDir.toFile(), "data/databases/mydb");
        Mockito.when((Object)consistencyCheckService.runFullConsistencyCheck((File)ArgumentMatchers.eq((Object)databasePath), (Config)ArgumentMatchers.any(Config.class), (ProgressMonitorFactory)ArgumentMatchers.any(ProgressMonitorFactory.class), (LogProvider)ArgumentMatchers.any(LogProvider.class), (FileSystemAbstraction)ArgumentMatchers.any(FileSystemAbstraction.class), ArgumentMatchers.eq((boolean)true), (File)ArgumentMatchers.any(), (ConsistencyFlags)ArgumentMatchers.any(ConsistencyFlags.class))).thenReturn((Object)ConsistencyCheckService.Result.failure((File)new File("/the/report/path")));
        try {
            checkConsistencyCommand.execute(new String[]{"--database=mydb", "--verbose"});
        }
        catch (CommandFailed e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)new File("/the/report/path").toString()));
        }
    }

    @Test
    public void shouldWriteReportFileToCurrentDirectoryByDefault() throws IOException, ConsistencyCheckIncompleteException, CommandFailed, IncorrectUsage {
        ConsistencyCheckService consistencyCheckService = (ConsistencyCheckService)Mockito.mock(ConsistencyCheckService.class);
        Path homeDir = this.testDir.directory("home").toPath();
        OutsideWorld outsideWorld = (OutsideWorld)Mockito.mock(OutsideWorld.class);
        CheckConsistencyCommand checkConsistencyCommand = new CheckConsistencyCommand(homeDir, this.testDir.directory("conf").toPath(), outsideWorld, consistencyCheckService);
        Mockito.when((Object)consistencyCheckService.runFullConsistencyCheck((File)ArgumentMatchers.any(), (Config)ArgumentMatchers.any(), (ProgressMonitorFactory)ArgumentMatchers.any(), (LogProvider)ArgumentMatchers.any(), (FileSystemAbstraction)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), (File)ArgumentMatchers.any(), (ConsistencyFlags)ArgumentMatchers.any(ConsistencyFlags.class))).thenReturn((Object)ConsistencyCheckService.Result.success(null));
        checkConsistencyCommand.execute(new String[]{"--database=mydb"});
        ((ConsistencyCheckService)Mockito.verify((Object)consistencyCheckService)).runFullConsistencyCheck((File)ArgumentMatchers.any(), (Config)ArgumentMatchers.any(), (ProgressMonitorFactory)ArgumentMatchers.any(), (LogProvider)ArgumentMatchers.any(), (FileSystemAbstraction)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), (File)ArgumentMatchers.eq((Object)new File(".").getCanonicalFile()), (ConsistencyFlags)ArgumentMatchers.any(ConsistencyFlags.class));
    }

    @Test
    public void shouldWriteReportFileToSpecifiedDirectory() throws IOException, ConsistencyCheckIncompleteException, CommandFailed, IncorrectUsage {
        ConsistencyCheckService consistencyCheckService = (ConsistencyCheckService)Mockito.mock(ConsistencyCheckService.class);
        Path homeDir = this.testDir.directory("home").toPath();
        OutsideWorld outsideWorld = (OutsideWorld)Mockito.mock(OutsideWorld.class);
        CheckConsistencyCommand checkConsistencyCommand = new CheckConsistencyCommand(homeDir, this.testDir.directory("conf").toPath(), outsideWorld, consistencyCheckService);
        Mockito.when((Object)consistencyCheckService.runFullConsistencyCheck((File)ArgumentMatchers.any(), (Config)ArgumentMatchers.any(), (ProgressMonitorFactory)ArgumentMatchers.any(), (LogProvider)ArgumentMatchers.any(), (FileSystemAbstraction)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), (File)ArgumentMatchers.any(), (ConsistencyFlags)ArgumentMatchers.any(ConsistencyFlags.class))).thenReturn((Object)ConsistencyCheckService.Result.success(null));
        checkConsistencyCommand.execute(new String[]{"--database=mydb", "--report-dir=some-dir-or-other"});
        ((ConsistencyCheckService)Mockito.verify((Object)consistencyCheckService)).runFullConsistencyCheck((File)ArgumentMatchers.any(), (Config)ArgumentMatchers.any(), (ProgressMonitorFactory)ArgumentMatchers.any(), (LogProvider)ArgumentMatchers.any(), (FileSystemAbstraction)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), (File)ArgumentMatchers.eq((Object)new File("some-dir-or-other").getCanonicalFile()), (ConsistencyFlags)ArgumentMatchers.any(ConsistencyFlags.class));
    }

    @Test
    public void shouldCanonicalizeReportDirectory() throws IOException, ConsistencyCheckIncompleteException, CommandFailed, IncorrectUsage {
        ConsistencyCheckService consistencyCheckService = (ConsistencyCheckService)Mockito.mock(ConsistencyCheckService.class);
        Path homeDir = this.testDir.directory("home").toPath();
        OutsideWorld outsideWorld = (OutsideWorld)Mockito.mock(OutsideWorld.class);
        CheckConsistencyCommand checkConsistencyCommand = new CheckConsistencyCommand(homeDir, this.testDir.directory("conf").toPath(), outsideWorld, consistencyCheckService);
        Mockito.when((Object)consistencyCheckService.runFullConsistencyCheck((File)ArgumentMatchers.any(), (Config)ArgumentMatchers.any(), (ProgressMonitorFactory)ArgumentMatchers.any(), (LogProvider)ArgumentMatchers.any(), (FileSystemAbstraction)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), (File)ArgumentMatchers.any(), (ConsistencyFlags)ArgumentMatchers.any(ConsistencyFlags.class))).thenReturn((Object)ConsistencyCheckService.Result.success(null));
        checkConsistencyCommand.execute(new String[]{"--database=mydb", "--report-dir=" + Paths.get("..", "bar")});
        ((ConsistencyCheckService)Mockito.verify((Object)consistencyCheckService)).runFullConsistencyCheck((File)ArgumentMatchers.any(), (Config)ArgumentMatchers.any(), (ProgressMonitorFactory)ArgumentMatchers.any(), (LogProvider)ArgumentMatchers.any(), (FileSystemAbstraction)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), (File)ArgumentMatchers.eq((Object)new File("../bar").getCanonicalFile()), (ConsistencyFlags)ArgumentMatchers.any(ConsistencyFlags.class));
    }

    @Test
    public void passesOnCheckParameters() throws Exception {
        ConsistencyCheckService consistencyCheckService = (ConsistencyCheckService)Mockito.mock(ConsistencyCheckService.class);
        Path homeDir = this.testDir.directory("home").toPath();
        OutsideWorld outsideWorld = (OutsideWorld)Mockito.mock(OutsideWorld.class);
        CheckConsistencyCommand checkConsistencyCommand = new CheckConsistencyCommand(homeDir, this.testDir.directory("conf").toPath(), outsideWorld, consistencyCheckService);
        Mockito.when((Object)consistencyCheckService.runFullConsistencyCheck((File)ArgumentMatchers.any(), (Config)ArgumentMatchers.any(), (ProgressMonitorFactory)ArgumentMatchers.any(), (LogProvider)ArgumentMatchers.any(), (FileSystemAbstraction)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), (File)ArgumentMatchers.any(), (ConsistencyFlags)ArgumentMatchers.any(ConsistencyFlags.class))).thenReturn((Object)ConsistencyCheckService.Result.success(null));
        checkConsistencyCommand.execute(new String[]{"--database=mydb", "--check-graph=false", "--check-indexes=false", "--check-label-scan-store=false", "--check-property-owners=true"});
        ((ConsistencyCheckService)Mockito.verify((Object)consistencyCheckService)).runFullConsistencyCheck((File)ArgumentMatchers.any(), (Config)ArgumentMatchers.any(), (ProgressMonitorFactory)ArgumentMatchers.any(), (LogProvider)ArgumentMatchers.any(), (FileSystemAbstraction)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), (File)ArgumentMatchers.any(), (ConsistencyFlags)ArgumentMatchers.eq((Object)new ConsistencyFlags(false, false, false, true)));
    }

    @Test
    public void databaseAndBackupAreMutuallyExclusive() throws Exception {
        ConsistencyCheckService consistencyCheckService = (ConsistencyCheckService)Mockito.mock(ConsistencyCheckService.class);
        Path homeDir = this.testDir.directory("home").toPath();
        OutsideWorld outsideWorld = (OutsideWorld)Mockito.mock(OutsideWorld.class);
        CheckConsistencyCommand checkConsistencyCommand = new CheckConsistencyCommand(homeDir, this.testDir.directory("conf").toPath(), outsideWorld, consistencyCheckService);
        Mockito.when((Object)consistencyCheckService.runFullConsistencyCheck((File)ArgumentMatchers.any(), (Config)ArgumentMatchers.any(), (ProgressMonitorFactory)ArgumentMatchers.any(), (LogProvider)ArgumentMatchers.any(), (FileSystemAbstraction)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), (ConsistencyFlags)ArgumentMatchers.any(ConsistencyFlags.class))).thenReturn((Object)ConsistencyCheckService.Result.success(null));
        this.expect.expect(IncorrectUsage.class);
        this.expect.expectMessage("Only one of '--database' and '--backup' can be specified.");
        checkConsistencyCommand.execute(new String[]{"--database=foo", "--backup=bar"});
    }

    @Test
    public void backupNeedsToBePath() throws Exception {
        ConsistencyCheckService consistencyCheckService = (ConsistencyCheckService)Mockito.mock(ConsistencyCheckService.class);
        Path homeDir = this.testDir.directory("home").toPath();
        OutsideWorld outsideWorld = (OutsideWorld)Mockito.mock(OutsideWorld.class);
        CheckConsistencyCommand checkConsistencyCommand = new CheckConsistencyCommand(homeDir, this.testDir.directory("conf").toPath(), outsideWorld, consistencyCheckService);
        File backupPath = new File(homeDir.toFile(), "dir/does/not/exist");
        this.expect.expect(CommandFailed.class);
        this.expect.expectMessage("Specified backup should be a directory: " + backupPath);
        checkConsistencyCommand.execute(new String[]{"--backup=" + backupPath});
    }

    @Test
    public void canRunOnBackup() throws Exception {
        ConsistencyCheckService consistencyCheckService = (ConsistencyCheckService)Mockito.mock(ConsistencyCheckService.class);
        Path backupDir = this.testDir.directory("backup").toPath();
        Path homeDir = this.testDir.directory("home").toPath();
        OutsideWorld outsideWorld = (OutsideWorld)Mockito.mock(OutsideWorld.class);
        CheckConsistencyCommand checkConsistencyCommand = new CheckConsistencyCommand(homeDir, this.testDir.directory("conf").toPath(), outsideWorld, consistencyCheckService);
        Mockito.when((Object)consistencyCheckService.runFullConsistencyCheck((File)ArgumentMatchers.eq((Object)backupDir.toFile()), (Config)ArgumentMatchers.any(Config.class), (ProgressMonitorFactory)ArgumentMatchers.any(ProgressMonitorFactory.class), (LogProvider)ArgumentMatchers.any(LogProvider.class), (FileSystemAbstraction)ArgumentMatchers.any(FileSystemAbstraction.class), ArgumentMatchers.eq((boolean)false), (File)ArgumentMatchers.any(), (ConsistencyFlags)ArgumentMatchers.any(ConsistencyFlags.class))).thenReturn((Object)ConsistencyCheckService.Result.success(null));
        checkConsistencyCommand.execute(new String[]{"--backup=" + backupDir});
        ((ConsistencyCheckService)Mockito.verify((Object)consistencyCheckService)).runFullConsistencyCheck((File)ArgumentMatchers.eq((Object)backupDir.toFile()), (Config)ArgumentMatchers.any(Config.class), (ProgressMonitorFactory)ArgumentMatchers.any(ProgressMonitorFactory.class), (LogProvider)ArgumentMatchers.any(LogProvider.class), (FileSystemAbstraction)ArgumentMatchers.any(FileSystemAbstraction.class), ArgumentMatchers.eq((boolean)false), (File)ArgumentMatchers.any(), (ConsistencyFlags)ArgumentMatchers.any(ConsistencyFlags.class));
    }

    @Test
    public void shouldPrintNiceHelp() throws Throwable {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            PrintStream ps = new PrintStream(baos);
            Usage usage = new Usage("neo4j-admin", (CommandLocator)Mockito.mock(CommandLocator.class));
            usage.printUsageForCommand((AdminCommand.Provider)new CheckConsistencyCommandProvider(), ps::println);
            Assert.assertEquals((Object)String.format("usage: neo4j-admin check-consistency [--database=<name>]%n                                     [--backup=</path/to/backup>]%n                                     [--verbose[=<true|false>]]%n                                     [--report-dir=<directory>]%n                                     [--additional-config=<config-file-path>]%n                                     [--check-graph[=<true|false>]]%n                                     [--check-indexes[=<true|false>]]%n                                     [--check-label-scan-store[=<true|false>]]%n                                     [--check-property-owners[=<true|false>]]%n%nenvironment variables:%n    NEO4J_CONF    Path to directory which contains neo4j.conf.%n    NEO4J_DEBUG   Set to anything to enable debug output.%n    NEO4J_HOME    Neo4j home directory.%n    HEAP_SIZE     Set JVM maximum heap size during command execution.%n                  Takes a number and a unit, for example 512m.%n%nThis command allows for checking the consistency of a database or a backup%nthereof. It cannot be used with a database which is currently in use.%n%nAll checks except 'check-graph' can be quite expensive so it may be useful to%nturn them off for very large databases. Increasing the heap size can also be a%ngood idea. See 'neo4j-admin help' for details.%n%noptions:%n  --database=<name>                        Name of database. [default:graph.db]%n  --backup=</path/to/backup>               Path to backup to check consistency%n                                           of. Cannot be used together with%n                                           --database. [default:]%n  --verbose=<true|false>                   Enable verbose output.%n                                           [default:false]%n  --report-dir=<directory>                 Directory to write report file in.%n                                           [default:.]%n  --additional-config=<config-file-path>   Configuration file to supply%n                                           additional configuration in. This%n                                           argument is DEPRECATED. [default:]%n  --check-graph=<true|false>               Perform checks between nodes,%n                                           relationships, properties, types and%n                                           tokens. [default:true]%n  --check-indexes=<true|false>             Perform checks on indexes.%n                                           [default:true]%n  --check-label-scan-store=<true|false>    Perform checks on the label scan%n                                           store. [default:true]%n  --check-property-owners=<true|false>     Perform additional checks on property%n                                           ownership. This check is *very*%n                                           expensive in time and memory.%n                                           [default:false]%n", new Object[0]), (Object)baos.toString());
        }
    }
}

