/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import org.neo4j.consistency.checking.full.Owner;
import org.neo4j.consistency.report.PendingReferenceCheck;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.consistency.store.RecordReference;
import org.neo4j.kernel.impl.store.record.NeoStoreRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;

abstract class PropertyOwner<RECORD extends PrimitiveRecord>
implements Owner {
    static final PropertyOwner<NeoStoreRecord> OWNING_GRAPH = new PropertyOwner<NeoStoreRecord>(){

        @Override
        RecordReference<NeoStoreRecord> record(RecordAccess records) {
            return records.graph();
        }
    };

    abstract RecordReference<RECORD> record(RecordAccess var1);

    @Override
    public void checkOrphanage() {
    }

    private PropertyOwner() {
    }

    static class UnknownOwner
    extends PropertyOwner<PrimitiveRecord>
    implements RecordReference<PrimitiveRecord> {
        private PendingReferenceCheck<PrimitiveRecord> reporter;

        UnknownOwner() {
        }

        @Override
        RecordReference<PrimitiveRecord> record(RecordAccess records) {
            this.markInCustody();
            return RecordReference.SkippingReference.skipReference();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void checkOrphanage() {
            PendingReferenceCheck<PrimitiveRecord> reporter;
            UnknownOwner unknownOwner = this;
            synchronized (unknownOwner) {
                reporter = this.reporter;
                this.reporter = null;
            }
            if (reporter != null) {
                reporter.checkReference(null, null);
            }
        }

        synchronized void markInCustody() {
            if (this.reporter != null) {
                this.reporter.skip();
                this.reporter = null;
            }
        }

        @Override
        public synchronized void dispatch(PendingReferenceCheck<PrimitiveRecord> reporter) {
            this.reporter = reporter;
        }
    }

    static class OwningRelationship
    extends PropertyOwner<RelationshipRecord> {
        private final long id;

        OwningRelationship(RelationshipRecord record) {
            this.id = record.getId();
        }

        @Override
        RecordReference<RelationshipRecord> record(RecordAccess records) {
            return records.relationship(this.id);
        }
    }

    static class OwningNode
    extends PropertyOwner<NodeRecord> {
        private final long id;

        OwningNode(NodeRecord record) {
            this.id = record.getId();
        }

        @Override
        RecordReference<NodeRecord> record(RecordAccess records) {
            return records.node(this.id);
        }
    }
}

