/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.store;

import java.io.File;
import java.io.IOException;
import org.junit.Assert;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class StoreAssertions {
    private StoreAssertions() {
    }

    public static void assertConsistentStore(File storeDir) throws ConsistencyCheckIncompleteException, IOException {
        Config configuration = Config.defaults((Setting)GraphDatabaseSettings.pagecache_memory, (String)"8m");
        AssertableLogProvider logger = new AssertableLogProvider();
        ConsistencyCheckService.Result result = new ConsistencyCheckService().runFullConsistencyCheck(storeDir, configuration, ProgressMonitorFactory.NONE, (LogProvider)NullLogProvider.getInstance(), false);
        Assert.assertTrue((String)("Consistency check for " + storeDir + " found inconsistencies:\n\n" + logger.serialize()), (boolean)result.isSuccessful());
    }
}

