/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Properties;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.consistency.ConsistencyCheckSettings;
import org.neo4j.consistency.ConsistencyCheckTool;
import org.neo4j.consistency.checking.full.CheckConsistencyConfig;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.LogProvider;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class ConsistencyCheckToolTest {
    private final TestDirectory storeDirectory = TestDirectory.testDirectory();
    private final EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.storeDirectory).around((TestRule)this.fs);

    @Test
    public void runsConsistencyCheck() throws Exception {
        File storeDir = this.storeDirectory.directory();
        String[] args = new String[]{storeDir.getPath()};
        ConsistencyCheckService service = (ConsistencyCheckService)Mockito.mock(ConsistencyCheckService.class);
        PrintStream systemError = (PrintStream)Mockito.mock(PrintStream.class);
        this.runConsistencyCheckToolWith(service, systemError, args);
        ((ConsistencyCheckService)Mockito.verify((Object)service)).runFullConsistencyCheck((File)Matchers.eq((Object)storeDir), (Config)Matchers.any(Config.class), (ProgressMonitorFactory)Matchers.any(ProgressMonitorFactory.class), (LogProvider)Matchers.any(LogProvider.class), (FileSystemAbstraction)Matchers.any(FileSystemAbstraction.class), Matchers.anyBoolean(), (CheckConsistencyConfig)Matchers.any(CheckConsistencyConfig.class));
    }

    @Test
    public void appliesDefaultTuningConfigurationForConsistencyChecker() throws Exception {
        File storeDir = this.storeDirectory.directory();
        String[] args = new String[]{storeDir.getPath()};
        ConsistencyCheckService service = (ConsistencyCheckService)Mockito.mock(ConsistencyCheckService.class);
        PrintStream systemOut = (PrintStream)Mockito.mock(PrintStream.class);
        this.runConsistencyCheckToolWith(service, systemOut, args);
        ArgumentCaptor config = ArgumentCaptor.forClass(Config.class);
        ((ConsistencyCheckService)Mockito.verify((Object)service)).runFullConsistencyCheck((File)Matchers.eq((Object)storeDir), (Config)config.capture(), (ProgressMonitorFactory)Matchers.any(ProgressMonitorFactory.class), (LogProvider)Matchers.any(LogProvider.class), (FileSystemAbstraction)Matchers.any(FileSystemAbstraction.class), Matchers.anyBoolean(), (CheckConsistencyConfig)Matchers.any(CheckConsistencyConfig.class));
        Assert.assertFalse((boolean)((Boolean)((Config)config.getValue()).get(ConsistencyCheckSettings.consistency_check_property_owners)));
    }

    @Test
    public void passesOnConfigurationIfProvided() throws Exception {
        File storeDir = this.storeDirectory.directory();
        File configFile = this.storeDirectory.file("neo4j.conf");
        Properties properties = new Properties();
        properties.setProperty(ConsistencyCheckSettings.consistency_check_property_owners.name(), "true");
        properties.store(new FileWriter(configFile), null);
        String[] args = new String[]{storeDir.getPath(), "-config", configFile.getPath()};
        ConsistencyCheckService service = (ConsistencyCheckService)Mockito.mock(ConsistencyCheckService.class);
        PrintStream systemOut = (PrintStream)Mockito.mock(PrintStream.class);
        this.runConsistencyCheckToolWith(service, systemOut, args);
        ArgumentCaptor config = ArgumentCaptor.forClass(Config.class);
        ((ConsistencyCheckService)Mockito.verify((Object)service)).runFullConsistencyCheck((File)Matchers.eq((Object)storeDir), (Config)config.capture(), (ProgressMonitorFactory)Matchers.any(ProgressMonitorFactory.class), (LogProvider)Matchers.any(LogProvider.class), (FileSystemAbstraction)Matchers.any(FileSystemAbstraction.class), Matchers.anyBoolean(), (CheckConsistencyConfig)Matchers.any(CheckConsistencyConfig.class));
        Assert.assertTrue((boolean)((Boolean)((Config)config.getValue()).get(ConsistencyCheckSettings.consistency_check_property_owners)));
    }

    @Test
    public void exitWithFailureIndicatingCorrectUsageIfNoArgumentsSupplied() throws Exception {
        ConsistencyCheckService service = (ConsistencyCheckService)Mockito.mock(ConsistencyCheckService.class);
        String[] args = new String[]{};
        PrintStream systemError = (PrintStream)Mockito.mock(PrintStream.class);
        try {
            this.runConsistencyCheckToolWith(service, systemError, args);
            Assert.fail((String)"should have thrown exception");
        }
        catch (ConsistencyCheckTool.ToolFailureException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"USAGE:"));
        }
    }

    @Test
    public void exitWithFailureIfConfigSpecifiedButConfigFileDoesNotExist() throws Exception {
        File configFile = this.storeDirectory.file("nonexistent_file");
        String[] args = new String[]{this.storeDirectory.directory().getPath(), "-config", configFile.getPath()};
        ConsistencyCheckService service = (ConsistencyCheckService)Mockito.mock(ConsistencyCheckService.class);
        PrintStream systemOut = (PrintStream)Mockito.mock(PrintStream.class);
        try {
            this.runConsistencyCheckToolWith(service, systemOut, args);
            Assert.fail((String)"should have thrown exception");
        }
        catch (ConsistencyCheckTool.ToolFailureException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Could not read configuration file"));
            Assert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(IOException.class));
        }
        Mockito.verifyZeroInteractions((Object[])new Object[]{service});
    }

    @Test(expected=ConsistencyCheckTool.ToolFailureException.class)
    public void failWhenStoreWasNonCleanlyShutdown() throws Exception {
        this.createGraphDbAndKillIt();
        this.runConsistencyCheckToolWith(this.fs.get(), this.storeDirectory.graphDbDir().getAbsolutePath());
    }

    private void createGraphDbAndKillIt() throws Exception {
        GraphDatabaseService db = new TestGraphDatabaseFactory().setFileSystem(this.fs.get()).newImpermanentDatabaseBuilder(this.storeDirectory.graphDbDir()).newGraphDatabase();
        try (Transaction tx = db.beginTx();){
            db.createNode(new Label[]{Label.label((String)"FOO")});
            db.createNode(new Label[]{Label.label((String)"BAR")});
            tx.success();
        }
        this.fs.snapshot(() -> db.shutdown());
    }

    private void runConsistencyCheckToolWith(FileSystemAbstraction fileSystem, String ... args) throws IOException, ConsistencyCheckTool.ToolFailureException {
        new ConsistencyCheckTool((ConsistencyCheckService)Mockito.mock(ConsistencyCheckService.class), fileSystem, (PrintStream)Mockito.mock(PrintStream.class)).run(args);
    }

    private void runConsistencyCheckToolWith(ConsistencyCheckService consistencyCheckService, PrintStream systemError, String ... args) throws ConsistencyCheckTool.ToolFailureException, IOException {
        try (DefaultFileSystemAbstraction fileSystemAbstraction = new DefaultFileSystemAbstraction();){
            new ConsistencyCheckTool(consistencyCheckService, (FileSystemAbstraction)fileSystemAbstraction, systemError).run(args);
        }
    }
}

