/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.consistency.ConsistencyCheckSettings;
import org.neo4j.consistency.checking.GraphStoreFixture;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageEngine;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.Property;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.TestDirectory;

public class ConsistencyCheckServiceIntegrationTest {
    private final GraphStoreFixture fixture = new GraphStoreFixture(this.getRecordFormatName()){

        @Override
        protected void generateInitialData(GraphDatabaseService graphDb) {
            try (Transaction tx = graphDb.beginTx();){
                Node node1 = (Node)Property.set((PropertyContainer)graphDb.createNode(), (Property[])new Property[0]);
                Node node2 = (Node)Property.set((PropertyContainer)graphDb.createNode(), (Property[])new Property[]{Property.property((String)"key", (Object)"exampleValue")});
                node1.createRelationshipTo(node2, RelationshipType.withName((String)"C"));
                tx.success();
            }
        }
    };
    private final TestDirectory testDirectory = TestDirectory.testDirectory();
    @Rule
    public final RuleChain chain = RuleChain.outerRule((TestRule)this.testDirectory).around((TestRule)this.fixture);

    @Test
    public void reportNotUsedRelationshipReferencedInChain() throws Exception {
        this.prepareDbWithDeletedRelationshipPartOfTheChain();
        Date timestamp = new Date();
        ConsistencyCheckService service = new ConsistencyCheckService(timestamp);
        Config configuration = Config.embeddedDefaults(this.settings(new String[0]));
        ConsistencyCheckService.Result result = this.runFullConsistencyCheck(service, configuration);
        Assert.assertFalse((boolean)result.isSuccessful());
        File reportFile = result.reportFile();
        Assert.assertTrue((String)"Consistency check report file should be generated.", (boolean)reportFile.exists());
        Assert.assertThat((String)"Expected to see report about not deleted relationship record present as part of a chain", (Object)Files.readAllLines(reportFile.toPath()).toString(), (Matcher)Matchers.containsString((String)"The relationship record is not in use, but referenced from relationships chain."));
    }

    @Test
    public void shouldSucceedIfStoreIsConsistent() throws Exception {
        Date timestamp = new Date();
        ConsistencyCheckService service = new ConsistencyCheckService(timestamp);
        Config configuration = Config.embeddedDefaults(this.settings(new String[0]));
        ConsistencyCheckService.Result result = this.runFullConsistencyCheck(service, configuration);
        Assert.assertTrue((boolean)result.isSuccessful());
        File reportFile = result.reportFile();
        Assert.assertFalse((String)("Unexpected generation of consistency check report file: " + reportFile), (boolean)reportFile.exists());
    }

    @Test
    public void shouldFailIfTheStoreInNotConsistent() throws Exception {
        this.breakNodeStore();
        Date timestamp = new Date();
        ConsistencyCheckService service = new ConsistencyCheckService(timestamp);
        String logsDir = this.testDirectory.directory().getPath();
        Config configuration = Config.embeddedDefaults(this.settings(GraphDatabaseSettings.logs_directory.name(), logsDir));
        ConsistencyCheckService.Result result = this.runFullConsistencyCheck(service, configuration);
        Assert.assertFalse((boolean)result.isSuccessful());
        String reportFile = String.format("inconsistencies-%s.report", new SimpleDateFormat("yyyy-MM-dd.HH.mm.ss").format(timestamp));
        Assert.assertEquals((Object)new File(logsDir, reportFile), (Object)result.reportFile());
        Assert.assertTrue((String)"Inconsistency report file not generated", (boolean)result.reportFile().exists());
    }

    @Test
    public void shouldNotReportDuplicateForHugeLongValues() throws Exception {
        ConsistencyCheckService service = new ConsistencyCheckService();
        Config configuration = Config.embeddedDefaults(this.settings(new String[0]));
        GraphDatabaseService db = new TestGraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.testDirectory.graphDbDir()).setConfig(GraphDatabaseSettings.record_format, this.getRecordFormatName()).newGraphDatabase();
        String propertyKey = "itemId";
        Label label = Label.label((String)"Item");
        try (Transaction tx = db.beginTx();){
            db.schema().constraintFor(label).assertPropertyIsUnique(propertyKey).create();
            tx.success();
        }
        tx = db.beginTx();
        var7_7 = null;
        try {
            Property.set((PropertyContainer)db.createNode(new Label[]{label}), (Property[])new Property[]{Property.property((String)propertyKey, (Object)973305894188596880L)});
            Property.set((PropertyContainer)db.createNode(new Label[]{label}), (Property[])new Property[]{Property.property((String)propertyKey, (Object)973305894188596864L)});
            tx.success();
        }
        catch (Throwable throwable) {
            var7_7 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var7_7 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var7_7.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        db.shutdown();
        ConsistencyCheckService.Result result = this.runFullConsistencyCheck(service, configuration);
        Assert.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    public void shouldAllowGraphCheckDisabled() throws IOException, ConsistencyCheckIncompleteException {
        GraphDatabaseService gds = this.getGraphDatabaseService();
        try (Transaction tx = gds.beginTx();){
            gds.createNode();
            tx.success();
        }
        gds.shutdown();
        ConsistencyCheckService service = new ConsistencyCheckService();
        Config configuration = Config.embeddedDefaults(this.settings(ConsistencyCheckSettings.consistency_check_graph.name(), "false"));
        ConsistencyCheckService.Result result = this.runFullConsistencyCheck(service, configuration);
        Assert.assertTrue((boolean)result.isSuccessful());
    }

    private GraphDatabaseService getGraphDatabaseService() {
        GraphDatabaseBuilder builder = new TestGraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.testDirectory.absolutePath());
        builder.setConfig(this.settings(new String[0]));
        return builder.newGraphDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareDbWithDeletedRelationshipPartOfTheChain() {
        GraphDatabaseAPI db = (GraphDatabaseAPI)new TestGraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.testDirectory.graphDbDir()).setConfig(GraphDatabaseSettings.record_format, this.getRecordFormatName()).newGraphDatabase();
        try {
            RelationshipType relationshipType = RelationshipType.withName((String)"testRelationshipType");
            try (Transaction tx = db.beginTx();){
                Node node1 = (Node)Property.set((PropertyContainer)db.createNode(), (Property[])new Property[0]);
                Node node2 = (Node)Property.set((PropertyContainer)db.createNode(), (Property[])new Property[]{Property.property((String)"key", (Object)"value")});
                node1.createRelationshipTo(node2, relationshipType);
                node1.createRelationshipTo(node2, relationshipType);
                node1.createRelationshipTo(node2, relationshipType);
                node1.createRelationshipTo(node2, relationshipType);
                node1.createRelationshipTo(node2, relationshipType);
                node1.createRelationshipTo(node2, relationshipType);
                tx.success();
            }
            RecordStorageEngine recordStorageEngine = (RecordStorageEngine)db.getDependencyResolver().resolveDependency(RecordStorageEngine.class);
            NeoStores neoStores = recordStorageEngine.testAccessNeoStores();
            RelationshipStore relationshipStore = neoStores.getRelationshipStore();
            RelationshipRecord relationshipRecord = new RelationshipRecord(-1L);
            RelationshipRecord record = (RelationshipRecord)relationshipStore.getRecord(4L, (AbstractBaseRecord)relationshipRecord, RecordLoad.FORCE);
            record.setInUse(false);
            relationshipStore.updateRecord((AbstractBaseRecord)relationshipRecord);
        }
        finally {
            db.shutdown();
        }
    }

    protected Map<String, String> settings(String ... strings) {
        HashMap<String, String> defaults = new HashMap<String, String>();
        defaults.put(GraphDatabaseSettings.pagecache_memory.name(), "8m");
        defaults.put(GraphDatabaseSettings.record_format.name(), this.getRecordFormatName());
        return MapUtil.stringMap(defaults, (String[])strings);
    }

    private void breakNodeStore() throws TransactionFailureException {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                tx.create(new NodeRecord(next.node(), false, next.relationship(), -1L));
            }
        });
    }

    private ConsistencyCheckService.Result runFullConsistencyCheck(ConsistencyCheckService service, Config configuration) throws ConsistencyCheckIncompleteException, IOException {
        return service.runFullConsistencyCheck(this.fixture.directory(), configuration, ProgressMonitorFactory.NONE, (LogProvider)NullLogProvider.getInstance(), false);
    }

    protected String getRecordFormatName() {
        return "";
    }
}

