/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.mutable.MutableLong;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.logging.NullLogService;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.format.standard.StandardV3_0;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.Randoms;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.unsafe.impl.batchimport.AdditionalInitialIds;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.IdGroupDistribution;
import org.neo4j.unsafe.impl.batchimport.InputIterable;
import org.neo4j.unsafe.impl.batchimport.InputIterator;
import org.neo4j.unsafe.impl.batchimport.ParallelBatchImporter;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdGenerator;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdGenerators;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdMapper;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdMappers;
import org.neo4j.unsafe.impl.batchimport.input.Collector;
import org.neo4j.unsafe.impl.batchimport.input.Collectors;
import org.neo4j.unsafe.impl.batchimport.input.Group;
import org.neo4j.unsafe.impl.batchimport.input.InputEntity;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.input.Inputs;
import org.neo4j.unsafe.impl.batchimport.input.SimpleInputIterator;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.staging.ProcessorAssignmentStrategies;

@RunWith(value=Parameterized.class)
public class ParallelBatchImporterTest {
    @Rule
    public final TestDirectory directory = TestDirectory.testDirectory();
    @Rule
    public final RandomRule random = new RandomRule();
    private static final int NODE_COUNT = 10000;
    private static final int RELATIONSHIPS_PER_NODE = 5;
    private static final int RELATIONSHIP_COUNT = 50000;
    protected final Configuration config = new Configuration.Default(){

        public int batchSize() {
            return 100;
        }

        public int denseNodeThreshold() {
            return 10;
        }

        public int maxNumberOfProcessors() {
            int cores = Runtime.getRuntime().availableProcessors();
            return ParallelBatchImporterTest.this.random.intBetween(cores, cores + 100);
        }
    };
    private final InputIdGenerator inputIdGenerator;
    private final IdMapper idMapper;
    private final IdGenerator idGenerator;
    private final boolean multiPassIterators;
    private static final String[] TOKENS = new String[]{"token1", "token2", "token3", "token4", "token5", "token6", "token7"};

    @Parameterized.Parameters(name="{0},{1},{3}")
    public static Collection<Object[]> data() {
        return Arrays.asList({new LongInputIdGenerator(), IdMappers.longs((NumberArrayFactory)NumberArrayFactory.AUTO), IdGenerators.fromInput(), true}, {new StringInputIdGenerator(), IdMappers.strings((NumberArrayFactory)NumberArrayFactory.AUTO), IdGenerators.startingFromTheBeginning(), true}, {new StringInputIdGenerator(), IdMappers.strings((NumberArrayFactory)NumberArrayFactory.AUTO), IdGenerators.startingFromTheBeginning(), false}, {new LongInputIdGenerator(), IdMappers.longs((NumberArrayFactory)NumberArrayFactory.AUTO), IdGenerators.fromInput(), false});
    }

    public ParallelBatchImporterTest(InputIdGenerator inputIdGenerator, IdMapper idMapper, IdGenerator idGenerator, boolean multiPassIterators) {
        this.multiPassIterators = multiPassIterators;
        this.inputIdGenerator = inputIdGenerator;
        this.idMapper = idMapper;
        this.idGenerator = idGenerator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void shouldImportCsvData() throws Exception {
        Throwable throwable;
        ExecutionMonitor processorAssigner = ProcessorAssignmentStrategies.eagerRandomSaturation((int)this.config.maxNumberOfProcessors());
        ParallelBatchImporter inserter = new ParallelBatchImporter(this.directory.graphDbDir(), (FileSystemAbstraction)new DefaultFileSystemAbstraction(), this.config, (LogService)NullLogService.getInstance(), processorAssigner, AdditionalInitialIds.EMPTY, Config.empty(), this.getFormat());
        boolean successful = false;
        IdGroupDistribution groups = new IdGroupDistribution(10000L, 5, this.random.random());
        long nodeRandomSeed = this.random.nextLong();
        long relationshipRandomSeed = this.random.nextLong();
        try {
            inserter.doImport(Inputs.input(this.nodes(nodeRandomSeed, 10000L, this.inputIdGenerator, groups), this.relationships(relationshipRandomSeed, 50000L, this.inputIdGenerator, groups), (IdMapper)this.idMapper, (IdGenerator)this.idGenerator, (Collector)Collectors.silentBadCollector((int)50000)));
            GraphDatabaseService db = new TestGraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.directory.graphDbDir()).newGraphDatabase();
            try {
                throwable = null;
                try (Transaction tx = db.beginTx();){
                    this.inputIdGenerator.reset();
                    this.verifyData(10000, 50000, db, groups, nodeRandomSeed, relationshipRandomSeed);
                    tx.success();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            finally {
                db.shutdown();
            }
            this.assertConsistent(this.directory.graphDbDir());
            successful = true;
            return;
        }
        finally {
            if (!successful) {
                File failureFile = this.directory.file("input");
                throwable = null;
                try (PrintStream out = new PrintStream(failureFile);){
                    out.println("Seed used in this failing run: " + this.random.seed());
                    out.println(this.inputIdGenerator);
                    this.inputIdGenerator.reset();
                    for (InputNode node : this.nodes(nodeRandomSeed, 10000L, this.inputIdGenerator, groups)) {
                        out.println(node);
                    }
                    for (InputRelationship relationship : this.relationships(relationshipRandomSeed, 50000L, this.inputIdGenerator, groups)) {
                        out.println(relationship);
                    }
                    out.println();
                    out.println("Processor assignments");
                    out.println(processorAssigner.toString());
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                System.err.println("Additional debug information stored in " + failureFile);
            }
        }
    }

    private void assertConsistent(File storeDir) throws ConsistencyCheckIncompleteException, IOException {
        ConsistencyCheckService consistencyChecker = new ConsistencyCheckService();
        ConsistencyCheckService.Result result = consistencyChecker.runFullConsistencyCheck(storeDir, new Config(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.pagecache_memory.name(), "8m"})), ProgressMonitorFactory.NONE, (LogProvider)NullLogProvider.getInstance(), false);
        Assert.assertTrue((String)("Database contains inconsistencies, there should be a report in " + storeDir), (boolean)result.isSuccessful());
    }

    protected RecordFormats getFormat() {
        return StandardV3_0.RECORD_FORMATS;
    }

    protected void verifyData(int nodeCount, int relationshipCount, GraphDatabaseService db, IdGroupDistribution groups, long nodeRandomSeed, long relationshipRandomSeed) {
        try (InputIterator nodes = this.nodes(nodeRandomSeed, nodeCount, this.inputIdGenerator, groups).iterator();
             InputIterator relationships = this.relationships(relationshipRandomSeed, relationshipCount, this.inputIdGenerator, groups).iterator();){
            HashMap<String, Node> nodeByInputId = new HashMap<String, Node>(nodeCount);
            ResourceIterator dbNodes = db.getAllNodes().iterator();
            int verifiedNodes = 0;
            while (nodes.hasNext()) {
                InputNode input = (InputNode)nodes.next();
                Node node = (Node)dbNodes.next();
                this.assertNodeEquals(input, node);
                String inputId = this.uniqueId(input.group(), (PropertyContainer)node);
                Assert.assertNull((Object)nodeByInputId.put(inputId, node));
                ++verifiedNodes;
                this.assertDegrees(node);
            }
            Assert.assertEquals((long)nodeCount, (long)verifiedNodes);
            HashMap<String, Relationship> relationshipByName = new HashMap<String, Relationship>();
            for (Relationship relationship : db.getAllRelationships()) {
                relationshipByName.put((String)relationship.getProperty("id"), relationship);
            }
            int verifiedRelationships = 0;
            while (relationships.hasNext()) {
                InputRelationship input = (InputRelationship)relationships.next();
                if (!this.inputIdGenerator.isMiss(input.startNode()) && !this.inputIdGenerator.isMiss(input.endNode())) {
                    String name = (String)this.propertyOf((InputEntity)input, "id");
                    Relationship relationship = (Relationship)relationshipByName.get(name);
                    Assert.assertNotNull((String)("Expected there to be a relationship with name '" + name + "'"), (Object)relationship);
                    Assert.assertEquals(nodeByInputId.get(this.uniqueId(input.startNodeGroup(), input.startNode())), (Object)relationship.getStartNode());
                    Assert.assertEquals(nodeByInputId.get(this.uniqueId(input.endNodeGroup(), input.endNode())), (Object)relationship.getEndNode());
                    this.assertRelationshipEquals(input, relationship);
                }
                ++verifiedRelationships;
            }
            Assert.assertEquals((long)relationshipCount, (long)verifiedRelationships);
        }
    }

    private void assertDegrees(Node node) {
        for (RelationshipType type : node.getRelationshipTypes()) {
            for (Direction direction : Direction.values()) {
                long degree = node.getDegree(type, direction);
                long actualDegree = Iterables.count((Iterable)node.getRelationships(type, direction));
                Assert.assertEquals((long)actualDegree, (long)degree);
            }
        }
    }

    private String uniqueId(Group group, PropertyContainer entity) {
        return this.uniqueId(group, entity.getProperty("id"));
    }

    private String uniqueId(Group group, Object id) {
        return group.name() + "_" + id;
    }

    private Object propertyOf(InputEntity input, String key) {
        Object[] properties = input.properties();
        for (int i = 0; i < properties.length; ++i) {
            if (!properties[i++].equals(key)) continue;
            return properties[i];
        }
        throw new IllegalStateException(key + " not found on " + input);
    }

    private void assertRelationshipEquals(InputRelationship input, Relationship relationship) {
        this.assertPropertiesEquals((InputEntity)input, (PropertyContainer)relationship);
        Assert.assertEquals((Object)input.type(), (Object)relationship.getType().name());
    }

    private void assertNodeEquals(InputNode input, Node node) {
        this.assertPropertiesEquals((InputEntity)input, (PropertyContainer)node);
        Set expectedLabels = Iterators.asSet((Object[])input.labels());
        for (Label label : node.getLabels()) {
            Assert.assertTrue((boolean)expectedLabels.remove(label.name()));
        }
        Assert.assertTrue((boolean)expectedLabels.isEmpty());
    }

    private void assertPropertiesEquals(InputEntity input, PropertyContainer entity) {
        Object[] properties = input.properties();
        for (int i = 0; i < properties.length; ++i) {
            String key = (String)properties[i++];
            Object value = properties[i];
            this.assertPropertyValueEquals(input, entity, key, value, entity.getProperty(key));
        }
    }

    private void assertPropertyValueEquals(InputEntity input, PropertyContainer entity, String key, Object expected, Object array) {
        if (expected.getClass().isArray()) {
            int length = Array.getLength(expected);
            Assert.assertEquals((String)(input + ", " + entity), (long)length, (long)Array.getLength(array));
            for (int i = 0; i < length; ++i) {
                this.assertPropertyValueEquals(input, entity, key, Array.get(expected, i), Array.get(array, i));
            }
        } else {
            Assert.assertEquals((String)(input + ", " + entity + " for key:" + key), (Object)expected, (Object)array);
        }
    }

    private InputIterable<InputRelationship> relationships(final long randomSeed, final long count, final InputIdGenerator idGenerator, final IdGroupDistribution groups) {
        return new InputIterable<InputRelationship>(){
            private int calls;

            public InputIterator<InputRelationship> iterator() {
                ++this.calls;
                Assert.assertTrue((String)("Unexpected use of input iterator " + ParallelBatchImporterTest.this.multiPassIterators + ", " + this.calls), (ParallelBatchImporterTest.this.multiPassIterators || !ParallelBatchImporterTest.this.multiPassIterators && this.calls == 1 ? 1 : 0) != 0);
                return new SimpleInputIterator<InputRelationship>("test relationships"){
                    private final Random random;
                    private final Randoms randoms;
                    private int cursor;
                    private final MutableLong nodeIndex;
                    {
                        this.random = new Random(randomSeed);
                        this.randoms = new Randoms(this.random, Randoms.DEFAULT);
                        this.nodeIndex = new MutableLong(-1L);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected InputRelationship fetchNextOrNull() {
                        if ((long)this.cursor < count) {
                            Object[] properties = ParallelBatchImporterTest.this.randomProperties(this.randoms, "Name " + this.cursor);
                            try {
                                Object startNode = idGenerator.randomExisting(this.random, this.nodeIndex);
                                Group startNodeGroup = groups.groupOf(this.nodeIndex.longValue());
                                Object endNode = idGenerator.randomExisting(this.random, this.nodeIndex);
                                Group endNodeGroup = groups.groupOf(this.nodeIndex.longValue());
                                startNode = idGenerator.miss(this.random, startNode, 0.001f);
                                endNode = idGenerator.miss(this.random, endNode, 0.001f);
                                String type = idGenerator.randomType(this.random);
                                if ((double)this.random.nextFloat() < 5.0E-5) {
                                    type = type + "_odd";
                                }
                                InputRelationship inputRelationship = new InputRelationship(this.sourceDescription, (long)this.itemNumber, (long)this.itemNumber, properties, null, startNodeGroup, startNode, endNodeGroup, endNode, type, null);
                                return inputRelationship;
                            }
                            finally {
                                ++this.cursor;
                            }
                        }
                        return null;
                    }
                };
            }

            public boolean supportsMultiplePasses() {
                return ParallelBatchImporterTest.this.multiPassIterators;
            }
        };
    }

    private InputIterable<InputNode> nodes(final long randomSeed, final long count, final InputIdGenerator inputIdGenerator, final IdGroupDistribution groups) {
        return new InputIterable<InputNode>(){
            private int calls;

            public InputIterator<InputNode> iterator() {
                ++this.calls;
                Assert.assertTrue((String)("Unexpected use of input iterator " + ParallelBatchImporterTest.this.multiPassIterators + ", " + this.calls), (ParallelBatchImporterTest.this.multiPassIterators || !ParallelBatchImporterTest.this.multiPassIterators && this.calls == 1 ? 1 : 0) != 0);
                return new SimpleInputIterator<InputNode>("test nodes"){
                    private final Random random;
                    private final Randoms randoms;
                    private int cursor;
                    {
                        this.random = new Random(randomSeed);
                        this.randoms = new Randoms(this.random, Randoms.DEFAULT);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected InputNode fetchNextOrNull() {
                        if ((long)this.cursor < count) {
                            Object nodeId = inputIdGenerator.nextNodeId(this.random);
                            Object[] properties = ParallelBatchImporterTest.this.randomProperties(this.randoms, nodeId);
                            String[] labels = (String[])this.randoms.selection((Object[])TOKENS, 0, TOKENS.length, true);
                            try {
                                Group group = groups.groupOf(this.cursor);
                                InputNode inputNode = new InputNode(this.sourceDescription, (long)this.itemNumber, (long)this.itemNumber, group, nodeId, properties, null, labels, null);
                                return inputNode;
                            }
                            finally {
                                ++this.cursor;
                            }
                        }
                        return null;
                    }
                };
            }

            public boolean supportsMultiplePasses() {
                return ParallelBatchImporterTest.this.multiPassIterators;
            }
        };
    }

    private Object[] randomProperties(Randoms randoms, Object id) {
        String[] keys = (String[])randoms.selection((Object[])TOKENS, 0, TOKENS.length, false);
        Object[] properties = new Object[(keys.length + 1) * 2];
        for (int i = 0; i < keys.length; ++i) {
            properties[i * 2] = keys[i];
            properties[i * 2 + 1] = randoms.propertyValue();
        }
        properties[properties.length - 2] = "id";
        properties[properties.length - 1] = id;
        return properties;
    }

    private static class StringInputIdGenerator
    extends InputIdGenerator {
        private final byte[] randomBytes = new byte[10];
        private final List<String> strings = new ArrayList<String>();

        private StringInputIdGenerator() {
        }

        @Override
        void reset() {
            this.strings.clear();
        }

        @Override
        Object nextNodeId(Random random) {
            random.nextBytes(this.randomBytes);
            String result = UUID.nameUUIDFromBytes(this.randomBytes).toString();
            this.strings.add(result);
            return result;
        }

        @Override
        Object randomExisting(Random random, MutableLong nodeIndex) {
            int index = random.nextInt(this.strings.size());
            nodeIndex.setValue((long)index);
            return this.strings.get(index);
        }

        @Override
        Object miss(Random random, Object id, float chance) {
            return random.nextFloat() < chance ? "_" + id : id;
        }

        @Override
        boolean isMiss(Object id) {
            return ((String)id).startsWith("_");
        }
    }

    private static class LongInputIdGenerator
    extends InputIdGenerator {
        private volatile int id;

        private LongInputIdGenerator() {
        }

        @Override
        void reset() {
            this.id = 0;
        }

        @Override
        Object nextNodeId(Random random) {
            return (long)this.id++;
        }

        @Override
        Object randomExisting(Random random, MutableLong nodeIndex) {
            long index = random.nextInt(10000);
            nodeIndex.setValue(index);
            return index;
        }

        @Override
        Object miss(Random random, Object id, float chance) {
            return random.nextFloat() < chance ? Long.valueOf((Long)id + 100000000L) : id;
        }

        @Override
        boolean isMiss(Object id) {
            return (Long)id >= 100000000L;
        }
    }

    public static abstract class InputIdGenerator {
        abstract void reset();

        abstract Object nextNodeId(Random var1);

        abstract Object randomExisting(Random var1, MutableLong var2);

        abstract Object miss(Random var1, Object var2, float var3);

        abstract boolean isMiss(Object var1);

        String randomType(Random random) {
            return "TYPE" + random.nextInt(3);
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }
}

