/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.store;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.neo4j.consistency.checking.CheckerEngine;
import org.neo4j.consistency.checking.ComparativeRecordChecker;
import org.neo4j.consistency.checking.cache.CacheAccess;
import org.neo4j.consistency.checking.cache.CacheTask;
import org.neo4j.consistency.checking.cache.DefaultCacheAccess;
import org.neo4j.consistency.checking.full.CheckStage;
import org.neo4j.consistency.checking.full.MultiPassStore;
import org.neo4j.consistency.checking.full.Stage;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.report.PendingReferenceCheck;
import org.neo4j.consistency.statistics.Counts;
import org.neo4j.consistency.store.DirectRecordReference;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.consistency.store.RecordReference;
import org.neo4j.helpers.ArrayUtil;
import org.neo4j.helpers.collection.IterableWrapper;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NeoStoreRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;

public class RecordAccessStub
implements RecordAccess {
    public static final int SCHEMA_RECORD_TYPE = 255;
    private final Queue<Runnable> deferredTasks = new LinkedList<Runnable>();
    private final Map<Long, Delta<DynamicRecord>> schemata = new HashMap<Long, Delta<DynamicRecord>>();
    private final Map<Long, Delta<NodeRecord>> nodes = new HashMap<Long, Delta<NodeRecord>>();
    private final Map<Long, Delta<RelationshipRecord>> relationships = new HashMap<Long, Delta<RelationshipRecord>>();
    private final Map<Long, Delta<PropertyRecord>> properties = new HashMap<Long, Delta<PropertyRecord>>();
    private final Map<Long, Delta<DynamicRecord>> strings = new HashMap<Long, Delta<DynamicRecord>>();
    private final Map<Long, Delta<DynamicRecord>> arrays = new HashMap<Long, Delta<DynamicRecord>>();
    private final Map<Long, Delta<RelationshipTypeTokenRecord>> relationshipTypeTokens = new HashMap<Long, Delta<RelationshipTypeTokenRecord>>();
    private final Map<Long, Delta<LabelTokenRecord>> labelTokens = new HashMap<Long, Delta<LabelTokenRecord>>();
    private final Map<Long, Delta<PropertyKeyTokenRecord>> propertyKeyTokens = new HashMap<Long, Delta<PropertyKeyTokenRecord>>();
    private final Map<Long, Delta<DynamicRecord>> relationshipTypeNames = new HashMap<Long, Delta<DynamicRecord>>();
    private final Map<Long, Delta<DynamicRecord>> nodeDynamicLabels = new HashMap<Long, Delta<DynamicRecord>>();
    private final Map<Long, Delta<DynamicRecord>> labelNames = new HashMap<Long, Delta<DynamicRecord>>();
    private final Map<Long, Delta<DynamicRecord>> propertyKeyNames = new HashMap<Long, Delta<DynamicRecord>>();
    private final Map<Long, Delta<RelationshipGroupRecord>> relationshipGroups = new HashMap<Long, Delta<RelationshipGroupRecord>>();
    private Delta<NeoStoreRecord> graph;
    private final CacheAccess cacheAccess = new DefaultCacheAccess(Counts.NONE, 1);
    private final MultiPassStore[] storesToCheck;

    public <RECORD extends AbstractBaseRecord, REPORT extends ConsistencyReport> CheckerEngine<RECORD, REPORT> engine(final RECORD record, REPORT report) {
        return new Engine<RECORD, REPORT>(report){

            @Override
            void checkReference(ComparativeRecordChecker checker, AbstractBaseRecord oldReference, AbstractBaseRecord newReference) {
                checker.checkReference(record, newReference, (CheckerEngine)this, (RecordAccess)RecordAccessStub.this);
            }
        };
    }

    public <RECORD extends AbstractBaseRecord, REPORT extends ConsistencyReport> CheckerEngine<RECORD, REPORT> engine(RECORD oldRecord, final RECORD newRecord, REPORT report) {
        return new Engine<RECORD, REPORT>(report){

            @Override
            void checkReference(ComparativeRecordChecker checker, AbstractBaseRecord oldReference, AbstractBaseRecord newReference) {
                checker.checkReference(newRecord, newReference, (CheckerEngine)this, (RecordAccess)RecordAccessStub.this);
            }
        };
    }

    public void checkDeferred() {
        Runnable task;
        while (null != (task = this.deferredTasks.poll())) {
            task.run();
        }
    }

    public RecordAccessStub() {
        this(Stage.SEQUENTIAL_FORWARD, MultiPassStore.values());
    }

    public RecordAccessStub(Stage stage, MultiPassStore ... storesToCheck) {
        this.storesToCheck = storesToCheck;
        if (stage.getCacheSlotSizes().length > 0) {
            this.cacheAccess.setCacheSlotSizes(stage.getCacheSlotSizes());
        }
    }

    public void populateCache() {
        CacheTask.CacheNextRel action = new CacheTask.CacheNextRel((Stage)CheckStage.Stage3_NS_NextRel, this.cacheAccess, Iterables.resourceIterable((Iterable)new IterableWrapper<NodeRecord, Delta<NodeRecord>>(this.nodes.values()){

            protected NodeRecord underlyingObjectToObject(Delta<NodeRecord> node) {
                return (NodeRecord)node.newRecord;
            }
        }));
        action.run();
    }

    private static <R extends AbstractBaseRecord> R add(Map<Long, Delta<R>> records, R record) {
        records.put(record.getId(), new Delta<R>(record));
        return record;
    }

    private static <R extends AbstractBaseRecord> void add(Map<Long, Delta<R>> records, R oldRecord, R newRecord) {
        records.put(newRecord.getId(), new Delta<R>(oldRecord, newRecord));
    }

    public DynamicRecord addSchema(DynamicRecord schema) {
        return RecordAccessStub.add(this.schemata, schema);
    }

    public DynamicRecord addString(DynamicRecord string) {
        return RecordAccessStub.add(this.strings, string);
    }

    public DynamicRecord addArray(DynamicRecord array) {
        return RecordAccessStub.add(this.arrays, array);
    }

    public DynamicRecord addNodeDynamicLabels(DynamicRecord array) {
        return RecordAccessStub.add(this.nodeDynamicLabels, array);
    }

    public DynamicRecord addPropertyKeyName(DynamicRecord name) {
        return RecordAccessStub.add(this.propertyKeyNames, name);
    }

    public DynamicRecord addRelationshipTypeName(DynamicRecord name) {
        return RecordAccessStub.add(this.relationshipTypeNames, name);
    }

    public DynamicRecord addLabelName(DynamicRecord name) {
        return RecordAccessStub.add(this.labelNames, name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <R extends AbstractBaseRecord> R addChange(R oldRecord, R newRecord) {
        if (newRecord instanceof NodeRecord) {
            RecordAccessStub.add(this.nodes, (NodeRecord)oldRecord, (NodeRecord)newRecord);
            return newRecord;
        } else if (newRecord instanceof RelationshipRecord) {
            RecordAccessStub.add(this.relationships, (RelationshipRecord)oldRecord, (RelationshipRecord)newRecord);
            return newRecord;
        } else if (newRecord instanceof PropertyRecord) {
            RecordAccessStub.add(this.properties, (PropertyRecord)oldRecord, (PropertyRecord)newRecord);
            return newRecord;
        } else if (newRecord instanceof DynamicRecord) {
            DynamicRecord dyn = (DynamicRecord)newRecord;
            if (dyn.getType() == PropertyType.STRING.intValue()) {
                RecordAccessStub.add(this.strings, (DynamicRecord)oldRecord, dyn);
                return newRecord;
            } else if (dyn.getType() == PropertyType.ARRAY.intValue()) {
                RecordAccessStub.add(this.arrays, (DynamicRecord)oldRecord, dyn);
                return newRecord;
            } else {
                if (dyn.getType() != 255) throw new IllegalArgumentException("Invalid dynamic record type");
                RecordAccessStub.add(this.schemata, (DynamicRecord)oldRecord, dyn);
            }
            return newRecord;
        } else if (newRecord instanceof RelationshipTypeTokenRecord) {
            RecordAccessStub.add(this.relationshipTypeTokens, (RelationshipTypeTokenRecord)oldRecord, (RelationshipTypeTokenRecord)newRecord);
            return newRecord;
        } else if (newRecord instanceof PropertyKeyTokenRecord) {
            RecordAccessStub.add(this.propertyKeyTokens, (PropertyKeyTokenRecord)oldRecord, (PropertyKeyTokenRecord)newRecord);
            return newRecord;
        } else {
            if (!(newRecord instanceof NeoStoreRecord)) throw new IllegalArgumentException("Invalid record type");
            this.graph = new Delta<NeoStoreRecord>((NeoStoreRecord)oldRecord, (NeoStoreRecord)newRecord);
        }
        return newRecord;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <R extends AbstractBaseRecord> R add(R record) {
        if (record instanceof NodeRecord) {
            RecordAccessStub.add(this.nodes, (NodeRecord)record);
            return record;
        } else if (record instanceof RelationshipRecord) {
            RecordAccessStub.add(this.relationships, (RelationshipRecord)record);
            return record;
        } else if (record instanceof PropertyRecord) {
            RecordAccessStub.add(this.properties, (PropertyRecord)record);
            return record;
        } else if (record instanceof DynamicRecord) {
            DynamicRecord dyn = (DynamicRecord)record;
            if (dyn.getType() == PropertyType.STRING.intValue()) {
                this.addString(dyn);
                return record;
            } else if (dyn.getType() == PropertyType.ARRAY.intValue()) {
                this.addArray(dyn);
                return record;
            } else {
                if (dyn.getType() != 255) throw new IllegalArgumentException("Invalid dynamic record type");
                this.addSchema(dyn);
            }
            return record;
        } else if (record instanceof RelationshipTypeTokenRecord) {
            RecordAccessStub.add(this.relationshipTypeTokens, (RelationshipTypeTokenRecord)record);
            return record;
        } else if (record instanceof PropertyKeyTokenRecord) {
            RecordAccessStub.add(this.propertyKeyTokens, (PropertyKeyTokenRecord)record);
            return record;
        } else if (record instanceof LabelTokenRecord) {
            RecordAccessStub.add(this.labelTokens, (LabelTokenRecord)record);
            return record;
        } else if (record instanceof NeoStoreRecord) {
            this.graph = new Delta<NeoStoreRecord>((NeoStoreRecord)record);
            return record;
        } else {
            if (!(record instanceof RelationshipGroupRecord)) throw new IllegalArgumentException("Invalid record type");
            RecordAccessStub.add(this.relationshipGroups, (RelationshipGroupRecord)record);
        }
        return record;
    }

    private <R extends AbstractBaseRecord> DirectRecordReference<R> reference(Map<Long, Delta<R>> records, long id, Version version) {
        return new DirectRecordReference(RecordAccessStub.record(records, id, version), (RecordAccess)this);
    }

    private static <R extends AbstractBaseRecord> R record(Map<Long, Delta<R>> records, long id, Version version) {
        Delta<R> delta = records.get(id);
        if (delta == null) {
            if (version == Version.NEW) {
                return null;
            }
            throw new AssertionError((Object)String.format("Access to record with id=%d not expected.", id));
        }
        return version.get(delta);
    }

    public RecordReference<DynamicRecord> schema(long id) {
        return this.reference(this.schemata, id, Version.LATEST);
    }

    public RecordReference<NodeRecord> node(long id) {
        return this.reference(this.nodes, id, Version.LATEST);
    }

    public RecordReference<RelationshipRecord> relationship(long id) {
        return this.reference(this.relationships, id, Version.LATEST);
    }

    public RecordReference<PropertyRecord> property(long id) {
        return this.reference(this.properties, id, Version.LATEST);
    }

    public Iterator<PropertyRecord> rawPropertyChain(final long firstId) {
        return new PrefetchingIterator<PropertyRecord>(){
            private long next;
            {
                this.next = firstId;
            }

            protected PropertyRecord fetchNextOrNull() {
                if (Record.NO_NEXT_PROPERTY.is(this.next)) {
                    return null;
                }
                PropertyRecord record = (PropertyRecord)RecordAccessStub.this.reference(RecordAccessStub.this.properties, this.next, Version.LATEST).record();
                this.next = record.getNextProp();
                return record;
            }
        };
    }

    public RecordReference<RelationshipTypeTokenRecord> relationshipType(int id) {
        return this.reference(this.relationshipTypeTokens, id, Version.LATEST);
    }

    public RecordReference<PropertyKeyTokenRecord> propertyKey(int id) {
        return this.reference(this.propertyKeyTokens, id, Version.LATEST);
    }

    public RecordReference<DynamicRecord> string(long id) {
        return this.reference(this.strings, id, Version.LATEST);
    }

    public RecordReference<DynamicRecord> array(long id) {
        return this.reference(this.arrays, id, Version.LATEST);
    }

    public RecordReference<DynamicRecord> relationshipTypeName(int id) {
        return this.reference(this.relationshipTypeNames, id, Version.LATEST);
    }

    public RecordReference<DynamicRecord> nodeLabels(long id) {
        return this.reference(this.nodeDynamicLabels, id, Version.LATEST);
    }

    public RecordReference<LabelTokenRecord> label(int id) {
        return this.reference(this.labelTokens, id, Version.LATEST);
    }

    public RecordReference<DynamicRecord> labelName(int id) {
        return this.reference(this.labelNames, id, Version.LATEST);
    }

    public RecordReference<DynamicRecord> propertyKeyName(int id) {
        return this.reference(this.propertyKeyNames, id, Version.LATEST);
    }

    public RecordReference<NeoStoreRecord> graph() {
        return this.reference(Collections.singletonMap(-1L, this.graph), -1L, Version.LATEST);
    }

    public RecordReference<RelationshipGroupRecord> relationshipGroup(long id) {
        return this.reference(this.relationshipGroups, id, Version.LATEST);
    }

    public boolean shouldCheck(long id, MultiPassStore store) {
        return ArrayUtil.contains((Object[])this.storesToCheck, (Object)store);
    }

    public CacheAccess cacheAccess() {
        return this.cacheAccess;
    }

    private static enum Version {
        PREV{

            @Override
            <R extends AbstractBaseRecord> R get(Delta<R> delta) {
                return delta.oldRecord == null ? delta.newRecord : delta.oldRecord;
            }
        }
        ,
        LATEST{

            @Override
            <R extends AbstractBaseRecord> R get(Delta<R> delta) {
                return delta.newRecord;
            }
        }
        ,
        NEW{

            @Override
            <R extends AbstractBaseRecord> R get(Delta<R> delta) {
                return delta.oldRecord == null ? null : (R)delta.newRecord;
            }
        };


        abstract <R extends AbstractBaseRecord> R get(Delta<R> var1);
    }

    private static class Delta<R extends AbstractBaseRecord> {
        final R oldRecord;
        final R newRecord;

        Delta(R record) {
            this.oldRecord = null;
            this.newRecord = record;
        }

        Delta(R oldRecord, R newRecord) {
            this.oldRecord = oldRecord;
            this.newRecord = newRecord;
        }
    }

    private static class DeferredReferenceCheck
    implements Answer<Void> {
        private final Engine dispatch;
        private final ComparativeRecordChecker checker;

        DeferredReferenceCheck(Engine dispatch, ComparativeRecordChecker checker) {
            this.dispatch = dispatch;
            this.checker = checker;
        }

        public Void answer(InvocationOnMock invocation) throws Throwable {
            AbstractBaseRecord newReference;
            Object[] arguments = invocation.getArguments();
            AbstractBaseRecord oldReference = null;
            if (arguments.length == 3) {
                oldReference = (AbstractBaseRecord)arguments[0];
                newReference = (AbstractBaseRecord)arguments[1];
            } else {
                newReference = (AbstractBaseRecord)arguments[0];
            }
            this.dispatch.checkReference(this.checker, oldReference, newReference);
            return null;
        }
    }

    private static abstract class Engine<RECORD extends AbstractBaseRecord, REPORT extends ConsistencyReport>
    implements CheckerEngine<RECORD, REPORT> {
        private final REPORT report;
        final /* synthetic */ RecordAccessStub this$0;

        protected Engine(REPORT report) {
            this.this$0 = var1_1;
            this.report = report;
        }

        public <REFERRED extends AbstractBaseRecord> void comparativeCheck(final RecordReference<REFERRED> other, final ComparativeRecordChecker<RECORD, ? super REFERRED, REPORT> checker) {
            this.this$0.deferredTasks.add(new Runnable(){

                @Override
                public void run() {
                    PendingReferenceCheck mock = (PendingReferenceCheck)Mockito.mock(PendingReferenceCheck.class);
                    DeferredReferenceCheck check = new DeferredReferenceCheck(Engine.this, checker);
                    ((PendingReferenceCheck)Mockito.doAnswer((Answer)check).when((Object)mock)).checkReference((AbstractBaseRecord)Matchers.any(AbstractBaseRecord.class), (RecordAccess)Matchers.any(RecordAccess.class));
                    ((PendingReferenceCheck)Mockito.doAnswer((Answer)check).when((Object)mock)).checkDiffReference((AbstractBaseRecord)Matchers.any(AbstractBaseRecord.class), (AbstractBaseRecord)Matchers.any(AbstractBaseRecord.class), (RecordAccess)Matchers.any(RecordAccess.class));
                    other.dispatch(mock);
                }
            });
        }

        public REPORT report() {
            return this.report;
        }

        abstract void checkReference(ComparativeRecordChecker var1, AbstractBaseRecord var2, AbstractBaseRecord var3);
    }
}

