/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.statistics;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.consistency.statistics.Counts;
import org.neo4j.consistency.statistics.DefaultCounts;

public class DefaultCountsTest {
    @Test
    public void shouldCountPerThread() throws Exception {
        DefaultCounts counts = new DefaultCounts(3);
        counts.incAndGet(Counts.Type.activeCache, 0);
        counts.incAndGet(Counts.Type.activeCache, 1);
        counts.incAndGet(Counts.Type.backLinks, 2);
        Assert.assertEquals((long)2L, (long)counts.sum(Counts.Type.activeCache));
        Assert.assertEquals((long)1L, (long)counts.sum(Counts.Type.backLinks));
        Assert.assertEquals((long)0L, (long)counts.sum(Counts.Type.clearCache));
    }

    @Test
    public void shouldResetCounts() throws Exception {
        DefaultCounts counts = new DefaultCounts(2);
        counts.incAndGet(Counts.Type.activeCache, 0);
        Assert.assertEquals((long)1L, (long)counts.sum(Counts.Type.activeCache));
        counts.reset();
        Assert.assertEquals((long)0L, (long)counts.sum(Counts.Type.activeCache));
    }
}

