/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.report;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.junit.runners.Suite;
import org.junit.runners.model.Statement;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.neo4j.consistency.RecordType;
import org.neo4j.consistency.checking.CheckerEngine;
import org.neo4j.consistency.checking.ComparativeRecordChecker;
import org.neo4j.consistency.checking.RecordCheck;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.report.ConsistencyReporter;
import org.neo4j.consistency.report.ConsistencySummaryStatistics;
import org.neo4j.consistency.report.InconsistencyLogger;
import org.neo4j.consistency.report.InconsistencyReport;
import org.neo4j.consistency.report.PendingReferenceCheck;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.consistency.store.RecordReference;
import org.neo4j.consistency.store.synthetic.CountsEntry;
import org.neo4j.consistency.store.synthetic.IndexEntry;
import org.neo4j.consistency.store.synthetic.LabelScanDocument;
import org.neo4j.kernel.api.impl.labelscan.LuceneNodeLabelRange;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.labelscan.NodeLabelRange;
import org.neo4j.kernel.impl.store.counts.keys.CountsKey;
import org.neo4j.kernel.impl.store.counts.keys.CountsKeyFactory;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NeoStoreRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.storageengine.api.schema.SchemaRule;

@RunWith(value=Suite.class)
@Suite.SuiteClasses(value={TestAllReportMessages.class, TestReportLifecycle.class})
public class ConsistencyReporterTest {
    private static Matcher<String> hasExpectedFormat() {
        return new TypeSafeMatcher<String>(){

            public boolean matchesSafely(String item) {
                return item.trim().split(" ").length > 1;
            }

            public void describeTo(Description description) {
                description.appendText("message of valid format");
            }
        };
    }

    @RunWith(value=Parameterized.class)
    public static class TestAllReportMessages
    implements Answer {
        private final Method reportMethod;
        private final Method method;
        @Rule
        public final TestRule logFailure = new TestRule(){

            public Statement apply(final Statement base, org.junit.runner.Description description) {
                return new Statement(){

                    public void evaluate() throws Throwable {
                        try {
                            base.evaluate();
                        }
                        catch (Throwable failure) {
                            System.err.println("Failure in " + this + ": " + failure);
                            throw failure;
                        }
                    }
                };
            }
        };

        @Test
        public void shouldLogInconsistency() throws Exception {
            InconsistencyReport report = (InconsistencyReport)Mockito.mock(InconsistencyReport.class);
            ConsistencyReporter reporter = new ConsistencyReporter((RecordAccess)Mockito.mock(RecordAccess.class), report);
            this.reportMethod.invoke((Object)reporter, this.parameters(this.reportMethod));
            if (this.method.getAnnotation(ConsistencyReport.Warning.class) == null) {
                if (this.reportMethod.getName().endsWith("Change")) {
                    ((InconsistencyReport)Mockito.verify((Object)report)).error((RecordType)Matchers.any(RecordType.class), (AbstractBaseRecord)Matchers.any(AbstractBaseRecord.class), (AbstractBaseRecord)Matchers.any(AbstractBaseRecord.class), (String)Matchers.argThat((Matcher)ConsistencyReporterTest.hasExpectedFormat()), (Object[])Matchers.any(Object[].class));
                } else {
                    ((InconsistencyReport)Mockito.verify((Object)report)).error((RecordType)Matchers.any(RecordType.class), (AbstractBaseRecord)Matchers.any(AbstractBaseRecord.class), (String)Matchers.argThat((Matcher)ConsistencyReporterTest.hasExpectedFormat()), (Object[])Matchers.any(Object[].class));
                }
            } else if (this.reportMethod.getName().endsWith("Change")) {
                ((InconsistencyReport)Mockito.verify((Object)report)).warning((RecordType)Matchers.any(RecordType.class), (AbstractBaseRecord)Matchers.any(AbstractBaseRecord.class), (AbstractBaseRecord)Matchers.any(AbstractBaseRecord.class), (String)Matchers.argThat((Matcher)ConsistencyReporterTest.hasExpectedFormat()), (Object[])Matchers.any(Object[].class));
            } else {
                ((InconsistencyReport)Mockito.verify((Object)report)).warning((RecordType)Matchers.any(RecordType.class), (AbstractBaseRecord)Matchers.any(AbstractBaseRecord.class), (String)Matchers.argThat((Matcher)ConsistencyReporterTest.hasExpectedFormat()), (Object[])Matchers.any(Object[].class));
            }
        }

        public TestAllReportMessages(Method reportMethod, Method method) {
            this.reportMethod = reportMethod;
            this.method = method;
        }

        @Parameterized.Parameters(name="{1}")
        public static List<Object[]> methods() {
            ArrayList<Object[]> methods = new ArrayList<Object[]>();
            for (Method reporterMethod : ConsistencyReport.Reporter.class.getMethods()) {
                Type[] parameterTypes = reporterMethod.getGenericParameterTypes();
                ParameterizedType checkerParameter = (ParameterizedType)parameterTypes[parameterTypes.length - 1];
                Class reportType = (Class)checkerParameter.getActualTypeArguments()[1];
                for (Method method : reportType.getMethods()) {
                    methods.add(new Object[]{reporterMethod, method});
                }
            }
            return methods;
        }

        public String toString() {
            return String.format("report.%s( %s{ reporter.%s(); } )", this.reportMethod.getName(), TestAllReportMessages.signatureOf(this.reportMethod), this.method.getName());
        }

        private static String signatureOf(Method reportMethod) {
            if (reportMethod.getParameterTypes().length == 2) {
                return "record, RecordCheck( reporter )";
            }
            return "oldRecord, newRecord, RecordCheck( reporter )";
        }

        private Object[] parameters(Method method) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            Object[] parameters = new Object[parameterTypes.length];
            for (int i = 0; i < parameters.length; ++i) {
                parameters[i] = this.parameter(parameterTypes[i]);
            }
            return parameters;
        }

        private Object parameter(Class<?> type) {
            if (type == RecordType.class) {
                return RecordType.STRING_PROPERTY;
            }
            if (type == RecordCheck.class) {
                return this.mockChecker();
            }
            if (type == NodeRecord.class) {
                return new NodeRecord(0L, false, 1L, 2L);
            }
            if (type == RelationshipRecord.class) {
                return new RelationshipRecord(0L, 1L, 2L, 3);
            }
            if (type == PropertyRecord.class) {
                return new PropertyRecord(0L);
            }
            if (type == PropertyKeyTokenRecord.class) {
                return new PropertyKeyTokenRecord(0);
            }
            if (type == PropertyBlock.class) {
                return new PropertyBlock();
            }
            if (type == RelationshipTypeTokenRecord.class) {
                return new RelationshipTypeTokenRecord(0);
            }
            if (type == LabelTokenRecord.class) {
                return new LabelTokenRecord(0);
            }
            if (type == DynamicRecord.class) {
                return new DynamicRecord(0L);
            }
            if (type == NeoStoreRecord.class) {
                return new NeoStoreRecord();
            }
            if (type == LabelScanDocument.class) {
                return new LabelScanDocument((NodeLabelRange)new LuceneNodeLabelRange(0, new long[0], (long[][])new long[0][]));
            }
            if (type == IndexEntry.class) {
                return new IndexEntry(0L);
            }
            if (type == CountsEntry.class) {
                return new CountsEntry((CountsKey)CountsKeyFactory.nodeKey((int)7), 42L);
            }
            if (type == SchemaRule.Kind.class) {
                return SchemaRule.Kind.INDEX_RULE;
            }
            if (type == IndexRule.class) {
                return IndexRule.indexRule((long)1L, (int)2, (int)3, (SchemaIndexProvider.Descriptor)new SchemaIndexProvider.Descriptor("provider", "version"));
            }
            if (type == RelationshipGroupRecord.class) {
                return new RelationshipGroupRecord(0L, 1);
            }
            if (type == Long.TYPE) {
                return 12L;
            }
            if (type == Object.class) {
                return "object";
            }
            throw new IllegalArgumentException(String.format("Don't know how to provide parameter of type %s", type.getName()));
        }

        private RecordCheck mockChecker() {
            RecordCheck checker = (RecordCheck)Mockito.mock(RecordCheck.class);
            ((RecordCheck)Mockito.doAnswer((Answer)this).when((Object)checker)).check((AbstractBaseRecord)Matchers.any(AbstractBaseRecord.class), (CheckerEngine)Matchers.any(CheckerEngine.class), (RecordAccess)Matchers.any(RecordAccess.class));
            return checker;
        }

        public Object answer(InvocationOnMock invocation) throws Throwable {
            Object[] arguments = invocation.getArguments();
            ConsistencyReport report = ((CheckerEngine)arguments[arguments.length - 2]).report();
            try {
                return this.method.invoke((Object)report, this.parameters(this.method));
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalArgumentException(String.format("%s.%s#%s(...)", report, this.method.getDeclaringClass().getSimpleName(), this.method.getName()), ex);
            }
        }
    }

    public static class TestReportLifecycle {
        @Test
        public void shouldSummarizeStatisticsAfterCheck() {
            ConsistencySummaryStatistics summary = (ConsistencySummaryStatistics)Mockito.mock(ConsistencySummaryStatistics.class);
            RecordAccess records = (RecordAccess)Mockito.mock(RecordAccess.class);
            ConsistencyReporter.ReportHandler handler = new ConsistencyReporter.ReportHandler(new InconsistencyReport((InconsistencyLogger)Mockito.mock(InconsistencyLogger.class), summary), (ConsistencyReporter.ProxyFactory)Mockito.mock(ConsistencyReporter.ProxyFactory.class), RecordType.PROPERTY, records, (AbstractBaseRecord)new PropertyRecord(0L), ConsistencyReporter.NO_MONITOR);
            handler.updateSummary();
            ((ConsistencySummaryStatistics)Mockito.verify((Object)summary)).update(RecordType.PROPERTY, 0, 0);
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{summary});
        }

        @Test
        public void shouldOnlySummarizeStatisticsWhenAllReferencesAreChecked() {
            ConsistencySummaryStatistics summary = (ConsistencySummaryStatistics)Mockito.mock(ConsistencySummaryStatistics.class);
            RecordAccess records = (RecordAccess)Mockito.mock(RecordAccess.class);
            ConsistencyReporter.ReportHandler handler = new ConsistencyReporter.ReportHandler(new InconsistencyReport((InconsistencyLogger)Mockito.mock(InconsistencyLogger.class), summary), (ConsistencyReporter.ProxyFactory)Mockito.mock(ConsistencyReporter.ProxyFactory.class), RecordType.PROPERTY, records, (AbstractBaseRecord)new PropertyRecord(0L), ConsistencyReporter.NO_MONITOR);
            RecordReference reference = (RecordReference)Mockito.mock(RecordReference.class);
            ComparativeRecordChecker checker = (ComparativeRecordChecker)Mockito.mock(ComparativeRecordChecker.class);
            handler.comparativeCheck(reference, checker);
            ArgumentCaptor captor = ArgumentCaptor.forClass(PendingReferenceCheck.class);
            ((RecordReference)Mockito.verify((Object)reference)).dispatch((PendingReferenceCheck)captor.capture());
            PendingReferenceCheck pendingRefCheck = (PendingReferenceCheck)captor.getValue();
            handler.updateSummary();
            Mockito.verifyZeroInteractions((Object[])new Object[]{summary});
            pendingRefCheck.skip();
            ((ConsistencySummaryStatistics)Mockito.verify((Object)summary)).update(RecordType.PROPERTY, 0, 0);
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{summary});
        }
    }
}

