/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.util.ArrayList;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.consistency.checking.CheckerEngine;
import org.neo4j.consistency.checking.RecordCheckTestBase;
import org.neo4j.consistency.checking.full.NodeInUseWithCorrectLabelsCheck;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.consistency.store.RecordAccessStub;
import org.neo4j.consistency.store.synthetic.LabelScanDocument;
import org.neo4j.kernel.impl.store.DynamicArrayStore;
import org.neo4j.kernel.impl.store.DynamicNodeLabels;
import org.neo4j.kernel.impl.store.DynamicRecordAllocator;
import org.neo4j.kernel.impl.store.InlineNodeLabels;
import org.neo4j.kernel.impl.store.LabelIdArray;
import org.neo4j.kernel.impl.store.allocator.ReusableRecordsAllocator;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;

public class NodeInUseWithCorrectLabelsCheckTest {
    @Test
    public void shouldReportNodeNotInUse() throws Exception {
        int nodeId = 42;
        ConsistencyReport.LabelScanConsistencyReport report = (ConsistencyReport.LabelScanConsistencyReport)Mockito.mock(ConsistencyReport.LabelScanConsistencyReport.class);
        NodeRecord node = RecordCheckTestBase.notInUse(new NodeRecord((long)nodeId, false, 0L, 0L));
        this.checker(new long[0]).checkReference(null, node, (CheckerEngine)this.engineFor(report), null);
        ((ConsistencyReport.LabelScanConsistencyReport)Mockito.verify((Object)report)).nodeNotInUse(node);
    }

    @Test
    public void shouldReportNodeWithoutExpectedLabelWhenLabelsAreInline() throws Exception {
        int nodeId = 42;
        int labelId1 = 7;
        int labelId2 = 9;
        NodeRecord node = RecordCheckTestBase.inUse(this.withInlineLabels(new NodeRecord((long)nodeId, false, 0L, 0L), labelId1));
        ConsistencyReport.LabelScanConsistencyReport report = (ConsistencyReport.LabelScanConsistencyReport)Mockito.mock(ConsistencyReport.LabelScanConsistencyReport.class);
        this.checker(new long[]{labelId1, labelId2}).checkReference(null, node, (CheckerEngine)this.engineFor(report), null);
        ((ConsistencyReport.LabelScanConsistencyReport)Mockito.verify((Object)report)).nodeDoesNotHaveExpectedLabel(node, (long)labelId2);
    }

    @Test
    public void shouldReportNodeWithoutExpectedLabelWhenLabelsAreDynamic() throws Exception {
        int nodeId = 42;
        long[] expectedLabelIds = new long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L};
        long[] presentLabelIds = new long[]{1L, 2L, 3L, 4L, 5L, 6L, 8L, 9L, 10L};
        long missingLabelId = 7L;
        RecordAccessStub recordAccess = new RecordAccessStub();
        NodeRecord node = RecordCheckTestBase.inUse(this.withDynamicLabels(recordAccess, new NodeRecord((long)nodeId, false, 0L, 0L), presentLabelIds));
        ConsistencyReport.LabelScanConsistencyReport report = (ConsistencyReport.LabelScanConsistencyReport)Mockito.mock(ConsistencyReport.LabelScanConsistencyReport.class);
        CheckerEngine<Object, ConsistencyReport.LabelScanConsistencyReport> engine = recordAccess.engine(null, report);
        this.checker(expectedLabelIds).checkReference(null, node, engine, (RecordAccess)recordAccess);
        recordAccess.checkDeferred();
        ((ConsistencyReport.LabelScanConsistencyReport)Mockito.verify((Object)report)).nodeDoesNotHaveExpectedLabel(node, missingLabelId);
    }

    @Test
    public void shouldRemainSilentWhenEverythingIsInOrder() throws Exception {
        int nodeId = 42;
        int labelId = 7;
        NodeRecord node = this.withInlineLabels(RecordCheckTestBase.inUse(new NodeRecord((long)nodeId, false, 0L, 0L)), labelId);
        ConsistencyReport.LabelScanConsistencyReport report = (ConsistencyReport.LabelScanConsistencyReport)Mockito.mock(ConsistencyReport.LabelScanConsistencyReport.class);
        this.checker(new long[]{labelId}).checkReference(null, node, (CheckerEngine)this.engineFor(report), null);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    private NodeRecord withInlineLabels(NodeRecord nodeRecord, long ... labelIds) {
        new InlineNodeLabels(nodeRecord).put(labelIds, null, null);
        return nodeRecord;
    }

    private NodeRecord withDynamicLabels(RecordAccessStub recordAccess, NodeRecord nodeRecord, long ... labelIds) {
        ArrayList<DynamicRecord> preAllocatedRecords = new ArrayList<DynamicRecord>();
        for (int i = 0; i < 10; ++i) {
            preAllocatedRecords.add(RecordCheckTestBase.inUse(new DynamicRecord((long)i)));
        }
        ArrayList dynamicRecords = new ArrayList();
        DynamicArrayStore.allocateFromNumbers(dynamicRecords, (Object)LabelIdArray.prependNodeId((long)nodeRecord.getId(), (long[])labelIds), (DynamicRecordAllocator)new ReusableRecordsAllocator(4, preAllocatedRecords));
        for (DynamicRecord dynamicRecord : dynamicRecords) {
            recordAccess.addNodeDynamicLabels(dynamicRecord);
        }
        nodeRecord.setLabelField(DynamicNodeLabels.dynamicPointer(dynamicRecords), dynamicRecords);
        return nodeRecord;
    }

    private Engine engineFor(ConsistencyReport.LabelScanConsistencyReport report) {
        Engine engine = (Engine)Mockito.mock(Engine.class);
        Mockito.when((Object)engine.report()).thenReturn((Object)report);
        return engine;
    }

    private NodeInUseWithCorrectLabelsCheck<LabelScanDocument, ConsistencyReport.LabelScanConsistencyReport> checker(long[] expectedLabels) {
        return new NodeInUseWithCorrectLabelsCheck(expectedLabels);
    }

    static interface Engine
    extends CheckerEngine<LabelScanDocument, ConsistencyReport.LabelScanConsistencyReport> {
    }
}

