/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.consistency.checking.CheckerEngine;
import org.neo4j.consistency.checking.full.NodeCorrectlyIndexedCheck;
import org.neo4j.consistency.checking.full.PropertyReader;
import org.neo4j.consistency.checking.index.IndexAccessors;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.BoundedIterable;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.IndexSampler;

public class NodeCorrectlyIndexedCheckTest {
    private static final int indexId = 12;
    private static final int labelId = 34;
    private static final int propertyKeyId = 56;
    private static final long constraintId = 78L;

    @Test
    public void shouldBeSilentWhenNodesCorrectlyIndexed() throws Exception {
        IndexRule indexRule = IndexRule.indexRule((long)12L, (int)34, (int)56, (SchemaIndexProvider.Descriptor)new SchemaIndexProvider.Descriptor("provider1", "version1"));
        NodeRecord nodeRecord = this.nodeWithLabels(34L);
        NodeCorrectlyIndexedCheck check = new NodeCorrectlyIndexedCheck(this.indexContaining(indexRule, Collections.singletonMap("propertyValue", new long[]{nodeRecord.getId()})), this.nodeHasProperty(nodeRecord, "propertyValue"));
        ConsistencyReport.NodeConsistencyReport report = (ConsistencyReport.NodeConsistencyReport)Mockito.mock(ConsistencyReport.NodeConsistencyReport.class);
        check.check(nodeRecord, this.engineFor(report), null);
        Mockito.verifyZeroInteractions((Object[])new Object[]{report});
    }

    @Test
    public void shouldReportNodeThatIsNotIndexed() throws Exception {
        IndexRule indexRule = IndexRule.indexRule((long)12L, (int)34, (int)56, (SchemaIndexProvider.Descriptor)new SchemaIndexProvider.Descriptor("provider1", "version1"));
        NodeRecord nodeRecord = this.nodeWithLabels(34L);
        NodeCorrectlyIndexedCheck check = new NodeCorrectlyIndexedCheck(this.indexContaining(indexRule, new HashMap<Object, long[]>()), this.nodeHasProperty(nodeRecord, "propertyValue"));
        ConsistencyReport.NodeConsistencyReport report = (ConsistencyReport.NodeConsistencyReport)Mockito.mock(ConsistencyReport.NodeConsistencyReport.class);
        check.check(nodeRecord, this.engineFor(report), null);
        ((ConsistencyReport.NodeConsistencyReport)Mockito.verify((Object)report)).notIndexed(indexRule, (Object)"propertyValue");
    }

    @Test
    public void shouldReportDuplicateNode() throws Exception {
        IndexRule indexRule = IndexRule.constraintIndexRule((long)12L, (int)34, (int)56, (SchemaIndexProvider.Descriptor)new SchemaIndexProvider.Descriptor("provider1", "version1"), (Long)78L);
        NodeRecord nodeRecord = this.nodeWithLabels(34L);
        long duplicateNodeId1 = 1L;
        long duplicateNodeId2 = 2L;
        NodeCorrectlyIndexedCheck check = new NodeCorrectlyIndexedCheck(this.indexContaining(indexRule, Collections.singletonMap("propertyValue", new long[]{nodeRecord.getId(), duplicateNodeId1, duplicateNodeId2})), this.nodeHasProperty(nodeRecord, "propertyValue"));
        ConsistencyReport.NodeConsistencyReport report = (ConsistencyReport.NodeConsistencyReport)Mockito.mock(ConsistencyReport.NodeConsistencyReport.class);
        check.check(nodeRecord, this.engineFor(report), null);
        ((ConsistencyReport.NodeConsistencyReport)Mockito.verify((Object)report)).uniqueIndexNotUnique(indexRule, (Object)"propertyValue", duplicateNodeId1);
        ((ConsistencyReport.NodeConsistencyReport)Mockito.verify((Object)report)).uniqueIndexNotUnique(indexRule, (Object)"propertyValue", duplicateNodeId2);
    }

    @Test
    public void shouldReportNodeIndexedMultipleTimes() throws Exception {
        IndexRule indexRule = IndexRule.indexRule((long)12L, (int)34, (int)56, (SchemaIndexProvider.Descriptor)new SchemaIndexProvider.Descriptor("provider1", "version1"));
        NodeRecord nodeRecord = this.nodeWithLabels(34L);
        long nodeId = nodeRecord.getId();
        NodeCorrectlyIndexedCheck check = new NodeCorrectlyIndexedCheck(this.indexContaining(indexRule, MapUtil.genericMap((Object[])new Object[]{"propertyValue", new long[]{nodeId, nodeId, nodeId}})), this.nodeHasProperty(nodeRecord, "propertyValue"));
        ConsistencyReport.NodeConsistencyReport report = (ConsistencyReport.NodeConsistencyReport)Mockito.mock(ConsistencyReport.NodeConsistencyReport.class);
        check.check(nodeRecord, this.engineFor(report), null);
        ((ConsistencyReport.NodeConsistencyReport)Mockito.verify((Object)report)).indexedMultipleTimes(indexRule, (Object)"propertyValue", 3L);
    }

    private IndexAccessors indexContaining(IndexRule indexRule, Map<Object, long[]> entries) {
        IndexAccessorStub reader = new IndexAccessorStub(entries);
        IndexAccessors indexes = (IndexAccessors)Mockito.mock(IndexAccessors.class);
        Mockito.when((Object)indexes.accessorFor((IndexRule)Matchers.any(IndexRule.class))).thenReturn((Object)reader);
        Mockito.when((Object)indexes.rules()).thenReturn(Arrays.asList(indexRule));
        return indexes;
    }

    private PropertyReader nodeHasProperty(NodeRecord nodeRecord, String propertyValue) {
        PropertyReader propertyReader = (PropertyReader)Mockito.mock(PropertyReader.class);
        PropertyBlock propertyBlock = (PropertyBlock)Mockito.mock(PropertyBlock.class);
        Mockito.when((Object)propertyBlock.getKeyIndexId()).thenReturn((Object)56);
        Mockito.when((Object)propertyReader.propertyBlocks(nodeRecord)).thenReturn(Arrays.asList(propertyBlock));
        Mockito.when((Object)propertyReader.propertyValue((PropertyBlock)Matchers.any(PropertyBlock.class))).thenReturn((Object)Property.stringProperty((int)56, (String)propertyValue));
        return propertyReader;
    }

    private NodeRecord nodeWithLabels(long ... labelIds) {
        NodeRecord nodeRecord = new NodeRecord(0L, false, 0L, 0L);
        NodeLabelsField.parseLabelsField((NodeRecord)nodeRecord).put(labelIds, null, null);
        return nodeRecord;
    }

    private CheckerEngine<NodeRecord, ConsistencyReport.NodeConsistencyReport> engineFor(ConsistencyReport.NodeConsistencyReport report) {
        CheckerEngine engine = (CheckerEngine)Mockito.mock(CheckerEngine.class);
        Mockito.when((Object)engine.report()).thenReturn((Object)report);
        return engine;
    }

    private static class IndexAccessorStub
    implements IndexAccessor {
        private final Map<Object, long[]> entries;

        private IndexAccessorStub(Map<Object, long[]> entries) {
            this.entries = entries;
        }

        public IndexReader newReader() {
            return new IndexReader(){

                public PrimitiveLongIterator seek(Object value) {
                    if (entries.containsKey(value)) {
                        return PrimitiveLongCollections.iterator((long[])((long[])entries.get(value)));
                    }
                    return PrimitiveLongCollections.emptyIterator();
                }

                public PrimitiveLongIterator rangeSeekByNumberInclusive(Number lower, Number upper) {
                    throw new UnsupportedOperationException();
                }

                public PrimitiveLongIterator rangeSeekByString(String lower, boolean includeLower, String upper, boolean includeUpper) {
                    throw new UnsupportedOperationException();
                }

                public PrimitiveLongIterator rangeSeekByPrefix(String prefix) {
                    throw new UnsupportedOperationException();
                }

                public PrimitiveLongIterator scan() {
                    ArrayList<Long> ids = new ArrayList<Long>();
                    Iterator iterator = entries.values().iterator();
                    while (iterator.hasNext()) {
                        long[] longs;
                        for (long id : longs = (long[])iterator.next()) {
                            ids.add(id);
                        }
                    }
                    return PrimitiveLongCollections.toPrimitiveIterator(ids.iterator());
                }

                public PrimitiveLongIterator containsString(String exactTerm) {
                    throw new UnsupportedOperationException();
                }

                public PrimitiveLongIterator endsWith(String suffix) {
                    throw new UnsupportedOperationException();
                }

                public long countIndexedNodes(long nodeId, Object propertyValue) {
                    long[] candidates = (long[])entries.get(propertyValue);
                    if (candidates == null) {
                        return 0L;
                    }
                    long count = 0L;
                    for (long candidate : candidates) {
                        if (candidate != nodeId) continue;
                        ++count;
                    }
                    return count;
                }

                public IndexSampler createSampler() {
                    throw new UnsupportedOperationException();
                }

                public void close() {
                }
            };
        }

        public void close() throws IOException {
        }

        public void drop() throws IOException {
            throw new UnsupportedOperationException();
        }

        public IndexUpdater newUpdater(IndexUpdateMode mode) {
            throw new UnsupportedOperationException();
        }

        public void force() throws IOException {
            throw new UnsupportedOperationException();
        }

        public void flush() throws IOException {
            throw new UnsupportedOperationException();
        }

        public BoundedIterable<Long> newAllEntriesReader() {
            throw new UnsupportedOperationException();
        }

        public ResourceIterator<File> snapshotFiles() throws IOException {
            throw new UnsupportedOperationException();
        }
    }
}

