/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.cache;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.consistency.checking.cache.PackedMultiFieldCache;

public class PackedMultiFieldCacheTest {
    @Test
    public void shouldPutValuesIntoSlots() throws Exception {
        PackedMultiFieldCache cache = new PackedMultiFieldCache(new int[]{5, 10, 25, 24});
        int index = 10;
        long[] values = new long[]{3L, 100L, 12345L, 67890L};
        cache.put((long)index, values);
        for (int i = 0; i < values.length; ++i) {
            Assert.assertEquals((long)values[i], (long)cache.get((long)index, i));
        }
    }

    @Test
    public void shouldHaveCorrectDefaultValues() throws Exception {
        PackedMultiFieldCache cache = new PackedMultiFieldCache(new int[]{1, 34, 35});
        int index = 0;
        cache.clear((long)index);
        Assert.assertEquals((long)0L, (long)cache.get((long)index, 0));
        Assert.assertEquals((long)0L, (long)cache.get((long)index, 1));
        Assert.assertEquals((long)-1L, (long)cache.get((long)index, 2));
    }

    @Test
    public void shouldBeAbleToChangeSlotSize() throws Exception {
        PackedMultiFieldCache cache = new PackedMultiFieldCache(new int[]{1, 5});
        int index = 10;
        try {
            cache.put((long)index, 0, 10L);
            Assert.fail((String)"Shouldn't fit");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        cache.setSlotSizes(new int[]{5, 20});
        cache.put((long)index, 0, 10L);
        Assert.assertEquals((long)10L, (long)cache.get((long)index, 0));
    }
}

