/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency;

import java.io.File;
import java.nio.file.Path;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.commandline.admin.CommandFailed;
import org.neo4j.commandline.admin.IncorrectUsage;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.consistency.CheckConsistencyCommand;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.LogProvider;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.EmbeddedDatabaseRule;
import org.neo4j.test.rule.TestDirectory;

public class CheckConsistencyCommandTest {
    private TestDirectory testDir = TestDirectory.testDirectory(this.getClass());
    @Rule
    public final DatabaseRule db = new EmbeddedDatabaseRule();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.testDir);

    @Test
    public void requiresDatabaseArgument() throws Exception {
        OutsideWorld outsideWorld = (OutsideWorld)Mockito.mock(OutsideWorld.class);
        CheckConsistencyCommand checkConsistencyCommand = new CheckConsistencyCommand(this.testDir.directory("home").toPath(), this.testDir.directory("conf").toPath(), outsideWorld);
        String[] arguments = new String[]{""};
        try {
            checkConsistencyCommand.execute(arguments);
            Assert.fail((String)"Should have thrown an exception.");
        }
        catch (IncorrectUsage e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"database"));
        }
    }

    @Test
    public void runsConsistencyChecker() throws Exception {
        ConsistencyCheckService consistencyCheckService = (ConsistencyCheckService)Mockito.mock(ConsistencyCheckService.class);
        Path homeDir = this.testDir.directory("home").toPath();
        OutsideWorld outsideWorld = (OutsideWorld)Mockito.mock(OutsideWorld.class);
        CheckConsistencyCommand checkConsistencyCommand = new CheckConsistencyCommand(homeDir, this.testDir.directory("conf").toPath(), outsideWorld, consistencyCheckService);
        File databasePath = new File(homeDir.toFile(), "data/databases/mydb");
        Mockito.when((Object)consistencyCheckService.runFullConsistencyCheck((File)Matchers.eq((Object)databasePath), (Config)Matchers.any(Config.class), (ProgressMonitorFactory)Matchers.any(ProgressMonitorFactory.class), (LogProvider)Matchers.any(LogProvider.class), (FileSystemAbstraction)Matchers.any(FileSystemAbstraction.class), Matchers.eq((boolean)false))).thenReturn((Object)ConsistencyCheckService.Result.SUCCESS);
        checkConsistencyCommand.execute(new String[]{"--database=mydb"});
        ((ConsistencyCheckService)Mockito.verify((Object)consistencyCheckService)).runFullConsistencyCheck((File)Matchers.eq((Object)databasePath), (Config)Matchers.any(Config.class), (ProgressMonitorFactory)Matchers.any(ProgressMonitorFactory.class), (LogProvider)Matchers.any(LogProvider.class), (FileSystemAbstraction)Matchers.any(FileSystemAbstraction.class), Matchers.eq((boolean)false));
    }

    @Test
    public void enablesVerbosity() throws Exception {
        ConsistencyCheckService consistencyCheckService = (ConsistencyCheckService)Mockito.mock(ConsistencyCheckService.class);
        Path homeDir = this.testDir.directory("home").toPath();
        OutsideWorld outsideWorld = (OutsideWorld)Mockito.mock(OutsideWorld.class);
        CheckConsistencyCommand checkConsistencyCommand = new CheckConsistencyCommand(homeDir, this.testDir.directory("conf").toPath(), outsideWorld, consistencyCheckService);
        File databasePath = new File(homeDir.toFile(), "data/databases/mydb");
        Mockito.when((Object)consistencyCheckService.runFullConsistencyCheck((File)Matchers.eq((Object)databasePath), (Config)Matchers.any(Config.class), (ProgressMonitorFactory)Matchers.any(ProgressMonitorFactory.class), (LogProvider)Matchers.any(LogProvider.class), (FileSystemAbstraction)Matchers.any(FileSystemAbstraction.class), Matchers.eq((boolean)true))).thenReturn((Object)ConsistencyCheckService.Result.SUCCESS);
        checkConsistencyCommand.execute(new String[]{"--database=mydb", "--verbose"});
        ((ConsistencyCheckService)Mockito.verify((Object)consistencyCheckService)).runFullConsistencyCheck((File)Matchers.eq((Object)databasePath), (Config)Matchers.any(Config.class), (ProgressMonitorFactory)Matchers.any(ProgressMonitorFactory.class), (LogProvider)Matchers.any(LogProvider.class), (FileSystemAbstraction)Matchers.any(FileSystemAbstraction.class), Matchers.eq((boolean)true));
    }

    @Test
    public void failsWhenInconsistenciesAreFound() throws Exception {
        ConsistencyCheckService consistencyCheckService = (ConsistencyCheckService)Mockito.mock(ConsistencyCheckService.class);
        Path homeDir = this.testDir.directory("home").toPath();
        OutsideWorld outsideWorld = (OutsideWorld)Mockito.mock(OutsideWorld.class);
        CheckConsistencyCommand checkConsistencyCommand = new CheckConsistencyCommand(homeDir, this.testDir.directory("conf").toPath(), outsideWorld, consistencyCheckService);
        File databasePath = new File(homeDir.toFile(), "data/databases/mydb");
        Mockito.when((Object)consistencyCheckService.runFullConsistencyCheck((File)Matchers.eq((Object)databasePath), (Config)Matchers.any(Config.class), (ProgressMonitorFactory)Matchers.any(ProgressMonitorFactory.class), (LogProvider)Matchers.any(LogProvider.class), (FileSystemAbstraction)Matchers.any(FileSystemAbstraction.class), Matchers.eq((boolean)true))).thenReturn((Object)ConsistencyCheckService.Result.FAILURE);
        Mockito.when((Object)consistencyCheckService.chooseReportPath((Config)Matchers.any(), (File)Matchers.any())).thenReturn((Object)this.testDir.directory("report file"));
        try {
            checkConsistencyCommand.execute(new String[]{"--database=mydb", "--verbose"});
        }
        catch (Exception e) {
            Assert.assertEquals(CommandFailed.class, e.getClass());
        }
    }
}

