/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.admin;

import java.util.function.Consumer;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.commandline.admin.CommandLocator;
import org.neo4j.helpers.Args;

public class Usage {
    private final String scriptName;
    private final CommandLocator commands;

    public Usage(String scriptName, CommandLocator commands) {
        this.scriptName = scriptName;
        this.commands = commands;
    }

    public void print(Consumer<String> output) {
        output.accept("Usage:");
        output.accept("");
        for (AdminCommand.Provider command : this.commands.getAllProviders()) {
            CommandUsage commandUsage = new CommandUsage(command, this.scriptName);
            commandUsage.print(output);
        }
    }

    public static class CommandUsage {
        private final AdminCommand.Provider command;
        private final String scriptName;

        public CommandUsage(AdminCommand.Provider command, String scriptName) {
            this.command = command;
            this.scriptName = scriptName;
        }

        public void print(Consumer<String> output) {
            String arguments = this.command.arguments().map(s -> " " + s).orElse("");
            output.accept(String.format("%s %s%s", this.scriptName, this.command.name(), arguments));
            output.accept("");
            for (String line : Args.splitLongLine((String)this.command.description(), (int)80)) {
                output.accept("    " + line);
            }
            output.accept("");
        }
    }
}

