/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.admin;

import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Consumer;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.commandline.admin.CannedLocator;
import org.neo4j.commandline.admin.CommandLocator;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.commandline.admin.Usage;

public class UsageTest {
    @Mock
    private Consumer<String> out;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void shouldPrintUsageForAllCommands() {
        AdminCommand.Provider[] commands = new AdminCommand.Provider[]{new StubProvider("restore", Optional.of("---from <backup-directory> --database=<database-name> [--force]"), "Restores a database backed up using the neo4j-backup tool."), new StubProvider("bam", Optional.empty(), "Some description")};
        Usage usage = new Usage("neo4j-admin", (CommandLocator)new CannedLocator(commands));
        usage.print(this.out);
        InOrder ordered = Mockito.inOrder((Object[])new Object[]{this.out});
        ((Consumer)ordered.verify(this.out)).accept("Usage:");
        ((Consumer)ordered.verify(this.out)).accept("");
        ((Consumer)ordered.verify(this.out)).accept("neo4j-admin restore ---from <backup-directory> --database=<database-name> [--force]");
        ((Consumer)ordered.verify(this.out)).accept("");
        ((Consumer)ordered.verify(this.out)).accept("    Restores a database backed up using the neo4j-backup tool.");
        ((Consumer)ordered.verify(this.out)).accept("");
        ((Consumer)ordered.verify(this.out)).accept("neo4j-admin bam");
        ((Consumer)ordered.verify(this.out)).accept("");
        ((Consumer)ordered.verify(this.out)).accept("    Some description");
        ((Consumer)ordered.verify(this.out)).accept("");
        ordered.verifyNoMoreInteractions();
    }

    private static class StubProvider
    extends AdminCommand.Provider {
        private final Optional<String> arguments;
        private final String description;

        public StubProvider(String name, Optional<String> arguments, String description) {
            super(name, new String[0]);
            this.arguments = arguments;
            this.description = description;
        }

        public Optional<String> arguments() {
            return this.arguments;
        }

        public String description() {
            return this.description;
        }

        public AdminCommand create(Path homeDir, Path configDir, OutsideWorld outsideWorld) {
            throw new UnsupportedOperationException("not implemented");
        }
    }
}

