/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.admin;

import java.nio.file.Path;
import java.util.Optional;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.commandline.admin.AdminTool;
import org.neo4j.commandline.admin.CannedLocator;
import org.neo4j.commandline.admin.CommandFailed;
import org.neo4j.commandline.admin.CommandLocator;
import org.neo4j.commandline.admin.IncorrectUsage;
import org.neo4j.commandline.admin.NullOutsideWorld;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.helpers.collection.Iterables;

public class AdminToolTest {
    @Test
    public void shouldExecuteTheCommand() throws CommandFailed, IncorrectUsage {
        AdminCommand command = (AdminCommand)Mockito.mock(AdminCommand.class);
        new AdminTool((CommandLocator)this.cannedCommand("command", command), (OutsideWorld)new NullOutsideWorld(), false).execute(null, null, new String[]{"command", "the", "other", "args"});
        ((AdminCommand)Mockito.verify((Object)command)).execute(new String[]{"the", "other", "args"});
    }

    @Test
    public void shouldExit0WhenEverythingWorks() {
        OutsideWorld outsideWorld = (OutsideWorld)Mockito.mock(OutsideWorld.class);
        new AdminTool((CommandLocator)new CannedLocator(new NullCommandProvider()), outsideWorld, false).execute(null, null, new String[]{"null"});
        ((OutsideWorld)Mockito.verify((Object)outsideWorld)).exit(0);
    }

    @Test
    public void shouldAddTheHelpCommandToThoseProvidedByTheLocator() {
        OutsideWorld outsideWorld = (OutsideWorld)Mockito.mock(OutsideWorld.class);
        new AdminTool((CommandLocator)new NullCommandLocator(), outsideWorld, false).execute(null, null, new String[]{"help"});
        ((OutsideWorld)Mockito.verify((Object)outsideWorld)).stdOutLine("neo4j-admin help");
    }

    @Test
    public void shouldProvideFeedbackWhenNoCommandIsProvided() {
        OutsideWorld outsideWorld = (OutsideWorld)Mockito.mock(OutsideWorld.class);
        new AdminTool((CommandLocator)new NullCommandLocator(), outsideWorld, false).execute(null, null, new String[0]);
        ((OutsideWorld)Mockito.verify((Object)outsideWorld)).stdErrLine("you must provide a command");
        ((OutsideWorld)Mockito.verify((Object)outsideWorld)).stdErrLine("Usage:");
        ((OutsideWorld)Mockito.verify((Object)outsideWorld)).exit(1);
    }

    @Test
    public void shouldProvideFeedbackIfTheCommandThrowsARuntimeException() {
        OutsideWorld outsideWorld = (OutsideWorld)Mockito.mock(OutsideWorld.class);
        AdminCommand command = args -> {
            throw new RuntimeException("the-exception-message");
        };
        new AdminTool((CommandLocator)this.cannedCommand("exception", command), outsideWorld, false).execute(null, null, new String[]{"exception"});
        ((OutsideWorld)Mockito.verify((Object)outsideWorld)).stdErrLine("unexpected error: the-exception-message");
        ((OutsideWorld)Mockito.verify((Object)outsideWorld)).exit(1);
    }

    @Test
    public void shouldPrintTheStacktraceWhenTheCommandThrowsARuntimeExceptionIfTheDebugFlagIsSet() {
        OutsideWorld outsideWorld = (OutsideWorld)Mockito.mock(OutsideWorld.class);
        RuntimeException exception = new RuntimeException("");
        AdminCommand command = args -> {
            throw exception;
        };
        new AdminTool((CommandLocator)this.cannedCommand("exception", command), outsideWorld, true).execute(null, null, new String[]{"exception"});
        ((OutsideWorld)Mockito.verify((Object)outsideWorld)).printStacktrace((Exception)exception);
    }

    @Test
    public void shouldNotPrintTheStacktraceWhenTheCommandThrowsARuntimeExceptionIfTheDebugFlagIsNotSet() {
        OutsideWorld outsideWorld = (OutsideWorld)Mockito.mock(OutsideWorld.class);
        RuntimeException exception = new RuntimeException("");
        AdminCommand command = args -> {
            throw exception;
        };
        new AdminTool((CommandLocator)this.cannedCommand("exception", command), outsideWorld, false).execute(null, null, new String[]{"exception"});
        ((OutsideWorld)Mockito.verify((Object)outsideWorld, (VerificationMode)Mockito.never())).printStacktrace((Exception)exception);
    }

    @Test
    public void shouldProvideFeedbackIfTheCommandFails() {
        OutsideWorld outsideWorld = (OutsideWorld)Mockito.mock(OutsideWorld.class);
        AdminCommand command = args -> {
            throw new CommandFailed("the-failure-message");
        };
        new AdminTool((CommandLocator)this.cannedCommand("exception", command), outsideWorld, false).execute(null, null, new String[]{"exception"});
        ((OutsideWorld)Mockito.verify((Object)outsideWorld)).stdErrLine("command failed: the-failure-message");
        ((OutsideWorld)Mockito.verify((Object)outsideWorld)).exit(1);
    }

    @Test
    public void shouldPrintTheStacktraceWhenTheCommandFailsIfTheDebugFlagIsSet() {
        OutsideWorld outsideWorld = (OutsideWorld)Mockito.mock(OutsideWorld.class);
        CommandFailed exception = new CommandFailed("");
        AdminCommand command = args -> {
            throw exception;
        };
        new AdminTool((CommandLocator)this.cannedCommand("exception", command), outsideWorld, true).execute(null, null, new String[]{"exception"});
        ((OutsideWorld)Mockito.verify((Object)outsideWorld)).printStacktrace((Exception)exception);
    }

    @Test
    public void shouldNotPrintTheStacktraceWhenTheCommandFailsIfTheDebugFlagIsNotSet() {
        OutsideWorld outsideWorld = (OutsideWorld)Mockito.mock(OutsideWorld.class);
        CommandFailed exception = new CommandFailed("");
        AdminCommand command = args -> {
            throw exception;
        };
        new AdminTool((CommandLocator)this.cannedCommand("exception", command), outsideWorld, false).execute(null, null, new String[]{"exception"});
        ((OutsideWorld)Mockito.verify((Object)outsideWorld, (VerificationMode)Mockito.never())).printStacktrace((Exception)exception);
    }

    @Test
    public void shouldProvideFeedbackIfTheCommandReportsAUsageProblem() {
        OutsideWorld outsideWorld = (OutsideWorld)Mockito.mock(OutsideWorld.class);
        AdminCommand command = args -> {
            throw new IncorrectUsage("the-usage-message");
        };
        new AdminTool((CommandLocator)this.cannedCommand("exception", command), outsideWorld, false).execute(null, null, new String[]{"exception"});
        ((OutsideWorld)Mockito.verify((Object)outsideWorld)).stdErrLine("neo4j-admin exception");
        ((OutsideWorld)Mockito.verify((Object)outsideWorld)).stdErrLine("the-usage-message");
        ((OutsideWorld)Mockito.verify((Object)outsideWorld)).exit(1);
    }

    private CannedLocator cannedCommand(String name, final AdminCommand command) {
        return new CannedLocator(new AdminCommand.Provider(name, new String[0]){

            public Optional<String> arguments() {
                return Optional.empty();
            }

            public String description() {
                return "";
            }

            public AdminCommand create(Path homeDir, Path configDir, OutsideWorld outsideWorld) {
                return command;
            }
        });
    }

    private class NullCommandProvider
    extends AdminCommand.Provider {
        protected NullCommandProvider() {
            super("null", new String[0]);
        }

        public Optional<String> arguments() {
            return Optional.empty();
        }

        public String description() {
            return "";
        }

        public AdminCommand create(Path homeDir, Path configDir, OutsideWorld outsideWorld) {
            return args -> {};
        }
    }

    private static class NullCommandLocator
    implements CommandLocator {
        private NullCommandLocator() {
        }

        public AdminCommand.Provider findProvider(String s) {
            throw new UnsupportedOperationException("not implemented");
        }

        public Iterable<AdminCommand.Provider> getAllProviders() {
            return Iterables.empty();
        }
    }
}

