/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers.collection;

import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.PrefetchingResourceIterator;

public class LimitingResourceIterator<T>
extends PrefetchingResourceIterator<T> {
    private int returned;
    private final ResourceIterator<T> source;
    private final int limit;

    public LimitingResourceIterator(ResourceIterator<T> source, int limit) {
        this.source = source;
        this.limit = limit;
    }

    @Override
    protected T fetchNextOrNull() {
        if (!this.source.hasNext() || this.returned >= this.limit) {
            return null;
        }
        try {
            Object object = this.source.next();
            return (T)object;
        }
        finally {
            ++this.returned;
        }
    }

    public boolean limitReached() {
        return this.returned == this.limit;
    }

    public void close() {
        this.source.close();
    }
}

