/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.LongFunction;
import java.util.function.LongPredicate;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.neo4j.collection.PrimitiveLongResourceCollections;
import org.neo4j.collection.PrimitiveLongResourceIterator;
import org.neo4j.graphdb.Resource;

public class PrimitiveLongCollections {
    public static final long[] EMPTY_LONG_ARRAY = new long[0];

    private PrimitiveLongCollections() {
    }

    public static LongIterator iterator(final long ... items) {
        return new PrimitiveLongResourceCollections.PrimitiveLongBaseResourceIterator(Resource.EMPTY){
            private int index;
            {
                super(resource);
                this.index = -1;
            }

            @Override
            protected boolean fetchNext() {
                return ++this.index < items.length && this.next(items[this.index]);
            }
        };
    }

    public static LongIterator concat(LongIterator ... longIterators) {
        return PrimitiveLongCollections.concat(Arrays.asList(longIterators));
    }

    public static LongIterator concat(Iterable<LongIterator> primitiveLongIterators) {
        return new PrimitiveLongConcatingIterator(primitiveLongIterators.iterator());
    }

    public static LongIterator filter(LongIterator source, final LongPredicate filter) {
        return new PrimitiveLongFilteringIterator(source){

            @Override
            public boolean test(long item) {
                return filter.test(item);
            }
        };
    }

    public static LongIterator range(long start, long end) {
        return new PrimitiveLongRangeIterator(start, end);
    }

    public static int indexOf(LongIterator iterator, long item) {
        int i = 0;
        while (iterator.hasNext()) {
            if (item == iterator.next()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static MutableLongSet asSet(Collection<Long> collection) {
        LongHashSet set = new LongHashSet(collection.size());
        for (Long next : collection) {
            set.add(next.longValue());
        }
        return set;
    }

    public static MutableLongSet asSet(LongIterator iterator) {
        LongHashSet set = new LongHashSet();
        while (iterator.hasNext()) {
            set.add(iterator.next());
        }
        return set;
    }

    public static int count(LongIterator iterator) {
        int count = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++count;
        }
        return count;
    }

    public static long[] asArray(LongIterator iterator) {
        long[] array = new long[8];
        int i = 0;
        while (iterator.hasNext()) {
            if (i >= array.length) {
                array = Arrays.copyOf(array, i << 1);
            }
            array[i] = iterator.next();
            ++i;
        }
        if (i < array.length) {
            array = Arrays.copyOf(array, i);
        }
        return array;
    }

    public static long[] asArray(Iterator<Long> iterator) {
        long[] array = new long[8];
        int i = 0;
        while (iterator.hasNext()) {
            if (i >= array.length) {
                array = Arrays.copyOf(array, i << 1);
            }
            array[i] = iterator.next();
            ++i;
        }
        if (i < array.length) {
            array = Arrays.copyOf(array, i);
        }
        return array;
    }

    public static LongIterator toPrimitiveIterator(final Iterator<Long> iterator) {
        return new PrimitiveLongBaseIterator(){

            @Override
            protected boolean fetchNext() {
                if (iterator.hasNext()) {
                    Long nextValue = (Long)iterator.next();
                    if (null == nextValue) {
                        throw new IllegalArgumentException("Cannot convert null Long to primitive long");
                    }
                    return this.next(nextValue);
                }
                return false;
            }
        };
    }

    public static <T> Iterator<T> map(final LongFunction<T> mapFunction, final LongIterator source) {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return source.hasNext();
            }

            @Override
            public T next() {
                return mapFunction.apply(source.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static List<Long> asList(LongIterator iterator) {
        ArrayList<Long> out = new ArrayList<Long>();
        while (iterator.hasNext()) {
            out.add(iterator.next());
        }
        return out;
    }

    public static Iterator<Long> toIterator(final LongIterator primIterator) {
        return new Iterator<Long>(){

            @Override
            public boolean hasNext() {
                return primIterator.hasNext();
            }

            @Override
            public Long next() {
                return primIterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static PrimitiveLongResourceIterator resourceIterator(final LongIterator iterator, final Resource resource) {
        return new PrimitiveLongResourceIterator(){

            public void close() {
                if (resource != null) {
                    resource.close();
                }
            }

            public long next() {
                return iterator.next();
            }

            public boolean hasNext() {
                return iterator.hasNext();
            }
        };
    }

    public static Set<Long> toSet(LongSet set) {
        return PrimitiveLongCollections.toSet(set.longIterator());
    }

    public static Set<Long> toSet(LongIterator iterator) {
        HashSet<Long> set = new HashSet<Long>();
        while (iterator.hasNext()) {
            PrimitiveLongCollections.addUnique(set, iterator.next());
        }
        return set;
    }

    private static <T, C extends Collection<T>> void addUnique(C collection, T item) {
        if (!collection.add(item)) {
            throw new IllegalStateException("Encountered an already added item:" + item + " when adding items uniquely to a collection:" + collection);
        }
    }

    public static long[] deduplicate(long[] values) {
        int unique = 0;
        for (int i = 0; i < values.length; ++i) {
            long value = values[i];
            for (int j = 0; j < unique; ++j) {
                if (value != values[j]) continue;
                value = -1L;
                break;
            }
            if (value == -1L) continue;
            values[unique++] = values[i];
        }
        return unique < values.length ? Arrays.copyOf(values, unique) : values;
    }

    public static MutableLongSet mergeToSet(LongIterable a, LongIterable b) {
        LongHashSet set = new LongHashSet(a.size() + b.size());
        set.addAll(a);
        set.addAll(b);
        return set;
    }

    public static class PrimitiveLongRangeIterator
    extends PrimitiveLongBaseIterator {
        private long current;
        private final long end;

        PrimitiveLongRangeIterator(long start, long end) {
            this.current = start;
            this.end = end;
        }

        @Override
        protected boolean fetchNext() {
            try {
                boolean bl = this.current <= this.end && this.next(this.current);
                return bl;
            }
            finally {
                ++this.current;
            }
        }
    }

    public static abstract class PrimitiveLongFilteringIterator
    extends PrimitiveLongBaseIterator
    implements LongPredicate {
        protected final LongIterator source;

        PrimitiveLongFilteringIterator(LongIterator source) {
            this.source = source;
        }

        @Override
        protected boolean fetchNext() {
            while (this.source.hasNext()) {
                long testItem = this.source.next();
                if (!this.test(testItem)) continue;
                return this.next(testItem);
            }
            return false;
        }

        @Override
        public abstract boolean test(long var1);
    }

    public static class PrimitiveLongConcatingIterator
    extends PrimitiveLongBaseIterator {
        private final Iterator<? extends LongIterator> iterators;
        private LongIterator currentIterator;

        public PrimitiveLongConcatingIterator(Iterator<? extends LongIterator> iterators) {
            this.iterators = iterators;
        }

        @Override
        protected boolean fetchNext() {
            if (this.currentIterator == null || !this.currentIterator.hasNext()) {
                while (this.iterators.hasNext()) {
                    this.currentIterator = this.iterators.next();
                    if (!this.currentIterator.hasNext()) continue;
                }
            }
            return this.currentIterator != null && this.currentIterator.hasNext() && this.next(this.currentIterator.next());
        }

        protected final LongIterator currentIterator() {
            return this.currentIterator;
        }
    }

    public static abstract class PrimitiveLongBaseIterator
    implements LongIterator {
        private boolean hasNextDecided;
        private boolean hasNext;
        protected long next;

        public boolean hasNext() {
            if (!this.hasNextDecided) {
                this.hasNext = this.fetchNext();
                this.hasNextDecided = true;
            }
            return this.hasNext;
        }

        public long next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more elements in " + this);
            }
            this.hasNextDecided = false;
            return this.next;
        }

        protected abstract boolean fetchNext();

        protected boolean next(long nextItem) {
            this.next = nextItem;
            this.hasNext = true;
            return true;
        }
    }
}

